/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrUnusedIncDecInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance(GrUnusedIncDecInspection.class);

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        GrUnusedIncDecInspectionVisitor grUnusedIncDecInspectionVisitor = new GrUnusedIncDecInspectionVisitor();
        if (grUnusedIncDecInspectionVisitor == null) {
            GrUnusedIncDecInspection.$$$reportNull$$$0(0);
        }
        return grUnusedIncDecInspectionVisitor;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("unused.inc.dec", new Object[0]);
        if (string == null) {
            GrUnusedIncDecInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static GrUnaryExpression findUnaryExpression(ProblemDescriptor descriptor2) {
        PsiElement element = descriptor2.getPsiElement();
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        IElementType opType = element.getNode().getElementType();
        if (opType != GroovyTokenTypes.mINC && opType != GroovyTokenTypes.mDEC) {
            return null;
        }
        if (!(parent instanceof GrUnaryExpression)) {
            return null;
        }
        GrUnaryExpression expr = (GrUnaryExpression)parent;
        return expr;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class GrUnusedIncDecInspectionVisitor
    extends BaseInspectionVisitor {
        private GrUnusedIncDecInspectionVisitor() {
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                GrUnusedIncDecInspectionVisitor.$$$reportNull$$$0(0);
            }
            super.visitUnaryExpression(expression);
            IElementType opType = expression.getOperationTokenType();
            if (opType != GroovyTokenTypes.mINC && opType != GroovyTokenTypes.mDEC) {
                return;
            }
            GrExpression operand = expression.getOperand();
            if (!(operand instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement resolved = ((GrReferenceExpression)operand).resolve();
            if (!(resolved instanceof GrVariable) || resolved instanceof GrField) {
                return;
            }
            GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(expression);
            assert (owner != null);
            GrControlFlowOwner ownerOfDeclaration = ControlFlowUtils.findControlFlowOwner(resolved);
            if (ownerOfDeclaration != owner) {
                return;
            }
            Instruction cur = ControlFlowUtils.findInstruction(operand, owner.getControlFlow());
            if (cur == null) {
                LOG.error("no instruction found in flow.operand: " + operand.getText(), new Attachment[]{new Attachment("", owner.getText())});
            }
            Iterable<Instruction> successors = cur.allSuccessors();
            Iterator<Instruction> iterator2 = successors.iterator();
            LOG.assertTrue(iterator2.hasNext());
            Instruction writeAccess = iterator2.next();
            LOG.assertTrue(!iterator2.hasNext());
            List<ReadWriteVariableInstruction> accesses = ControlFlowUtils.findAccess((GrVariable)resolved, true, false, writeAccess);
            boolean allAreWrite = true;
            for (ReadWriteVariableInstruction access : accesses) {
                if (access.isWrite()) continue;
                allAreWrite = false;
                break;
            }
            if (allAreWrite) {
                if (expression.isPostfix() && PsiUtil.isExpressionUsed(expression)) {
                    this.registerError(expression.getOperationToken(), GroovyInspectionBundle.message("unused.0", expression.getOperationToken().getText()), new LocalQuickFix[]{new ReplacePostfixIncWithPrefixFix(expression), new RemoveIncOrDecFix(expression)}, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                } else if (!PsiUtil.isExpressionUsed(expression)) {
                    this.registerError(expression.getOperationToken(), GroovyInspectionBundle.message("unused.0", expression.getOperationToken().getText()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor", "visitUnaryExpression"));
        }

        private static class ReplaceIncDecWithBinary
        implements LocalQuickFix {
            private final String myMessage;

            public ReplaceIncDecWithBinary(GrUnaryExpression expression) {
                String opToken = expression.getOperationToken().getText();
                this.myMessage = GroovyInspectionBundle.message("replace.0.with.1", opToken, opToken.substring(0, 1));
            }

            @NotNull
            public String getFamilyName() {
                String string = this.myMessage;
                if (string == null) {
                    ReplaceIncDecWithBinary.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                if (project == null) {
                    ReplaceIncDecWithBinary.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    ReplaceIncDecWithBinary.$$$reportNull$$$0(2);
                }
                GrUnaryExpression expr = GrUnusedIncDecInspection.findUnaryExpression(descriptor2);
                GrExpression newExpr = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(expr.getOperand().getText() + expr.getOperationToken().getText().substring(0, 1) + "1");
                expr.replaceWithExpression(newExpr, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplaceIncDecWithBinary";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplaceIncDecWithBinary";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private static class ReplacePostfixIncWithPrefixFix
        implements LocalQuickFix {
            private final String myMessage;

            public ReplacePostfixIncWithPrefixFix(GrUnaryExpression expression) {
                this.myMessage = GroovyInspectionBundle.message("replace.postfix.0.with.prefix.0", expression.getOperationToken().getText());
            }

            @NotNull
            public String getFamilyName() {
                String string = this.myMessage;
                if (string == null) {
                    ReplacePostfixIncWithPrefixFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                GrUnaryExpression expr;
                if (project == null) {
                    ReplacePostfixIncWithPrefixFix.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    ReplacePostfixIncWithPrefixFix.$$$reportNull$$$0(2);
                }
                if ((expr = GrUnusedIncDecInspection.findUnaryExpression(descriptor2)) == null) {
                    return;
                }
                GrExpression prefix = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(expr.getOperationToken().getText() + expr.getOperand().getText());
                expr.replaceWithExpression(prefix, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplacePostfixIncWithPrefixFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplacePostfixIncWithPrefixFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private static class RemoveIncOrDecFix
        implements LocalQuickFix {
            private final String myMessage;

            public RemoveIncOrDecFix(GrUnaryExpression expression) {
                this.myMessage = GroovyInspectionBundle.message("remove.0", expression.getOperationToken().getText());
            }

            @NotNull
            public String getFamilyName() {
                String string = this.myMessage;
                if (string == null) {
                    RemoveIncOrDecFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                GrUnaryExpression expr;
                if (project == null) {
                    RemoveIncOrDecFix.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    RemoveIncOrDecFix.$$$reportNull$$$0(2);
                }
                if ((expr = GrUnusedIncDecInspection.findUnaryExpression(descriptor2)) == null) {
                    return;
                }
                expr.replaceWithExpression(expr.getOperand(), true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$RemoveIncOrDecFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$RemoveIncOrDecFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

