/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.ParameterCastFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyTypeCheckVisitorHelper {
    private static final Function<PsiType, PsiType> id = Function.ID;

    @Nullable
    @Contract(value="null -> null")
    protected static GrListOrMap getTupleInitializer(@Nullable GrExpression initializer) {
        if (initializer instanceof GrListOrMap && initializer.getReference() instanceof LiteralConstructorReference && ((LiteralConstructorReference)initializer.getReference()).getConstructedClassType() != null) {
            return (GrListOrMap)initializer;
        }
        return null;
    }

    @NotNull
    public static PsiElement getExpressionPartToHighlight(@NotNull GrExpression expr) {
        if (expr == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(0);
        }
        if (expr instanceof GrClosableBlock) {
            PsiElement highlightElement = ((GrClosableBlock)expr).getLBrace();
            assert (highlightElement != null);
            PsiElement psiElement = highlightElement;
            if (psiElement == null) {
                GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(1);
            }
            return psiElement;
        }
        GrExpression grExpression = expr;
        if (grExpression == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(2);
        }
        return grExpression;
    }

    public static boolean checkSimpleArrayAccess(@NotNull CallInfo<? extends GrIndexProperty> info, @Nullable PsiType type, @NotNull PsiType[] types) {
        if (info == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(3);
        }
        if (types == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(4);
        }
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        return PsiUtil.isLValue(info.getCall()) ? types.length == 2 && TypesUtil.isAssignable((PsiType)PsiType.INT, types[0], info.getCall()) && TypesUtil.isAssignable(((PsiArrayType)type).getComponentType(), types[1], info.getCall()) : types.length == 1 && TypesUtil.isAssignable((PsiType)PsiType.INT, types[0], info.getCall());
    }

    public static boolean typesAreEqual(@NotNull PsiType expected, @NotNull PsiType actual, @NotNull PsiElement context) {
        if (expected == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(5);
        }
        if (actual == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(7);
        }
        return TypesUtil.isAssignableByMethodCallConversion(expected, actual, context) && TypesUtil.isAssignableByMethodCallConversion(actual, expected, context);
    }

    public static boolean hasErrorElements(@Nullable PsiElement e) {
        if (e == null) {
            return false;
        }
        for (PsiElement child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSpockTimesOperator(GrBinaryExpression call) {
        PsiClass aClass;
        GrExpression operand;
        return call.getOperationTokenType() == GroovyTokenTypes.mSTAR && PsiUtil.isExpressionStatement(call) && (operand = call.getLeftOperand()) instanceof GrLiteral && TypesUtil.isNumericType(operand.getType()) && InheritanceUtil.isInheritor((PsiClass)(aClass = PsiUtil.getContextClass(call)), (boolean)false, (String)"spock.lang.Specification");
    }

    public static boolean isOperatorWithSimpleTypes(GrBinaryExpression binary, GroovyResolveResult result) {
        if (result.getElement() != null && result.isApplicable()) {
            return false;
        }
        GrExpression left = binary.getLeftOperand();
        GrExpression right = binary.getRightOperand();
        PsiType ltype = left.getType();
        PsiType rtype = right != null ? right.getType() : null;
        return TypesUtil.isNumericType(ltype) && (rtype == null || TypesUtil.isNumericType(rtype));
    }

    @NotNull
    public static LocalQuickFix[] genCastFixes(@NotNull GrSignature signature, @NotNull PsiType[] argumentTypes, @Nullable GrArgumentList argumentList) {
        if (signature == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(8);
        }
        if (argumentTypes == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(9);
        }
        if (argumentList == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(10);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        List<GrExpression> args = GroovyTypeCheckVisitorHelper.getExpressionArgumentsOfCall(argumentList);
        if (args == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(11);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<Pair<Integer, PsiType>> allErrors = new ArrayList<Pair<Integer, PsiType>>();
        List<GrClosureSignature> signatures = GrClosureSignatureUtil.generateSimpleSignatures(signature);
        for (GrClosureSignature closureSignature : signatures) {
            GrClosureSignatureUtil.MapResultWithError<PsiType> mapResultWithError = GrClosureSignatureUtil.mapSimpleSignatureWithErrors(closureSignature, argumentTypes, id, argumentList, 1);
            if (mapResultWithError == null) continue;
            List<Pair<Integer, PsiType>> errors = mapResultWithError.getErrors();
            for (Pair<Integer, PsiType> error : errors) {
                if ((Integer)error.first == 0 && PsiImplUtil.hasNamedArguments(argumentList)) continue;
                allErrors.add(error);
            }
        }
        ArrayList<ParameterCastFix> fixes = new ArrayList<ParameterCastFix>();
        for (Pair pair : allErrors) {
            PsiType type;
            if (args.size() <= (Integer)pair.first || pair.second == null || (type = PsiImplUtil.normalizeWildcardTypeByPosition((PsiType)pair.second, args.get((Integer)pair.first))) == null) continue;
            fixes.add(new ParameterCastFix((Integer)pair.first, type));
        }
        LocalQuickFix[] localQuickFixArray = fixes.toArray(new LocalQuickFix[fixes.size()]);
        if (localQuickFixArray == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(12);
        }
        return localQuickFixArray;
    }

    @NotNull
    public static String buildArgTypesList(@NotNull PsiType[] argTypes) {
        if (argTypes == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(13);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < argTypes.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = argTypes[i]) != null ? argType.getInternalCanonicalText() : "?");
        }
        builder.append(")");
        String string = builder.toString();
        if (string == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static boolean checkCategoryQualifier(@NotNull GrReferenceExpression place, @Nullable GrExpression qualifier, @NotNull PsiMethod gdkMethod, @Nullable PsiSubstitutor substitutor) {
        PsiClassType categoryType;
        PsiClass categoryAnnotationOwner;
        if (place == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(15);
        }
        if (gdkMethod == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(16);
        }
        if ((categoryAnnotationOwner = GroovyTypeCheckVisitorHelper.inferCategoryAnnotationOwner(place, qualifier)) != null && (categoryType = GdkMethodUtil.getCategoryType(categoryAnnotationOwner)) != null) {
            return GdkMethodUtil.isCategoryMethod(gdkMethod, (PsiType)categoryType, qualifier, substitutor);
        }
        return false;
    }

    @Nullable
    public static PsiClass inferCategoryAnnotationOwner(@NotNull GrReferenceExpression place, @Nullable GrExpression qualifier) {
        PsiElement resolved;
        if (place == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(17);
        }
        if (qualifier == null) {
            GrMethod container = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethod.class, (boolean)true, (Class[])new Class[]{GrMember.class});
            if (container != null && !container.hasModifierProperty("static")) {
                return container.getContainingClass();
            }
        } else if (PsiUtil.isThisReference(qualifier) && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
            return (PsiClass)resolved;
        }
        return null;
    }

    @Nullable
    public static String getLValueVarName(@NotNull PsiElement highlight) {
        PsiElement resolved;
        PsiElement parent;
        if (highlight == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(18);
        }
        if ((parent = highlight.getParent()) instanceof GrVariable) {
            return ((GrVariable)parent).getName();
        }
        if (highlight instanceof GrReferenceExpression && parent instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).getLValue() == highlight && (resolved = ((GrReferenceExpression)highlight).resolve()) instanceof GrVariable && PsiUtil.isLocalVariable(resolved)) {
            return ((GrVariable)resolved).getName();
        }
        return null;
    }

    @Nullable
    public static List<GrExpression> getExpressionArgumentsOfCall(@NotNull GrArgumentList argumentList) {
        if (argumentList == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(19);
        }
        ArrayList args = ContainerUtil.newArrayList();
        for (GroovyPsiElement arg : argumentList.getAllArguments()) {
            if (arg instanceof GrSpreadArgument) {
                GrExpression spreaded = ((GrSpreadArgument)arg).getArgument();
                if (spreaded instanceof GrListOrMap && !((GrListOrMap)spreaded).isMap()) {
                    Collections.addAll(args, ((GrListOrMap)spreaded).getInitializers());
                    continue;
                }
                return null;
            }
            if (arg instanceof GrExpression) {
                args.add((GrExpression)arg);
                continue;
            }
            if (!(arg instanceof GrNamedArgument)) continue;
            args.add(((GrNamedArgument)arg).getExpression());
        }
        PsiElement parent = argumentList.getParent();
        if (parent instanceof GrIndexProperty && PsiUtil.isLValue((GroovyPsiElement)parent)) {
            args.add(TypeInferenceHelper.getInitializerFor((GrExpression)parent));
        } else if (parent instanceof GrMethodCallExpression) {
            ContainerUtil.addAll((Collection)args, (Object[])((GrMethodCallExpression)parent).getClosureArguments());
        }
        return args;
    }

    static boolean isImplicitReturnStatement(@NotNull GrExpression expression) {
        GrControlFlowOwner flowOwner;
        if (expression == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(20);
        }
        return (flowOwner = ControlFlowUtils.findControlFlowOwner(expression)) != null && PsiUtil.isExpressionStatement(expression) && ControlFlowUtils.isReturnValue(expression, flowOwner) && !PsiUtil.isVoidMethodCall(expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/type/GroovyTypeCheckVisitorHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argTypes";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gdkMethod";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlight";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/type/GroovyTypeCheckVisitorHelper";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionPartToHighlight";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "genCastFixes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildArgTypesList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionPartToHighlight";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkSimpleArrayAccess";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "typesAreEqual";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "genCastFixes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildArgTypesList";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkCategoryQualifier";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "inferCategoryAnnotationOwner";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLValueVarName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionArgumentsOfCall";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitReturnStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

