/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtilRt;
import java.lang.ref.Reference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrNameValuePairStub;

public class GrAnnotationNameValuePairImpl
extends GrStubElementBase<GrNameValuePairStub>
implements GrAnnotationNameValuePair,
PsiPolyVariantReference,
StubBasedPsiElement<GrNameValuePairStub> {
    private volatile Reference<PsiAnnotationMemberValue> myDetachedValue;

    public GrAnnotationNameValuePairImpl(@NotNull GrNameValuePairStub stub) {
        if (stub == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(0);
        }
        super(stub, GroovyElementTypes.ANNOTATION_MEMBER_VALUE_PAIR);
    }

    public GrAnnotationNameValuePairImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitAnnotationNameValuePair(this);
    }

    public String toString() {
        return "Annotation member value pair";
    }

    @Nullable
    public String getName() {
        GrNameValuePairStub stub = (GrNameValuePairStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement nameId = this.getNameIdentifierGroovy();
        return nameId != null ? nameId.getText() : null;
    }

    public String getLiteralValue() {
        return null;
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifierGroovy() {
        PsiElement child = this.getFirstChild();
        if (child == null) {
            return null;
        }
        IElementType type = child.getNode().getElementType();
        if (TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS.contains(type)) {
            return child;
        }
        return null;
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Nullable
    public PsiAnnotationMemberValue getDetachedValue() {
        GrNameValuePairStub stub = (GrNameValuePairStub)this.getStub();
        if (stub != null) {
            String text = stub.getValue();
            PsiAnnotationMemberValue result = (PsiAnnotationMemberValue)SoftReference.dereference(this.myDetachedValue);
            if (result == null) {
                PsiAnnotationMemberValue value;
                GrAnnotation annotation = GroovyPsiElementFactory.getInstance(this.getProject()).createAnnotationFromText("@F(" + text + ")", this);
                ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
                result = value = annotation.findAttributeValue(null);
                this.myDetachedValue = new SoftReference((Object)result);
            }
            return result;
        }
        return this.getValue();
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myDetachedValue = null;
    }

    @Override
    public GrAnnotationMemberValue getValue() {
        return (GrAnnotationMemberValue)this.findChildByClass(GrAnnotationMemberValue.class);
    }

    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        GrAnnotationMemberValue value;
        if (newValue == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(2);
        }
        if ((value = this.getValue()) == null) {
            PsiAnnotationMemberValue psiAnnotationMemberValue = (PsiAnnotationMemberValue)this.add((PsiElement)newValue);
            if (psiAnnotationMemberValue == null) {
                GrAnnotationNameValuePairImpl.$$$reportNull$$$0(3);
            }
            return psiAnnotationMemberValue;
        }
        PsiAnnotationMemberValue psiAnnotationMemberValue = (PsiAnnotationMemberValue)value.replace((PsiElement)newValue);
        if (psiAnnotationMemberValue == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(4);
        }
        return psiAnnotationMemberValue;
    }

    public PsiReference getReference() {
        return this.getNameIdentifierGroovy() == null ? null : this;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement nameId = this.getNameIdentifierGroovy();
        assert (nameId != null);
        return nameId.getTextRange().shiftRight(-this.getTextRange().getStartOffset());
    }

    @Nullable
    public PsiElement resolve() {
        GroovyResolveResult[] results2 = this.multiResolve(false);
        return results2.length == 1 ? results2[0].getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getText());
        if (string == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement nameElement = this.getNameIdentifierGroovy();
        ASTNode newNameNode = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceNameFromText(newElementName).getNode();
        assert (newNameNode != null);
        if (nameElement != null) {
            ASTNode node = nameElement.getNode();
            assert (node != null);
            this.getNode().replaceChild(node, newNameNode);
        } else {
            PsiElement first = this.getFirstChild();
            ASTNode anchorBefore = first != null ? first.getNode() : null;
            this.getNode().addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", anchorBefore);
            this.getNode().addChild(newNameNode, anchorBefore);
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(6);
        }
        throw new IncorrectOperationException("NYI");
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof PsiMethod && this.getManager().areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(7);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GrAnnotation annotation = PsiImplUtil.getAnnotation(this);
        if (annotation != null) {
            String name;
            GrCodeReferenceElement ref = annotation.getClassReference();
            PsiElement resolved = ref.resolve();
            String declaredName = this.getName();
            String string = name = declaredName == null ? "value" : declaredName;
            if (resolved instanceof PsiClass) {
                PsiAnnotation collector = GrAnnotationCollector.findAnnotationCollector((PsiClass)resolved);
                if (collector != null) {
                    GroovyResolveResult[] groovyResolveResultArray = GrAnnotationNameValuePairImpl.multiResolveFromAlias(annotation, name, collector);
                    if (groovyResolveResultArray == null) {
                        GrAnnotationNameValuePairImpl.$$$reportNull$$$0(8);
                    }
                    return groovyResolveResultArray;
                }
                if (((PsiClass)resolved).isAnnotationType()) {
                    GroovyResolveResult[] groovyResolveResultArray = GrAnnotationNameValuePairImpl.multiResolveFromAnnotationType((PsiClass)resolved, name);
                    if (groovyResolveResultArray == null) {
                        GrAnnotationNameValuePairImpl.$$$reportNull$$$0(9);
                    }
                    return groovyResolveResultArray;
                }
            }
        }
        if (GroovyResolveResult.EMPTY_ARRAY == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(10);
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private static GroovyResolveResult[] multiResolveFromAnnotationType(@NotNull PsiClass resolved, @NotNull String name) {
        PsiMethod[] methods;
        if (resolved == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(11);
        }
        if (name == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(12);
        }
        if ((methods = resolved.findMethodsByName(name, false)).length == 0) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] results2 = new GroovyResolveResult[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            PsiMethod method = methods[i];
            results2[i] = new GroovyResolveResultImpl((PsiElement)method, true);
        }
        return results2;
    }

    private static GroovyResolveResult[] multiResolveFromAlias(@NotNull GrAnnotation alias, @NotNull String name, @NotNull PsiAnnotation annotationCollector) {
        if (alias == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(13);
        }
        if (name == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(14);
        }
        if (annotationCollector == null) {
            GrAnnotationNameValuePairImpl.$$$reportNull$$$0(15);
        }
        ArrayList result = ContainerUtilRt.newArrayList();
        ArrayList annotations2 = ContainerUtilRt.newArrayList();
        GrAnnotationCollector.collectAnnotations(annotations2, alias, annotationCollector);
        for (GrAnnotation annotation : annotations2) {
            PsiElement clazz = annotation.getClassReference().resolve();
            if (!(clazz instanceof PsiClass) || !((PsiClass)clazz).isAnnotationType() || "groovy.transform.AnnotationCollector".equals(((PsiClass)clazz).getQualifiedName())) continue;
            for (PsiMethod method : ((PsiClass)clazz).findMethodsByName(name, false)) {
                result.add(new GroovyResolveResultImpl((PsiElement)method, true));
            }
        }
        return result.toArray(new GroovyResolveResult[result.size()]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationNameValuePairImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationNameValuePairImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveFromAnnotationType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveFromAlias";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

