/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public abstract class GrTypeDefinitionBodyBase
extends GrStubElementBase<EmptyStub>
implements GrTypeDefinitionBody {
    public GrTypeDefinitionBodyBase(@NotNull ASTNode node) {
        if (node == null) {
            GrTypeDefinitionBodyBase.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrTypeDefinitionBodyBase(EmptyStub stub, IStubElementType classBody) {
        super(stub, classBody);
    }

    @Override
    public abstract void accept(GroovyElementVisitor var1);

    public String toString() {
        return "Type definition body";
    }

    @Override
    @NotNull
    public GrField[] getFields() {
        GrVariableDeclaration[] declarations = (GrVariableDeclaration[])this.getStubOrPsiChildren(GroovyElementTypes.VARIABLE_DEFINITION, GrVariableDeclaration.ARRAY_FACTORY);
        ArrayList result = ContainerUtil.newArrayList();
        for (GrVariableDeclaration declaration : declarations) {
            GrVariable[] variables;
            for (GrVariable variable : variables = declaration.getVariables()) {
                if (!(variable instanceof GrField)) continue;
                result.add((GrField)variable);
            }
        }
        GrField[] grFieldArray = result.toArray(new GrField[result.size()]);
        if (grFieldArray == null) {
            GrTypeDefinitionBodyBase.$$$reportNull$$$0(1);
        }
        return grFieldArray;
    }

    @Override
    @NotNull
    public GrMethod[] getMethods() {
        GrMethod[] grMethodArray = (GrMethod[])this.getStubOrPsiChildren(TokenSets.METHOD_DEFS, GrMethod.ARRAY_FACTORY);
        if (grMethodArray == null) {
            GrTypeDefinitionBodyBase.$$$reportNull$$$0(2);
        }
        return grMethodArray;
    }

    @Override
    @NotNull
    public GrMembersDeclaration[] getMemberDeclarations() {
        GrMembersDeclaration[] grMembersDeclarationArray = (GrMembersDeclaration[])this.findChildrenByClass(GrMembersDeclaration.class);
        if (grMembersDeclarationArray == null) {
            GrTypeDefinitionBodyBase.$$$reportNull$$$0(3);
        }
        return grMembersDeclarationArray;
    }

    @Override
    @Nullable
    public PsiElement getLBrace() {
        return this.findChildByType(GroovyTokenTypes.mLCURLY);
    }

    @Override
    @Nullable
    public PsiElement getRBrace() {
        return this.findChildByType(GroovyTokenTypes.mRCURLY);
    }

    @Override
    @NotNull
    public GrClassInitializer[] getInitializers() {
        GrClassInitializer[] grClassInitializerArray = (GrClassInitializer[])this.findChildrenByClass(GrClassInitializer.class);
        if (grClassInitializerArray == null) {
            GrTypeDefinitionBodyBase.$$$reportNull$$$0(4);
        }
        return grClassInitializerArray;
    }

    @Override
    @NotNull
    public GrTypeDefinition[] getInnerClasses() {
        GrTypeDefinition[] grTypeDefinitionArray = (GrTypeDefinition[])this.getStubOrPsiChildren(TokenSets.TYPE_DEFINITIONS, GrTypeDefinition.ARRAY_FACTORY);
        if (grTypeDefinitionArray == null) {
            GrTypeDefinitionBodyBase.$$$reportNull$$$0(5);
        }
        return grTypeDefinitionArray;
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        PsiElement rBrace = this.getRBrace();
        if (anchor == null && rBrace == null) {
            throw new IncorrectOperationException();
        }
        if (anchor != null && !this.equals(anchor.getParent())) {
            throw new IncorrectOperationException();
        }
        ASTNode elemNode = declaration.getNode();
        ASTNode anchorNode = anchor != null ? anchor.getNode() : rBrace.getNode();
        this.getNode().addChild(elemNode, anchorNode);
        this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchorNode);
        return (GrVariableDeclaration)elemNode.getPsi();
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement element;
        if (child == null) {
            GrTypeDefinitionBodyBase.$$$reportNull$$$0(6);
        }
        if ((element = child.getPsi()) instanceof GrTopStatement) {
            PsiImplUtil.deleteStatementTail(this, element);
        }
        super.deleteChildInternal(child);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        if (last instanceof GrTopStatement) {
            PsiImplUtil.deleteStatementTail(this, last);
        }
        super.deleteChildRange(first, last);
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode afterLast = last.getTreeNext();
        ASTNode child = first;
        while (child != afterLast) {
            ASTNode next = child.getTreeNext();
            if (child.getElementType() == GroovyElementTypes.CONSTRUCTOR_DEFINITION) {
                ASTNode oldIdentifier = child.findChildByType(GroovyTokenTypes.mIDENT);
                ASTNode newIdentifier = ((GrTypeDefinition)this.getParent()).getNameIdentifierGroovy().getNode().copyElement();
                child.replaceChild(oldIdentifier, newIdentifier);
            }
            child = next;
        }
        return super.addInternal(first, last, anchor, before);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionBodyBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionBodyBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberDeclarations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GrEnumBody
    extends GrTypeDefinitionBodyBase
    implements GrEnumDefinitionBody,
    StubBasedPsiElement<EmptyStub> {
        public GrEnumBody(@NotNull ASTNode node) {
            if (node == null) {
                GrEnumBody.$$$reportNull$$$0(0);
            }
            super(node);
        }

        public GrEnumBody(EmptyStub stub) {
            super(stub, (IStubElementType)GroovyElementTypes.ENUM_BODY);
        }

        @Override
        @Nullable
        public GrEnumConstantList getEnumConstantList() {
            return (GrEnumConstantList)this.getStubOrPsiChild((IStubElementType)GroovyElementTypes.ENUM_CONSTANTS);
        }

        @Override
        @NotNull
        public GrEnumConstant[] getEnumConstants() {
            GrEnumConstantList list = this.getEnumConstantList();
            if (list != null) {
                GrEnumConstant[] grEnumConstantArray = list.getEnumConstants();
                if (grEnumConstantArray == null) {
                    GrEnumBody.$$$reportNull$$$0(1);
                }
                return grEnumConstantArray;
            }
            if (GrEnumConstant.EMPTY_ARRAY == null) {
                GrEnumBody.$$$reportNull$$$0(2);
            }
            return GrEnumConstant.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public GrField[] getFields() {
            Object[] bodyFields = super.getFields();
            Object[] enumConstants = this.getEnumConstants();
            if (bodyFields.length == 0) {
                if (enumConstants == null) {
                    GrEnumBody.$$$reportNull$$$0(3);
                }
                return enumConstants;
            }
            if (enumConstants.length == 0) {
                if (bodyFields == null) {
                    GrEnumBody.$$$reportNull$$$0(4);
                }
                return bodyFields;
            }
            GrField[] grFieldArray = (GrField[])ArrayUtil.mergeArrays((Object[])bodyFields, (Object[])enumConstants);
            if (grFieldArray == null) {
                GrEnumBody.$$$reportNull$$$0(5);
            }
            return grFieldArray;
        }

        @Override
        public void accept(GroovyElementVisitor visitor2) {
            visitor2.visitEnumDefinitionBody(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionBodyBase$GrEnumBody";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionBodyBase$GrEnumBody";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnumConstants";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFields";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class GrClassBody
    extends GrTypeDefinitionBodyBase
    implements StubBasedPsiElement<EmptyStub> {
        public GrClassBody(@NotNull ASTNode node) {
            if (node == null) {
                GrClassBody.$$$reportNull$$$0(0);
            }
            super(node);
        }

        public GrClassBody(EmptyStub stub) {
            super(stub, (IStubElementType)GroovyElementTypes.CLASS_BODY);
        }

        @Override
        public void accept(GroovyElementVisitor visitor2) {
            visitor2.visitTypeDefinitionBody(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionBodyBase$GrClassBody", "<init>"));
        }
    }
}

