/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrCharConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        if (position == null) {
            GrCharConverter.$$$reportNull$$$0(0);
        }
        return position == GrTypeConverter.ApplicableTo.ASSIGNMENT || position == GrTypeConverter.ApplicableTo.RETURN_VALUE;
    }

    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        GrExpression rValue;
        if (lType == null) {
            GrCharConverter.$$$reportNull$$$0(1);
        }
        if (rType == null) {
            GrCharConverter.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GrCharConverter.$$$reportNull$$$0(3);
        }
        if (currentPosition == null) {
            GrCharConverter.$$$reportNull$$$0(4);
        }
        if (!PsiType.CHAR.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(lType))) {
            return null;
        }
        if (PsiType.CHAR.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(rType))) {
            return ConversionResult.OK;
        }
        if (TypesUtil.isNumericType(rType)) {
            if (rType instanceof PsiPrimitiveType || TypesUtil.unboxPrimitiveTypeWrapper(rType) instanceof PsiPrimitiveType) {
                return PsiType.CHAR.equals((Object)lType) ? ConversionResult.OK : ConversionResult.ERROR;
            }
            return ConversionResult.ERROR;
        }
        if (context instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)context;
            rValue = assignmentExpression.getRValue();
        } else if (context instanceof GrVariable) {
            GrVariable assignmentExpression = (GrVariable)context;
            rValue = assignmentExpression.getInitializerGroovy();
        } else {
            rValue = null;
        }
        if (rValue instanceof GrListOrMap && ((GrListOrMap)rValue).isEmpty()) {
            return ConversionResult.WARNING;
        }
        if (PsiType.BOOLEAN.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(rType))) {
            switch (currentPosition) {
                case ASSIGNMENT: 
                case RETURN_VALUE: {
                    return ConversionResult.WARNING;
                }
            }
            return null;
        }
        if (currentPosition == GrTypeConverter.ApplicableTo.RETURN_VALUE) {
            return null;
        }
        if (!TypesUtil.isClassType(rType, "java.lang.String")) {
            return null;
        }
        return GrCharConverter.checkSingleSymbolLiteral(context) ? ConversionResult.OK : ConversionResult.ERROR;
    }

    public static boolean checkSingleSymbolLiteral(GroovyPsiElement context) {
        GrLiteral literal = GrCharConverter.getLiteral(context);
        Object value = literal == null ? null : literal.getValue();
        return value != null && value.toString().length() == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPosition";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrCharConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableTo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConvertibleEx";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

