/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.AnnotationHint;
import org.jetbrains.plugins.groovy.lang.resolve.ClassResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B3\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J#\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0017\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\rH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/ClassProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GrScopeProcessorWithHints;", "Lorg/jetbrains/plugins/groovy/lang/resolve/AnnotationHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/GrResolverProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/ClassResolveResult;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "typeArguments", "", "Lcom/intellij/psi/PsiType;", "annotationResolve", "", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/PsiType;Z)V", "myResults", "Lcom/intellij/util/SmartList;", "results", "", "getResults", "()Ljava/util/List;", "[Lcom/intellij/psi/PsiType;", "execute", "element", "state", "Lcom/intellij/psi/ResolveState;", "getHint", "T", "hintKey", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "isAnnotationResolve", "groovy-psi"})
public final class ClassProcessor
extends GrScopeProcessorWithHints
implements AnnotationHint,
GrResolverProcessor<ClassResolveResult> {
    private final SmartList<ClassResolveResult> myResults;
    private final PsiElement place;
    private final PsiType[] typeArguments;
    private final boolean annotationResolve;

    @Override
    @NotNull
    public List<ClassResolveResult> getResults() {
        return (List)this.myResults;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        PsiElement psiElement = element;
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (psiClass == null) {
            return true;
        }
        PsiClass clazz = psiClass;
        if (clazz instanceof PsiTypeParameter) {
            return true;
        }
        PsiSubstitutor psiSubstitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        if (psiSubstitutor == null) {
            PsiSubstitutor psiSubstitutor2 = PsiSubstitutor.EMPTY;
            psiSubstitutor = psiSubstitutor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor2, (String)"PsiSubstitutor.EMPTY");
        }
        PsiSubstitutor substitutor = psiSubstitutor;
        Collection collection = (Collection)this.myResults;
        PsiElement psiElement2 = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
        PsiSubstitutor psiSubstitutor3 = substitutor.putAll(clazz, this.typeArguments);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor3, (String)"substitutor.putAll(clazz, typeArguments)");
        ClassResolveResult classResolveResult = new ClassResolveResult(clazz, this.place, psiElement2, psiSubstitutor3);
        collection.add(classResolveResult);
        return false;
    }

    @Override
    @Nullable
    public <T> T getHint(@NotNull Key<T> hintKey) {
        Intrinsics.checkParameterIsNotNull(hintKey, (String)"hintKey");
        if (Intrinsics.areEqual(hintKey, AnnotationHint.HINT_KEY) && this.annotationResolve) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    @Override
    public boolean isAnnotationResolve() {
        return this.annotationResolve;
    }

    public ClassProcessor(@NotNull String name, @Nullable PsiElement place, @NotNull PsiType[] typeArguments, boolean annotationResolve) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)typeArguments, (String)"typeArguments");
        super(name, (Set<ElementClassHint.DeclarationKind>)ClassHint.RESOLVE_KINDS_CLASS);
        this.place = place;
        this.typeArguments = typeArguments;
        this.annotationResolve = annotationResolve;
        this.myResults = new SmartList();
    }

    public /* synthetic */ ClassProcessor(String string, PsiElement psiElement, PsiType[] psiTypeArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiType.EMPTY_ARRAY, (String)"PsiType.EMPTY_ARRAY");
            psiTypeArray = PsiType.EMPTY_ARRAY;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, psiElement, psiTypeArray, bl);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getResultsArray() {
        return GrResolverProcessor.DefaultImpls.getResultsArray(this);
    }
}

