/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToStatic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.VisitorCallback;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.DynamicFeaturesVisitor;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.TypeChecker;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.fixes.BaseFix;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.fixes.EmptyFieldTypeFix;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.fixes.EmptyReturnTypeFix;

public class ConvertToStaticProcessor
extends BaseRefactoringProcessor {
    private static final int maxIterations = 5;
    private static final Logger LOG = Logger.getInstance(ConvertToStaticProcessor.class);
    private final GroovyFile[] myFiles;
    private BaseFix[] myFixes = new BaseFix[]{new EmptyFieldTypeFix(), new EmptyReturnTypeFix()};

    public ConvertToStaticProcessor(Project project, GroovyFile ... files) {
        super(project);
        this.myFiles = files;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(0);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = ConvertToStaticProcessor.this.myFiles;
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return GroovyRefactoringBundle.message("files.to.be.converted", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(1);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (UsageInfo.EMPTY_ARRAY == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(2);
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(3);
        }
        int counter = 0;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        LOG.assertTrue(progressIndicator != null);
        progressIndicator.setIndeterminate(false);
        for (GroovyFile file : this.myFiles) {
            ++counter;
            this.commitFile(file);
            if (file.isScript()) continue;
            progressIndicator.setText2(file.getName());
            progressIndicator.setFraction((double)counter / (double)this.myFiles.length);
            try {
                this.applyFixes(file);
                this.putCompileAnnotations(file);
                ConvertToStaticProcessor.applyErrorFixes(file);
                this.commitFile(file);
            }
            catch (Exception e) {
                LOG.error("Error in converting file: " + file.getName(), (Throwable)e);
            }
        }
    }

    private void commitFile(@NotNull GroovyFile file) {
        if (file == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(4);
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)file);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        LOG.assertTrue(document != null);
        psiDocumentManager.commitDocument(document);
        LOG.assertTrue(file.isValid());
    }

    private void applyFixes(GroovyFile file) {
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                for (BaseFix fix : ConvertToStaticProcessor.this.myFixes) {
                    element.accept((PsiElementVisitor)new GroovyPsiElementVisitor(fix));
                }
                super.visitElement(element);
            }
        });
    }

    private void putCompileAnnotations(@NotNull GroovyFile file) {
        GrTypeDefinition[] classes2;
        if (file == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(5);
        }
        for (GrTypeDefinition typeDef : classes2 = file.getTypeDefinitions()) {
            this.addAnnotation((PsiModifierListOwner)typeDef, true);
        }
        HashSet<GrTypeDefinition> classesWithUnresolvedRef = new HashSet<GrTypeDefinition>();
        HashSet<GrMethod> methodsWithUnresolvedRef = new HashSet<GrMethod>();
        VisitorCallback callback = (element, info) -> {
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
            if (containingMethod != null) {
                methodsWithUnresolvedRef.add(containingMethod);
                return;
            }
            GrTypeDefinition containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)element, GrTypeDefinition.class);
            if (containingClass != null) {
                classesWithUnresolvedRef.add(containingClass);
            }
        };
        file.accept(new DynamicFeaturesVisitor(file, this.myProject, callback));
        for (GrTypeDefinition typeDef : classes2) {
            this.processDefinitions(typeDef, classesWithUnresolvedRef, methodsWithUnresolvedRef, false);
        }
    }

    private void processDefinitions(GrTypeDefinition typeDef, Set<GrTypeDefinition> dynamicClasses, Set<GrMethod> dynamicMethods, boolean isOuterStatic) {
        boolean isStatic;
        boolean bl = isStatic = !dynamicClasses.contains(typeDef);
        if (isOuterStatic && !isStatic) {
            this.addAnnotation((PsiModifierListOwner)typeDef, false);
        }
        if (!isOuterStatic && isStatic) {
            this.addAnnotation((PsiModifierListOwner)typeDef, true);
        }
        if (!isOuterStatic && !isStatic) {
            this.removeAnnotation((PsiModifierListOwner)typeDef);
        }
        for (GrMethod grMethod : typeDef.getCodeMethods()) {
            if (dynamicMethods.stream().anyMatch(arg_0 -> ((GrMethod)grMethod).isEquivalentTo(arg_0)) != isStatic) continue;
            this.addAnnotation(grMethod, !isStatic);
        }
        for (GrDocCommentOwner grDocCommentOwner : typeDef.getCodeInnerClasses()) {
            this.processDefinitions((GrTypeDefinition)grDocCommentOwner, dynamicClasses, dynamicMethods, isStatic);
        }
    }

    private static void applyErrorFixes(@NotNull GroovyFile file) {
        if (file == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(6);
        }
        for (int iteration = 0; iteration < 5; ++iteration) {
            final TypeChecker checker = new TypeChecker();
            file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    if (PsiUtil.isCompileStatic(element)) {
                        element.accept((PsiElementVisitor)new GroovyPsiElementVisitor(checker));
                    }
                    super.visitElement(element);
                }
            });
            if (checker.applyFixes() != 0) continue;
            return;
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = GroovyRefactoringBundle.message("converting.files.to.static", new Object[0]);
        if (string == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    void addAnnotation(@NotNull PsiModifierListOwner owner, boolean isStatic) {
        String annotation;
        if (owner == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(8);
        }
        PsiModifierList modifierList = owner.getModifierList();
        String string = annotation = isStatic ? "groovy.transform.CompileStatic" : "groovy.transform.CompileDynamic";
        if (modifierList != null && modifierList.findAnnotation(annotation) == null) {
            modifierList.addAnnotation(annotation);
        }
    }

    void removeAnnotation(@NotNull PsiModifierListOwner owner) {
        PsiAnnotation psiAnnotation;
        PsiModifierList modifierList;
        if (owner == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(9);
        }
        if ((modifierList = owner.getModifierList()) != null && (psiAnnotation = modifierList.findAnnotation("groovy.transform.CompileStatic")) != null) {
            psiAnnotation.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "commitFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putCompileAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyErrorFixes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

