/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameJavaMethodProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.rename.RenameAliasedUsagesUtil;

public class RenameAliasImportedMethodProcessor
extends RenameJavaMethodProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof GroovyPsiElement && super.canProcessElement(element);
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        Collection<PsiReference> collection = RenameAliasedUsagesUtil.filterAliasedRefs(super.findReferences(element), element);
        if (collection == null) {
            RenameAliasImportedMethodProcessor.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public RenameDialog createRenameDialog(Project project, PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        return new RenameDialog(project, element, nameSuggestionContext, editor){

            protected boolean areButtonsValid() {
                return true;
            }
        };
    }

    public void renameElement(PsiElement psiElement, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        PsiElement element;
        boolean isGetter = GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)psiElement);
        boolean isSetter = GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)psiElement);
        ArrayList<UsageInfo> methodAccess = new ArrayList<UsageInfo>(usages.length);
        ArrayList<UsageInfo> propertyAccess = new ArrayList<UsageInfo>(usages.length);
        for (UsageInfo usage : usages) {
            element = usage.getElement();
            if (element instanceof GrReferenceExpression && ((GrReferenceExpression)element).advancedResolve().isInvokedOnProperty()) {
                propertyAccess.add(usage);
                continue;
            }
            methodAccess.add(usage);
        }
        super.renameElement(psiElement, newName, methodAccess.toArray(new UsageInfo[methodAccess.size()]), listener);
        String propertyName = isGetter ? GroovyPropertyUtils.getPropertyNameByGetterName(newName, true) : (isSetter ? GroovyPropertyUtils.getPropertyNameBySetterName(newName) : null);
        if (propertyName == null) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(psiElement.getProject());
            for (UsageInfo info : propertyAccess) {
                String qualifierPrefix;
                element = info.getElement();
                if (!(element instanceof GrReferenceExpression)) continue;
                PsiElement qualifier = ((GrReferenceExpression)element).getQualifier();
                String string = qualifierPrefix = qualifier == null ? "" : qualifier.getText() + ".";
                if (isGetter) {
                    GrExpression call = factory.createExpressionFromText(qualifierPrefix + newName + "()");
                    ((GrReferenceExpression)element).replaceWithExpression(call, true);
                    continue;
                }
                PsiElement parent = element.getParent();
                assert (parent instanceof GrAssignmentExpression);
                GrExpression rValue = ((GrAssignmentExpression)parent).getRValue();
                GrExpression call = factory.createExpressionFromText(qualifierPrefix + newName + "(" + (rValue == null ? "" : rValue.getText()) + ")");
                ((GrAssignmentExpression)parent).replaceWithExpression(call, true);
            }
        } else {
            for (UsageInfo usage : propertyAccess) {
                PsiReference ref = usage.getReference();
                if (ref == null) continue;
                ref.handleElementRename(propertyName);
            }
        }
    }

    public void findCollisions(PsiElement element, final String newName, Map<? extends PsiElement, String> allRenames, List<UsageInfo> result) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            OverridingMethodsSearch.search((PsiMethod)method).forEach(overrider -> {
                PsiMethod original = overrider;
                if (overrider instanceof PsiMirrorElement) {
                    original = ((PsiMirrorElement)overrider).getPrototype();
                }
                if (original instanceof SyntheticElement) {
                    return true;
                }
                if (original instanceof GrField) {
                    result.add((UsageInfo)new FieldNameCollisionInfo((GrField)original, method));
                }
                return true;
            });
        }
        ListIterator<UsageInfo> iterator2 = result.listIterator();
        while (iterator2.hasNext()) {
            UsageInfo info = iterator2.next();
            final PsiElement ref = info.getElement();
            if (ref instanceof GrReferenceExpression || ref == null || RenameUtil.isValidName((Project)element.getProject(), (PsiElement)ref, (String)newName)) continue;
            iterator2.add((UsageInfo)new UnresolvableCollisionUsageInfo(ref, element){

                public String getDescription() {
                    return RefactoringBundle.message((String)"0.is.not.an.identifier", (Object[])new Object[]{newName, ref.getText()});
                }
            });
        }
    }

    @Nullable
    protected PsiElement processRef(PsiReference ref, String newName) {
        PsiElement element = ref.getElement();
        if (RenameUtil.isValidName((Project)element.getProject(), (PsiElement)element, (String)newName) || element instanceof GrReferenceElement) {
            return super.processRef(ref, newName);
        }
        if (!(element instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement nameElement = ((PsiReferenceExpression)element).getReferenceNameElement();
        TextRange range = nameElement.getTextRange();
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(nameElement.getContainingFile());
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newName);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/rename/RenameAliasImportedMethodProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/rename/RenameAliasImportedMethodProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FieldNameCollisionInfo
    extends UnresolvableCollisionUsageInfo {
        private final String myName;
        private final String myBaseName;

        public FieldNameCollisionInfo(GrField field, PsiMethod baseMethod) {
            super((PsiElement)field, (PsiElement)field);
            this.myName = field.getName();
            this.myBaseName = baseMethod.getName();
        }

        public String getDescription() {
            return GroovyRefactoringBundle.message("cannot.rename.property.0", this.myName, this.myBaseName);
        }
    }
}

