/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;

public class RenameGroovyScriptProcessor
extends RenamePsiFileProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameGroovyScriptProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof GroovyFile && ((GroovyFile)element).isScript();
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        String scriptName;
        PsiClass script;
        if (element instanceof GroovyFile && (script = ((GroovyFile)element).getScriptClass()) != null && script.isValid() && StringUtil.isJavaIdentifier((String)(scriptName = FileUtil.getNameWithoutExtension((String)newName)))) {
            allRenames.put((PsiElement)script, scriptName);
        }
    }

    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts) {
        String scriptName = FileUtil.getNameWithoutExtension((String)newName);
        if (!StringUtil.isJavaIdentifier((String)scriptName)) {
            PsiClass script = ((GroovyFile)element).getScriptClass();
            conflicts.putValue((Object)script, (Object)GroovyRefactoringBundle.message("cannot.rename.script.class.to.0", script.getName(), scriptName));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/refactoring/rename/RenameGroovyScriptProcessor", "canProcessElement"));
    }
}

