/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.run.PluginRunConfiguration;

public class PluginConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactory(this){

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                1.$$$reportNull$$$0(0);
            }
            PluginRunConfiguration runConfiguration = new PluginRunConfiguration(project, this, "");
            runConfiguration.VM_PARAMETERS = runConfiguration.VM_PARAMETERS == null ? PluginConfigurationType.this.getVmParameters() : runConfiguration.VM_PARAMETERS + PluginConfigurationType.this.getVmParameters();
            PluginRunConfiguration pluginRunConfiguration = runConfiguration;
            if (pluginRunConfiguration == null) {
                1.$$$reportNull$$$0(1);
            }
            return pluginRunConfiguration;
        }

        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                1.$$$reportNull$$$0(2);
            }
            return ModuleUtil.hasModulesOfType((Project)project, (ModuleType)PluginModuleType.getInstance());
        }

        public boolean isConfigurationSingletonByDefault() {
            return true;
        }

        public RunConfiguration createConfiguration(String name, RunConfiguration template) {
            PluginRunConfiguration pluginRunConfiguration = (PluginRunConfiguration)template;
            if (pluginRunConfiguration.getModule() == null) {
                Collection modules = ModuleUtil.getModulesOfType((Project)pluginRunConfiguration.getProject(), (ModuleType)PluginModuleType.getInstance());
                pluginRunConfiguration.setModule((Module)ContainerUtil.getFirstItem((Collection)modules));
            }
            return super.createConfiguration(name, (RunConfiguration)pluginRunConfiguration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/run/PluginConfigurationType$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/run/PluginConfigurationType$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private String myVmParameters = "-Xmx512m -Xms256m -XX:MaxPermSize=250m -ea";

    public String getDisplayName() {
        return DevKitBundle.message("run.configuration.title", new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return DevKitBundle.message("run.configuration.type.description", new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.Nodes.Plugin;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NotNull
    public String getId() {
        if ("#org.jetbrains.idea.devkit.run.PluginConfigurationType" == null) {
            PluginConfigurationType.$$$reportNull$$$0(0);
        }
        return "#org.jetbrains.idea.devkit.run.PluginConfigurationType";
    }

    @NotNull
    private String getVmParameters() {
        if (this.myVmParameters == null) {
            String vmOptions;
            try {
                vmOptions = FileUtil.loadFile((File)new File(PathManager.getBinPath(), "idea.plugins.vmoptions"));
            }
            catch (IOException e) {
                vmOptions = VMOptions.read();
            }
            this.myVmParameters = vmOptions != null ? vmOptions.replaceAll("\\s+", " ").trim() : "";
        }
        String string = this.myVmParameters;
        if (string == null) {
            PluginConfigurationType.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/devkit/run/PluginConfigurationType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmParameters";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

