/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class TestDataGuessByExistingFilesUtil {
    private static final Logger LOG = Logger.getInstance(TestDataGuessByExistingFilesUtil.class);

    private TestDataGuessByExistingFilesUtil() {
    }

    @NotNull
    static List<String> collectTestDataByExistingFiles(@NotNull PsiMethod psiMethod) {
        Application application;
        if (psiMethod == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(0);
        }
        if (!(application = ApplicationManager.getApplication()).isUnitTestMode() && application.isHeadlessEnvironment()) {
            LOG.warn("Collecting testdata by existing files called in headless environment and not-unit testing mode");
            List<String> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        TestDataDescriptor descriptor = TestDataGuessByExistingFilesUtil.buildDescriptorFromExistingTestData(psiMethod);
        if (descriptor == null || !descriptor.isComplete()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<String> list = descriptor.generate();
        if (list == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    static String guessTestDataName(PsiMethod method) {
        String testName = TestDataGuessByExistingFilesUtil.getTestName(method);
        if (testName == null) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        int count = 5;
        PsiMethod prev = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)method, PsiMethod.class);
        while (prev != null && count-- > 0) {
            String s = TestDataGuessByExistingFilesUtil.getFilePath(prev, testName);
            if (s != null) {
                return s;
            }
            prev = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiMethod.class);
        }
        count = 5;
        PsiMethod next = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)method, PsiMethod.class);
        while (next != null && count-- > 0) {
            String s = TestDataGuessByExistingFilesUtil.getFilePath(next, testName);
            if (s != null) {
                return s;
            }
            next = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)next, PsiMethod.class);
        }
        return null;
    }

    @Nullable
    private static String getFilePath(PsiMethod psiMethod, String testName) {
        List<String> strings = TestDataGuessByExistingFilesUtil.collectTestDataByExistingFiles(psiMethod);
        if (!strings.isEmpty()) {
            String s = strings.get(0);
            return new File(new File(s).getParent(), testName + "." + FileUtilRt.getExtension((String)new File(s).getName())).getPath();
        }
        return null;
    }

    @Nullable
    private static String getTestName(@NotNull PsiMethod method) {
        PsiClass psiClass;
        if (method == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(4);
        }
        if ((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class)) == null) {
            return null;
        }
        TestFramework framework = TestFrameworks.detectFramework((PsiClass)psiClass);
        if (framework == null || TestDataGuessByExistingFilesUtil.isUtilityMethod(method, psiClass, framework)) {
            return null;
        }
        return TestDataGuessByExistingFilesUtil.getTestName(method.getName());
    }

    private static boolean isUtilityMethod(@NotNull PsiMethod method, @NotNull PsiClass psiClass, @NotNull TestFramework framework) {
        if (method == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(6);
        }
        if (framework == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(7);
        }
        if (method == framework.findSetUpMethod((PsiElement)psiClass) || method == framework.findTearDownMethod((PsiElement)psiClass)) {
            return true;
        }
        if (framework.getClass().getName().contains("JUnit3")) {
            return !method.getName().startsWith("test");
        }
        if (framework.getClass().getName().contains("JUnit4")) {
            return !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Test", (int)0);
        }
        return false;
    }

    @NotNull
    public static String getTestName(@NotNull String methodName) {
        if (methodName == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(8);
        }
        String string = StringUtil.trimStart((String)methodName, (String)"test");
        if (string == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static TestDataDescriptor buildDescriptorFromExistingTestData(@NotNull PsiMethod method) {
        TestDataDescriptor cachedValue;
        if (method == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(10);
        }
        return (cachedValue = (TestDataDescriptor)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            if (method == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(26);
            }
            return new CachedValueProvider.Result((Object)TestDataGuessByExistingFilesUtil.buildDescriptor(method), new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        })) == TestDataDescriptor.NOTHING_FOUND ? null : cachedValue;
    }

    private static TestDataDescriptor buildDescriptor(PsiMethod psiMethod) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiMethod, PsiClass.class);
        String testName = TestDataGuessByExistingFilesUtil.getTestName(psiMethod);
        if (testName == null || psiClass == null) {
            return TestDataDescriptor.NOTHING_FOUND;
        }
        return TestDataGuessByExistingFilesUtil.buildDescriptor(testName, psiClass);
    }

    public static List<String> suggestTestDataFiles(@NotNull String testName, String testDataPath, @NotNull PsiClass psiClass) {
        if (testName == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(11);
        }
        if (psiClass == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(12);
        }
        return TestDataGuessByExistingFilesUtil.buildDescriptor(testName, psiClass).generate(testName, testDataPath);
    }

    @NotNull
    private static TestDataDescriptor buildDescriptor(@NotNull String test, @NotNull PsiClass psiClass) {
        if (test == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(13);
        }
        if (psiClass == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(14);
        }
        String possibleFileName = (String)ContainerUtil.getLastItem((List)StringUtil.split((String)test, (String)"$"), (Object)test);
        assert (possibleFileName != null);
        if (possibleFileName.isEmpty()) {
            TestDataDescriptor testDataDescriptor = TestDataDescriptor.NOTHING_FOUND;
            if (testDataDescriptor == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(15);
            }
            return testDataDescriptor;
        }
        Project project = psiClass.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        GotoFileModel gotoModel = new GotoFileModel(project);
        String possibleFilePath = test.replace('$', '/');
        HashMap descriptorsByFileNames = new HashMap();
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> TestDataGuessByExistingFilesUtil.lambda$buildDescriptor$3(psiClass, possibleFileName, gotoModel, fileIndex, possibleFilePath, test, project, (Map)descriptorsByFileNames), DevKitBundle.message("testdata.searching", new Object[0]), true, project);
        if (!completed) {
            throw new ProcessCanceledException();
        }
        TestDataGuessByExistingFilesUtil.filterDirsFromOtherModules((Map<String, TestLocationDescriptor>)descriptorsByFileNames);
        TestDataDescriptor testDataDescriptor = new TestDataDescriptor(descriptorsByFileNames.values(), possibleFileName);
        if (testDataDescriptor == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(16);
        }
        return testDataDescriptor;
    }

    private static Collection<String> getAllFileNames(final String testName, GotoFileModel model) {
        CommonProcessors.CollectProcessor<String> processor = new CommonProcessors.CollectProcessor<String>(){

            public boolean accept(String name) {
                ProgressManager.checkCanceled();
                return StringUtil.containsIgnoreCase((String)name, (String)testName);
            }
        };
        model.processNames((Processor)processor, false);
        return processor.getResults();
    }

    private static void filterDirsFromOtherModules(Map<String, TestLocationDescriptor> descriptorsByFileNames) {
        if (descriptorsByFileNames.size() < 2) {
            return;
        }
        if (descriptorsByFileNames.values().stream().noneMatch(descriptor -> descriptor.isFromCurrentModule)) {
            return;
        }
        descriptorsByFileNames.entrySet().removeIf(e -> !((TestLocationDescriptor)e.getValue()).isFromCurrentModule);
    }

    @Nullable
    private static String getSimpleClassName(@NotNull PsiClass psiClass) {
        String result;
        if (psiClass == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(17);
        }
        if ((result = psiClass.getQualifiedName()) == null) {
            return null;
        }
        int i = (result = StringUtil.trimEnd((String)result, (String)"Test")).lastIndexOf(46);
        if (i >= 0) {
            result = result.substring(i + 1);
        }
        return result;
    }

    private static boolean moreRelevantPath(@NotNull TestLocationDescriptor candidate, @NotNull TestLocationDescriptor current, @NotNull PsiClass psiClass) {
        boolean currentMatched;
        String packageAsPath;
        boolean candidateMatched;
        String className;
        if (candidate == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(18);
        }
        if (current == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(19);
        }
        if (psiClass == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(20);
        }
        if ((className = psiClass.getQualifiedName()) == null) {
            return false;
        }
        int lastDotIndex = className.lastIndexOf(".");
        String candidateLcDir = candidate.dir.toLowerCase();
        String currentLcDir = current.dir.toLowerCase();
        if (lastDotIndex >= 0 && (candidateMatched = candidateLcDir.contains(packageAsPath = className.substring(0, lastDotIndex).replace('.', '/').toLowerCase())) ^ (currentMatched = currentLcDir.contains(packageAsPath))) {
            return candidateMatched;
        }
        String simpleName = TestDataGuessByExistingFilesUtil.getSimpleClassName(psiClass);
        if (simpleName == null) {
            return false;
        }
        String pattern = simpleName.toLowerCase();
        candidateMatched = candidateLcDir.contains(pattern);
        if (candidateMatched ^ (currentMatched = currentLcDir.contains(pattern))) {
            return candidateMatched;
        }
        String[] words = NameUtil.nameToWords((String)simpleName);
        int candidateWordsMatched = 0;
        int currentWordsMatched = 0;
        int candidateMatchPosition = -1;
        int currentMatchPosition = -1;
        StringBuilder currentNameSubstringSb = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            int currentWordsIndex;
            currentNameSubstringSb.append(words[i]);
            String currentNameLcSubstring = currentNameSubstringSb.toString().toLowerCase();
            int candidateWordsIndex = candidateLcDir.lastIndexOf(currentNameLcSubstring);
            if (candidateWordsIndex > 0) {
                candidateWordsMatched = i + 1;
                candidateMatchPosition = candidateWordsIndex;
            }
            if ((currentWordsIndex = currentLcDir.lastIndexOf(currentNameLcSubstring)) > 0) {
                currentWordsMatched = i + 1;
                candidateMatchPosition = currentWordsIndex;
            }
            if (candidateWordsMatched != currentWordsMatched) break;
        }
        if (candidateWordsMatched != currentWordsMatched) {
            return candidateWordsMatched > currentWordsMatched;
        }
        return candidateMatchPosition > currentMatchPosition;
    }

    private static /* synthetic */ void lambda$buildDescriptor$3(@NotNull PsiClass psiClass, String possibleFileName, GotoFileModel gotoModel, ProjectFileIndex fileIndex, String possibleFilePath, @NotNull String test, Project project, Map descriptorsByFileNames) {
        if (psiClass == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(21);
        }
        if (test == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(22);
        }
        Module module = (Module)ReadAction.compute(() -> {
            if (psiClass == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(25);
            }
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        });
        Collection<String> fileNames = TestDataGuessByExistingFilesUtil.getAllFileNames(possibleFileName, gotoModel);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setIndeterminate(false);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (test == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(23);
            }
            if (psiClass == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(24);
            }
            int fileNamesCount = fileNames.size();
            double currentIndex = 0.0;
            for (String name : fileNames) {
                Object[] elements;
                ProgressManager.checkCanceled();
                for (Object element : elements = gotoModel.getElementsByName(name, false, name)) {
                    String fileName;
                    int i;
                    String filePath;
                    VirtualFile file;
                    if (!(element instanceof PsiFile) || (file = ((PsiFile)element).getVirtualFile()) == null || fileIndex.isInSource(file) && !fileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.RESOURCES) || !StringUtil.containsIgnoreCase((String)(filePath = file.getPath()), (String)possibleFilePath) && !StringUtil.containsIgnoreCase((String)filePath, (String)test) || (i = (fileName = PathUtil.getFileName((String)filePath).toLowerCase()).indexOf(possibleFileName.toLowerCase())) < 0 || i + possibleFileName.length() < fileName.length() && Character.isDigit(fileName.charAt(i + possibleFileName.length()))) continue;
                    TestLocationDescriptor current = new TestLocationDescriptor();
                    current.populate(possibleFileName, file, project, module);
                    if (!current.isComplete()) continue;
                    TestLocationDescriptor previousDescriptor = (TestLocationDescriptor)descriptorsByFileNames.get(name);
                    if (previousDescriptor == null) {
                        descriptorsByFileNames.put(name, current);
                        continue;
                    }
                    if (!TestDataGuessByExistingFilesUtil.moreRelevantPath(current, previousDescriptor, psiClass)) continue;
                    descriptorsByFileNames.put(name, current);
                }
                indicator.setFraction((currentIndex += 1.0) / (double)fileNamesCount);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 13: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTestDataByExistingFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTestDataByExistingFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 15: 
            case 16: {
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTestName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUtilityMethod";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildDescriptorFromExistingTestData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "suggestTestDataFiles";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildDescriptor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleClassName";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "moreRelevantPath";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildDescriptor$3";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildDescriptorFromExistingTestData$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TestDataDescriptor {
        private static final TestDataDescriptor NOTHING_FOUND = new TestDataDescriptor(Collections.emptyList(), null);
        private final List<TestLocationDescriptor> myDescriptors = new ArrayList<TestLocationDescriptor>();
        private final String myTestName;

        TestDataDescriptor(Collection<TestLocationDescriptor> descriptors, String testName) {
            this.myTestName = testName;
            this.myDescriptors.addAll(descriptors);
        }

        public boolean isComplete() {
            if (this.myDescriptors.isEmpty()) {
                return false;
            }
            for (TestLocationDescriptor descriptor : this.myDescriptors) {
                if (descriptor.isComplete()) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public List<String> generate(@NotNull String testName) {
            if (testName == null) {
                TestDataDescriptor.$$$reportNull$$$0(0);
            }
            List<String> list = this.generate(testName, null);
            if (list == null) {
                TestDataDescriptor.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public List<String> generate() {
            List<String> list = this.generate(this.myTestName, null);
            if (list == null) {
                TestDataDescriptor.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public List<String> generate(@NotNull String testName, String root) {
            if (testName == null) {
                TestDataDescriptor.$$$reportNull$$$0(3);
            }
            ArrayList<String> result = new ArrayList<String>();
            if (StringUtil.isEmpty((String)testName)) {
                ArrayList<String> arrayList = result;
                if (arrayList == null) {
                    TestDataDescriptor.$$$reportNull$$$0(4);
                }
                return arrayList;
            }
            for (TestLocationDescriptor descriptor : this.myDescriptors) {
                if (root != null && !root.equals(descriptor.dir)) continue;
                result.add(String.format("%s/%s%c%s%s%s", descriptor.dir, descriptor.filePrefix, Character.valueOf(descriptor.startWithLowerCase ? Character.toLowerCase(testName.charAt(0)) : Character.toUpperCase(testName.charAt(0))), testName.substring(1), descriptor.fileSuffix, StringUtil.isEmpty((String)descriptor.ext) ? "" : "." + descriptor.ext));
            }
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                TestDataDescriptor.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        public String toString() {
            return this.myDescriptors.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testName";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TestLocationDescriptor {
        public String dir;
        public String filePrefix;
        public String fileSuffix;
        public String ext;
        public boolean startWithLowerCase;
        public boolean isFromCurrentModule;

        private TestLocationDescriptor() {
        }

        public boolean isComplete() {
            return this.dir != null && this.filePrefix != null && this.fileSuffix != null && this.ext != null;
        }

        public void populate(@NotNull String testName, @NotNull VirtualFile matched, @NotNull Project project, @Nullable Module module) {
            if (testName == null) {
                TestLocationDescriptor.$$$reportNull$$$0(0);
            }
            if (matched == null) {
                TestLocationDescriptor.$$$reportNull$$$0(1);
            }
            if (project == null) {
                TestLocationDescriptor.$$$reportNull$$$0(2);
            }
            if (testName.isEmpty()) {
                return;
            }
            String withoutExtension = FileUtil.getNameWithoutExtension((String)testName);
            boolean excludeExtension = !withoutExtension.equals(testName);
            testName = withoutExtension;
            String fileName = matched.getNameWithoutExtension();
            int i = fileName.indexOf(testName);
            char firstChar = testName.charAt(0);
            boolean testNameStartsWithLowerCase = Character.isLowerCase(firstChar);
            if (i < 0) {
                i = fileName.indexOf((testNameStartsWithLowerCase ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar)) + testName.substring(1));
                this.startWithLowerCase = !testNameStartsWithLowerCase;
            } else {
                this.startWithLowerCase = testNameStartsWithLowerCase;
            }
            if (i < 0) {
                return;
            }
            this.filePrefix = fileName.substring(0, i);
            this.fileSuffix = fileName.substring(i + testName.length());
            this.ext = excludeExtension ? "" : matched.getExtension();
            this.dir = matched.getParent().getPath();
            if (module != null) {
                this.isFromCurrentModule = module.equals(ModuleUtilCore.findModuleForFile((VirtualFile)matched, (Project)project));
            }
        }

        public int hashCode() {
            int result = this.dir != null ? this.dir.hashCode() : 0;
            result = 31 * result + (this.filePrefix != null ? this.filePrefix.hashCode() : 0);
            result = 31 * result + (this.fileSuffix != null ? this.fileSuffix.hashCode() : 0);
            result = 31 * result + (this.ext != null ? this.ext.hashCode() : 0);
            result = 31 * result + (this.startWithLowerCase ? 1 : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestLocationDescriptor that = (TestLocationDescriptor)o;
            if (this.startWithLowerCase != that.startWithLowerCase) {
                return false;
            }
            if (this.dir != null ? !this.dir.equals(that.dir) : that.dir != null) {
                return false;
            }
            if (this.ext != null ? !this.ext.equals(that.ext) : that.ext != null) {
                return false;
            }
            if (this.filePrefix != null ? !this.filePrefix.equals(that.filePrefix) : that.filePrefix != null) {
                return false;
            }
            return !(this.fileSuffix != null ? !this.fileSuffix.equals(that.fileSuffix) : that.fileSuffix != null);
        }

        public String toString() {
            return String.format("%s/%s[...]%s.%s", this.dir, this.filePrefix, this.fileSuffix, this.ext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "testName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "matched";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestLocationDescriptor";
            objectArray[2] = "populate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

