/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.Nullable;

class FromArrayConversion {
    FromArrayConversion() {
    }

    static void addConversions(final PsiElement element, final String prefix, PsiType itemType, Consumer<LookupElement> result, @Nullable PsiElement qualifier, PsiType expectedType) throws IncorrectOperationException {
        final String methodName = FromArrayConversion.getArraysConversionMethod(itemType, expectedType);
        if (methodName == null) {
            return;
        }
        final String qualifierText = ReferenceExpressionCompletionContributor.getQualifierText(qualifier);
        PsiExpression conversion = ReferenceExpressionCompletionContributor.createExpression("java.util.Arrays." + methodName + "(" + qualifierText + prefix + ")", element);
        String presentable = "Arrays." + methodName + "(" + qualifierText + prefix + ")";
        String[] lookupStrings = new String[]{StringUtil.isEmpty((String)qualifierText) ? presentable : prefix, prefix, presentable, methodName + "(" + prefix + ")"};
        result.consume((Object)new ExpressionLookupItem(conversion, PlatformIcons.METHOD_ICON, presentable, lookupStrings){

            @Override
            public void handleInsert(InsertionContext context) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.aslist");
                int startOffset = context.getStartOffset() - qualifierText.length();
                Project project = element.getProject();
                String callSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)project).getCommonSettings((Language)JavaLanguage.INSTANCE).SPACE_WITHIN_METHOD_CALL_PARENTHESES);
                String newText = "java.util.Arrays." + methodName + "(" + callSpace + qualifierText + prefix + callSpace + ")";
                context.getDocument().replaceString(startOffset, context.getTailOffset(), (CharSequence)newText);
                context.commitDocument();
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)context.getFile(), startOffset, startOffset + "java.util.Arrays".length());
            }
        });
    }

    @Nullable
    private static String getArraysConversionMethod(PsiType itemType, PsiType expectedType) {
        String methodName = "asList";
        PsiType componentType = PsiUtil.extractIterableTypeParameter((PsiType)expectedType, (boolean)true);
        if (componentType == null) {
            methodName = "stream";
            componentType = FromArrayConversion.getStreamComponentType(expectedType);
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)componentType);
            if (unboxedType != null) {
                componentType = unboxedType;
            }
        }
        if (componentType == null || !(itemType instanceof PsiArrayType) || !componentType.isAssignableFrom(((PsiArrayType)itemType).getComponentType())) {
            return null;
        }
        return methodName;
    }

    private static PsiType getStreamComponentType(PsiType expectedType) {
        return PsiUtil.substituteTypeParameter((PsiType)expectedType, (String)"java.util.stream.BaseStream", (int)0, (boolean)true);
    }
}

