/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.HashSet;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationsHighlightUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil");
    private static final ElementPattern<PsiElement> ANY_ANNOTATION_ALLOWED = PsiJavaPatterns.psiElement().andOr(new ElementPattern[]{PsiJavaPatterns.psiElement().withParent(PsiNameValuePair.class), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiArrayInitializerMemberValue.class, PsiNameValuePair.class}), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiArrayInitializerMemberValue.class, PsiAnnotationMethod.class}), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiAnnotationMethod.class)).afterLeaf(new String[]{"default"})});

    @Nullable
    static HighlightInfo checkNameValuePair(PsiNameValuePair pair) {
        PsiReference ref = pair.getReference();
        if (ref == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)ref.resolve();
        if (method == null) {
            if (pair.getName() != null) {
                String description = JavaErrorMessages.message("annotation.unknown.method", ref.getCanonicalText());
                PsiElement element = ref.getElement();
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(element).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createCreateAnnotationMethodFromUsageFix(pair));
                return highlightInfo;
            }
            String description = JavaErrorMessages.message("annotation.missing.method", ref.getCanonicalText());
            PsiElement element = ref.getElement();
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            for (IntentionAction action : QuickFixFactory.getInstance().createAddAnnotationAttributeNameFixes(pair)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)action);
            }
            return highlightInfo;
        }
        PsiType returnType = method.getReturnType();
        assert (returnType != null) : method;
        PsiAnnotationMemberValue value2 = pair.getValue();
        HighlightInfo info = AnnotationsHighlightUtil.checkMemberValueType(value2, returnType);
        if (info != null) {
            return info;
        }
        return AnnotationsHighlightUtil.checkDuplicateAttribute(pair);
    }

    @Nullable
    private static HighlightInfo checkDuplicateAttribute(PsiNameValuePair pair) {
        PsiNameValuePair[] attributes;
        PsiAnnotationParameterList annotation = (PsiAnnotationParameterList)pair.getParent();
        for (PsiNameValuePair attribute : attributes = annotation.getAttributes()) {
            if (attribute == pair) break;
            String name = pair.getName();
            if (!Comparing.equal((String)attribute.getName(), (String)name)) continue;
            String description = JavaErrorMessages.message("annotation.duplicate.attribute", name == null ? "value" : name);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)pair).descriptionAndTooltip(description).create();
        }
        return null;
    }

    private static String formatReference(PsiJavaCodeReferenceElement ref) {
        return ref.getCanonicalText();
    }

    @Nullable
    static HighlightInfo checkMemberValueType(@Nullable PsiAnnotationMemberValue value2, PsiType expectedType) {
        if (value2 == null) {
            return null;
        }
        if (expectedType instanceof PsiClassType && expectedType.equalsToText("java.lang.Class") && !(value2 instanceof PsiClassObjectAccessExpression)) {
            String description = JavaErrorMessages.message("annotation.non.class.literal.attribute.value", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)value2).descriptionAndTooltip(description).create();
        }
        if (value2 instanceof PsiAnnotation) {
            PsiClass aClass;
            PsiType componentType;
            PsiClass aClass2;
            PsiJavaCodeReferenceElement nameRef = ((PsiAnnotation)value2).getNameReferenceElement();
            if (nameRef == null) {
                return null;
            }
            if (expectedType instanceof PsiClassType && (aClass2 = ((PsiClassType)expectedType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass2)) {
                return null;
            }
            if (expectedType instanceof PsiArrayType && (componentType = ((PsiArrayType)expectedType).getComponentType()) instanceof PsiClassType && (aClass = ((PsiClassType)componentType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass)) {
                return null;
            }
            String description = JavaErrorMessages.message("incompatible.types", JavaHighlightUtil.formatType(expectedType), AnnotationsHighlightUtil.formatReference(nameRef));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)value2).descriptionAndTooltip(description).create();
        }
        if (value2 instanceof PsiArrayInitializerMemberValue) {
            if (expectedType instanceof PsiArrayType) {
                return null;
            }
            String description = JavaErrorMessages.message("annotation.illegal.array.initializer", JavaHighlightUtil.formatType(expectedType));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)value2).descriptionAndTooltip(description).create();
        }
        if (value2 instanceof PsiExpression) {
            PsiExpression expr = (PsiExpression)value2;
            PsiType type2 = expr.getType();
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
            if (!(psiClass == null || !psiClass.isEnum() || expr instanceof PsiReferenceExpression && ((PsiReferenceExpression)expr).resolve() instanceof PsiEnumConstant)) {
                String description = JavaErrorMessages.message("annotation.non.enum.constant.attribute.value", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)value2).descriptionAndTooltip(description).create();
            }
            if (type2 != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)expectedType, (PsiExpression)expr) || expectedType instanceof PsiArrayType && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)((PsiArrayType)expectedType).getComponentType(), (PsiExpression)expr)) {
                return null;
            }
            String description = JavaErrorMessages.message("incompatible.types", JavaHighlightUtil.formatType(expectedType), JavaHighlightUtil.formatType(type2));
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)value2).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QuickFixFactory.getInstance().createSurroundWithQuotesAnnotationParameterValueFix(value2, expectedType));
            return info;
        }
        LOG.error("Unknown annotation member value: " + value2);
        return null;
    }

    static HighlightInfo checkDuplicateAnnotations(@NotNull PsiAnnotation annotationToCheck, @NotNull LanguageLevel languageLevel) {
        String containedElementFQN;
        PsiAnnotationOwner owner;
        if (annotationToCheck == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(0);
        }
        if (languageLevel == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(1);
        }
        if ((owner = annotationToCheck.getOwner()) == null) {
            return null;
        }
        PsiJavaCodeReferenceElement element = annotationToCheck.getNameReferenceElement();
        if (element == null) {
            return null;
        }
        PsiElement resolved = element.resolve();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass annotationType = (PsiClass)resolved;
        PsiClass contained = AnnotationsHighlightUtil.contained(annotationType);
        String string = containedElementFQN = contained == null ? null : contained.getQualifiedName();
        if (containedElementFQN != null) {
            String containerName = annotationType.getQualifiedName();
            if (AnnotationsHighlightUtil.isAnnotationRepeatedTwice(owner, containedElementFQN)) {
                String description = JavaErrorMessages.message("annotation.container.wrong.place", containerName);
                return AnnotationsHighlightUtil.annotationError(annotationToCheck, description);
            }
        } else if (AnnotationsHighlightUtil.isAnnotationRepeatedTwice(owner, annotationType.getQualifiedName())) {
            PsiAnnotation.TargetType[] targets;
            PsiAnnotation.TargetType applicable;
            if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                String description = JavaErrorMessages.message("annotation.duplicate.annotation", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
            }
            PsiAnnotation metaAnno = PsiImplUtil.findAnnotation((PsiAnnotationOwner)annotationType.getModifierList(), "java.lang.annotation.Repeatable");
            if (metaAnno == null) {
                String explanation = JavaErrorMessages.message("annotation.non.repeatable", annotationType.getQualifiedName());
                String description = JavaErrorMessages.message("annotation.duplicate.explained", explanation);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
            }
            String explanation = AnnotationsHighlightUtil.doCheckRepeatableAnnotation(metaAnno);
            if (explanation != null) {
                String description = JavaErrorMessages.message("annotation.duplicate.explained", explanation);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
            }
            PsiClass container = AnnotationsHighlightUtil.getRepeatableContainer(metaAnno);
            if (container != null && (applicable = AnnotationTargetUtil.findAnnotationTarget((PsiClass)container, (PsiAnnotation.TargetType[])(targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)owner)))) == null) {
                String target = JavaErrorMessages.message("annotation.target." + targets[0], new Object[0]);
                String message2 = JavaErrorMessages.message("annotation.container.not.applicable", container.getName(), target);
                return AnnotationsHighlightUtil.annotationError(annotationToCheck, message2);
            }
        }
        return null;
    }

    private static PsiClass contained(PsiClass annotationType) {
        if (!annotationType.isAnnotationType()) {
            return null;
        }
        PsiMethod[] values = annotationType.findMethodsByName("value", false);
        if (values.length != 1) {
            return null;
        }
        PsiMethod value2 = values[0];
        PsiType returnType = value2.getReturnType();
        if (!(returnType instanceof PsiArrayType)) {
            return null;
        }
        PsiType type2 = ((PsiArrayType)returnType).getComponentType();
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClass contained = ((PsiClassType)type2).resolve();
        if (contained == null || !contained.isAnnotationType()) {
            return null;
        }
        if (PsiImplUtil.findAnnotation((PsiAnnotationOwner)contained.getModifierList(), "java.lang.annotation.Repeatable") == null) {
            return null;
        }
        return contained;
    }

    private static boolean isAnnotationRepeatedTwice(@NotNull PsiAnnotationOwner owner, @Nullable String qualifiedName) {
        if (owner == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(2);
        }
        int count = 0;
        for (PsiAnnotation annotation : owner.getAnnotations()) {
            PsiElement resolved;
            PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
            if (nameRef == null || !((resolved = nameRef.resolve()) instanceof PsiClass) || !Comparing.equal((String)qualifiedName, (String)((PsiClass)resolved).getQualifiedName()) || ++count != 2) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkMissingAttributes(PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)nameRef.resolve();
        if (aClass != null && aClass.isAnnotationType()) {
            PsiNameValuePair[] attributes;
            HashSet names = new HashSet();
            for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
                String name = attribute.getName();
                if (name != null) {
                    names.add(name);
                    continue;
                }
                names.add("value");
            }
            PsiMethod[] annotationMethods = aClass.getMethods();
            ArrayList<String> missed = new ArrayList<String>();
            for (PsiMethod method : annotationMethods) {
                PsiAnnotationMethod annotationMethod;
                if (!PsiUtil.isAnnotationMethod((PsiElement)method) || (annotationMethod = (PsiAnnotationMethod)method).getDefaultValue() != null || names.contains(annotationMethod.getName())) continue;
                missed.add(annotationMethod.getName());
            }
            if (!missed.isEmpty()) {
                StringBuffer buff = new StringBuffer("'" + (String)missed.get(0) + "'");
                for (int i = 1; i < missed.size(); ++i) {
                    buff.append(", ");
                    buff.append("'").append((String)missed.get(i)).append("'");
                }
                String description = JavaErrorMessages.message("annotation.missing.attribute", buff);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)nameRef).descriptionAndTooltip(description).create();
                IntentionAction fix = QuickFixFactory.getInstance().createAddMissingRequiredAnnotationParametersFix(annotation, annotationMethods, missed);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fix);
                return info;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkConstantExpression(PsiExpression expression2) {
        PsiElement parent = expression2.getParent();
        if ((PsiUtil.isAnnotationMethod((PsiElement)parent) || parent instanceof PsiNameValuePair || parent instanceof PsiArrayInitializerMemberValue) && !PsiUtil.isConstantExpression((PsiExpression)expression2)) {
            String description = JavaErrorMessages.message("annotation.non.constant.attribute.value", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkValidAnnotationType(PsiType type2, PsiTypeElement typeElement) {
        if (type2 != null && ((Boolean)type2.accept((PsiTypeVisitor)AnnotationReturnTypeVisitor.INSTANCE)).booleanValue()) {
            return null;
        }
        String description = JavaErrorMessages.message("annotation.invalid.annotation.member.type", type2 != null ? type2.getPresentableText() : null);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
    }

    @Nullable
    public static HighlightInfo checkApplicability(@NotNull PsiAnnotation annotation, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        HighlightInfo info;
        if (annotation == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(3);
        }
        if (level == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(5);
        }
        if (ANY_ANNOTATION_ALLOWED.accepts((Object)annotation)) {
            return null;
        }
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiAnnotationOwner owner = annotation.getOwner();
        PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)owner);
        if (owner == null || targets.length == 0) {
            String message2 = JavaErrorMessages.message("annotation.not.allowed.here", new Object[0]);
            return AnnotationsHighlightUtil.annotationError(annotation, message2);
        }
        if (!(owner instanceof PsiModifierList) && (info = HighlightUtil.checkFeature((PsiElement)annotation, HighlightUtil.Feature.TYPE_ANNOTATIONS, level, file)) != null) {
            return info;
        }
        PsiAnnotation.TargetType applicable = AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])targets);
        if (applicable == PsiAnnotation.TargetType.UNKNOWN) {
            return null;
        }
        if (applicable == null) {
            String target = JavaErrorMessages.message("annotation.target." + targets[0], new Object[0]);
            String message3 = JavaErrorMessages.message("annotation.not.applicable", nameRef.getText(), target);
            return AnnotationsHighlightUtil.annotationError(annotation, message3);
        }
        if (applicable == PsiAnnotation.TargetType.TYPE_USE) {
            if (owner instanceof PsiClassReferenceType) {
                PsiJavaCodeReferenceElement ref = ((PsiClassReferenceType)owner).getReference();
                HighlightInfo info2 = AnnotationsHighlightUtil.checkReferenceTarget(annotation, ref);
                if (info2 != null) {
                    return info2;
                }
            } else if (owner instanceof PsiModifierList || owner instanceof PsiTypeElement) {
                PsiTypeElement nextElement;
                Object object = nextElement = owner instanceof PsiTypeElement ? (PsiTypeElement)owner : PsiTreeUtil.skipSiblingsForward((PsiElement)((PsiModifierList)owner), (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class});
                if (nextElement instanceof PsiTypeElement) {
                    PsiJavaCodeReferenceElement ref;
                    HighlightInfo info3;
                    PsiTypeElement typeElement = nextElement;
                    PsiType type2 = typeElement.getType();
                    if (PsiType.VOID.equals((Object)type2)) {
                        String message4 = JavaErrorMessages.message("annotation.not.allowed.void", new Object[0]);
                        return AnnotationsHighlightUtil.annotationError(annotation, message4);
                    }
                    if (!(type2 instanceof PsiPrimitiveType) && (info3 = AnnotationsHighlightUtil.checkReferenceTarget(annotation, ref = AnnotationsHighlightUtil.getOutermostReferenceElement(typeElement.getInnermostComponentReferenceElement()))) != null) {
                        return info3;
                    }
                    PsiElement context = PsiTreeUtil.skipParentsOfType((PsiElement)typeElement, (Class[])new Class[]{PsiTypeElement.class});
                    if (context instanceof PsiClassObjectAccessExpression) {
                        String message5 = JavaErrorMessages.message("annotation.not.allowed.class", new Object[0]);
                        return AnnotationsHighlightUtil.annotationError(annotation, message5);
                    }
                }
            }
        }
        return null;
    }

    private static HighlightInfo annotationError(PsiAnnotation annotation, String message2) {
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)annotation).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new DeleteAnnotationAction(annotation));
        return info;
    }

    @Nullable
    private static HighlightInfo checkReferenceTarget(PsiAnnotation annotation, @Nullable PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            return null;
        }
        PsiElement refTarget = ref.resolve();
        if (refTarget == null) {
            return null;
        }
        String message2 = null;
        if (!(refTarget instanceof PsiClass)) {
            message2 = JavaErrorMessages.message("annotation.not.allowed.ref", new Object[0]);
        } else {
            PsiElement qualified;
            PsiElement parent = ref.getParent();
            if (parent instanceof PsiJavaCodeReferenceElement && (qualified = ((PsiJavaCodeReferenceElement)parent).resolve()) instanceof PsiMember && ((PsiMember)qualified).hasModifierProperty("static")) {
                message2 = JavaErrorMessages.message("annotation.not.allowed.static", new Object[0]);
            }
        }
        return message2 != null ? AnnotationsHighlightUtil.annotationError(annotation, message2) : null;
    }

    @Nullable
    private static PsiJavaCodeReferenceElement getOutermostReferenceElement(@Nullable PsiJavaCodeReferenceElement ref) {
        PsiElement qualifier;
        if (ref == null) {
            return null;
        }
        while ((qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement) {
            ref = (PsiJavaCodeReferenceElement)qualifier;
        }
        return ref;
    }

    @Nullable
    static HighlightInfo checkAnnotationType(PsiAnnotation annotation) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
        if (!(nameReferenceElement == null || (resolved = nameReferenceElement.resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType())) {
            String description = JavaErrorMessages.message("annotation.annotation.type.expected", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)nameReferenceElement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkCyclicMemberType(PsiTypeElement typeElement, PsiClass aClass) {
        HashSet checked;
        PsiType type2 = typeElement.getType();
        if (AnnotationsHighlightUtil.cyclicDependencies(aClass, type2, (Set<PsiClass>)(checked = new HashSet()), aClass.getManager())) {
            String description = JavaErrorMessages.message("annotation.cyclic.element.type", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    private static boolean cyclicDependencies(PsiClass aClass, PsiType type2, @NotNull Set<PsiClass> checked, @NotNull PsiManager manager) {
        PsiClass resolvedClass;
        if (checked == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(7);
        }
        if ((resolvedClass = PsiUtil.resolveClassInType((PsiType)type2)) != null && resolvedClass.isAnnotationType()) {
            PsiMethod[] methods;
            if (aClass == resolvedClass) {
                return true;
            }
            if (!checked.add(resolvedClass) || !manager.isInProject((PsiElement)resolvedClass)) {
                return false;
            }
            for (PsiMethod method : methods = resolvedClass.getMethods()) {
                if (!AnnotationsHighlightUtil.cyclicDependencies(aClass, method.getReturnType(), checked, manager)) continue;
                return true;
            }
        }
        return false;
    }

    static HighlightInfo checkClashesWithSuperMethods(@NotNull PsiAnnotationMethod psiMethod) {
        PsiIdentifier nameIdentifier;
        if (psiMethod == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(8);
        }
        if ((nameIdentifier = psiMethod.getNameIdentifier()) != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = psiMethod.findDeepestSuperMethods()) {
                String qualifiedName;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || !"java.lang.Object".equals(qualifiedName = containingClass.getQualifiedName()) && !"java.lang.annotation.Annotation".equals(qualifiedName)) continue;
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)nameIdentifier).descriptionAndTooltip("@interface member clashes with '" + JavaHighlightUtil.formatMethod(method) + "' in " + HighlightUtil.formatClass(containingClass)).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkAnnotationDeclaration(PsiElement parent, PsiReferenceList list) {
        if (PsiUtil.isAnnotationMethod((PsiElement)parent)) {
            PsiAnnotationMethod method = (PsiAnnotationMethod)parent;
            if (list == method.getThrowsList()) {
                String description = JavaErrorMessages.message("annotation.members.may.not.have.throws.list", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
            }
        } else if (parent instanceof PsiClass && ((PsiClass)parent).isAnnotationType() && "extends".equals(list.getFirstChild().getText())) {
            String description = JavaErrorMessages.message("annotation.may.not.have.extends.list", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPackageAnnotationContainingFile(PsiPackageStatement statement, PsiFile file) {
        PsiModifierList annotationList = statement.getAnnotationList();
        if (annotationList != null && !"package-info.java".equals(file.getName())) {
            String message2 = JavaErrorMessages.message("invalid.package.annotation.containing.file", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(annotationList.getTextRange()).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkTargetAnnotationDuplicates(PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiElement resolved = nameRef.resolve();
        if (!(resolved instanceof PsiClass) || !"java.lang.annotation.Target".equals(((PsiClass)resolved).getQualifiedName())) {
            return null;
        }
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (attributes.length < 1) {
            return null;
        }
        PsiAnnotationMemberValue value2 = attributes[0].getValue();
        if (!(value2 instanceof PsiArrayInitializerMemberValue)) {
            return null;
        }
        PsiAnnotationMemberValue[] arrayInitializers = ((PsiArrayInitializerMemberValue)value2).getInitializers();
        HashSet targets = new HashSet();
        for (PsiAnnotationMemberValue initializer : arrayInitializers) {
            PsiElement target;
            if (!(initializer instanceof PsiReferenceExpression) || (target = ((PsiReferenceExpression)initializer).resolve()) == null) continue;
            if (targets.contains(target)) {
                String description = JavaErrorMessages.message("repeated.annotation.target", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)initializer).descriptionAndTooltip(description).create();
            }
            targets.add(target);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFunctionalInterface(@NotNull PsiAnnotation annotation, @NotNull LanguageLevel languageLevel) {
        String errorMessage;
        PsiElement parent;
        PsiAnnotationOwner owner;
        if (annotation == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(9);
        }
        if (languageLevel == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(10);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && Comparing.strEqual((String)annotation.getQualifiedName(), (String)"java.lang.FunctionalInterface") && (owner = annotation.getOwner()) instanceof PsiModifierList && (parent = ((PsiModifierList)owner).getParent()) instanceof PsiClass && (errorMessage = LambdaHighlightingUtil.checkInterfaceFunctional((PsiClass)parent, ((PsiClass)parent).getName() + " is not a functional interface")) != null) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)annotation).descriptionAndTooltip(errorMessage).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkRepeatableAnnotation(PsiAnnotation annotation) {
        PsiAnnotationMemberValue containerRef;
        String qualifiedName = annotation.getQualifiedName();
        if (!"java.lang.annotation.Repeatable".equals(qualifiedName)) {
            return null;
        }
        String description = AnnotationsHighlightUtil.doCheckRepeatableAnnotation(annotation);
        if (description != null && (containerRef = PsiImplUtil.findAttributeValue(annotation, null)) != null) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)containerRef).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    private static String doCheckRepeatableAnnotation(@NotNull PsiAnnotation annotation) {
        Set containerTargets;
        RetentionPolicy containerPolicy;
        PsiArrayType expected;
        PsiAnnotationOwner owner;
        if (annotation == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(11);
        }
        if (!((owner = annotation.getOwner()) instanceof PsiModifierList)) {
            return null;
        }
        PsiElement target = ((PsiModifierList)owner).getParent();
        if (!(target instanceof PsiClass) || !((PsiClass)target).isAnnotationType()) {
            return null;
        }
        PsiClass container = AnnotationsHighlightUtil.getRepeatableContainer(annotation);
        if (container == null) {
            return null;
        }
        PsiMethod[] methods = container.findMethodsByName("value", false);
        if (methods.length == 0) {
            return JavaErrorMessages.message("annotation.container.no.value", container.getQualifiedName());
        }
        if (methods.length == 1 && !(expected = new PsiImmediateClassType((PsiClass)target, PsiSubstitutor.EMPTY).createArrayType()).equals(methods[0].getReturnType())) {
            return JavaErrorMessages.message("annotation.container.bad.type", container.getQualifiedName(), JavaHighlightUtil.formatType((PsiType)expected));
        }
        RetentionPolicy targetPolicy = AnnotationsHighlightUtil.getRetentionPolicy((PsiClass)target);
        if (targetPolicy != null && (containerPolicy = AnnotationsHighlightUtil.getRetentionPolicy(container)) != null && targetPolicy.compareTo(containerPolicy) > 0) {
            return JavaErrorMessages.message("annotation.container.low.retention", new Object[]{container.getQualifiedName(), containerPolicy});
        }
        Set repeatableTargets = AnnotationTargetUtil.getAnnotationTargets((PsiClass)((PsiClass)target));
        if (repeatableTargets != null && (containerTargets = AnnotationTargetUtil.getAnnotationTargets((PsiClass)container)) != null && !repeatableTargets.containsAll(containerTargets)) {
            return JavaErrorMessages.message("annotation.container.wide.target", container.getQualifiedName());
        }
        return null;
    }

    @Nullable
    private static PsiClass getRepeatableContainer(@NotNull PsiAnnotation annotation) {
        PsiAnnotationMemberValue containerRef;
        if (annotation == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(12);
        }
        if (!((containerRef = PsiImplUtil.findAttributeValue(annotation, null)) instanceof PsiClassObjectAccessExpression)) {
            return null;
        }
        PsiType containerType = ((PsiClassObjectAccessExpression)containerRef).getOperand().getType();
        if (!(containerType instanceof PsiClassType)) {
            return null;
        }
        PsiClass container = ((PsiClassType)containerType).resolve();
        if (container == null || !container.isAnnotationType()) {
            return null;
        }
        return container;
    }

    @Nullable
    static HighlightInfo checkReceiverPlacement(PsiReceiverParameter parameter2) {
        PsiElement owner = parameter2.getParent().getParent();
        if (owner == null) {
            return null;
        }
        if (!(owner instanceof PsiMethod)) {
            String text2 = JavaErrorMessages.message("receiver.wrong.context", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)parameter2.getIdentifier()).descriptionAndTooltip(text2).create();
        }
        PsiMethod method = (PsiMethod)owner;
        if (AnnotationsHighlightUtil.isStatic((PsiModifierListOwner)method) || method.isConstructor() && AnnotationsHighlightUtil.isStatic((PsiModifierListOwner)method.getContainingClass())) {
            String text3 = JavaErrorMessages.message("receiver.static.context", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)parameter2.getIdentifier()).descriptionAndTooltip(text3).create();
        }
        PsiElement leftNeighbour = PsiTreeUtil.skipWhitespacesBackward((PsiElement)parameter2);
        if (leftNeighbour != null && !PsiUtil.isJavaToken((PsiElement)leftNeighbour, (IElementType)JavaTokenType.LPARENTH)) {
            String text4 = JavaErrorMessages.message("receiver.wrong.position", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)parameter2.getIdentifier()).descriptionAndTooltip(text4).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkReceiverType(PsiReceiverParameter parameter2) {
        PsiElement owner = parameter2.getParent().getParent();
        if (!(owner instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)owner;
        PsiClass enclosingClass = method.getContainingClass();
        if (method.isConstructor() && enclosingClass != null) {
            enclosingClass = enclosingClass.getContainingClass();
        }
        if (enclosingClass != null) {
            PsiClassType type2 = PsiElementFactory.SERVICE.getInstance((Project)parameter2.getProject()).createType(enclosingClass, PsiSubstitutor.EMPTY);
            if (!type2.equals((Object)parameter2.getType())) {
                PsiElement range = (PsiElement)ObjectUtils.notNull((Object)parameter2.getTypeElement(), (Object)parameter2);
                String text2 = JavaErrorMessages.message("receiver.type.mismatch", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(text2).create();
            }
            PsiThisExpression identifier = parameter2.getIdentifier();
            if (!enclosingClass.equals(PsiUtil.resolveClassInType((PsiType)identifier.getType()))) {
                String text3 = JavaErrorMessages.message("receiver.name.mismatch", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(text3).create();
            }
        }
        return null;
    }

    private static boolean isStatic(PsiModifierListOwner owner) {
        if (owner == null) {
            return false;
        }
        if (owner instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)((PsiClass)owner))) {
            return true;
        }
        PsiModifierList modifierList = owner.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty("static");
    }

    @Nullable
    public static RetentionPolicy getRetentionPolicy(@NotNull PsiClass annotation) {
        PsiModifierList modifierList;
        if (annotation == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(13);
        }
        if ((modifierList = annotation.getModifierList()) != null) {
            PsiElement field;
            PsiAnnotation retentionAnno = modifierList.findAnnotation("java.lang.annotation.Retention");
            if (retentionAnno == null) {
                return RetentionPolicy.CLASS;
            }
            PsiAnnotationMemberValue policyRef = PsiImplUtil.findAttributeValue(retentionAnno, null);
            if (policyRef instanceof PsiReference && (field = ((PsiReference)policyRef).resolve()) instanceof PsiEnumConstant) {
                String name = ((PsiEnumConstant)field).getName();
                try {
                    return Enum.valueOf(RetentionPolicy.class, name);
                }
                catch (Exception e) {
                    LOG.warn("Unknown policy: " + name);
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationToCheck";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checked";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDuplicateAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnnotationRepeatedTwice";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkApplicability";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "cyclicDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClashesWithSuperMethods";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunctionalInterface";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheckRepeatableAnnotation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getRepeatableContainer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getRetentionPolicy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DeleteAnnotationAction
    implements IntentionAction {
        private final PsiAnnotation myAnnotation;

        private DeleteAnnotationAction(PsiAnnotation annotation) {
            this.myAnnotation = annotation;
        }

        @NotNull
        public String getText() {
            if ("Remove" == null) {
                DeleteAnnotationAction.$$$reportNull$$$0(0);
            }
            return "Remove";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                DeleteAnnotationAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                DeleteAnnotationAction.$$$reportNull$$$0(2);
            }
            return this.myAnnotation;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                DeleteAnnotationAction.$$$reportNull$$$0(3);
            }
            return this.myAnnotation.isValid();
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                DeleteAnnotationAction.$$$reportNull$$$0(4);
            }
            this.myAnnotation.delete();
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil$DeleteAnnotationAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil$DeleteAnnotationAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AnnotationReturnTypeVisitor
    extends PsiTypeVisitor<Boolean> {
        public static final AnnotationReturnTypeVisitor INSTANCE = new AnnotationReturnTypeVisitor();

        public Boolean visitType(PsiType type2) {
            return Boolean.FALSE;
        }

        public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
            return PsiType.VOID.equals((Object)primitiveType) || PsiType.NULL.equals((Object)primitiveType) ? Boolean.FALSE : Boolean.TRUE;
        }

        public Boolean visitArrayType(PsiArrayType arrayType) {
            if (arrayType.getArrayDimensions() != 1) {
                return Boolean.FALSE;
            }
            PsiType componentType = arrayType.getComponentType();
            return (Boolean)componentType.accept((PsiTypeVisitor)this);
        }

        public Boolean visitClassType(PsiClassType classType) {
            if (classType.getParameters().length > 0) {
                PsiClassType rawType = classType.rawType();
                return rawType.equalsToText("java.lang.Class");
            }
            PsiClass aClass = classType.resolve();
            if (aClass != null && (aClass.isAnnotationType() || aClass.isEnum())) {
                return Boolean.TRUE;
            }
            return classType.equalsToText("java.lang.Class") || classType.equalsToText("java.lang.String");
        }
    }
}

