/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SideEffectWarningDialog;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.BlockUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessStaticViaInstanceFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AccessStaticViaInstanceFix");
    private final boolean myOnTheFly;
    private final String myText;

    public AccessStaticViaInstanceFix(@NotNull PsiReferenceExpression expression2, @NotNull JavaResolveResult result, boolean onTheFly) {
        if (expression2 == null) {
            AccessStaticViaInstanceFix.$$$reportNull$$$0(0);
        }
        if (result == null) {
            AccessStaticViaInstanceFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)expression2);
        this.myOnTheFly = onTheFly;
        PsiMember member = (PsiMember)result.getElement();
        this.myText = AccessStaticViaInstanceFix.calcText(member, result.getSubstitutor());
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            AccessStaticViaInstanceFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static String calcText(PsiMember member, PsiSubstitutor substitutor) {
        PsiClass aClass = member.getContainingClass();
        if (aClass == null) {
            return "";
        }
        return QuickFixBundle.message("access.static.via.class.reference.text", HighlightMessageUtil.getSymbolName((PsiElement)member, substitutor, 2), HighlightUtil.formatClass(aClass, false), HighlightUtil.formatClass(aClass, false));
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("access.static.via.class.reference.family", new Object[0]);
        if (string == null) {
            AccessStaticViaInstanceFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiReferenceExpression myExpression;
        if (project == null) {
            AccessStaticViaInstanceFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AccessStaticViaInstanceFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            AccessStaticViaInstanceFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            AccessStaticViaInstanceFix.$$$reportNull$$$0(7);
        }
        if (!(myExpression = (PsiReferenceExpression)startElement).isValid()) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(myExpression.getContainingFile())) {
            return;
        }
        PsiElement element = myExpression.resolve();
        if (!(element instanceof PsiMember)) {
            return;
        }
        PsiMember myMember = (PsiMember)element;
        if (!myMember.isValid()) {
            return;
        }
        PsiClass containingClass = myMember.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiExpression qualifierExpression2 = myExpression.getQualifierExpression();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        if (qualifierExpression2 != null) {
            if (!this.checkSideEffects(project, containingClass, qualifierExpression2, factory, (PsiElement)myExpression, editor)) {
                return;
            }
            WriteAction.run(() -> {
                try {
                    PsiElement newQualifier = qualifierExpression2.replace((PsiElement)factory.createReferenceExpression(containingClass));
                    PsiElement qualifiedWithClassName = myExpression.copy();
                    if (myExpression.getTypeParameters().length == 0 && (!containingClass.isInterface() || containingClass.equals(PsiTreeUtil.getParentOfType((PsiElement)myExpression, PsiClass.class)))) {
                        newQualifier.delete();
                        if (myExpression.resolve() != myMember) {
                            myExpression.replace(qualifiedWithClassName);
                        }
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private boolean checkSideEffects(Project project, PsiClass containingClass, final PsiExpression qualifierExpression2, PsiElementFactory factory, final PsiElement myExpression, Editor editor) {
        ArrayList<PsiElement> sideEffects = new ArrayList<PsiElement>();
        boolean hasSideEffects = RemoveUnusedVariableUtil.checkSideEffects(qualifierExpression2, null, sideEffects);
        if (hasSideEffects && !this.myOnTheFly) {
            return false;
        }
        if (!hasSideEffects || ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (editor == null) {
            return false;
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, PsiUtilCore.toPsiElementArray(sideEffects), attributes, true, null);
        try {
            hasSideEffects = PsiUtil.isStatement((PsiElement)factory.createStatementFromText(qualifierExpression2.getText(), (PsiElement)qualifierExpression2));
        }
        catch (IncorrectOperationException e) {
            hasSideEffects = false;
        }
        final PsiReferenceExpression qualifiedWithClassName = (PsiReferenceExpression)myExpression.copy();
        qualifiedWithClassName.setQualifierExpression((PsiExpression)factory.createReferenceExpression(containingClass));
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)myExpression, PsiStatement.class);
        final boolean canCopeWithSideEffects = hasSideEffects && statement != null;
        SideEffectWarningDialog dialog = new SideEffectWarningDialog(project, false, null, ((PsiElement)sideEffects.get(0)).getText(), PsiExpressionTrimRenderer.render((PsiExpression)qualifierExpression2), canCopeWithSideEffects){

            @Override
            protected String sideEffectsDescription() {
                if (canCopeWithSideEffects) {
                    return MessageFormat.format(this.getFormatString(), "expression '" + qualifierExpression2.getText() + "'", myExpression.getText(), qualifierExpression2.getText() + ";<br>" + qualifiedWithClassName.getText());
                }
                return "<html><body>  There are possible side effects found in expression '" + qualifierExpression2.getText() + "'<br>You can <b>Remove</b> class reference along with whole expressions involved</body></html>";
            }
        };
        dialog.show();
        int res = dialog.getExitCode();
        if (res == RemoveUnusedVariableUtil.RemoveMode.CANCEL.ordinal()) {
            return false;
        }
        if (res == RemoveUnusedVariableUtil.RemoveMode.MAKE_STATEMENT.ordinal()) {
            PsiStatement statementFromText = factory.createStatementFromText(qualifierExpression2.getText() + ";", null);
            LOG.assertTrue(statement != null);
            WriteAction.run(() -> {
                try {
                    PsiElement parent = statement.getParent();
                    BlockUtils.addBefore(parent instanceof PsiForStatement ? (PsiStatement)parent : statement, statementFromText);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

