/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CreateParameterFromUsageFix
extends CreateVarFromUsageFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateParameterFromUsageFix");

    public CreateParameterFromUsageFix(PsiReferenceExpression referenceElement) {
        super(referenceElement);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        if (!super.isAvailableImpl(offset)) {
            return false;
        }
        if (this.myReferenceExpression.isQualified()) {
            return false;
        }
        PsiReferenceExpression scope = this.myReferenceExpression;
        while ((scope = PsiTreeUtil.getParentOfType((PsiElement)scope, (Class[])new Class[]{PsiMethod.class, PsiClass.class})) instanceof PsiAnonymousClass) {
        }
        return scope instanceof PsiMethod && ((PsiMethod)scope).getParameterList().isPhysical();
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.parameter.from.usage.text", varName);
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        TransactionGuard.getInstance().submitTransactionLater((Disposable)targetClass.getProject(), () -> {
            block12: {
                if (!this.myReferenceExpression.isValid()) {
                    return;
                }
                if (CreateFromUsageUtils.isValidReference((PsiReference)this.myReferenceExpression, false)) {
                    return;
                }
                Project project = this.myReferenceExpression.getProject();
                PsiType[] expectedTypes = CreateFromUsageUtils.guessType((PsiExpression)this.myReferenceExpression, false);
                PsiType type2 = expectedTypes[0];
                String varName = this.myReferenceExpression.getReferenceName();
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myReferenceExpression, PsiMethod.class);
                LOG.assertTrue(method != null);
                method = IntroduceParameterHandler.chooseEnclosingMethod(method);
                if (method == null) {
                    return;
                }
                if ((method = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"))) == null) {
                    return;
                }
                ArrayList<ParameterInfoImpl> parameterInfos = new ArrayList<ParameterInfoImpl>(Arrays.asList(ParameterInfoImpl.fromMethod(method)));
                ParameterInfoImpl parameterInfo = new ParameterInfoImpl(-1, varName, type2, varName, false);
                if (!method.isVarArgs()) {
                    parameterInfos.add(parameterInfo);
                } else {
                    parameterInfos.add(parameterInfos.size() - 1, parameterInfo);
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    ParameterInfoImpl[] array = parameterInfos.toArray(new ParameterInfoImpl[parameterInfos.size()]);
                    String modifier = PsiUtil.getAccessModifier((int)PsiUtil.getAccessLevel((PsiModifierList)method.getModifierList()));
                    ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, method, false, modifier, method.getName(), method.getReturnType(), array);
                    processor.run();
                } else {
                    try {
                        JavaChangeSignatureDialog dialog = JavaChangeSignatureDialog.createAndPreselectNew(project, method, parameterInfos, true, this.myReferenceExpression);
                        dialog.setParameterInfos(parameterInfos);
                        if (!dialog.showAndGet()) break block12;
                        for (ParameterInfoImpl info : parameterInfos) {
                            if (info.getOldIndex() != -1) continue;
                            String newParamName = info.getName();
                            if (!Comparing.strEqual((String)varName, (String)newParamName)) {
                                final PsiExpression newExpr = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newParamName, (PsiElement)method);
                                new WriteCommandAction(project, new PsiFile[0]){

                                    protected void run(@NotNull Result result) throws Throwable {
                                        PsiReferenceExpression[] refs;
                                        if (result == null) {
                                            1.$$$reportNull$$$0(0);
                                        }
                                        for (PsiReferenceExpression ref : refs = CreateFromUsageUtils.collectExpressions((PsiExpression)CreateParameterFromUsageFix.this.myReferenceExpression, PsiMember.class, PsiFile.class)) {
                                            ref.replace(newExpr.copy());
                                        }
                                    }

                                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/quickfix/CreateParameterFromUsageFix$1", "run"));
                                    }
                                }.execute();
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    @Override
    protected boolean isAllowOuterTargetClass() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.parameter.from.usage.family", new Object[0]);
        if (string == null) {
            CreateParameterFromUsageFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateParameterFromUsageFix", "getFamilyName"));
    }
}

