/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuessTypeParameters {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters");
    private final Project myProject;
    private final PsiManager myManager;
    private final JVMElementFactory myFactory;
    private final TemplateBuilder myBuilder;
    private final PsiSubstitutor mySubstitutor;
    private static final int SUBSTITUTED_NONE = 0;
    private static final int SUBSTITUTED_IN_REF = 1;
    private static final int SUBSTITUTED_IN_PARAMETERS = 2;

    public GuessTypeParameters(@NotNull Project project, @NotNull JVMElementFactory factory, @NotNull TemplateBuilder builder, @Nullable PsiSubstitutor substitutor) {
        if (project == null) {
            GuessTypeParameters.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            GuessTypeParameters.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            GuessTypeParameters.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myManager = PsiManager.getInstance((Project)project);
        this.myFactory = factory;
        this.myBuilder = builder;
        this.mySubstitutor = substitutor == null ? PsiSubstitutor.EMPTY : substitutor;
    }

    public void setupTypeElement(PsiTypeElement typeElement, ExpectedTypeInfo[] infos, @Nullable PsiElement context, PsiClass targetClass) {
        PsiType[] psiTypeArray;
        LOG.assertTrue(typeElement.isValid());
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        GlobalSearchScope scope = typeElement.getResolveScope();
        if (infos.length == 1 && this.mySubstitutor != PsiSubstitutor.EMPTY) {
            int substitionResult;
            ExpectedTypeInfo info = infos[0];
            PsiType expectedType = info.getType();
            List<PsiTypeParameter> matchedParameters = GuessTypeParameters.matchingTypeParameters(this.mySubstitutor, expectedType, info.getKind());
            if (!matchedParameters.isEmpty()) {
                SmartList types = new SmartList((Collection)ContainerUtil.map(matchedParameters, it -> this.myFactory.createType((PsiClass)it)));
                ContainerUtil.addAll((Collection)types, (Object[])ExpectedTypesProvider.processExpectedTypes(infos, new MyTypeVisitor(this.myManager, scope), this.myProject));
                this.myBuilder.replaceElement((PsiElement)typeElement, (Expression)new TypeExpression(this.myProject, (Iterable<PsiType>)types));
                return;
            }
            typeElement = (PsiTypeElement)typeElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeElement(info.getType()));
            PsiSubstitutor rawingSubstitutor = GuessTypeParameters.getRawingSubstitutor(this.myProject, context, targetClass);
            int n = substitionResult = GuessTypeParameters.hasNullSubstitutions(this.mySubstitutor) ? 0 : this.substituteToTypeParameters(typeElement, expectedType, rawingSubstitutor, true);
            if (substitionResult == 2) {
                PsiJavaCodeReferenceElement refElement = typeElement.getInnermostComponentReferenceElement();
                LOG.assertTrue(refElement != null);
                PsiElement referenceNameElement = refElement.getReferenceNameElement();
                LOG.assertTrue(referenceNameElement != null);
                PsiClassType defaultType = GuessTypeParameters.getComponentType(info.getDefaultType());
                LOG.assertTrue(defaultType != null);
                PsiClassType rawDefaultType = defaultType.rawType();
                ExpectedTypeInfo info1 = ExpectedTypesProvider.createInfo((PsiType)rawDefaultType, 0, (PsiType)rawDefaultType, info.getTailType());
                MyTypeVisitor visitor = new MyTypeVisitor(this.myManager, scope);
                PsiType[] types = ExpectedTypesProvider.processExpectedTypes(new ExpectedTypeInfo[]{info1}, visitor, this.myProject);
                this.myBuilder.replaceElement(referenceNameElement, (Expression)new TypeExpression(this.myProject, types));
                return;
            }
            if (substitionResult != 0) {
                return;
            }
        }
        if (infos.length == 0) {
            PsiType[] psiTypeArray2 = new PsiType[1];
            psiTypeArray = psiTypeArray2;
            psiTypeArray2[0] = typeElement.getType();
        } else {
            psiTypeArray = ExpectedTypesProvider.processExpectedTypes(infos, new MyTypeVisitor(this.myManager, scope), this.myProject);
        }
        PsiType[] types = psiTypeArray;
        this.myBuilder.replaceElement((PsiElement)typeElement, (Expression)new TypeExpression(this.myProject, types));
    }

    private static PsiSubstitutor getRawingSubstitutor(Project project, PsiElement context, PsiClass targetClass) {
        if (context == null || targetClass == null) {
            return PsiSubstitutor.EMPTY;
        }
        PsiManager manager = context.getManager();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (PsiTypeParameterListOwner currContext = (PsiTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)context, PsiTypeParameterListOwner.class); currContext != null && !manager.areElementsEquivalent((PsiElement)currContext, (PsiElement)targetClass); currContext = currContext.getContainingClass()) {
            PsiTypeParameter[] typeParameters = currContext.getTypeParameters();
            substitutor = JavaPsiFacade.getInstance((Project)project).getElementFactory().createRawSubstitutor(substitutor, typeParameters);
        }
        return substitutor;
    }

    @Nullable
    private static PsiClassType getComponentType(PsiType type2) {
        if ((type2 = type2.getDeepComponentType()) instanceof PsiClassType) {
            return (PsiClassType)type2;
        }
        return null;
    }

    private int substituteToTypeParameters(PsiTypeElement typeElement, PsiType expectedType, PsiSubstitutor rawingSubstitutor, boolean toplevel) {
        List<PsiTypeParameter> matchedParameters = GuessTypeParameters.matchingTypeParameters(this.mySubstitutor, expectedType, 0);
        if (!matchedParameters.isEmpty()) {
            SmartList types = new SmartList((Collection)ContainerUtil.map(matchedParameters, it -> this.myFactory.createType((PsiClass)it)));
            PsiType substituted = rawingSubstitutor.substitute(expectedType);
            if (!"java.lang.Object".equals(substituted.getCanonicalText()) && (toplevel || substituted.equals(expectedType))) {
                types.add(substituted);
            }
            this.myBuilder.replaceElement((PsiElement)typeElement, (Expression)new TypeExpression(this.myProject, (Iterable<PsiType>)types));
            return toplevel ? 1 : 2;
        }
        PsiTypeElement[] innerTypeElements = GuessTypeParameters.typeArguments(typeElement);
        if (innerTypeElements == null) {
            return 0;
        }
        PsiType[] expectedTypeArguments = GuessTypeParameters.typeArguments(expectedType);
        if (expectedTypeArguments == null) {
            return 0;
        }
        boolean substituted = false;
        for (int i = 0; i < innerTypeElements.length; ++i) {
            substituted |= this.substituteToTypeParameters(innerTypeElements[i], expectedTypeArguments[i], rawingSubstitutor, false) != 0;
        }
        return substituted ? 2 : 0;
    }

    @Nullable
    private static PsiTypeElement[] typeArguments(@NotNull PsiTypeElement typeElement) {
        PsiJavaCodeReferenceElement unwrappedRef;
        if (typeElement == null) {
            GuessTypeParameters.$$$reportNull$$$0(3);
        }
        if ((unwrappedRef = typeElement.getInnermostComponentReferenceElement()) == null) {
            return null;
        }
        PsiReferenceParameterList typeArgumentList = unwrappedRef.getParameterList();
        if (typeArgumentList == null) {
            return null;
        }
        return typeArgumentList.getTypeParameterElements();
    }

    @Nullable
    private static PsiType[] typeArguments(@NotNull PsiType type2) {
        PsiClassType unwrappedType;
        if (type2 == null) {
            GuessTypeParameters.$$$reportNull$$$0(4);
        }
        return (unwrappedType = GuessTypeParameters.getComponentType(type2)) == null ? null : unwrappedType.getParameters();
    }

    @NotNull
    private static List<PsiTypeParameter> matchingTypeParameters(@NotNull PsiSubstitutor substitutor, @NotNull PsiType expectedType, @ExpectedTypeInfo.Type int kind2) {
        if (substitutor == null) {
            GuessTypeParameters.$$$reportNull$$$0(5);
        }
        if (expectedType == null) {
            GuessTypeParameters.$$$reportNull$$$0(6);
        }
        SmartList result = new SmartList();
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            PsiType typeArgument = (PsiType)entry.getValue();
            if (typeArgument == null || !GuessTypeParameters.matches(typeArgument, expectedType, kind2)) continue;
            result.add(entry.getKey());
        }
        SmartList smartList = result;
        if (smartList == null) {
            GuessTypeParameters.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private static boolean matches(@NotNull PsiType type2, @NotNull PsiType expectedType, @ExpectedTypeInfo.Type int kind2) {
        if (type2 == null) {
            GuessTypeParameters.$$$reportNull$$$0(8);
        }
        if (expectedType == null) {
            GuessTypeParameters.$$$reportNull$$$0(9);
        }
        switch (kind2) {
            case 0: {
                return type2.equals(expectedType);
            }
            case 1: {
                return expectedType.isAssignableFrom(type2);
            }
            case 2: {
                return type2.isAssignableFrom(expectedType);
            }
        }
        return false;
    }

    private static boolean hasNullSubstitutions(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            GuessTypeParameters.$$$reportNull$$$0(10);
        }
        for (PsiType type2 : substitutor.getSubstitutionMap().values()) {
            if (type2 != null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/GuessTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/GuessTypeParameters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "typeArguments";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "matchingTypeParameters";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasNullSubstitutions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyTypeVisitor
    extends PsiTypeVisitor<PsiType> {
        private final GlobalSearchScope myResolveScope;
        private final PsiManager myManager;

        public MyTypeVisitor(PsiManager manager, GlobalSearchScope resolveScope) {
            this.myManager = manager;
            this.myResolveScope = resolveScope;
        }

        public PsiType visitType(PsiType type2) {
            if (type2.equals(PsiType.NULL)) {
                return PsiType.getJavaLangObject((PsiManager)this.myManager, (GlobalSearchScope)this.myResolveScope);
            }
            return type2;
        }

        public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return (PsiType)capturedWildcardType.getUpperBound().accept((PsiTypeVisitor)this);
        }
    }
}

