/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class MoveClassToModuleFix
implements IntentionAction {
    private final Map<PsiClass, Module> myModules = new LinkedHashMap<PsiClass, Module>();
    private final String myReferenceName;
    private final Module myCurrentModule;
    private final PsiDirectory mySourceRoot;
    private static final Logger LOG = Logger.getInstance(MoveClassToModuleFix.class);

    public MoveClassToModuleFix(String referenceName, Module currentModule, PsiDirectory root, PsiElement psiElement) {
        this.myReferenceName = referenceName;
        this.myCurrentModule = currentModule;
        this.mySourceRoot = root;
        Project project = psiElement.getProject();
        PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(referenceName, GlobalSearchScope.allScope((Project)project));
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiClass aClass : classes2) {
            Module classModule;
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || !((psiFile = aClass.getContainingFile()) instanceof PsiJavaFile) || aClass.getQualifiedName() == null || (virtualFile = psiFile.getVirtualFile()) == null || (classModule = fileIndex.getModuleForFile(virtualFile)) == null || classModule == currentModule || ModuleRootManager.getInstance((Module)currentModule).isDependsOn(classModule)) continue;
            this.myModules.put(aClass, classModule);
        }
    }

    @NotNull
    public String getText() {
        if (this.myModules.size() == 1) {
            PsiClass aClass = this.myModules.keySet().iterator().next();
            String string = "Move '" + aClass.getQualifiedName() + "' from module '" + this.myModules.get(aClass).getName() + "' to '" + this.myCurrentModule.getName() + "'";
            if (string == null) {
                MoveClassToModuleFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = "Move '" + this.myReferenceName + "' in '" + this.myCurrentModule.getName() + "'...";
        if (string == null) {
            MoveClassToModuleFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("move it" == null) {
            MoveClassToModuleFix.$$$reportNull$$$0(2);
        }
        return "move it";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            MoveClassToModuleFix.$$$reportNull$$$0(3);
        }
        return !this.myModules.isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            MoveClassToModuleFix.$$$reportNull$$$0(4);
        }
        if (this.myModules.size() == 1) {
            this.moveClass(project, editor, file, this.myModules.keySet().iterator().next());
        } else {
            LOG.assertTrue(editor != null);
            JBList list = new JBList(this.myModules.keySet());
            list.setCellRenderer((ListCellRenderer)new PsiElementListCellRenderer<PsiClass>(){

                public String getElementText(PsiClass psiClass) {
                    return psiClass.getQualifiedName();
                }

                @Nullable
                protected String getContainerText(PsiClass element, String name) {
                    return null;
                }

                protected int getIconFlags() {
                    return 0;
                }
            });
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Class to Move").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
                Object value2;
                if (project == null) {
                    MoveClassToModuleFix.$$$reportNull$$$0(5);
                }
                if ((value2 = list.getSelectedValue()) instanceof PsiClass) {
                    TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                        if (project == null) {
                            MoveClassToModuleFix.$$$reportNull$$$0(6);
                        }
                        this.moveClass(project, editor, file, (PsiClass)value2);
                    });
                }
            }).createPopup().showInBestPositionFor(editor);
        }
    }

    private void moveClass(Project project, Editor editor, PsiFile file, PsiClass aClass) {
        RefactoringActionHandler moveHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = dataManager.getDataContext();
        String fqName = aClass.getQualifiedName();
        LOG.assertTrue(fqName != null);
        PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage(this.myCurrentModule, StringUtil.getPackageName((String)fqName), this.mySourceRoot, true);
        DataContext context = SimpleDataContext.getSimpleContext((String)LangDataKeys.TARGET_PSI_ELEMENT.getName(), (Object)directory, (DataContext)dataContext);
        moveHandler.invoke(project, new PsiElement[]{aClass}, context);
        PsiReference reference = file.findReferenceAt(editor.getCaretModel().getOffset());
        PsiClass newClass = JavaPsiFacade.getInstance((Project)project).findClass(fqName, GlobalSearchScope.moduleScope((Module)this.myCurrentModule));
        if (reference != null && newClass != null) {
            AddImportAction action = new AddImportAction(project, reference, editor, newClass);
            action.execute();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void registerFixes(QuickFixActionRegistrar registrar, PsiJavaCodeReferenceElement reference) {
        PsiElement psiElement = reference.getElement();
        String referenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project = psiElement.getProject();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return;
        }
        PsiDirectory dir = containingFile.getContainingDirectory();
        if (dir == null) {
            return;
        }
        VirtualFile classVFile = containingFile.getVirtualFile();
        if (classVFile == null) {
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module currentModule = fileIndex.getModuleForFile(classVFile);
        if (currentModule == null) {
            return;
        }
        List sourceRoots = ModuleRootManager.getInstance((Module)currentModule).getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
        if (sourceRoots.isEmpty()) {
            return;
        }
        PsiDirectory sourceDirectory = PsiManager.getInstance((Project)project).findDirectory((VirtualFile)sourceRoots.get(0));
        if (sourceDirectory == null) {
            return;
        }
        VirtualFile vsourceRoot = fileIndex.getSourceRootForFile(classVFile);
        if (vsourceRoot == null) {
            return;
        }
        PsiDirectory sourceRoot = PsiManager.getInstance((Project)project).findDirectory(vsourceRoot);
        if (sourceRoot == null) {
            return;
        }
        registrar.register((IntentionAction)new MoveClassToModuleFix(referenceName, currentModule, sourceRoot, psiElement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$1";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

