/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacePrimitiveWithBoxedTypeAction
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myPrimitiveName;
    private final String myBoxedTypeName;
    private static final Logger LOG = Logger.getInstance(ReplacePrimitiveWithBoxedTypeAction.class);

    public ReplacePrimitiveWithBoxedTypeAction(@NotNull PsiTypeElement element, @NotNull String typeName, @NotNull String boxedTypeName) {
        if (element == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(0);
        }
        if (typeName == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(1);
        }
        if (boxedTypeName == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(2);
        }
        super((PsiElement)element);
        this.myPrimitiveName = typeName;
        this.myBoxedTypeName = boxedTypeName;
    }

    @NotNull
    public String getText() {
        String string = "Convert '" + this.myPrimitiveName + "' to '" + this.myBoxedTypeName + "'";
        if (string == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Convert primitive to boxed type" == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(4);
        }
        return "Convert primitive to boxed type";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(8);
        }
        if (startElement instanceof PsiTypeElement) {
            PsiType type2 = ((PsiTypeElement)startElement).getType();
            if (type2 instanceof PsiWildcardType) {
                type2 = ((PsiWildcardType)type2).getBound();
            }
            if (type2 instanceof PsiPrimitiveType) {
                return ((PsiPrimitiveType)type2).getBoxedType(startElement) != null;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClassType boxedType;
        PsiType type2;
        if (project == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(9);
        }
        if (file == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(10);
        }
        if (startElement == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(11);
        }
        if (endElement == null) {
            ReplacePrimitiveWithBoxedTypeAction.$$$reportNull$$$0(12);
        }
        if ((type2 = ((PsiTypeElement)startElement).getType()) instanceof PsiPrimitiveType) {
            boxedType = ((PsiPrimitiveType)type2).getBoxedType(startElement);
        } else {
            LOG.assertTrue(type2 instanceof PsiWildcardType);
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            PsiClassType boxedBound = ((PsiPrimitiveType)wildcardType.getBound()).getBoxedType(startElement);
            LOG.assertTrue(boxedBound != null);
            boxedType = wildcardType.isExtends() ? PsiWildcardType.createExtends((PsiManager)startElement.getManager(), (PsiType)boxedBound) : PsiWildcardType.createSuper((PsiManager)startElement.getManager(), (PsiType)boxedBound);
        }
        LOG.assertTrue(boxedType != null);
        startElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createTypeElement((PsiType)boxedType));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedTypeName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

