/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.WordSelectioner;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FieldSelectioner
extends WordSelectioner {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            FieldSelectioner.$$$reportNull$$$0(0);
        }
        return e instanceof PsiField && e.getLanguage() == JavaLanguage.INSTANCE;
    }

    private static void addRangeElem(List<TextRange> result, CharSequence editorText, PsiElement first, int end) {
        if (first != null) {
            result.addAll(FieldSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(first.getTextRange().getStartOffset(), end)));
        }
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (e == null) {
            FieldSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            FieldSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            FieldSelectioner.$$$reportNull$$$0(3);
        }
        List result = super.select(e, editorText, cursorOffset, editor);
        PsiField field = (PsiField)e;
        TextRange fieldRange = field.getTextRange();
        PsiIdentifier nameId = field.getNameIdentifier();
        TextRange nameRange = nameId.getTextRange();
        PsiExpression last = field.getInitializer();
        int end = last == null ? nameRange.getEndOffset() : last.getTextRange().getEndOffset();
        PsiDocComment comment = field.getDocComment();
        if (comment != null) {
            TextRange commentTextRange = comment.getTextRange();
            FieldSelectioner.addRangeElem(result, editorText, (PsiElement)comment, commentTextRange.getEndOffset());
        }
        FieldSelectioner.addRangeElem(result, editorText, (PsiElement)nameId, end);
        FieldSelectioner.addRangeElem(result, editorText, (PsiElement)field.getTypeElement(), nameRange.getEndOffset());
        FieldSelectioner.addRangeElem(result, editorText, (PsiElement)field.getModifierList(), fieldRange.getEndOffset());
        result.addAll(FieldSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)fieldRange));
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/FieldSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

