/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class AddAnnotationIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
        if (string == null) {
            AddAnnotationIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public abstract Pair<String, String[]> getAnnotations(@NotNull Project var1);

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiModifierListOwner owner;
        if (project == null) {
            AddAnnotationIntention.$$$reportNull$$$0(1);
        }
        if ((owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset())) == null || owner.getModifierList() == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner)) {
            return false;
        }
        Pair<String, String[]> annotations2 = this.getAnnotations(project);
        String toAdd = (String)annotations2.first;
        String[] toRemove = (String[])annotations2.second;
        if (toRemove.length > 0 && AddAnnotationIntention.isAnnotatedSkipInferred(owner, toRemove)) {
            return false;
        }
        this.setText(AddAnnotationPsiFix.calcText(owner, toAdd));
        if (AddAnnotationIntention.isAnnotatedSkipInferred(owner, toAdd)) {
            return false;
        }
        return this.canAnnotate(owner);
    }

    protected boolean canAnnotate(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            AddAnnotationIntention.$$$reportNull$$$0(2);
        }
        return true;
    }

    private static boolean isAnnotatedSkipInferred(PsiModifierListOwner owner, String ... annoFqns) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)false, (String[])annoFqns);
        return annotation != null && !AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiModifierListOwner owner;
        if (project == null) {
            AddAnnotationIntention.$$$reportNull$$$0(3);
        }
        if ((owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset())) == null || !owner.isValid()) {
            return;
        }
        Pair<String, String[]> annotations2 = this.getAnnotations(project);
        String toAdd = (String)annotations2.first;
        String[] toRemove = (String[])annotations2.second;
        AddAnnotationFix fix = new AddAnnotationFix(toAdd, owner, toRemove);
        fix.invoke(project, editor, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/AddAnnotationIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/AddAnnotationIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canAnnotate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

