/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.javadoc.AnnotationDocGenerator;
import com.intellij.codeInsight.javadoc.AnnotationFormat;
import com.intellij.codeInsight.javadoc.ColorUtil;
import com.intellij.codeInsight.javadoc.DocumentationDelegateProvider;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInsight.javadoc.NonCodeAnnotationGenerator;
import com.intellij.javadoc.JavadocGeneratorRunProfile;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LangBundle;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.util.XmlStringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocInfoGenerator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.javadoc.JavaDocInfoGenerator");
    private static final String THROWS_KEYWORD = "throws";
    private static final String BR_TAG = "<br>";
    private static final String LINK_TAG = "link";
    private static final String LITERAL_TAG = "literal";
    private static final String CODE_TAG = "code";
    private static final String LINKPLAIN_TAG = "linkplain";
    private static final String INHERIT_DOC_TAG = "inheritDoc";
    private static final String DOC_ROOT_TAG = "docRoot";
    private static final String VALUE_TAG = "value";
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";
    private static final Pattern ourWhitespaces = Pattern.compile("[ \\n\\r\\t]+");
    private static final Pattern ourRelativeHtmlLinks = Pattern.compile("<A.*?HREF=\"([^\":]*)\"", 34);
    private static final InheritDocProvider<PsiDocTag> ourEmptyProvider = new InheritDocProvider<PsiDocTag>(){

        @Override
        public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
            return null;
        }

        @Override
        public PsiClass getElement() {
            return null;
        }
    };
    private static final InheritDocProvider<PsiElement[]> ourEmptyElementsProvider = JavaDocInfoGenerator.mapProvider(ourEmptyProvider, false);
    private final Project myProject;
    private final PsiElement myElement;
    private final JavaSdkVersion mySdkVersion;

    public JavaDocInfoGenerator(Project project, PsiElement element) {
        this.myProject = project;
        this.myElement = element;
        Sdk jdk = JavadocGeneratorRunProfile.getSdk(this.myProject);
        this.mySdkVersion = jdk == null ? null : JavaSdk.getInstance().getVersion(jdk);
    }

    private static InheritDocProvider<PsiElement[]> mapProvider(final InheritDocProvider<PsiDocTag> i, final boolean dropFirst) {
        return new InheritDocProvider<PsiElement[]>(){

            @Override
            public Pair<PsiElement[], InheritDocProvider<PsiElement[]>> getInheritDoc() {
                PsiElement[] elements;
                Pair pair = i.getInheritDoc();
                if (pair == null) {
                    return null;
                }
                PsiElement[] rawElements = ((PsiDocTag)pair.first).getDataElements();
                if (dropFirst && rawElements.length > 0) {
                    elements = new PsiElement[rawElements.length - 1];
                    System.arraycopy(rawElements, 1, elements, 0, elements.length);
                } else {
                    elements = rawElements;
                }
                return Pair.create((Object)elements, (Object)JavaDocInfoGenerator.mapProvider((InheritDocProvider)pair.second, dropFirst));
            }

            @Override
            public PsiClass getElement() {
                return i.getElement();
            }
        };
    }

    private static DocTagLocator<PsiDocTag> parameterLocator(final int parameterIndex) {
        return new DocTagLocator<PsiDocTag>(){

            @Override
            public PsiDocTag find(PsiDocCommentOwner owner, PsiDocComment comment) {
                if (parameterIndex < 0 || comment == null || !(owner instanceof PsiMethod)) {
                    return null;
                }
                PsiParameter[] parameters2 = ((PsiMethod)owner).getParameterList().getParameters();
                if (parameterIndex >= parameters2.length) {
                    return null;
                }
                String name = parameters2[parameterIndex].getName();
                return JavaDocInfoGenerator.getParamTagByName(comment, name);
            }
        };
    }

    private static DocTagLocator<PsiDocTag> typeParameterLocator(final int parameterIndex) {
        return new DocTagLocator<PsiDocTag>(){

            @Override
            public PsiDocTag find(PsiDocCommentOwner owner, PsiDocComment comment) {
                if (parameterIndex < 0 || comment == null || !(owner instanceof PsiTypeParameterListOwner)) {
                    return null;
                }
                PsiTypeParameter[] parameters2 = ((PsiTypeParameterListOwner)owner).getTypeParameters();
                if (parameterIndex >= parameters2.length) {
                    return null;
                }
                String rawName = parameters2[parameterIndex].getName();
                if (rawName == null) {
                    return null;
                }
                String name = "<" + rawName + ">";
                return JavaDocInfoGenerator.getParamTagByName(comment, name);
            }
        };
    }

    private static PsiDocTag getParamTagByName(@NotNull PsiDocComment comment, String name) {
        if (comment == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(0);
        }
        PsiDocTag[] tags = comment.findTagsByName("param");
        return JavaDocInfoGenerator.getTagByName(tags, name);
    }

    private static PsiDocTag getTagByName(@NotNull PsiDocTag[] tags, String name) {
        if (tags == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(1);
        }
        for (PsiDocTag tag : tags) {
            String text2;
            PsiDocTagValue value2 = tag.getValueElement();
            if (value2 == null || (text2 = value2.getText()) == null || !text2.equals(name)) continue;
            return tag;
        }
        return null;
    }

    private static DocTagLocator<PsiDocTag> exceptionLocator(final String name) {
        return new DocTagLocator<PsiDocTag>(){

            @Override
            public PsiDocTag find(PsiDocCommentOwner owner, PsiDocComment comment) {
                if (comment == null) {
                    return null;
                }
                for (PsiDocTag tag : JavaDocInfoGenerator.getThrowsTags(comment)) {
                    String text2;
                    PsiDocTagValue value2 = tag.getValueElement();
                    if (value2 == null || (text2 = value2.getText()) == null || !JavaDocInfoGenerator.areWeakEqual(text2, name)) continue;
                    return tag;
                }
                return null;
            }
        };
    }

    @Nullable
    public String generateFileInfo() {
        StringBuilder buffer = new StringBuilder();
        if (this.myElement instanceof PsiFile) {
            this.generatePrologue(buffer);
            VirtualFile virtualFile = ((PsiFile)this.myElement).getVirtualFile();
            if (virtualFile != null) {
                buffer.append(virtualFile.getPresentableUrl());
            }
            this.generateEpilogue(buffer);
        }
        return this.sanitizeHtml(buffer);
    }

    private String sanitizeHtml(StringBuilder buffer) {
        String text2 = buffer.toString();
        if (text2.isEmpty()) {
            return null;
        }
        text2 = this.convertHtmlLinks(text2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated JavaDoc:");
            LOG.debug(text2);
        }
        text2 = StringUtil.replaceIgnoreCase((String)text2, (String)"<p/>", (String)"<p></p>");
        return StringUtil.replace((String)text2, (String)"/>", (String)">");
    }

    private String convertHtmlLinks(String text2) {
        if (this.myElement == null) {
            return text2;
        }
        StringBuilder result = new StringBuilder();
        int prev = 0;
        Matcher matcher = ourRelativeHtmlLinks.matcher(text2);
        while (matcher.find()) {
            int groupStart = matcher.start(1);
            int groupEnd = matcher.end(1);
            result.append(text2, prev, groupStart);
            result.append(this.convertReference(text2.substring(groupStart, groupEnd)));
            prev = groupEnd;
        }
        if (result.length() == 0) {
            return text2;
        }
        result.append(text2, prev, text2.length());
        return result.toString();
    }

    protected String convertReference(String href) {
        return (String)ObjectUtils.notNull((Object)JavaDocInfoGenerator.createReferenceForRelativeLink(href, this.myElement), (Object)href);
    }

    @Nullable
    static String createReferenceForRelativeLink(@NotNull String relativeLink, @NotNull PsiElement contextElement) {
        PsiClass targetElement;
        String fragment;
        block13: {
            if (relativeLink == null) {
                JavaDocInfoGenerator.$$$reportNull$$$0(2);
            }
            if (contextElement == null) {
                JavaDocInfoGenerator.$$$reportNull$$$0(3);
            }
            fragment = null;
            int hashPosition = relativeLink.indexOf(35);
            if (hashPosition >= 0) {
                fragment = relativeLink.substring(hashPosition + 1);
                relativeLink = relativeLink.substring(0, hashPosition);
            }
            if (relativeLink.isEmpty()) {
                targetElement = contextElement instanceof PsiField || contextElement instanceof PsiMethod ? ((PsiMember)contextElement).getContainingClass() : contextElement;
            } else {
                if (!relativeLink.toLowerCase(Locale.US).endsWith(".htm") && !relativeLink.toLowerCase(Locale.US).endsWith(".html")) {
                    return null;
                }
                relativeLink = relativeLink.substring(0, relativeLink.lastIndexOf(46));
                String packageName = JavaDocInfoGenerator.getPackageName(contextElement);
                if (packageName == null) {
                    return null;
                }
                Couple<String> pathWithPackage = JavaDocInfoGenerator.removeParentReferences((Couple<String>)Couple.of((Object)relativeLink, (Object)packageName));
                if (pathWithPackage == null) {
                    return null;
                }
                relativeLink = (String)pathWithPackage.first;
                packageName = (String)pathWithPackage.second;
                relativeLink = relativeLink.replace('/', '.');
                String qualifiedTargetName = packageName.isEmpty() ? relativeLink : packageName + "." + relativeLink;
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)contextElement.getProject());
                Object object = targetElement = "package-summary".equals(StringUtil.getShortName((String)qualifiedTargetName)) ? javaPsiFacade.findPackage(StringUtil.getPackageName((String)qualifiedTargetName)) : javaPsiFacade.findClass(qualifiedTargetName, contextElement.getResolveScope());
            }
            if (targetElement == null) {
                return null;
            }
            if (fragment == null || !(targetElement instanceof PsiClass)) break block13;
            if (fragment.contains("-") || fragment.contains("(")) {
                for (PsiMethod psiMethod : targetElement.getMethods()) {
                    Set<String> signatures = JavaDocumentationProvider.getHtmlMethodSignatures(psiMethod, true);
                    if (!signatures.contains(fragment)) continue;
                    targetElement = psiMethod;
                    fragment = null;
                    break;
                }
            } else {
                for (PsiMethod psiMethod : targetElement.getFields()) {
                    if (!fragment.equals(psiMethod.getName())) continue;
                    targetElement = psiMethod;
                    fragment = null;
                    break;
                }
            }
        }
        return "psi_element://" + JavaDocUtil.getReferenceText(targetElement.getProject(), (PsiElement)targetElement) + (fragment == null ? "" : "###" + fragment);
    }

    @Nullable
    static Couple<String> removeParentReferences(Couple<String> pathWithContextPackage) {
        String path = (String)pathWithContextPackage.first;
        String packageName = (String)pathWithContextPackage.second;
        while (path.startsWith("../")) {
            if (packageName.isEmpty()) {
                return null;
            }
            int dotPos = packageName.lastIndexOf(46);
            packageName = dotPos < 0 ? "" : packageName.substring(0, dotPos);
            path = path.substring(3);
        }
        return Couple.of((Object)path, (Object)packageName);
    }

    static String getPackageName(PsiElement element) {
        String packageName = null;
        if (element instanceof PsiPackage) {
            packageName = ((PsiPackage)element).getQualifiedName();
        } else {
            PsiFile file = element.getContainingFile();
            if (file instanceof PsiClassOwner) {
                packageName = ((PsiClassOwner)file).getPackageName();
            }
        }
        return packageName;
    }

    public boolean generateDocInfoCore(StringBuilder buffer, boolean generatePrologueAndEpilogue) {
        if (this.myElement instanceof PsiClass) {
            this.generateClassJavaDoc(buffer, (PsiClass)this.myElement, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiMethod) {
            this.generateMethodJavaDoc(buffer, (PsiMethod)this.myElement, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiParameter) {
            this.generateMethodParameterJavaDoc(buffer, (PsiParameter)this.myElement, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiField) {
            this.generateFieldJavaDoc(buffer, (PsiField)this.myElement, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiVariable) {
            this.generateVariableJavaDoc(buffer, (PsiVariable)this.myElement, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)this.myElement);
            if (aPackage == null) {
                return false;
            }
            this.generatePackageJavaDoc(buffer, aPackage, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiPackage) {
            this.generatePackageJavaDoc(buffer, (PsiPackage)this.myElement, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiJavaModule) {
            this.generateModuleJavaDoc(buffer, (PsiJavaModule)this.myElement, generatePrologueAndEpilogue);
        } else {
            return false;
        }
        return true;
    }

    public static String generateSignature(PsiElement element) {
        StringBuilder buf = new StringBuilder();
        if (element instanceof PsiClass) {
            if (JavaDocInfoGenerator.generateClassSignature(buf, (PsiClass)element, SignaturePlace.ToolTip)) {
                return null;
            }
        } else if (element instanceof PsiField) {
            JavaDocInfoGenerator.generateFieldSignature(buf, (PsiField)element, SignaturePlace.ToolTip);
        } else if (element instanceof PsiMethod) {
            JavaDocInfoGenerator.generateMethodSignature(buf, (PsiMethod)element, SignaturePlace.ToolTip);
        }
        return buf.toString();
    }

    @Nullable
    public String generateDocInfo(List<String> docURLs) {
        StringBuilder buffer = new StringBuilder();
        if (!this.generateDocInfoCore(buffer, true)) {
            return null;
        }
        if (docURLs != null) {
            if (buffer.length() > 0 && this.elementHasSourceCode()) {
                LOG.debug("Documentation for " + this.myElement + " was generated from source code, it wasn't found at following URLs: ", new Object[]{docURLs});
            } else {
                if (buffer.length() == 0) {
                    buffer.append("<html><body></body></html>");
                }
                String errorSection = "<p id=\"error\">Following external urls were checked:<br>&nbsp;&nbsp;&nbsp;<i>" + StringUtil.join(docURLs, XmlStringUtil::escapeString, (String)"</i><br>&nbsp;&nbsp;&nbsp;<i>") + "</i><br>The documentation for this element is not found. Please add all the needed paths to API docs in <a href=\"open://Project Settings\">Project Settings.</a></p>";
                buffer.insert(buffer.indexOf("<body>"), errorSection);
            }
        }
        return this.sanitizeHtml(buffer);
    }

    private boolean elementHasSourceCode() {
        PsiDirectory[] items;
        if (this.myElement instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)this.myElement);
            if (aPackage == null) {
                return false;
            }
            items = aPackage.getDirectories((GlobalSearchScope)new EverythingGlobalScope(this.myProject));
        } else if (this.myElement instanceof PsiPackage) {
            items = ((PsiPackage)this.myElement).getDirectories((GlobalSearchScope)new EverythingGlobalScope(this.myProject));
        } else {
            PsiFile containingFile = this.myElement.getNavigationElement().getContainingFile();
            if (containingFile == null) {
                return false;
            }
            items = new PsiFileSystemItem[]{containingFile};
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        for (PsiDirectory item : items) {
            VirtualFile file = item.getVirtualFile();
            if (file == null || !projectFileIndex.isInSource(file)) continue;
            return true;
        }
        return false;
    }

    private void generateClassJavaDoc(StringBuilder buffer, PsiClass aClass, boolean generatePrologueAndEpilogue) {
        String packageName;
        PsiFile file;
        if (aClass instanceof PsiAnonymousClass) {
            return;
        }
        if (generatePrologueAndEpilogue) {
            this.generatePrologue(buffer);
        }
        if ((file = aClass.getContainingFile()) instanceof PsiJavaFile && !(packageName = ((PsiJavaFile)file).getPackageName()).isEmpty()) {
            buffer.append("<small><b>");
            buffer.append(packageName);
            buffer.append("</b></small>");
        }
        buffer.append("<PRE>");
        if (JavaDocInfoGenerator.generateClassSignature(buffer, aClass, SignaturePlace.Javadoc)) {
            return;
        }
        buffer.append("</PRE>");
        PsiDocComment comment = JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)aClass);
        if (comment != null) {
            this.generateCommonSection(buffer, comment);
            this.generateTypeParametersSection(buffer, aClass);
        }
        new NonCodeAnnotationGenerator((PsiModifierListOwner)aClass, buffer).explainAnnotations();
        if (generatePrologueAndEpilogue) {
            this.generateEpilogue(buffer);
        }
    }

    private static boolean generateClassSignature(StringBuilder buffer, PsiClass aClass, SignaturePlace place) {
        int i;
        boolean generateLink = place == SignaturePlace.Javadoc;
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)aClass, place, true);
        String modifiers = PsiFormatUtil.formatModifiers((PsiModifierListOwner)aClass, (int)16384);
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
        buffer.append(LangBundle.message((String)(aClass.isInterface() ? "java.terms.interface" : "java.terms.class"), (Object[])new Object[0]));
        buffer.append(" ");
        String refText = JavaDocUtil.getReferenceText(aClass.getProject(), (PsiElement)aClass);
        if (refText == null) {
            buffer.setLength(0);
            return true;
        }
        String labelText = JavaDocUtil.getLabelText(aClass.getProject(), aClass.getManager(), refText, (PsiElement)aClass);
        buffer.append("<b>");
        buffer.append(labelText);
        buffer.append("</b>");
        buffer.append(JavaDocInfoGenerator.generateTypeParameters((PsiTypeParameterListOwner)aClass, false));
        buffer.append("\n");
        PsiClassType[] refs = aClass.getExtendsListTypes();
        String qName = aClass.getQualifiedName();
        if (refs.length > 0 || !aClass.isInterface() && (qName == null || !qName.equals("java.lang.Object"))) {
            buffer.append("extends ");
            if (refs.length == 0) {
                JavaDocInfoGenerator.generateLink(buffer, "java.lang.Object", null, (PsiElement)aClass, false);
            } else {
                for (i = 0; i < refs.length; ++i) {
                    JavaDocInfoGenerator.generateType(buffer, (PsiType)refs[i], (PsiElement)aClass, generateLink);
                    if (i >= refs.length - 1) continue;
                    buffer.append(",&nbsp;");
                }
            }
            buffer.append("\n");
        }
        if ((refs = aClass.getImplementsListTypes()).length > 0) {
            buffer.append("implements ");
            for (i = 0; i < refs.length; ++i) {
                JavaDocInfoGenerator.generateType(buffer, (PsiType)refs[i], (PsiElement)aClass, generateLink);
                if (i >= refs.length - 1) continue;
                buffer.append(",&nbsp;");
            }
            buffer.append("\n");
        }
        if (buffer.charAt(buffer.length() - 1) == '\n') {
            buffer.setLength(buffer.length() - 1);
        }
        return false;
    }

    private void generateTypeParametersSection(StringBuilder buffer, PsiClass aClass) {
        LinkedList<ParamInfo> result = new LinkedList<ParamInfo>();
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            PsiTypeParameter typeParameter = typeParameters[i];
            String name = "<" + typeParameter.getName() + ">";
            DocTagLocator<PsiDocTag> locator = JavaDocInfoGenerator.typeParameterLocator(i);
            Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> inClassComment = JavaDocInfoGenerator.findInClassComment(aClass, locator);
            if (inClassComment != null) {
                result.add(new ParamInfo(name, inClassComment));
                continue;
            }
            Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> pair = JavaDocInfoGenerator.findInHierarchy(aClass, locator);
            if (pair == null) continue;
            result.add(new ParamInfo(name, pair));
        }
        this.generateParametersSection(buffer, CodeInsightBundle.message((String)"javadoc.type.parameters", (Object[])new Object[0]), result);
    }

    @Nullable
    private static Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> findInHierarchy(PsiClass psiClass, DocTagLocator<PsiDocTag> locator) {
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> pair;
        for (PsiClass superClass : psiClass.getSupers()) {
            pair = JavaDocInfoGenerator.findInClassComment(superClass, locator);
            if (pair == null) continue;
            return pair;
        }
        for (PsiClass superInterface : psiClass.getInterfaces()) {
            pair = JavaDocInfoGenerator.findInClassComment(superInterface, locator);
            if (pair == null) continue;
            return pair;
        }
        return null;
    }

    private static Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> findInClassComment(final PsiClass psiClass, final DocTagLocator<PsiDocTag> locator) {
        PsiDocTag tag = locator.find((PsiDocCommentOwner)psiClass, JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)psiClass));
        if (tag != null) {
            return new Pair((Object)tag, (Object)new InheritDocProvider<PsiDocTag>(){

                @Override
                public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                    return JavaDocInfoGenerator.findInHierarchy(psiClass, locator);
                }

                @Override
                public PsiClass getElement() {
                    return psiClass;
                }
            });
        }
        return null;
    }

    @Nullable
    private static PsiDocComment getDocComment(PsiDocCommentOwner docOwner) {
        PsiElement parent;
        PsiModifierList modifierList;
        PsiElement navElement = docOwner.getNavigationElement();
        if (!(navElement instanceof PsiDocCommentOwner)) {
            LOG.info("Wrong navElement: " + navElement + "; original = " + docOwner + " of class " + docOwner.getClass());
            return null;
        }
        PsiDocComment comment = ((PsiDocCommentOwner)navElement).getDocComment();
        if (comment == null && (modifierList = docOwner.getModifierList()) != null && (parent = modifierList.getParent()) instanceof PsiDocCommentOwner && parent.getNavigationElement() instanceof PsiDocCommentOwner) {
            return ((PsiDocCommentOwner)parent.getNavigationElement()).getDocComment();
        }
        return comment;
    }

    private void generateFieldJavaDoc(StringBuilder buffer, PsiField field, boolean generatePrologueAndEpilogue) {
        if (generatePrologueAndEpilogue) {
            this.generatePrologue(buffer);
        }
        JavaDocInfoGenerator.generateLinkToParentIfNeeded(buffer, (PsiMember)field);
        buffer.append("<PRE>");
        JavaDocInfoGenerator.generateFieldSignature(buffer, field, SignaturePlace.Javadoc);
        buffer.append("</PRE>");
        ColorUtil.appendColorPreview((PsiVariable)field, buffer);
        PsiDocComment comment = JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)field);
        if (comment != null) {
            this.generateCommonSection(buffer, comment);
        }
        new NonCodeAnnotationGenerator((PsiModifierListOwner)field, buffer).explainAnnotations();
        if (generatePrologueAndEpilogue) {
            this.generateEpilogue(buffer);
        }
    }

    private static void generateFieldSignature(StringBuilder buffer, PsiField field, SignaturePlace place) {
        boolean generateLink = place == SignaturePlace.Javadoc;
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)field, place, true);
        String modifiers = PsiFormatUtil.formatModifiers((PsiModifierListOwner)field, (int)16384);
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
        JavaDocInfoGenerator.generateType(buffer, field.getType(), (PsiElement)field, generateLink);
        buffer.append(" ");
        buffer.append("<b>");
        buffer.append(field.getName());
        JavaDocInfoGenerator.appendInitializer(buffer, (PsiVariable)field);
        JavaDocInfoGenerator.enumConstantOrdinal(buffer, field, field.getContainingClass(), "\n");
        buffer.append("</b>");
    }

    public static void enumConstantOrdinal(StringBuilder buffer, PsiField field, PsiClass parentClass, String newLine) {
        Object[] fields;
        int idx;
        if (parentClass != null && field instanceof PsiEnumConstant && (idx = ArrayUtilRt.find((Object[])(fields = parentClass.getFields()), (Object)field)) >= 0) {
            buffer.append(newLine);
            buffer.append("Enum constant ordinal: ").append(idx);
        }
    }

    private void generateVariableJavaDoc(StringBuilder buffer, PsiVariable variable, boolean generatePrologueAndEpilogue) {
        if (generatePrologueAndEpilogue) {
            this.generatePrologue(buffer);
        }
        buffer.append("<PRE>");
        String modifiers = PsiFormatUtil.formatModifiers((PsiModifierListOwner)variable, (int)16384);
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
        JavaDocInfoGenerator.generateType(buffer, variable.getType(), (PsiElement)variable);
        buffer.append(" ");
        buffer.append("<b>");
        buffer.append(variable.getName());
        JavaDocInfoGenerator.appendInitializer(buffer, variable);
        buffer.append("</b>");
        buffer.append("</PRE>");
        ColorUtil.appendColorPreview(variable, buffer);
        if (generatePrologueAndEpilogue) {
            this.generateEpilogue(buffer);
        }
    }

    private void generatePackageJavaDoc(StringBuilder buffer, PsiPackage psiPackage, boolean generatePrologueAndEpilogue) {
        for (PsiDirectory directory : psiPackage.getDirectories((GlobalSearchScope)new EverythingGlobalScope(this.myProject))) {
            ASTNode docCommentNode;
            FileASTNode node;
            PsiFile packageInfoFile = directory.findFile("package-info.java");
            if (packageInfoFile != null && (node = packageInfoFile.getNode()) != null && (docCommentNode = JavaDocInfoGenerator.findRelevantCommentNode((ASTNode)node)) != null) {
                if (generatePrologueAndEpilogue) {
                    this.generatePrologue(buffer);
                }
                this.generateCommonSection(buffer, (PsiDocComment)docCommentNode.getPsi());
                if (!generatePrologueAndEpilogue) break;
                this.generateEpilogue(buffer);
                break;
            }
            PsiFile packageHtmlFile = directory.findFile("package.html");
            if (packageHtmlFile == null) continue;
            this.generatePackageHtmlJavaDoc(buffer, packageHtmlFile, generatePrologueAndEpilogue);
            break;
        }
    }

    private void generateModuleJavaDoc(StringBuilder buffer, PsiJavaModule module, boolean generatePrologueAndEpilogue) {
        if (generatePrologueAndEpilogue) {
            this.generatePrologue(buffer);
        }
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)module, SignaturePlace.Javadoc, true);
        buffer.append("<pre>module <b>").append(module.getName()).append("</b></pre>");
        PsiDocComment comment = module.getDocComment();
        if (comment != null) {
            this.generateCommonSection(buffer, comment);
        }
        if (generatePrologueAndEpilogue) {
            this.generateEpilogue(buffer);
        }
    }

    @Nullable
    private static ASTNode findRelevantCommentNode(@NotNull ASTNode fileNode) {
        ASTNode node;
        if (fileNode == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(4);
        }
        if ((node = fileNode.findChildByType(JavaElementType.PACKAGE_STATEMENT)) == null) {
            node = fileNode.getLastChildNode();
        }
        while (node != null && node.getElementType() != JavaDocElementType.DOC_COMMENT) {
            node = node.getTreePrev();
        }
        return node;
    }

    public void generateCommonSection(StringBuilder buffer, PsiDocComment docComment) {
        this.generateDescription(buffer, docComment);
        this.generateApiSection(buffer, docComment);
        this.generateDeprecatedSection(buffer, docComment);
        this.generateSinceSection(buffer, docComment);
        this.generateSeeAlsoSection(buffer, docComment);
    }

    private void generateApiSection(StringBuilder buffer, PsiDocComment comment) {
        String[] tagNames;
        for (String tagName : tagNames = new String[]{"apiNote", "implSpec", "implNote"}) {
            PsiDocTag tag = comment.findTagByName(tagName);
            if (tag == null) continue;
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(tagName).append("</b>");
            buffer.append("<DD>");
            this.generateValue(buffer, tag.getDataElements(), ourEmptyElementsProvider);
            buffer.append("</DD></DL></DD>");
        }
    }

    private void generatePackageHtmlJavaDoc(StringBuilder buffer, PsiFile packageHtmlFile, boolean generatePrologueAndEpilogue) {
        PsiDocComment docComment;
        String htmlText = packageHtmlFile.getText();
        try {
            Document document = JDOMUtil.loadDocument((InputStream)new ByteArrayInputStream(htmlText.getBytes(CharsetToolkit.UTF8_CHARSET)));
            Element rootTag = document.getRootElement();
            Element subTag = rootTag.getChild("body");
            if (subTag != null) {
                htmlText = subTag.getValue();
            }
        }
        catch (IOException | JDOMException document) {
            // empty catch block
        }
        htmlText = StringUtil.replace((String)htmlText, (String)"*/", (String)"&#42;&#47;");
        String fileText = "/** " + htmlText + " */";
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)packageHtmlFile.getProject()).getElementFactory();
        try {
            docComment = elementFactory.createDocCommentFromText(fileText);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (generatePrologueAndEpilogue) {
            this.generatePrologue(buffer);
        }
        this.generateCommonSection(buffer, docComment);
        if (generatePrologueAndEpilogue) {
            this.generateEpilogue(buffer);
        }
    }

    @Nullable
    public static PsiExpression calcInitializerExpression(PsiVariable variable) {
        JavaPsiFacade instance;
        Object o;
        PsiModifierList modifierList;
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && (modifierList = variable.getModifierList()) != null && modifierList.hasModifierProperty("final") && !(initializer instanceof PsiLiteralExpression) && (o = (instance = JavaPsiFacade.getInstance((Project)variable.getProject())).getConstantEvaluationHelper().computeConstantExpression((PsiElement)initializer)) != null) {
            String text2 = o.toString();
            PsiType type2 = variable.getType();
            if (type2.equalsToText("java.lang.String")) {
                text2 = "\"" + StringUtil.escapeStringCharacters((String)StringUtil.shortenPathWithEllipsis((String)text2, (int)120)) + "\"";
            } else if (type2.equalsToText("char")) {
                text2 = "'" + text2 + "'";
            }
            try {
                return instance.getElementFactory().createExpressionFromText(text2, (PsiElement)variable);
            }
            catch (IncorrectOperationException ex) {
                LOG.info("type:" + type2.getCanonicalText() + "; text: " + text2, (Throwable)ex);
            }
        }
        return null;
    }

    public static void appendExpressionValue(StringBuilder buffer, PsiExpression initializer, String label) {
        int index;
        int index2;
        String text2 = initializer.getText().trim();
        int index1 = text2.indexOf(10);
        if (index1 < 0) {
            index1 = text2.length();
        }
        if ((index2 = text2.indexOf(13)) < 0) {
            index2 = text2.length();
        }
        boolean trunc = (index = Math.min(index1, index2)) < text2.length();
        text2 = text2.substring(0, index);
        buffer.append(label);
        buffer.append(StringUtil.escapeXml((String)text2));
        if (trunc) {
            buffer.append("...");
        }
    }

    private static void appendInitializer(StringBuilder buffer, PsiVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null) {
            int index;
            boolean trunc;
            int index2;
            buffer.append(" = ");
            String text2 = initializer.getText();
            text2 = text2.trim();
            int index1 = text2.indexOf(10);
            if (index1 < 0) {
                index1 = text2.length();
            }
            if ((index2 = text2.indexOf(13)) < 0) {
                index2 = text2.length();
            }
            boolean bl = trunc = (index = Math.min(index1, index2)) < text2.length();
            if (trunc) {
                text2 = text2.substring(0, index);
                buffer.append(StringUtil.escapeXml((String)text2));
                buffer.append("...");
            } else {
                initializer.accept((PsiElementVisitor)new MyVisitor(buffer));
            }
            PsiExpression constantInitializer = JavaDocInfoGenerator.calcInitializerExpression(variable);
            if (constantInitializer != null) {
                buffer.append("\n");
                JavaDocInfoGenerator.appendExpressionValue(buffer, constantInitializer, CodeInsightBundle.message((String)"javadoc.resolved.value", (Object[])new Object[0]));
            }
        }
    }

    private static void generateAnnotations(StringBuilder buffer, PsiModifierListOwner owner, SignaturePlace place, boolean splitAnnotations) {
        AnnotationFormat format = place == SignaturePlace.Javadoc ? AnnotationFormat.JavaDocShort : AnnotationFormat.ToolTip;
        for (AnnotationDocGenerator anno : AnnotationDocGenerator.getAnnotationsToShow(owner)) {
            anno.generateAnnotation(buffer, format);
            buffer.append("&nbsp;");
            if (!splitAnnotations) continue;
            buffer.append("\n");
        }
    }

    public static boolean isDocumentedAnnotationType(@NotNull PsiClass resolved) {
        if (resolved == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(5);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)resolved, (String)"java.lang.annotation.Documented", (int)0);
    }

    public static boolean isRepeatableAnnotationType(@Nullable PsiElement annotationType) {
        return annotationType instanceof PsiClass && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiClass)annotationType), (String)"java.lang.annotation.Repeatable", (int)0);
    }

    private void generateMethodParameterJavaDoc(StringBuilder buffer, PsiParameter parameter2, boolean generatePrologueAndEpilogue) {
        String parameterName = parameter2.getName();
        if (generatePrologueAndEpilogue) {
            this.generatePrologue(buffer);
        }
        buffer.append("<PRE>");
        String modifiers = PsiFormatUtil.formatModifiers((PsiModifierListOwner)parameter2, (int)16384);
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)parameter2, SignaturePlace.Javadoc, true);
        JavaDocInfoGenerator.generateType(buffer, parameter2.getType(), (PsiElement)parameter2);
        buffer.append(" ");
        buffer.append("<b>");
        buffer.append(parameterName);
        JavaDocInfoGenerator.appendInitializer(buffer, (PsiVariable)parameter2);
        buffer.append("</b>");
        buffer.append("</PRE>");
        PsiElement method = PsiTreeUtil.getParentOfType((PsiElement)parameter2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (method instanceof PsiMethod) {
            int parameterIndex;
            PsiDocComment docComment;
            PsiDocTag[] localTags;
            ParamInfo tagInfoProvider;
            PsiMethod psiMethod = (PsiMethod)method;
            PsiParameterList parameterList = psiMethod.getParameterList();
            if (parameter2.getParent() == parameterList && (tagInfoProvider = this.findDocTag(localTags = (docComment = JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)psiMethod)) != null ? docComment.getTags() : PsiDocTag.EMPTY_ARRAY, parameterName, psiMethod, JavaDocInfoGenerator.parameterLocator(parameterIndex = parameterList.getParameterIndex(parameter2)))) != null) {
                this.generateOneParameter(buffer, tagInfoProvider);
            }
        }
        new NonCodeAnnotationGenerator((PsiModifierListOwner)parameter2, buffer).explainAnnotations();
        if (generatePrologueAndEpilogue) {
            this.generateEpilogue(buffer);
        }
    }

    public String generateMethodParameterJavaDoc() {
        if (!(this.myElement instanceof PsiParameter)) {
            return null;
        }
        PsiParameter parameter2 = (PsiParameter)this.myElement;
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter2, PsiMethod.class);
        if (method == null) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameter2.getParent() != parameterList) {
            return null;
        }
        PsiDocComment docComment = JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)method);
        PsiDocTag[] localTags = docComment != null ? docComment.getTags() : PsiDocTag.EMPTY_ARRAY;
        int parameterIndex = parameterList.getParameterIndex(parameter2);
        ParamInfo tagInfoProvider = this.findDocTag(localTags, parameter2.getName(), method, JavaDocInfoGenerator.parameterLocator(parameterIndex));
        if (tagInfoProvider == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        PsiElement[] elements = tagInfoProvider.docTag.getDataElements();
        if (elements.length == 0) {
            return null;
        }
        String text2 = elements[0].getText();
        int spaceIndex = text2.indexOf(32);
        if (spaceIndex < 0) {
            spaceIndex = text2.length();
        }
        buffer.append(text2.substring(spaceIndex));
        this.generateValue(buffer, elements, 1, JavaDocInfoGenerator.mapProvider(tagInfoProvider.inheritDocTagProvider, true));
        return buffer.toString();
    }

    private void generateMethodJavaDoc(StringBuilder buffer, PsiMethod method, boolean generatePrologueAndEpilogue) {
        if (generatePrologueAndEpilogue) {
            this.generatePrologue(buffer);
        }
        JavaDocInfoGenerator.generateLinkToParentIfNeeded(buffer, (PsiMember)method);
        buffer.append("<PRE>");
        JavaDocInfoGenerator.generateMethodSignature(buffer, method, SignaturePlace.Javadoc);
        buffer.append("</PRE>");
        PsiDocComment comment = this.getMethodDocComment(method);
        this.generateMethodDescription(buffer, method, comment);
        JavaDocInfoGenerator.generateSuperMethodsSection(buffer, method, false);
        JavaDocInfoGenerator.generateSuperMethodsSection(buffer, method, true);
        if (comment != null) {
            this.generateDeprecatedSection(buffer, comment);
        }
        this.generateParametersSection(buffer, method, comment);
        this.generateTypeParametersSection(buffer, method, comment);
        this.generateReturnsSection(buffer, method, comment);
        this.generateThrowsSection(buffer, method, comment);
        if (comment != null) {
            this.generateApiSection(buffer, comment);
            this.generateSinceSection(buffer, comment);
            this.generateSeeAlsoSection(buffer, comment);
        }
        new NonCodeAnnotationGenerator((PsiModifierListOwner)method, buffer).explainAnnotations();
        if (generatePrologueAndEpilogue) {
            this.generateEpilogue(buffer);
        }
    }

    private static void generateLinkToParentIfNeeded(StringBuilder buffer, PsiMember member) {
        String qName;
        PsiClass parentClass = member.getContainingClass();
        if (parentClass != null && (qName = parentClass.getQualifiedName()) != null) {
            buffer.append("<small><b>");
            JavaDocInfoGenerator.generateLink(buffer, qName, qName + JavaDocInfoGenerator.generateTypeParameters((PsiTypeParameterListOwner)parentClass, true), (PsiElement)member, false);
            buffer.append("</b></small>");
        }
    }

    private static void generateMethodSignature(StringBuilder buffer, PsiMethod method, SignaturePlace place) {
        boolean useShortNames = place == SignaturePlace.ToolTip;
        boolean generateLink = place == SignaturePlace.Javadoc;
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)method, place, true);
        String modifiers = PsiFormatUtil.formatModifiers((PsiModifierListOwner)method, (int)16384);
        int indent = 0;
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            buffer.append("&nbsp;");
            indent += modifiers.length() + 1;
        }
        String typeParamsString = JavaDocInfoGenerator.generateTypeParameters((PsiTypeParameterListOwner)method, useShortNames);
        indent += StringUtil.unescapeXml((String)StringUtil.stripHtml((String)typeParamsString, (boolean)true)).length();
        if (!typeParamsString.isEmpty()) {
            buffer.append(typeParamsString);
            buffer.append("&nbsp;");
            ++indent;
        }
        if (method.getReturnType() != null) {
            indent += JavaDocInfoGenerator.generateType(buffer, method.getReturnType(), (PsiElement)method, generateLink, useShortNames);
            buffer.append("&nbsp;");
            ++indent;
        }
        buffer.append("<b>");
        String name = method.getName();
        buffer.append(name);
        buffer.append("</b>");
        indent += name.length();
        buffer.append("(");
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parm = parameters2[i];
            JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)parm, place, false);
            JavaDocInfoGenerator.generateType(buffer, parm.getType(), (PsiElement)method, generateLink, useShortNames);
            buffer.append("&nbsp;");
            if (parm.getName() != null) {
                buffer.append(parm.getName());
            }
            if (i >= parameters2.length - 1) continue;
            buffer.append(",\n ");
            buffer.append(StringUtil.repeat((String)" ", (int)indent));
        }
        buffer.append(")");
        PsiClassType[] refs = method.getThrowsList().getReferencedTypes();
        if (refs.length > 0) {
            int i;
            buffer.append("\n");
            indent -= THROWS_KEYWORD.length() + 1;
            for (i = 0; i < indent; ++i) {
                buffer.append(" ");
            }
            indent += THROWS_KEYWORD.length() + 1;
            buffer.append(THROWS_KEYWORD);
            buffer.append("&nbsp;");
            for (i = 0; i < refs.length; ++i) {
                JavaDocInfoGenerator.generateLink(buffer, useShortNames ? refs[i].getPresentableText() : refs[i].getCanonicalText(), null, (PsiElement)method, false);
                if (i >= refs.length - 1) continue;
                buffer.append(",\n");
                for (int j = 0; j < indent; ++j) {
                    buffer.append(" ");
                }
            }
        }
    }

    private PsiDocComment getMethodDocComment(PsiMethod method) {
        PsiClass parentClass = method.getContainingClass();
        if (parentClass != null && parentClass.isEnum()) {
            PsiParameterList parameterList = method.getParameterList();
            if (method.getName().equals("values") && parameterList.getParametersCount() == 0) {
                return this.loadSyntheticDocComment(method, "/javadoc/EnumValues.java.template");
            }
            if (method.getName().equals("valueOf") && parameterList.getParametersCount() == 1 && parameterList.getParameters()[0].getType().equalsToText("java.lang.String")) {
                return this.loadSyntheticDocComment(method, "/javadoc/EnumValueOf.java.template");
            }
        }
        return JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)method);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PsiDocComment loadSyntheticDocComment(PsiMethod method, String resourceName) {
        PsiClass containingClass = method.getContainingClass();
        assert (containingClass != null) : method;
        String containingClassName = containingClass.getName();
        assert (containingClassName != null) : containingClass;
        try {
            String text2;
            try (InputStream commentStream = JavaDocInfoGenerator.class.getResourceAsStream(resourceName);){
                if (commentStream == null) {
                    PsiDocComment psiDocComment = null;
                    return psiDocComment;
                }
                byte[] bytes = FileUtil.loadBytes((InputStream)commentStream);
                text2 = new String(bytes, CharsetToolkit.UTF8_CHARSET);
            }
            text2 = StringUtil.replace((String)text2, (String)"<ClassName>", (String)containingClassName);
            return JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createDocCommentFromText(text2);
        }
        catch (IncorrectOperationException | IOException e) {
            LOG.info(e);
            return null;
        }
    }

    protected void generatePrologue(StringBuilder buffer) {
        URL baseUrl = this.getBaseUrl();
        buffer.append("<html><head>");
        if (baseUrl != null) {
            buffer.append("<base href=\"").append(baseUrl).append("\">");
        }
        buffer.append("    <style type=\"text/css\">        #error {            background-color: #eeeeee;            margin-bottom: 10px;        }        p {            margin: 5px 0;        }    </style></head><body>");
    }

    private URL getBaseUrl() {
        if (this.myElement == null) {
            return null;
        }
        PsiElement element = this.myElement.getNavigationElement();
        if (element == null) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        return VfsUtilCore.convertToURL((String)vFile.getUrl());
    }

    protected void generateEpilogue(StringBuilder buffer) {
        while (buffer.length() >= BR_TAG.length()) {
            char c = buffer.charAt(buffer.length() - 1);
            if (c == '\n' || c == '\r' || c == ' ' || c == '\t') {
                buffer.setLength(buffer.length() - 1);
                continue;
            }
            String tail = buffer.substring(buffer.length() - BR_TAG.length());
            if (!tail.equalsIgnoreCase(BR_TAG)) break;
            buffer.setLength(buffer.length() - BR_TAG.length());
        }
        buffer.append("</body></html>");
    }

    private void generateDescription(StringBuilder buffer, PsiDocComment comment) {
        PsiElement[] elements = comment.getDescriptionElements();
        this.generateValue(buffer, elements, ourEmptyElementsProvider);
    }

    private static boolean isEmptyDescription(PsiDocComment comment) {
        if (comment == null) {
            return true;
        }
        for (PsiElement description : comment.getDescriptionElements()) {
            String text2 = description.getText();
            if (text2 == null || ourWhitespaces.matcher(text2).replaceAll("").isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void generateMethodDescription(StringBuilder buffer, final PsiMethod method, PsiDocComment comment) {
        final DocTagLocator<PsiElement[]> descriptionLocator = new DocTagLocator<PsiElement[]>(){

            @Override
            public PsiElement[] find(PsiDocCommentOwner owner, PsiDocComment comment) {
                return comment != null && !JavaDocInfoGenerator.isEmptyDescription(comment) ? comment.getDescriptionElements() : null;
            }
        };
        if (comment != null && !JavaDocInfoGenerator.isEmptyDescription(comment)) {
            this.generateValue(buffer, comment.getDescriptionElements(), new InheritDocProvider<PsiElement[]>(){

                @Override
                public Pair<PsiElement[], InheritDocProvider<PsiElement[]>> getInheritDoc() {
                    return JavaDocInfoGenerator.this.findInheritDocTag(method, descriptionLocator);
                }

                @Override
                public PsiClass getElement() {
                    return method.getContainingClass();
                }
            });
            return;
        }
        Pair<PsiElement[], InheritDocProvider<PsiElement[]>> pair = this.findInheritDocTag(method, descriptionLocator);
        if (pair != null) {
            PsiElement[] elements = (PsiElement[])pair.first;
            if (elements != null) {
                PsiClass aClass = ((InheritDocProvider)pair.second).getElement();
                buffer.append("<DD><DL>");
                buffer.append("<DT><b>");
                buffer.append(CodeInsightBundle.message((String)(aClass.isInterface() ? "javadoc.description.copied.from.interface" : "javadoc.description.copied.from.class"), (Object[])new Object[0]));
                buffer.append("</b>&nbsp;");
                JavaDocInfoGenerator.generateLink(buffer, (PsiElement)aClass, JavaDocUtil.getShortestClassName(aClass, (PsiElement)method), false);
                buffer.append(BR_TAG);
                this.generateValue(buffer, elements, (InheritDocProvider)pair.second);
                buffer.append("</DD></DL></DD>");
            }
        } else {
            PsiDocComment fieldDocComment;
            PsiField field = PropertyUtil.getFieldOfGetter(method);
            if (field == null) {
                field = PropertyUtil.getFieldOfSetter(method);
            }
            if (field != null && (fieldDocComment = field.getDocComment()) != null && !JavaDocInfoGenerator.isEmptyDescription(fieldDocComment)) {
                buffer.append("<DD><DL>");
                buffer.append("<DT><b>");
                buffer.append(CodeInsightBundle.message((String)"javadoc.description.copied.from.field", (Object[])new Object[0]));
                buffer.append("</b>&nbsp;");
                JavaDocInfoGenerator.generateLink(buffer, (PsiElement)field, field.getName(), false);
                buffer.append(BR_TAG);
                this.generateValue(buffer, fieldDocComment.getDescriptionElements(), ourEmptyElementsProvider);
                buffer.append("</DD></DL></DD>");
            }
        }
    }

    private void generateValue(StringBuilder buffer, PsiElement[] elements, InheritDocProvider<PsiElement[]> provider) {
        this.generateValue(buffer, elements, 0, provider);
    }

    private String getDocRoot() {
        String qName;
        PsiClass aClass = this.myElement instanceof PsiClass ? (PsiClass)this.myElement : (this.myElement instanceof PsiMember ? ((PsiMember)this.myElement).getContainingClass() : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiClass.class));
        if (aClass != null && (qName = aClass.getQualifiedName()) != null) {
            return StringUtil.repeat((String)"../", (int)(StringUtil.countChars((CharSequence)qName, (char)'.') + 1));
        }
        return "";
    }

    private void generateValue(StringBuilder buffer, PsiElement[] elements, int startIndex, InheritDocProvider<PsiElement[]> provider) {
        int predictOffset = startIndex < elements.length ? elements[startIndex].getTextOffset() + elements[startIndex].getText().length() : 0;
        for (int i = startIndex; i < elements.length; ++i) {
            if (elements[i].getTextOffset() > predictOffset) {
                buffer.append(" ");
            }
            predictOffset = elements[i].getTextOffset() + elements[i].getText().length();
            PsiElement element = elements[i];
            if (element instanceof PsiInlineDocTag) {
                PsiInlineDocTag tag = (PsiInlineDocTag)element;
                String tagName = tag.getName();
                if (tagName.equals(LINK_TAG)) {
                    this.generateLinkValue(tag, buffer, false);
                    continue;
                }
                if (tagName.equals(LITERAL_TAG)) {
                    this.generateLiteralValue(buffer, (PsiDocTag)tag);
                    continue;
                }
                if (tagName.equals(CODE_TAG)) {
                    this.generateCodeValue(tag, buffer);
                    continue;
                }
                if (tagName.equals(LINKPLAIN_TAG)) {
                    this.generateLinkValue(tag, buffer, true);
                    continue;
                }
                if (tagName.equals(INHERIT_DOC_TAG)) {
                    Pair<PsiElement[], InheritDocProvider<PsiElement[]>> inheritInfo = provider.getInheritDoc();
                    if (inheritInfo == null) continue;
                    this.generateValue(buffer, (PsiElement[])inheritInfo.first, (InheritDocProvider)inheritInfo.second);
                    continue;
                }
                if (tagName.equals(DOC_ROOT_TAG)) {
                    buffer.append(this.getDocRoot());
                    continue;
                }
                if (!tagName.equals(VALUE_TAG)) continue;
                this.generateValueValue(tag, buffer, element);
                continue;
            }
            buffer.append(StringUtil.replaceUnicodeEscapeSequences((String)element.getText()));
        }
    }

    private void generateCodeValue(PsiInlineDocTag tag, StringBuilder buffer) {
        buffer.append("<code>");
        this.generateLiteralValue(buffer, (PsiDocTag)tag);
        buffer.append("</code>");
    }

    private void generateLiteralValue(StringBuilder buffer, PsiDocTag tag) {
        StringBuilder tmpBuffer = new StringBuilder();
        for (PsiElement element : tag.getDataElements()) {
            JavaDocInfoGenerator.appendPlainText(StringUtil.escapeXml((String)element.getText()), tmpBuffer);
        }
        if ((this.mySdkVersion == null || this.mySdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) && JavaDocInfoGenerator.isInPre(tag)) {
            buffer.append((CharSequence)tmpBuffer);
        } else {
            buffer.append(StringUtil.trimLeading((CharSequence)tmpBuffer));
        }
    }

    private static boolean isInPre(PsiDocTag tag) {
        for (PsiElement sibling = tag.getPrevSibling(); sibling != null; sibling = sibling.getPrevSibling()) {
            String text2;
            int pos;
            if (!(sibling instanceof PsiDocToken) || (pos = (text2 = sibling.getText().toLowerCase()).lastIndexOf("pre>")) <= 0) continue;
            switch (text2.charAt(pos - 1)) {
                case '<': {
                    return true;
                }
                case '/': {
                    return false;
                }
            }
        }
        return false;
    }

    private static void appendPlainText(String text2, StringBuilder buffer) {
        buffer.append(StringUtil.replaceUnicodeEscapeSequences((String)text2));
    }

    protected void generateLinkValue(PsiInlineDocTag tag, StringBuilder buffer, boolean plainLink) {
        PsiElement[] tagElements = tag.getDataElements();
        String text2 = this.createLinkText(tagElements);
        if (!text2.isEmpty()) {
            int index = JavaDocUtil.extractReference(text2);
            String refText = text2.substring(0, index).trim();
            String label = text2.substring(index).trim();
            if (label.isEmpty()) {
                label = null;
            }
            JavaDocInfoGenerator.generateLink(buffer, refText, label, tagElements[0], plainLink);
        }
    }

    private void generateValueValue(PsiInlineDocTag tag, StringBuilder buffer, PsiElement element) {
        String text2 = this.createLinkText(tag.getDataElements());
        PsiField valueField = null;
        if (text2.isEmpty()) {
            if (this.myElement instanceof PsiField) {
                valueField = (PsiField)this.myElement;
            }
        } else {
            if (text2.indexOf(35) == -1) {
                text2 = "#" + text2;
            }
            PsiElement target = null;
            try {
                target = JavaDocUtil.findReferenceTarget(PsiManager.getInstance((Project)this.myProject), text2, this.myElement);
            }
            catch (IndexNotReadyException e) {
                LOG.debug((Throwable)e);
            }
            if (target instanceof PsiField) {
                valueField = (PsiField)target;
            }
        }
        Object value2 = null;
        if (valueField != null) {
            PsiExpression initializer = valueField.getInitializer();
            value2 = JavaConstantExpressionEvaluator.computeConstantExpression(initializer, false);
        }
        if (value2 != null) {
            String valueText = StringUtil.escapeXml((String)value2.toString());
            if (value2 instanceof String) {
                valueText = '\"' + valueText + '\"';
            }
            if (valueField.equals(this.myElement)) {
                buffer.append(valueText);
            } else {
                JavaDocInfoGenerator.generateLink(buffer, (PsiElement)valueField, valueText, true);
            }
        } else {
            buffer.append(element.getText());
        }
    }

    protected String createLinkText(PsiElement[] tagElements) {
        int predictOffset = tagElements.length > 0 ? tagElements[0].getTextOffset() + tagElements[0].getText().length() : 0;
        StringBuilder buffer = new StringBuilder();
        for (int j = 0; j < tagElements.length; ++j) {
            PsiElement tagElement = tagElements[j];
            if (tagElement.getTextOffset() > predictOffset) {
                buffer.append(" ");
            }
            predictOffset = tagElement.getTextOffset() + tagElement.getText().length();
            this.collectElementText(buffer, tagElement);
            if (j >= tagElements.length - 1) continue;
            buffer.append(" ");
        }
        return buffer.toString().trim();
    }

    protected void collectElementText(final StringBuilder buffer, PsiElement element) {
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (element instanceof PsiWhiteSpace || element instanceof PsiJavaToken || element instanceof PsiDocToken && ((PsiDocToken)element).getTokenType() != JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) {
                    buffer.append(element.getText());
                }
            }
        });
    }

    private void generateDeprecatedSection(StringBuilder buffer, PsiDocComment comment) {
        PsiDocTag tag = comment.findTagByName("deprecated");
        if (tag != null) {
            buffer.append("<DD><DL>");
            buffer.append("<B>").append(CodeInsightBundle.message((String)"javadoc.deprecated", (Object[])new Object[0])).append("</B>&nbsp;");
            buffer.append("<I>");
            this.generateValue(buffer, tag.getDataElements(), ourEmptyElementsProvider);
            buffer.append("</I>");
            buffer.append("</DL></DD>");
        }
    }

    private void generateSinceSection(StringBuilder buffer, PsiDocComment comment) {
        PsiDocTag tag = comment.findTagByName("since");
        if (tag != null) {
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(CodeInsightBundle.message((String)"javadoc.since", (Object[])new Object[0])).append("</b>");
            buffer.append("<DD>");
            this.generateValue(buffer, tag.getDataElements(), ourEmptyElementsProvider);
            buffer.append("</DD></DL></DD>");
        }
    }

    protected void generateSeeAlsoSection(StringBuilder buffer, PsiDocComment comment) {
        PsiDocTag[] tags = comment.findTagsByName("see");
        if (tags.length > 0) {
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(CodeInsightBundle.message((String)"javadoc.see.also", (Object[])new Object[0])).append("</b>");
            buffer.append("<DD>");
            for (int i = 0; i < tags.length; ++i) {
                PsiDocTag tag = tags[i];
                PsiElement[] elements = tag.getDataElements();
                if (elements.length > 0) {
                    String text2 = this.createLinkText(elements);
                    if (text2.startsWith("<")) {
                        buffer.append(text2);
                    } else if (text2.startsWith("\"")) {
                        JavaDocInfoGenerator.appendPlainText(text2, buffer);
                    } else {
                        int index = JavaDocUtil.extractReference(text2);
                        String refText = text2.substring(0, index).trim();
                        String label = text2.substring(index).trim();
                        if (label.isEmpty()) {
                            label = null;
                        }
                        JavaDocInfoGenerator.generateLink(buffer, refText, label, (PsiElement)comment, false);
                    }
                }
                if (i >= tags.length - 1) continue;
                buffer.append(",\n");
            }
            buffer.append("</DD></DL></DD>");
        }
    }

    private void generateParametersSection(StringBuilder buffer, PsiMethod method, PsiDocComment comment) {
        PsiParameter[] params = method.getParameterList().getParameters();
        PsiDocTag[] localTags = comment != null ? comment.findTagsByName("param") : PsiDocTag.EMPTY_ARRAY;
        LinkedList<ParamInfo> collectedTags = new LinkedList<ParamInfo>();
        for (int i = 0; i < params.length; ++i) {
            DocTagLocator<PsiDocTag> tagLocator;
            PsiParameter param = params[i];
            String paramName = param.getName();
            ParamInfo parmTag = this.findDocTag(localTags, paramName, method, tagLocator = JavaDocInfoGenerator.parameterLocator(i));
            if (parmTag == null) continue;
            collectedTags.addLast(parmTag);
        }
        this.generateParametersSection(buffer, CodeInsightBundle.message((String)"javadoc.parameters", (Object[])new Object[0]), collectedTags);
    }

    private void generateTypeParametersSection(StringBuilder buffer, PsiMethod method, PsiDocComment comment) {
        PsiDocTag[] localTags = comment == null ? PsiDocTag.EMPTY_ARRAY : comment.findTagsByName("param");
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        LinkedList<ParamInfo> collectedTags = new LinkedList<ParamInfo>();
        for (int i = 0; i < typeParameters.length; ++i) {
            DocTagLocator<PsiDocTag> tagLocator;
            PsiTypeParameter typeParameter = typeParameters[i];
            String paramName = "<" + typeParameter.getName() + ">";
            ParamInfo parmTag = this.findDocTag(localTags, paramName, method, tagLocator = JavaDocInfoGenerator.typeParameterLocator(i));
            if (parmTag == null) continue;
            collectedTags.addLast(parmTag);
        }
        this.generateParametersSection(buffer, CodeInsightBundle.message((String)"javadoc.type.parameters", (Object[])new Object[0]), collectedTags);
    }

    private void generateParametersSection(StringBuilder buffer, String titleMessage, LinkedList<ParamInfo> collectedTags) {
        if (!collectedTags.isEmpty()) {
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(titleMessage).append("</b>");
            for (ParamInfo tag : collectedTags) {
                this.generateOneParameter(buffer, tag);
            }
            buffer.append("</DD></DL></DD>");
        }
    }

    @Nullable
    private ParamInfo findDocTag(PsiDocTag[] localTags, String paramName, final PsiMethod method, final DocTagLocator<PsiDocTag> tagLocator) {
        PsiDocTag localTag = JavaDocInfoGenerator.getTagByName(localTags, paramName);
        if (localTag != null) {
            return new ParamInfo(paramName, localTag, new InheritDocProvider<PsiDocTag>(){

                @Override
                public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                    return JavaDocInfoGenerator.this.findInheritDocTag(method, tagLocator);
                }

                @Override
                public PsiClass getElement() {
                    return method.getContainingClass();
                }
            });
        }
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> tag = this.findInheritDocTag(method, tagLocator);
        return tag == null ? null : new ParamInfo(paramName, tag);
    }

    private void generateOneParameter(StringBuilder buffer, ParamInfo tag) {
        PsiElement[] elements = tag.docTag.getDataElements();
        if (elements.length == 0) {
            return;
        }
        String text2 = elements[0].getText();
        buffer.append("<DD>");
        int spaceIndex = text2.indexOf(32);
        if (spaceIndex < 0) {
            spaceIndex = text2.length();
        }
        buffer.append("<code>");
        buffer.append(StringUtil.escapeXml((String)tag.name));
        buffer.append("</code>");
        buffer.append(" - ");
        buffer.append(text2.substring(spaceIndex));
        this.generateValue(buffer, elements, 1, JavaDocInfoGenerator.mapProvider(tag.inheritDocTagProvider, true));
    }

    private void generateReturnsSection(StringBuilder buffer, final PsiMethod method, PsiDocComment comment) {
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> pair;
        PsiDocTag tag = comment == null ? null : comment.findTagByName("return");
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> pair2 = pair = tag == null ? null : new Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>((Object)tag, (Object)new InheritDocProvider<PsiDocTag>(){

            @Override
            public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                return JavaDocInfoGenerator.this.findInheritDocTag(method, new ReturnTagLocator());
            }

            @Override
            public PsiClass getElement() {
                return method.getContainingClass();
            }
        });
        if (pair == null && this.myElement instanceof PsiMethod) {
            pair = this.findInheritDocTag((PsiMethod)this.myElement, new ReturnTagLocator());
        }
        if (pair != null) {
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(CodeInsightBundle.message((String)"javadoc.returns", (Object[])new Object[0])).append("</b>");
            buffer.append("<DD>");
            this.generateValue(buffer, ((PsiDocTag)pair.first).getDataElements(), JavaDocInfoGenerator.mapProvider((InheritDocProvider)pair.second, false));
            buffer.append("</DD></DL></DD>");
        }
    }

    private static PsiDocTag[] getThrowsTags(PsiDocComment comment) {
        if (comment == null) {
            return PsiDocTag.EMPTY_ARRAY;
        }
        Object[] tags1 = comment.findTagsByName(THROWS_KEYWORD);
        Object[] tags2 = comment.findTagsByName("exception");
        return (PsiDocTag[])ArrayUtil.mergeArrays((Object[])tags1, (Object[])tags2);
    }

    private static boolean areWeakEqual(String one, String two) {
        return one.equals(two) || one.endsWith("." + two) || two.endsWith("." + one);
    }

    private void generateThrowsSection(StringBuilder buffer, final PsiMethod method, PsiDocComment comment) {
        Object[] localTags;
        Object[] thrownTags = localTags = JavaDocInfoGenerator.getThrowsTags(comment);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)method.getProject());
        HashSet reported = new HashSet();
        for (HierarchicalMethodSignature signature : method.getHierarchicalMethodSignature().getSuperSignatures()) {
            PsiMethod superMethod = (PsiMethod)ObjectUtils.tryCast((Object)signature.getMethod().getNavigationElement(), PsiMethod.class);
            PsiDocComment docComment = superMethod != null ? superMethod.getDocComment() : null;
            if (docComment == null) continue;
            Object[] uncheckedExceptions = (PsiDocTag[])Arrays.stream(JavaDocInfoGenerator.getThrowsTags(docComment)).filter(arg_0 -> JavaDocInfoGenerator.lambda$generateThrowsSection$1((PsiDocTag[])localTags, psiFacade, docComment, reported, arg_0)).toArray(PsiDocTag[]::new);
            thrownTags = (PsiDocTag[])ArrayUtil.mergeArrays((Object[])thrownTags, (Object[])uncheckedExceptions);
        }
        LinkedList<Pair> collectedTags = new LinkedList<Pair>();
        ArrayList<PsiClassType> declaredThrows = new ArrayList<PsiClassType>(Arrays.asList(method.getThrowsList().getReferencedTypes()));
        for (int i = thrownTags.length - 1; i > -1; --i) {
            PsiDocTagValue valueElement = thrownTags[i].getValueElement();
            if (valueElement == null) continue;
            Iterator iterator = declaredThrows.iterator();
            while (iterator.hasNext()) {
                PsiClassType classType = (PsiClassType)iterator.next();
                if (!Comparing.strEqual((String)valueElement.getText(), (String)classType.getClassName()) && !Comparing.strEqual((String)valueElement.getText(), (String)classType.getCanonicalText())) continue;
                iterator.remove();
                break;
            }
            final Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> tag = this.findInheritDocTag(method, JavaDocInfoGenerator.exceptionLocator(valueElement.getText()));
            collectedTags.addFirst(new Pair(thrownTags[i], (Object)new InheritDocProvider<PsiDocTag>(){

                @Override
                public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                    return tag;
                }

                @Override
                public PsiClass getElement() {
                    return method.getContainingClass();
                }
            }));
        }
        for (PsiClassType trouser : declaredThrows) {
            if (trouser == null) continue;
            String paramName = trouser.getCanonicalText();
            Pair parmTag = null;
            for (Object localTag : thrownTags) {
                String tagName;
                PsiDocTagValue value2 = localTag.getValueElement();
                if (value2 == null || (tagName = value2.getText()) == null || !JavaDocInfoGenerator.areWeakEqual(tagName, paramName)) continue;
                parmTag = Pair.create((Object)localTag, ourEmptyProvider);
                break;
            }
            if (parmTag == null) {
                parmTag = this.findInheritDocTag(method, JavaDocInfoGenerator.exceptionLocator(paramName));
            }
            if (parmTag != null) {
                collectedTags.addLast(parmTag);
                continue;
            }
            try {
                PsiDocTag tag = psiFacade.getElementFactory().createDocTagFromText("@exception " + paramName);
                collectedTags.addLast(Pair.create((Object)tag, ourEmptyProvider));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!collectedTags.isEmpty()) {
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(CodeInsightBundle.message((String)"javadoc.throws", (Object[])new Object[0])).append("</b>");
            for (Pair tag : collectedTags) {
                PsiElement[] elements = ((PsiDocTag)tag.first).getDataElements();
                if (elements.length == 0) continue;
                buffer.append("<DD>");
                String text2 = elements[0].getText();
                int index = JavaDocUtil.extractReference(text2);
                String refText = text2.substring(0, index).trim();
                JavaDocInfoGenerator.generateLink(buffer, refText, null, (PsiElement)method, false);
                String rest = text2.substring(index);
                if (!rest.isEmpty() || elements.length > 1) {
                    buffer.append(" - ");
                }
                buffer.append(rest);
                this.generateValue(buffer, elements, 1, JavaDocInfoGenerator.mapProvider((InheritDocProvider)tag.second, true));
            }
            buffer.append("</DD></DL></DD>");
        }
    }

    private static void generateSuperMethodsSection(StringBuilder buffer, PsiMethod method, boolean overrides) {
        PsiClass parentClass = method.getContainingClass();
        if (parentClass == null) {
            return;
        }
        if (parentClass.isInterface() && !overrides) {
            return;
        }
        PsiMethod[] supers = method.findSuperMethods();
        if (supers.length == 0) {
            return;
        }
        boolean headerGenerated = false;
        for (PsiMethod superMethod : supers) {
            PsiClass superClass;
            boolean isAbstract = superMethod.hasModifierProperty("abstract");
            if ((!overrides ? !isAbstract : parentClass.isInterface() != isAbstract) || (superClass = superMethod.getContainingClass()) == null) continue;
            if (!headerGenerated) {
                buffer.append("<DD><DL>");
                buffer.append("<DT><b>");
                buffer.append(CodeInsightBundle.message((String)(overrides ? "javadoc.method.overrides" : "javadoc.method.specified.by"), (Object[])new Object[0]));
                buffer.append("</b>");
                headerGenerated = true;
            }
            buffer.append("<DD>");
            StringBuilder methodBuffer = new StringBuilder();
            JavaDocInfoGenerator.generateLink(methodBuffer, (PsiElement)superMethod, superMethod.getName(), false);
            StringBuilder classBuffer = new StringBuilder();
            JavaDocInfoGenerator.generateLink(classBuffer, (PsiElement)superClass, superClass.getName(), false);
            if (superClass.isInterface()) {
                buffer.append(CodeInsightBundle.message((String)"javadoc.method.in.interface", (Object[])new Object[]{methodBuffer.toString(), classBuffer.toString()}));
                continue;
            }
            buffer.append(CodeInsightBundle.message((String)"javadoc.method.in.class", (Object[])new Object[]{methodBuffer.toString(), classBuffer.toString()}));
        }
        if (headerGenerated) {
            buffer.append("</DD></DL></DD>");
        }
    }

    static void generateLink(StringBuilder buffer, PsiElement element, String label, boolean plainLink) {
        String refText = JavaDocUtil.getReferenceText(element.getProject(), element);
        if (refText != null) {
            DocumentationManagerUtil.createHyperlink((StringBuilder)buffer, (PsiElement)element, (String)refText, (String)label, (boolean)plainLink);
        }
    }

    static int generateLink(StringBuilder buffer, String refText, String label, @NotNull PsiElement context, boolean plainLink) {
        if (context == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(6);
        }
        if (label == null) {
            PsiManager manager = context.getManager();
            label = JavaDocUtil.getLabelText(manager.getProject(), manager, refText, context);
        }
        LOG.assertTrue(refText != null, (Object)"refText appears to be null.");
        PsiElement target = null;
        boolean resolveNotPossible = false;
        try {
            target = JavaDocUtil.findReferenceTarget(context.getManager(), refText, context);
        }
        catch (IndexNotReadyException e) {
            LOG.debug((Throwable)e);
            resolveNotPossible = true;
        }
        if (resolveNotPossible) {
            buffer.append(label);
        } else if (target == null) {
            buffer.append("<font color=red>").append(label).append("</font>");
        } else {
            JavaDocInfoGenerator.generateLink(buffer, target, label, plainLink);
        }
        return StringUtil.stripHtml((String)label, (boolean)true).length();
    }

    public static int generateType(StringBuilder buffer, PsiType type2, PsiElement context) {
        return JavaDocInfoGenerator.generateType(buffer, type2, context, true);
    }

    public static int generateType(StringBuilder buffer, PsiType type2, PsiElement context, boolean generateLink) {
        return JavaDocInfoGenerator.generateType(buffer, type2, context, generateLink, false);
    }

    public static int generateType(StringBuilder buffer, PsiType type2, PsiElement context, boolean generateLink, boolean useShortNames) {
        if (type2 instanceof PsiPrimitiveType) {
            String text2 = StringUtil.escapeXml((String)type2.getCanonicalText());
            buffer.append(text2);
            return text2.length();
        }
        if (type2 instanceof PsiArrayType) {
            int rest = JavaDocInfoGenerator.generateType(buffer, ((PsiArrayType)type2).getComponentType(), context, generateLink, useShortNames);
            if (type2 instanceof PsiEllipsisType) {
                buffer.append("...");
                return rest + 3;
            }
            buffer.append("[]");
            return rest + 2;
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            type2 = ((PsiCapturedWildcardType)type2).getWildcard();
        }
        if (type2 instanceof PsiWildcardType) {
            PsiWildcardType wt = (PsiWildcardType)type2;
            buffer.append("?");
            PsiType bound = wt.getBound();
            if (bound != null) {
                String keyword = wt.isExtends() ? " extends " : " super ";
                buffer.append(keyword);
                return JavaDocInfoGenerator.generateType(buffer, bound, context, generateLink, useShortNames) + 1 + keyword.length();
            }
            return 1;
        }
        if (type2 instanceof PsiClassType) {
            int length;
            String name;
            PsiClassType.ClassResolveResult result;
            try {
                result = ((PsiClassType)type2).resolveGenerics();
            }
            catch (IndexNotReadyException e) {
                LOG.debug((Throwable)e);
                String text3 = ((PsiClassType)type2).getClassName();
                buffer.append(StringUtil.escapeXml((String)text3));
                return text3.length();
            }
            PsiClass psiClass = result.getElement();
            PsiSubstitutor psiSubst = result.getSubstitutor();
            if (psiClass == null) {
                String canonicalText = type2.getCanonicalText();
                String text4 = "<font color=red>" + StringUtil.escapeXml((String)canonicalText) + "</font>";
                buffer.append(text4);
                return canonicalText.length();
            }
            String qName = psiClass.getQualifiedName();
            if (qName == null || psiClass instanceof PsiTypeParameter) {
                String text5 = StringUtil.escapeXml((String)(useShortNames ? type2.getPresentableText() : type2.getCanonicalText()));
                buffer.append(text5);
                return text5.length();
            }
            String string = name = useShortNames ? JavaDocInfoGenerator.getClassNameWithOuterClasses(psiClass) : qName;
            if (generateLink) {
                length = JavaDocInfoGenerator.generateLink(buffer, name, null, context, false);
            } else {
                buffer.append(name);
                length = buffer.length();
            }
            if (psiClass.hasTypeParameters()) {
                StringBuilder subst = new StringBuilder();
                PsiTypeParameter[] params = psiClass.getTypeParameters();
                subst.append(LT);
                ++length;
                boolean goodSubst = true;
                for (int i = 0; i < params.length; ++i) {
                    PsiType t = psiSubst.substitute(params[i]);
                    if (t == null) {
                        goodSubst = false;
                        break;
                    }
                    length += JavaDocInfoGenerator.generateType(subst, t, context, generateLink, useShortNames);
                    if (i >= params.length - 1) continue;
                    subst.append(", ");
                }
                subst.append(GT);
                ++length;
                if (goodSubst) {
                    String text6 = subst.toString();
                    buffer.append(text6);
                }
            }
            return length;
        }
        if (type2 instanceof PsiDisjunctionType || type2 instanceof PsiIntersectionType) {
            if (!generateLink) {
                String canonicalText = useShortNames ? type2.getPresentableText() : type2.getCanonicalText();
                String text7 = StringUtil.escapeXml((String)canonicalText);
                buffer.append(text7);
                return canonicalText.length();
            }
            String separator = type2 instanceof PsiDisjunctionType ? " | " : " & ";
            List<PsiType> componentTypes = type2 instanceof PsiIntersectionType ? Arrays.asList(((PsiIntersectionType)type2).getConjuncts()) : ((PsiDisjunctionType)type2).getDisjunctions();
            int length = 0;
            for (PsiType psiType : componentTypes) {
                if (length > 0) {
                    buffer.append(separator);
                    length += 3;
                }
                length += JavaDocInfoGenerator.generateType(buffer, psiType, context, true, useShortNames);
            }
            return length;
        }
        return 0;
    }

    private static String getClassNameWithOuterClasses(@NotNull PsiClass cls) {
        String name;
        if (cls == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(7);
        }
        StringBuilder result = new StringBuilder();
        while (cls != null && (name = cls.getName()) != null) {
            if (result.length() > 0) {
                result.insert(0, '.');
            }
            result.insert(0, name);
            cls = cls.getContainingClass();
        }
        return result.toString();
    }

    public static String generateTypeParameters(PsiTypeParameterListOwner owner, boolean useShortNames) {
        if (owner.hasTypeParameters()) {
            PsiTypeParameter[] parameters2 = owner.getTypeParameters();
            StringBuilder buffer = new StringBuilder();
            buffer.append(LT);
            for (int i = 0; i < parameters2.length; ++i) {
                PsiTypeParameter p = parameters2[i];
                buffer.append(p.getName());
                PsiClassType[] refs = JavaDocUtil.getExtendsList((PsiClass)p);
                if (refs.length > 0) {
                    buffer.append(" extends ");
                    for (int j = 0; j < refs.length; ++j) {
                        JavaDocInfoGenerator.generateType(buffer, (PsiType)refs[j], (PsiElement)owner, true, useShortNames);
                        if (j >= refs.length - 1) continue;
                        buffer.append(" & ");
                    }
                }
                if (i >= parameters2.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(GT);
            return buffer.toString();
        }
        return "";
    }

    private <T> Pair<T, InheritDocProvider<T>> searchDocTagInOverriddenMethod(PsiMethod method, final PsiClass aSuper, final DocTagLocator<T> loc) {
        T tag;
        PsiMethod overridden;
        if (aSuper != null && (overridden = JavaDocInfoGenerator.findMethodInSuperClass(method, aSuper)) != null && (tag = loc.find((PsiDocCommentOwner)overridden, JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)overridden))) != null) {
            return new Pair(tag, (Object)new InheritDocProvider<T>(){

                @Override
                public Pair<T, InheritDocProvider<T>> getInheritDoc() {
                    return JavaDocInfoGenerator.this.findInheritDocTag(overridden, loc);
                }

                @Override
                public PsiClass getElement() {
                    return aSuper;
                }
            });
        }
        return null;
    }

    @Nullable
    private static PsiMethod findMethodInSuperClass(PsiMethod method, PsiClass aSuper) {
        for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
            PsiMethod overridden = aSuper.findMethodBySignature(superMethod, false);
            if (overridden == null) continue;
            return overridden;
        }
        return null;
    }

    @Nullable
    private <T> Pair<T, InheritDocProvider<T>> searchDocTagInSupers(PsiClassType[] supers, PsiMethod method, DocTagLocator<T> loc, Set<PsiClass> visitedClasses) {
        try {
            Pair<T, InheritDocProvider<T>> tag;
            PsiClass aSuper;
            for (PsiClassType superType : supers) {
                aSuper = superType.resolve();
                if (aSuper == null || (tag = this.searchDocTagInOverriddenMethod(method, aSuper, loc)) == null) continue;
                return tag;
            }
            for (PsiClassType superType : supers) {
                aSuper = superType.resolve();
                if (aSuper == null || !visitedClasses.add(aSuper) || (tag = this.findInheritDocTagInClass(method, aSuper, loc, visitedClasses)) == null) continue;
                return tag;
            }
        }
        catch (IndexNotReadyException e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    private <T> Pair<T, InheritDocProvider<T>> findInheritDocTagInClass(PsiMethod aMethod, PsiClass aClass, DocTagLocator<T> loc, Set<PsiClass> visitedClasses) {
        if (aClass == null) {
            return null;
        }
        Pair<T, InheritDocProvider<T>> delegate = this.findInheritDocTagInDelegate(aMethod, loc);
        if (delegate != null) {
            return delegate;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return this.searchDocTagInSupers(new PsiClassType[]{((PsiAnonymousClass)aClass).getBaseClassType()}, aMethod, loc, visitedClasses);
        }
        PsiClassType[] implementsTypes = aClass.getImplementsListTypes();
        Pair<T, InheritDocProvider<T>> tag = this.searchDocTagInSupers(implementsTypes, aMethod, loc, visitedClasses);
        if (tag != null) {
            return tag;
        }
        PsiClassType[] extendsTypes = aClass.getExtendsListTypes();
        return this.searchDocTagInSupers(extendsTypes, aMethod, loc, visitedClasses);
    }

    @Nullable
    private <T> Pair<T, InheritDocProvider<T>> findInheritDocTagInDelegate(PsiMethod method, final DocTagLocator<T> loc) {
        final PsiMethod delegateMethod = JavaDocInfoGenerator.findDelegateMethod(method);
        if (delegateMethod == null) {
            return null;
        }
        final PsiClass containingClass = delegateMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        T tag = loc.find((PsiDocCommentOwner)delegateMethod, JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)delegateMethod));
        if (tag == null) {
            return null;
        }
        return Pair.create(tag, (Object)new InheritDocProvider<T>(){

            @Override
            public Pair<T, InheritDocProvider<T>> getInheritDoc() {
                return JavaDocInfoGenerator.this.findInheritDocTag(delegateMethod, loc);
            }

            @Override
            public PsiClass getElement() {
                return containingClass;
            }
        });
    }

    @Nullable
    private static PsiMethod findDelegateMethod(@NotNull PsiMethod method) {
        PsiDocCommentOwner delegate;
        if (method == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(8);
        }
        return (delegate = DocumentationDelegateProvider.findDocumentationDelegate((PsiMember)method)) instanceof PsiMethod ? (PsiMethod)delegate : null;
    }

    @Nullable
    private <T> Pair<T, InheritDocProvider<T>> findInheritDocTag(PsiMethod method, DocTagLocator<T> loc) {
        PsiClass aClass = method.getContainingClass();
        return aClass != null ? this.findInheritDocTagInClass(method, aClass, loc, new HashSet<PsiClass>()) : null;
    }

    private static /* synthetic */ boolean lambda$generateThrowsSection$1(PsiDocTag[] localTags, JavaPsiFacade psiFacade, PsiDocComment docComment, Set reported, PsiDocTag tag) {
        PsiDocTagValue valueElement = tag.getValueElement();
        if (valueElement == null) {
            return false;
        }
        if (Arrays.stream(localTags).map(PsiDocTag::getValueElement).filter(Objects::nonNull).anyMatch(docTagValue -> JavaDocInfoGenerator.areWeakEqual(docTagValue.getText(), valueElement.getText()))) {
            return false;
        }
        PsiClass exClass = psiFacade.getResolveHelper().resolveReferencedClass(valueElement.getText(), (PsiElement)docComment);
        if (exClass == null) {
            return false;
        }
        return ExceptionUtil.isUncheckedException(exClass) && reported.add(exClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeLink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/javadoc/JavaDocInfoGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParamTagByName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagByName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferenceForRelativeLink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findRelevantCommentNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocumentedAnnotationType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "generateLink";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassNameWithOuterClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findDelegateMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum SignaturePlace {
        Javadoc,
        ToolTip;

    }

    private static class MyVisitor
    extends JavaElementVisitor {
        private final StringBuilder myBuffer;

        MyVisitor(@NotNull StringBuilder buffer) {
            if (buffer == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myBuffer = buffer;
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            PsiExpression[] dimensions;
            this.myBuffer.append("new ");
            PsiType type2 = expression2.getType();
            if (type2 != null) {
                JavaDocInfoGenerator.generateType(this.myBuffer, type2, (PsiElement)expression2);
            }
            if ((dimensions = expression2.getArrayDimensions()).length > 0) {
                LOG.assertTrue(this.myBuffer.charAt(this.myBuffer.length() - 1) == ']');
                this.myBuffer.setLength(this.myBuffer.length() - 1);
                for (PsiExpression dimension : dimensions) {
                    dimension.accept((PsiElementVisitor)this);
                    this.myBuffer.append(", ");
                }
                this.myBuffer.setLength(this.myBuffer.length() - 2);
                this.myBuffer.append(']');
            } else {
                expression2.acceptChildren((PsiElementVisitor)this);
            }
        }

        public void visitExpressionList(PsiExpressionList list) {
            PsiExpression[] expressions2;
            this.myBuffer.append("(");
            String separator = ", ";
            for (PsiExpression expression2 : expressions2 = list.getExpressions()) {
                expression2.accept((PsiElementVisitor)this);
                this.myBuffer.append(separator);
            }
            if (expressions2.length > 0) {
                this.myBuffer.setLength(this.myBuffer.length() - separator.length());
            }
            this.myBuffer.append(")");
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            this.myBuffer.append(StringUtil.escapeXml((String)expression2.getMethodExpression().getText()));
            expression2.getArgumentList().accept((PsiElementVisitor)this);
        }

        public void visitExpression(PsiExpression expression2) {
            this.myBuffer.append(StringUtil.escapeXml((String)expression2.getText()));
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.myBuffer.append(StringUtil.escapeXml((String)expression2.getText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/codeInsight/javadoc/JavaDocInfoGenerator$MyVisitor", "<init>"));
        }
    }

    private static class ReturnTagLocator
    implements DocTagLocator<PsiDocTag> {
        private ReturnTagLocator() {
        }

        @Override
        public PsiDocTag find(PsiDocCommentOwner owner, PsiDocComment comment) {
            return comment != null ? comment.findTagByName("return") : null;
        }
    }

    private static class ParamInfo {
        private final String name;
        private final PsiDocTag docTag;
        private final InheritDocProvider<PsiDocTag> inheritDocTagProvider;

        private ParamInfo(String paramName, PsiDocTag tag, InheritDocProvider<PsiDocTag> provider) {
            this.name = paramName;
            this.docTag = tag;
            this.inheritDocTagProvider = provider;
        }

        private ParamInfo(String paramName, @NotNull Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> tagWithInheritProvider) {
            if (tagWithInheritProvider == null) {
                ParamInfo.$$$reportNull$$$0(0);
            }
            this(paramName, (PsiDocTag)tagWithInheritProvider.first, (InheritDocProvider)tagWithInheritProvider.second);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagWithInheritProvider", "com/intellij/codeInsight/javadoc/JavaDocInfoGenerator$ParamInfo", "<init>"));
        }
    }

    private static interface DocTagLocator<T> {
        public T find(PsiDocCommentOwner var1, PsiDocComment var2);
    }

    private static interface InheritDocProvider<T> {
        public Pair<T, InheritDocProvider<T>> getInheritDoc();

        public PsiClass getElement();
    }
}

