/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.AddOnDemandStaticImportAction;
import com.intellij.codeInsight.intention.impl.AddSingleMemberStaticImportAction;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.JavaCommentContextType;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ShortenToStaticImportProcessor
implements TemplateOptionalProcessor,
DumbAware {
    private static final List<StaticImporter> IMPORTERS = Arrays.asList(new SingleMemberStaticImporter(), new OnDemandStaticImporter());

    public void processText(Project project, Template template, Document document, RangeMarker templateRange, Editor editor) {
        if (!template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file == null) {
            return;
        }
        DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> ShortenToStaticImportProcessor.doStaticImport(project, editor, file, ShortenToStaticImportProcessor.getStaticImportTargets(templateRange, file)));
    }

    @NotNull
    private static List<Pair<PsiElement, StaticImporter>> getStaticImportTargets(RangeMarker templateRange, PsiFile file) {
        ArrayList<Pair<PsiElement, StaticImporter>> staticImportTargets = new ArrayList<Pair<PsiElement, StaticImporter>>();
        PsiElement element = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)templateRange.getStartOffset());
        while (element != null && element.getTextRange().getStartOffset() < templateRange.getEndOffset()) {
            for (StaticImporter importer : IMPORTERS) {
                if (!importer.canPerform(element)) continue;
                staticImportTargets.add((Pair<PsiElement, StaticImporter>)Pair.create((Object)element, (Object)importer));
                break;
            }
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        ArrayList<Pair<PsiElement, StaticImporter>> arrayList = staticImportTargets;
        if (arrayList == null) {
            ShortenToStaticImportProcessor.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static void doStaticImport(Project project, Editor editor, PsiFile file, List<Pair<PsiElement, StaticImporter>> staticImportTargets) {
        Collections.reverse(staticImportTargets);
        for (Pair<PsiElement, StaticImporter> pair : staticImportTargets) {
            if (!((PsiElement)pair.first).isValid()) continue;
            ((StaticImporter)pair.second).perform(project, file, editor, (PsiElement)pair.first);
        }
    }

    @Nls
    public String getOptionName() {
        return CodeInsightBundle.message((String)"dialog.edit.template.checkbox.use.static.import", (Object[])new Object[0]);
    }

    public boolean isEnabled(Template template) {
        return template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE);
    }

    public void setEnabled(Template template, boolean value2) {
        template.setValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE, value2);
    }

    public boolean isVisible(@NotNull Template template, @NotNull TemplateContext context) {
        if (template == null) {
            ShortenToStaticImportProcessor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ShortenToStaticImportProcessor.$$$reportNull$$$0(2);
        }
        for (TemplateContextType contextType : (TemplateContextType[])TemplateContextType.EP_NAME.getExtensions()) {
            if (!context.isEnabled(contextType) || !(contextType instanceof JavaCodeContextType) && !(contextType instanceof JavaCommentContextType)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/ShortenToStaticImportProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticImportTargets";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/ShortenToStaticImportProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OnDemandStaticImporter
    implements StaticImporter {
        private OnDemandStaticImporter() {
        }

        @Override
        public boolean canPerform(@NotNull PsiElement element) {
            if (element == null) {
                OnDemandStaticImporter.$$$reportNull$$$0(0);
            }
            return AddOnDemandStaticImportAction.getClassToPerformStaticImport(element) != null;
        }

        @Override
        public void perform(Project project, PsiFile file, Editor editor, PsiElement element) {
            AddOnDemandStaticImportAction.invoke(project, file, editor, element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/impl/ShortenToStaticImportProcessor$OnDemandStaticImporter", "canPerform"));
        }
    }

    private static class SingleMemberStaticImporter
    implements StaticImporter {
        private SingleMemberStaticImporter() {
        }

        @Override
        public boolean canPerform(@NotNull PsiElement element) {
            if (element == null) {
                SingleMemberStaticImporter.$$$reportNull$$$0(0);
            }
            return AddSingleMemberStaticImportAction.getStaticImportClass(element) != null;
        }

        @Override
        public void perform(Project project, PsiFile file, Editor editor, PsiElement element) {
            AddSingleMemberStaticImportAction.invoke(file, element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/impl/ShortenToStaticImportProcessor$SingleMemberStaticImporter", "canPerform"));
        }
    }

    private static interface StaticImporter {
        public boolean canPerform(@NotNull PsiElement var1);

        public void perform(Project var1, PsiFile var2, Editor var3, PsiElement var4);
    }
}

