/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObviousNullCheckInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher REQUIRE_NON_NULL_METHOD = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "requireNonNull"), CallMatcher.staticCall("com.google.common.base.Preconditions", "checkNotNull"));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ObviousNullCheckInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                NullCheckParameter nullCheckParameter = NullCheckParameter.fromCall(call);
                if (nullCheckParameter == null) {
                    return;
                }
                if (!(call.getParent() instanceof PsiExpressionStatement) && !REQUIRE_NON_NULL_METHOD.test(call)) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length <= nullCheckParameter.myIndex) {
                    return;
                }
                PsiExpression nullArg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[nullCheckParameter.myIndex]);
                String explanation = ObviousNullCheckInspection.getObviouslyNonNullExplanation(nullArg);
                if (explanation == null) {
                    return;
                }
                if (nullCheckParameter.myNull) {
                    holder.registerProblem((PsiElement)nullArg, InspectionsBundle.message((String)"inspection.useless.null.check.always.fail.message", (Object[])new Object[]{explanation}), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)nullArg, InspectionsBundle.message((String)"inspection.useless.null.check.message", (Object[])new Object[]{explanation}), new LocalQuickFix[]{new RemoveNullCheckFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            ObviousNullCheckInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @Nullable
    private static String getObviouslyNonNullExplanation(PsiExpression arg) {
        if (arg == null || ExpressionUtils.isNullLiteral(arg)) {
            return null;
        }
        if (arg instanceof PsiNewExpression) {
            return "newly created object";
        }
        if (arg instanceof PsiLiteralExpression) {
            return "literal";
        }
        if (arg.getType() instanceof PsiPrimitiveType) {
            return "a value of primitive type";
        }
        if (arg instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)arg).getOperationTokenType() == JavaTokenType.PLUS) {
            return "concatenation";
        }
        if (arg instanceof PsiThisExpression) {
            return "this object";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ObviousNullCheckInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ObviousNullCheckInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RemoveNullCheckFix
    implements LocalQuickFix {
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.useless.null.check.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveNullCheckFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement startElement;
            PsiMethodCallExpression call;
            if (project == null) {
                RemoveNullCheckFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveNullCheckFix.$$$reportNull$$$0(2);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)(startElement = descriptor.getStartElement()), PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiElement parent = call.getParent();
            CommentTracker ct = new CommentTracker();
            if (parent instanceof PsiExpressionStatement) {
                List expressions2 = ((StreamEx)StreamEx.of((Object[])call.getArgumentList().getExpressions()).flatCollection(SideEffectChecker::extractSideEffectExpressions).peek(ct::markUnchanged)).toList();
                PsiStatement[] sideEffectStatements = StatementExtractor.generateStatements(expressions2, (PsiExpression)call);
                if (sideEffectStatements.length > 0) {
                    BlockUtils.addBefore((PsiStatement)parent, sideEffectStatements);
                }
                ct.deleteAndRestoreComments(parent);
            } else {
                ct.replaceAndRestoreComments((PsiElement)call, ct.markUnchanged(startElement));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ObviousNullCheckInspection$RemoveNullCheckFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ObviousNullCheckInspection$RemoveNullCheckFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class NullCheckParameter {
        int myIndex;
        boolean myNull;

        public NullCheckParameter(int index, boolean aNull) {
            this.myIndex = index;
            this.myNull = aNull;
        }

        @Nullable
        static NullCheckParameter fromCall(PsiMethodCallExpression call) {
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return null;
            }
            if (!ControlFlowAnalyzer.isPure(method)) {
                return null;
            }
            List<? extends MethodContract> contracts2 = ControlFlowAnalyzer.getMethodCallContracts(method, call);
            if (contracts2.size() != 1) {
                return null;
            }
            StandardMethodContract contract = (StandardMethodContract)ObjectUtils.tryCast((Object)contracts2.get(0), StandardMethodContract.class);
            if (contract == null || contract.getReturnValue() != MethodContract.ValueConstraint.THROW_EXCEPTION) {
                return null;
            }
            MethodContract.ValueConstraint[] arguments = contract.arguments;
            Integer nullIndex = null;
            boolean isNull = false;
            for (int i = 0; i < arguments.length; ++i) {
                MethodContract.ValueConstraint argument = arguments[i];
                if (argument == MethodContract.ValueConstraint.NULL_VALUE || argument == MethodContract.ValueConstraint.NOT_NULL_VALUE) {
                    if (nullIndex != null) {
                        return null;
                    }
                    nullIndex = i;
                    isNull = argument == MethodContract.ValueConstraint.NOT_NULL_VALUE;
                    continue;
                }
                if (argument == MethodContract.ValueConstraint.ANY_VALUE) continue;
                return null;
            }
            return nullIndex == null ? null : new NullCheckParameter(nullIndex, isNull);
        }
    }
}

