/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamFilterNotNullFix
implements LocalQuickFix,
HighPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.data.flow.filter.notnull.quickfix", (Object[])new Object[0]);
        if (string == null) {
            StreamFilterNotNullFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiFunctionalExpression function;
        if (project == null) {
            StreamFilterNotNullFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            StreamFilterNotNullFix.$$$reportNull$$$0(2);
        }
        if ((function = StreamFilterNotNullFix.findFunction(descriptor.getStartElement())) == null) {
            return;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)function, PsiMethodCallExpression.class);
        if (call == null) {
            return;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return;
        }
        String name = StreamFilterNotNullFix.suggestVariableName(function, qualifier);
        PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(qualifier.getText() + ".filter(" + name + "->" + name + "!=null)", (PsiElement)qualifier);
        PsiMethodCallExpression result = (PsiMethodCallExpression)qualifier.replace((PsiElement)replacement);
        LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result.getArgumentList());
    }

    @NotNull
    private static String suggestVariableName(@NotNull PsiFunctionalExpression function, @NotNull PsiExpression qualifier) {
        PsiParameter parameter2;
        if (function == null) {
            StreamFilterNotNullFix.$$$reportNull$$$0(3);
        }
        if (qualifier == null) {
            StreamFilterNotNullFix.$$$reportNull$$$0(4);
        }
        String name = null;
        if (function instanceof PsiLambdaExpression && (parameter2 = (PsiParameter)ArrayUtil.getFirstElement((Object[])((PsiLambdaExpression)function).getParameterList().getParameters())) != null) {
            name = parameter2.getName();
        }
        PsiType type2 = StreamApiUtil.getStreamElementType(qualifier.getType());
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)function.getProject());
        SuggestedNameInfo info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, name, null, type2, true);
        name = (String)ArrayUtil.getFirstElement((Object[])info.names);
        String string = javaCodeStyleManager.suggestUniqueVariableName(name == null ? "obj" : name, (PsiElement)qualifier, false);
        if (string == null) {
            StreamFilterNotNullFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static PsiFunctionalExpression findFunction(PsiElement reference) {
        if (reference instanceof PsiFunctionalExpression) {
            return (PsiFunctionalExpression)reference;
        }
        if (reference instanceof PsiIdentifier && (reference = reference.getParent()) instanceof PsiReferenceExpression) {
            reference = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiReferenceExpression)reference).getQualifierExpression());
        }
        if (reference instanceof PsiReferenceExpression) {
            PsiParameter parameter2 = (PsiParameter)ObjectUtils.tryCast((Object)((PsiReferenceExpression)reference).resolve(), PsiParameter.class);
            if (parameter2 == null) {
                return null;
            }
            PsiParameterList parameterList = (PsiParameterList)ObjectUtils.tryCast((Object)parameter2.getParent(), PsiParameterList.class);
            if (parameterList == null || parameterList.getParametersCount() != 1) {
                return null;
            }
            return (PsiFunctionalExpression)ObjectUtils.tryCast((Object)parameterList.getParent(), PsiLambdaExpression.class);
        }
        return null;
    }

    public static StreamFilterNotNullFix makeFix(PsiElement reference) {
        PsiFunctionalExpression fn = StreamFilterNotNullFix.findFunction(reference);
        if (fn == null) {
            return null;
        }
        PsiExpressionList args = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)fn.getParent()), PsiExpressionList.class);
        if (args == null || args.getExpressions().length != 1) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)args.getParent(), PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null || !InheritanceUtil.isInheritor((PsiType)qualifier.getType(), (String)"java.util.stream.Stream")) {
            return null;
        }
        return new StreamFilterNotNullFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/StreamFilterNotNullFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/StreamFilterNotNullFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVariableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

