/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.ExceptionTransfer;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.InstructionTransfer;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.LiveVariablesAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.ReturnTransfer;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.TransferTarget;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.inliner.CollectionFactoryInliner;
import com.intellij.codeInspection.dataFlow.inliner.LambdaInliner;
import com.intellij.codeInspection.dataFlow.inliner.MapUpdateInliner;
import com.intellij.codeInspection.dataFlow.inliner.OptionalChainInliner;
import com.intellij.codeInspection.dataFlow.inliner.StreamChainInliner;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DereferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DupInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyStackInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SpliceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SwapInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.siyeh.ig.numeric.UnnecessaryExplicitNumericCastInspection;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer");
    public static final String ORG_JETBRAINS_ANNOTATIONS_CONTRACT = Contract.class.getName();
    private final PsiElement myCodeFragment;
    private final boolean myIgnoreAssertions;
    private final boolean myInlining;
    private final Project myProject;
    private final DfaValueFactory myFactory;
    private ControlFlow myCurrentFlow;
    private FList<Trap> myTrapStack;
    private final ExceptionTransfer myRuntimeException;
    private final ExceptionTransfer myError;
    private final PsiType myAssertionError;
    private InlinedBlockContext myInlinedBlockContext;
    private final boolean myThisReadOnly;
    static final CallInliner[] INLINERS = new CallInliner[]{new OptionalChainInliner(), new LambdaInliner(), new CollectionFactoryInliner(), new StreamChainInliner(), new MapUpdateInliner()};

    ControlFlowAnalyzer(DfaValueFactory valueFactory, @NotNull PsiElement codeFragment, boolean ignoreAssertions, boolean inlining) {
        if (codeFragment == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(0);
        }
        this.myTrapStack = FList.emptyList();
        this.myInlining = inlining;
        this.myFactory = valueFactory;
        this.myCodeFragment = codeFragment;
        this.myProject = codeFragment.getProject();
        this.myIgnoreAssertions = ignoreAssertions;
        GlobalSearchScope scope = codeFragment.getResolveScope();
        this.myRuntimeException = new ExceptionTransfer(this.myFactory.createDfaType((PsiType)this.createClassType(scope, "java.lang.RuntimeException")));
        this.myError = new ExceptionTransfer(this.myFactory.createDfaType((PsiType)this.createClassType(scope, "java.lang.Error")));
        this.myAssertionError = this.createClassType(scope, "java.lang.AssertionError");
        PsiElement member = PsiTreeUtil.getParentOfType((PsiElement)codeFragment, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
        this.myThisReadOnly = member instanceof PsiMethod && MutationSignature.fromMethod((PsiMethod)member).preservesThis();
    }

    private void buildClassInitializerFlow(PsiClass psiClass, boolean isStatic) {
        this.pushUnknown();
        ConditionalGotoInstruction conditionalGoto = new ConditionalGotoInstruction(null, false, null);
        this.addInstruction(conditionalGoto);
        for (PsiElement element : psiClass.getChildren()) {
            if (!(element instanceof PsiField) && !(element instanceof PsiClassInitializer) || ((PsiModifierListOwner)element).hasModifierProperty("static") != isStatic) continue;
            element.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new FlushVariableInstruction(null));
        conditionalGoto.setOffset(this.getInstructionCount());
    }

    @Nullable
    public ControlFlow buildControlFlow() {
        this.myCurrentFlow = new ControlFlow(this.myFactory);
        try {
            if (this.myCodeFragment instanceof PsiClass) {
                this.buildClassInitializerFlow((PsiClass)this.myCodeFragment, true);
                this.buildClassInitializerFlow((PsiClass)this.myCodeFragment, false);
            } else {
                this.myCodeFragment.accept((PsiElementVisitor)this);
            }
        }
        catch (CannotAnalyzeException e) {
            return null;
        }
        PsiElement parent = this.myCodeFragment.getParent();
        if (parent instanceof PsiLambdaExpression && this.myCodeFragment instanceof PsiExpression) {
            this.generateBoxingUnboxingInstructionFor((PsiExpression)this.myCodeFragment, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)parent)));
            this.addInstruction(new CheckReturnValueInstruction((PsiExpression)this.myCodeFragment));
        }
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, (FList<Trap>)FList.emptyList()), null));
        if (Registry.is((String)"idea.dfa.live.variables.analysis")) {
            new LiveVariablesAnalyzer(this.myCurrentFlow, this.myFactory).flushDeadVariablesOnStatementFinish();
        }
        return this.myCurrentFlow;
    }

    DfaValueFactory getFactory() {
        return this.myFactory;
    }

    PsiElement getContext() {
        return this.myCodeFragment;
    }

    private PsiClassType createClassType(GlobalSearchScope scope, String fqn) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(fqn, scope);
        if (aClass != null) {
            return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass);
        }
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(fqn, scope);
    }

    <T extends Instruction> T addInstruction(T i) {
        this.myCurrentFlow.addInstruction(i);
        return i;
    }

    int getInstructionCount() {
        return this.myCurrentFlow.getInstructionCount();
    }

    private ControlFlow.ControlFlowOffset getEndOffset(PsiElement element) {
        return this.myCurrentFlow.getEndOffset(element);
    }

    private ControlFlow.ControlFlowOffset getStartOffset(PsiElement element) {
        return this.myCurrentFlow.getStartOffset(element);
    }

    private void startElement(PsiElement element) {
        this.myCurrentFlow.startElement(element);
    }

    private void finishElement(PsiElement element) {
        this.myCurrentFlow.finishElement(element);
        if (element instanceof PsiStatement && !(element instanceof PsiReturnStatement)) {
            this.addInstruction(new FinishElementInstruction(element));
        }
    }

    public void visitErrorElement(PsiErrorElement element) {
        throw new CannotAnalyzeException();
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        PsiExpression lExpr = expression2.getLExpression();
        PsiExpression rExpr = expression2.getRExpression();
        this.startElement((PsiElement)expression2);
        if (rExpr == null) {
            this.pushUnknown();
            this.finishElement((PsiElement)expression2);
            return;
        }
        IElementType op = expression2.getOperationTokenType();
        PsiType type2 = expression2.getType();
        boolean isBoolean = PsiType.BOOLEAN.equals((Object)type2);
        if (op == JavaTokenType.EQ) {
            lExpr.accept((PsiElementVisitor)this);
            rExpr.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(rExpr, type2);
        } else if (op == JavaTokenType.ANDEQ && isBoolean) {
            this.generateBooleanAssignmentExpression(true, lExpr, rExpr, type2);
        } else if (op == JavaTokenType.OREQ && isBoolean) {
            this.generateBooleanAssignmentExpression(false, lExpr, rExpr, type2);
        } else if (op == JavaTokenType.XOREQ && isBoolean) {
            this.generateXorExpression((PsiExpression)expression2, new PsiExpression[]{lExpr, rExpr}, type2, true);
        } else if (op == JavaTokenType.PLUSEQ && type2 != null && type2.equalsToText("java.lang.String")) {
            lExpr.accept((PsiElementVisitor)this);
            this.addInstruction(new DupInstruction());
            rExpr.accept((PsiElementVisitor)this);
            this.addInstruction(new BinopInstruction(JavaTokenType.PLUS, null, this.myProject));
        } else if (ControlFlowAnalyzer.isAssignmentDivision(op) && type2 != null && PsiType.LONG.isAssignableFrom(type2)) {
            lExpr.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(lExpr, type2);
            rExpr.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(rExpr, type2);
            this.checkZeroDivisor();
            this.addInstruction(new PopInstruction());
            this.pushUnknown();
        } else {
            this.generateDefaultAssignmentBinOp(lExpr, rExpr, type2);
        }
        this.addInstruction(new AssignInstruction(rExpr, this.myFactory.createValue(lExpr)));
        this.finishElement((PsiElement)expression2);
    }

    private void generateDefaultAssignmentBinOp(PsiExpression lExpr, PsiExpression rExpr, PsiType exprType) {
        lExpr.accept((PsiElementVisitor)this);
        this.addInstruction(new DupInstruction());
        this.generateBoxingUnboxingInstructionFor(lExpr, exprType);
        rExpr.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpr, exprType);
        this.addInstruction(new BinopInstruction(null, null, this.myProject));
    }

    public void visitAssertStatement(PsiAssertStatement statement) {
        if (this.myIgnoreAssertions) {
            return;
        }
        this.startElement((PsiElement)statement);
        PsiExpression condition2 = statement.getAssertCondition();
        PsiExpression description = statement.getAssertDescription();
        if (condition2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), false, (PsiElement)condition2));
            if (description != null) {
                description.accept((PsiElementVisitor)this);
            }
            this.throwException(this.myAssertionError, (PsiElement)statement);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        PsiElement[] elements;
        this.startElement((PsiElement)statement);
        for (PsiElement element : elements = statement.getDeclaredElements()) {
            PsiVariable variable;
            PsiExpression initializer;
            if (element instanceof PsiClass) {
                this.addInstruction(new EmptyInstruction(element));
                continue;
            }
            if (!(element instanceof PsiVariable) || (initializer = (variable = (PsiVariable)element).getInitializer()) == null) continue;
            this.initializeVariable(variable, initializer);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitField(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            this.initializeVariable((PsiVariable)field, initializer);
        } else if (!field.hasModifierProperty("final")) {
            DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue((PsiVariable)field, false);
            this.addInstruction(new PushInstruction(dfaVariable, null, true));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().createFromValue(PsiTypesUtil.getDefaultValue((PsiType)field.getType()), field.getType(), null), null));
            this.addInstruction(new AssignInstruction(null, dfaVariable));
            this.addInstruction(new PopInstruction());
        }
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        this.visitCodeBlock(initializer.getBody());
    }

    private void initializeVariable(PsiVariable variable, PsiExpression initializer) {
        if (DfaUtil.ignoreInitializer(variable)) {
            return;
        }
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue(variable, false);
        this.addInstruction(new PushInstruction(dfaVariable, initializer, true));
        initializer.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(initializer, variable.getType());
        this.addInstruction(new AssignInstruction(initializer, dfaVariable));
        this.addInstruction(new PopInstruction());
    }

    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiExpression expression2;
        this.startElement((PsiElement)codeFragment);
        if (codeFragment instanceof PsiExpressionCodeFragment && (expression2 = ((PsiExpressionCodeFragment)codeFragment).getExpression()) != null) {
            expression2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)codeFragment);
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        this.startElement((PsiElement)block);
        for (PsiStatement statement : block.getStatements()) {
            statement.accept((PsiElementVisitor)this);
        }
        this.flushCodeBlockVariables(block);
        this.finishElement((PsiElement)block);
    }

    private void flushCodeBlockVariables(PsiCodeBlock block) {
        block6: {
            PsiResourceList list;
            PsiElement parent;
            block8: {
                block7: {
                    block5: {
                        for (PsiStatement statement : block.getStatements()) {
                            if (!(statement instanceof PsiDeclarationStatement)) continue;
                            for (PsiElement declaration2 : ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                                if (!(declaration2 instanceof PsiVariable)) continue;
                                this.myCurrentFlow.removeVariable((PsiVariable)declaration2);
                            }
                        }
                        parent = block.getParent();
                        if (!(parent instanceof PsiCatchSection)) break block5;
                        this.myCurrentFlow.removeVariable((PsiVariable)((PsiCatchSection)parent).getParameter());
                        break block6;
                    }
                    if (!(parent instanceof PsiForeachStatement)) break block7;
                    this.myCurrentFlow.removeVariable((PsiVariable)((PsiForeachStatement)parent).getIterationParameter());
                    break block6;
                }
                if (!(parent instanceof PsiForStatement)) break block8;
                PsiStatement statement = ((PsiForStatement)parent).getInitialization();
                if (!(statement instanceof PsiDeclarationStatement)) break block6;
                for (PsiElement declaration3 : ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                    if (!(declaration3 instanceof PsiVariable)) continue;
                    this.myCurrentFlow.removeVariable((PsiVariable)declaration3);
                }
                break block6;
            }
            if (parent instanceof PsiTryStatement && (list = ((PsiTryStatement)parent).getResourceList()) != null) {
                for (PsiResourceListElement resource : list) {
                    if (!(resource instanceof PsiResourceVariable)) continue;
                    this.myCurrentFlow.removeVariable((PsiVariable)resource);
                }
            }
        }
    }

    public void visitBlockStatement(PsiBlockStatement statement) {
        this.startElement((PsiElement)statement);
        statement.getCodeBlock().accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)statement);
    }

    public void visitBreakStatement(PsiBreakStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement exitedStatement = statement.findExitedStatement();
        if (exitedStatement != null && PsiTreeUtil.isAncestor((PsiElement)this.myCodeFragment, (PsiElement)exitedStatement, (boolean)false)) {
            this.controlTransfer(new InstructionTransfer(this.getEndOffset((PsiElement)exitedStatement), this.getVariablesInside((PsiElement)exitedStatement)), this.getTrapsInsideElement((PsiElement)exitedStatement));
        } else {
            this.controlTransfer(ReturnTransfer.INSTANCE, this.getTrapsInsideElement(this.myCodeFragment));
        }
        this.finishElement((PsiElement)statement);
    }

    private void controlTransfer(@NotNull TransferTarget target, FList<Trap> traps) {
        if (target == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(1);
        }
        this.addInstruction(new ControlTransferInstruction(this.myFactory.controlTransfer(target, traps)));
    }

    @NotNull
    private FList<Trap> getTrapsInsideElement(PsiElement element) {
        FList fList = FList.createFromReversed((Iterable)ContainerUtil.reverse((List)ContainerUtil.findAll(this.myTrapStack, cd -> PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)cd.getAnchor(), (boolean)true))));
        if (fList == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(2);
        }
        return fList;
    }

    @NotNull
    private List<DfaVariableValue> getVariablesInside(PsiElement exitedStatement) {
        List list = ContainerUtil.map((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)exitedStatement, PsiVariable.class), var -> this.myFactory.getVarFactory().createVariableValue((PsiVariable)var, false));
        if (list == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void visitContinueStatement(PsiContinueStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement continuedStatement = statement.findContinuedStatement();
        if (continuedStatement instanceof PsiLoopStatement && PsiTreeUtil.isAncestor((PsiElement)this.myCodeFragment, (PsiElement)continuedStatement, (boolean)false)) {
            PsiStatement body2 = ((PsiLoopStatement)continuedStatement).getBody();
            this.controlTransfer(new InstructionTransfer(this.getEndOffset((PsiElement)body2), this.getVariablesInside((PsiElement)body2)), this.getTrapsInsideElement((PsiElement)body2));
        } else {
            this.controlTransfer(ReturnTransfer.INSTANCE, this.getTrapsInsideElement(this.myCodeFragment));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement body2 = statement.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
            PsiExpression condition2 = statement.getCondition();
            if (condition2 != null) {
                condition2.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
                this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset((PsiElement)statement), false, (PsiElement)condition2));
            }
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitEmptyStatement(PsiEmptyStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionStatement(PsiExpressionStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression expr = statement.getExpression();
        expr.accept((PsiElementVisitor)this);
        this.addInstruction(new PopInstruction());
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionListStatement(PsiExpressionListStatement statement) {
        PsiExpression[] expressions2;
        this.startElement((PsiElement)statement);
        for (PsiExpression expr : expressions2 = statement.getExpressionList().getExpressions()) {
            expr.accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        PsiStatement body2;
        this.startElement((PsiElement)statement);
        PsiParameter parameter2 = statement.getIterationParameter();
        PsiExpression iteratedValue2 = statement.getIteratedValue();
        ControlFlow.ControlFlowOffset loopEndOffset = this.getEndOffset((PsiElement)statement);
        boolean hasSizeCheck = false;
        if (iteratedValue2 != null) {
            iteratedValue2.accept((PsiElementVisitor)this);
            this.addInstruction(new DereferenceInstruction(iteratedValue2));
            DfaValue qualifier = this.myFactory.createValue(iteratedValue2);
            if (qualifier instanceof DfaVariableValue) {
                PsiType type2 = iteratedValue2.getType();
                SpecialField length = null;
                if (type2 instanceof PsiArrayType) {
                    length = SpecialField.ARRAY_LENGTH;
                } else if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Collection")) {
                    length = SpecialField.COLLECTION_SIZE;
                }
                if (length != null) {
                    this.addInstruction(new PushInstruction(length.createValue(this.myFactory, qualifier), null));
                    this.addInstruction(new PushInstruction(this.myFactory.getInt(0), null));
                    this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, (PsiElement)iteratedValue2, this.myProject));
                    this.addInstruction(new ConditionalGotoInstruction(loopEndOffset, false, null));
                    hasSizeCheck = true;
                }
            }
        }
        ControlFlow.ControlFlowOffset offset = this.myCurrentFlow.getNextOffset();
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue((PsiVariable)parameter2, false);
        this.addInstruction(new FlushVariableInstruction(dfaVariable));
        if (!hasSizeCheck) {
            this.pushUnknown();
            this.addInstruction(new ConditionalGotoInstruction(loopEndOffset, true, null));
        }
        if ((body2 = statement.getBody()) != null) {
            body2.accept((PsiElementVisitor)this);
        }
        if (hasSizeCheck) {
            this.pushUnknown();
            this.addInstruction(new ConditionalGotoInstruction(loopEndOffset, true, null));
        }
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement((PsiElement)statement);
        this.myCurrentFlow.removeVariable((PsiVariable)parameter2);
    }

    public void visitForStatement(PsiForStatement statement) {
        PsiStatement update2;
        PsiExpression condition2;
        this.startElement((PsiElement)statement);
        final ArrayList declaredVariables = new ArrayList();
        PsiStatement initialization = statement.getInitialization();
        if (initialization != null) {
            initialization.accept((PsiElementVisitor)this);
            initialization.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    this.visitElement((PsiElement)expression2);
                }

                public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                    PsiElement[] declaredElements;
                    for (PsiElement element : declaredElements = statement.getDeclaredElements()) {
                        if (!(element instanceof PsiVariable)) continue;
                        declaredVariables.add(element);
                    }
                }
            });
        }
        if ((condition2 = statement.getCondition()) != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
        } else {
            this.addInstruction(new PushInstruction(statement.getRParenth() == null ? null : this.myFactory.getConstFactory().getTrue(), null));
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), true, (PsiElement)condition2));
        PsiStatement body2 = statement.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        if ((update2 = statement.getUpdate()) != null) {
            update2.accept((PsiElementVisitor)this);
        }
        this.addCountingLoopBound(statement);
        ControlFlow.ControlFlowOffset offset = initialization != null ? this.getEndOffset((PsiElement)initialization) : this.getStartOffset((PsiElement)statement);
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement((PsiElement)statement);
        for (PsiElement declaredVariable : declaredVariables) {
            PsiVariable psiVariable = (PsiVariable)declaredVariable;
            this.myCurrentFlow.removeVariable(psiVariable);
        }
    }

    private void addCountingLoopBound(PsiForStatement statement) {
        PsiVariable initialVariable;
        PsiExpression initializer;
        CountingLoop loop = CountingLoop.from(statement);
        if (loop == null) {
            return;
        }
        PsiLocalVariable counter = loop.getCounter();
        if (!(!loop.isIncluding() || PsiType.LONG.equals((Object)counter.getType()) && PsiType.INT.equals((Object)loop.getBound().getType()))) {
            Object bound = ExpressionUtils.computeConstantExpression(loop.getBound());
            if (!(bound instanceof Number)) {
                return;
            }
            if (bound.equals(Long.MAX_VALUE) || bound.equals(Integer.MAX_VALUE)) {
                return;
            }
        }
        if (!PsiType.INT.equals((Object)(initializer = loop.getInitializer()).getType()) && !PsiType.LONG.equals((Object)initializer.getType())) {
            return;
        }
        DfaValue origin = null;
        Object initialValue = ExpressionUtils.computeConstantExpression(initializer);
        if (initialValue instanceof Number) {
            origin = this.myFactory.getConstFactory().createFromValue(initialValue, initializer.getType(), null);
        } else if (initializer instanceof PsiReferenceExpression && ((initialVariable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)initializer).resolve(), PsiVariable.class)) instanceof PsiLocalVariable || initialVariable instanceof PsiParameter) && !VariableAccessUtils.variableIsAssigned(initialVariable, (PsiElement)statement.getBody())) {
            origin = this.myFactory.getVarFactory().createVariableValue(initialVariable, false);
        }
        if (origin == null || VariableAccessUtils.variableIsAssigned((PsiVariable)counter, (PsiElement)statement.getBody())) {
            return;
        }
        this.addInstruction(new PushInstruction(this.myFactory.getVarFactory().createVariableValue((PsiVariable)counter, false), null));
        this.addInstruction(new PushInstruction(origin, null));
        this.addInstruction(new BinopInstruction(JavaTokenType.LE, null, this.myProject));
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), false, null));
    }

    public void visitIfStatement(PsiIfStatement statement) {
        ControlFlow.ControlFlowOffset offset;
        this.startElement((PsiElement)statement);
        PsiExpression condition2 = statement.getCondition();
        PsiStatement thenStatement = statement.getThenBranch();
        PsiStatement elseStatement = statement.getElseBranch();
        ControlFlow.ControlFlowOffset controlFlowOffset = offset = elseStatement != null ? this.getStartOffset((PsiElement)elseStatement) : this.getEndOffset((PsiElement)statement);
        if (condition2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(offset, true, (PsiElement)condition2));
        }
        if (thenStatement != null) {
            thenStatement.accept((PsiElementVisitor)this);
        }
        if (elseStatement != null) {
            offset = this.getEndOffset((PsiElement)statement);
            GotoInstruction instruction = new GotoInstruction(offset);
            this.addInstruction(instruction);
            elseStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitStatement(PsiStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitLabeledStatement(PsiLabeledStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement childStatement = statement.getStatement();
        if (childStatement != null) {
            childStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createValue((PsiExpression)expression2);
        this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
        this.addInstruction(new LambdaInstruction(expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression returnValue = statement.getReturnValue();
        if (this.myInlinedBlockContext != null) {
            if (returnValue != null) {
                DfaVariableValue var = this.myFactory.getVarFactory().createVariableValue(this.myInlinedBlockContext.myTarget, false);
                this.addInstruction(new PushInstruction(var, null, true));
                returnValue.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(returnValue, var.getVariableType());
                if (this.myInlinedBlockContext.myForceNonNullBlockResult) {
                    this.addInstruction(new CheckNotNullInstruction(NullabilityProblemKind.nullableFunctionReturn.problem(returnValue)));
                }
                this.addInstruction(new AssignInstruction(returnValue, null));
                this.addInstruction(new PopInstruction());
            }
            this.controlTransfer(new InstructionTransfer(this.getEndOffset((PsiElement)this.myInlinedBlockContext.myCodeBlock), this.getVariablesInside((PsiElement)this.myInlinedBlockContext.myCodeBlock)), this.myTrapStack);
        } else {
            if (returnValue != null) {
                returnValue.accept((PsiElementVisitor)this);
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
                if (method != null) {
                    this.generateBoxingUnboxingInstructionFor(returnValue, method.getReturnType());
                } else {
                    PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
                    if (lambdaExpression != null) {
                        this.generateBoxingUnboxingInstructionFor(returnValue, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression));
                    }
                }
                this.addInstruction(new CheckReturnValueInstruction(returnValue));
            }
            this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, this.myTrapStack), (PsiElement)statement));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitSwitchStatement(PsiSwitchStatement switchStmt) {
        PsiCodeBlock body2;
        this.startElement((PsiElement)switchStmt);
        PsiExpression caseExpression = switchStmt.getExpression();
        HashSet<PsiEnumConstant> enumValues = null;
        if (caseExpression != null) {
            caseExpression.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(caseExpression, (PsiType)PsiType.INT);
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)caseExpression.getType());
            if (psiClass != null) {
                this.addInstruction(new DereferenceInstruction(caseExpression));
                if (psiClass.isEnum()) {
                    enumValues = new HashSet<PsiEnumConstant>();
                    for (PsiField f : psiClass.getFields()) {
                        if (!(f instanceof PsiEnumConstant)) continue;
                        enumValues.add((PsiEnumConstant)f);
                    }
                }
            } else {
                this.addInstruction(new PopInstruction());
            }
        }
        if ((body2 = switchStmt.getBody()) != null) {
            PsiStatement[] statements = body2.getStatements();
            PsiSwitchLabelStatement defaultLabel = null;
            for (PsiStatement statement : statements) {
                if (!(statement instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement psiLabelStatement = (PsiSwitchLabelStatement)statement;
                if (psiLabelStatement.isDefaultCase()) {
                    defaultLabel = psiLabelStatement;
                    continue;
                }
                try {
                    boolean alwaysTrue;
                    ControlFlow.ControlFlowOffset offset = this.getStartOffset((PsiElement)statement);
                    PsiExpression caseValue = psiLabelStatement.getCaseValue();
                    if (enumValues != null && caseValue instanceof PsiReferenceExpression) {
                        enumValues.remove(((PsiReferenceExpression)caseValue).resolve());
                    }
                    boolean bl = alwaysTrue = enumValues != null && enumValues.isEmpty();
                    if (alwaysTrue) {
                        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
                    } else if (caseValue != null && caseExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)caseExpression).getQualifierExpression() == null) {
                        this.addInstruction(new PushInstruction(this.myFactory.createValue(caseExpression), caseExpression));
                        caseValue.accept((PsiElementVisitor)this);
                        this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, this.myProject));
                    } else {
                        this.pushUnknown();
                    }
                    this.addInstruction(new ConditionalGotoInstruction(offset, false, (PsiElement)statement));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (enumValues == null || !enumValues.isEmpty()) {
                ControlFlow.ControlFlowOffset offset = defaultLabel != null ? this.getStartOffset((PsiElement)defaultLabel) : this.getEndOffset((PsiElement)body2);
                this.addInstruction(new GotoInstruction(offset));
            }
            body2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)switchStmt);
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept((PsiElementVisitor)this);
            this.addInstruction(new DereferenceInstruction(qualifier));
        }
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression2.getFunctionalInterfaceType(), Nullness.NOT_NULL), (PsiExpression)expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression lock = statement.getLockExpression();
        if (lock != null) {
            lock.accept((PsiElementVisitor)this);
            this.addInstruction(new DereferenceInstruction(lock));
        }
        this.addInstruction(new FlushVariableInstruction(null));
        PsiCodeBlock body2 = statement.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitThrowStatement(PsiThrowStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression exception = statement.getException();
        if (exception != null) {
            exception.accept((PsiElementVisitor)this);
            this.addInstruction(new DereferenceInstruction(exception));
            this.throwException(exception.getType(), (PsiElement)statement);
        }
        this.finishElement((PsiElement)statement);
    }

    private void addConditionalRuntimeThrow() {
        if (this.myTrapStack.isEmpty()) {
            return;
        }
        this.pushUnknown();
        ConditionalGotoInstruction ifNoException = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.pushUnknown();
        ConditionalGotoInstruction ifError = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.throwException(this.myRuntimeException, null);
        ifError.setOffset(this.myCurrentFlow.getInstructionCount());
        this.throwException(this.myError, null);
        ifNoException.setOffset(this.myCurrentFlow.getInstructionCount());
    }

    public void visitTryStatement(PsiTryStatement statement) {
        PsiCatchSection[] sections;
        Trap.TryFinally finallyDescriptor;
        this.startElement((PsiElement)statement);
        PsiResourceList resourceList = statement.getResourceList();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        PsiCodeBlock finallyBlock = statement.getFinallyBlock();
        Trap.TryFinally tryFinally = finallyDescriptor = finallyBlock != null ? new Trap.TryFinally(finallyBlock, this.getStartOffset((PsiElement)finallyBlock)) : null;
        if (finallyDescriptor != null) {
            this.myTrapStack = this.myTrapStack.prepend((Object)finallyDescriptor);
        }
        if ((sections = statement.getCatchSections()).length > 0) {
            LinkedHashMap<PsiCatchSection, ControlFlow.ControlFlowOffset> clauses = new LinkedHashMap<PsiCatchSection, ControlFlow.ControlFlowOffset>();
            for (PsiCatchSection section : sections) {
                PsiCodeBlock catchBlock = section.getCatchBlock();
                if (catchBlock == null) continue;
                clauses.put(section, this.getStartOffset((PsiElement)catchBlock));
            }
            this.myTrapStack = this.myTrapStack.prepend((Object)new Trap.TryCatch(statement, clauses));
        }
        this.processTryWithResources(resourceList, tryBlock);
        InstructionTransfer gotoEnd = new InstructionTransfer(this.getEndOffset((PsiElement)statement), this.getVariablesInside((PsiElement)tryBlock));
        FList singleFinally = FList.createFromReversed((Iterable)ContainerUtil.createMaybeSingletonList((Object)finallyDescriptor));
        this.controlTransfer(gotoEnd, (FList<Trap>)singleFinally);
        if (sections.length > 0) {
            assert (this.myTrapStack.getHead() instanceof Trap.TryCatch);
            this.myTrapStack = this.myTrapStack.getTail();
        }
        for (PsiCatchSection section : sections) {
            PsiCodeBlock catchBlock = section.getCatchBlock();
            if (catchBlock != null) {
                this.visitCodeBlock(catchBlock);
            }
            this.controlTransfer(gotoEnd, (FList<Trap>)singleFinally);
        }
        if (finallyBlock != null) {
            assert (this.myTrapStack.getHead() instanceof Trap.TryFinally);
            this.myTrapStack = this.myTrapStack.getTail().prepend((Object)new Trap.InsideFinally((PsiElement)finallyBlock));
            finallyBlock.accept((PsiElementVisitor)this);
            this.addInstruction(new ControlTransferInstruction(null));
            assert (this.myTrapStack.getHead() instanceof Trap.InsideFinally);
            this.myTrapStack = this.myTrapStack.getTail();
        }
        this.finishElement((PsiElement)statement);
    }

    private void processTryWithResources(@Nullable PsiResourceList resourceList, @Nullable PsiCodeBlock tryBlock) {
        Set closerExceptions = Collections.emptySet();
        Trap.TwrFinally twrFinallyDescriptor = null;
        if (resourceList != null) {
            resourceList.accept((PsiElementVisitor)this);
            closerExceptions = StreamEx.of((Iterator)resourceList.iterator()).flatCollection(ExceptionUtil::getCloserExceptions).toSet();
            if (!closerExceptions.isEmpty()) {
                twrFinallyDescriptor = new Trap.TwrFinally(resourceList, this.getStartOffset((PsiElement)resourceList));
                this.myTrapStack = this.myTrapStack.prepend((Object)twrFinallyDescriptor);
            }
        }
        if (tryBlock != null) {
            tryBlock.accept((PsiElementVisitor)this);
        }
        if (twrFinallyDescriptor != null) {
            assert (this.myTrapStack.getHead() instanceof Trap.TwrFinally);
            InstructionTransfer gotoEnd = new InstructionTransfer(this.getEndOffset((PsiElement)resourceList), this.getVariablesInside((PsiElement)tryBlock));
            this.controlTransfer(gotoEnd, (FList<Trap>)FList.createFromReversed((Iterable)ContainerUtil.createMaybeSingletonList(twrFinallyDescriptor)));
            this.myTrapStack = this.myTrapStack.getTail().prepend((Object)new Trap.InsideFinally((PsiElement)resourceList));
            this.startElement((PsiElement)resourceList);
            this.addThrows(null, closerExceptions.toArray(PsiClassType.EMPTY_ARRAY));
            this.addInstruction(new ControlTransferInstruction(null));
            this.finishElement((PsiElement)resourceList);
            assert (this.myTrapStack.getHead() instanceof Trap.InsideFinally);
            this.myTrapStack = this.myTrapStack.getTail();
        }
    }

    public void visitResourceList(PsiResourceList resourceList) {
        for (PsiResourceListElement resource : resourceList) {
            if (resource instanceof PsiResourceVariable) {
                PsiResourceVariable variable = (PsiResourceVariable)resource;
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) continue;
                this.initializeVariable((PsiVariable)variable, initializer);
                continue;
            }
            if (!(resource instanceof PsiResourceExpression)) continue;
            ((PsiResourceExpression)resource).getExpression().accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
        }
    }

    public void visitWhileStatement(PsiWhileStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression condition2 = statement.getCondition();
        if (condition2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
        } else {
            this.pushUnknown();
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), true, (PsiElement)condition2));
        PsiStatement body2 = statement.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new GotoInstruction(this.getStartOffset((PsiElement)statement)));
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] expressions2;
        this.startElement((PsiElement)list);
        for (PsiExpression expression2 : expressions2 = list.getExpressions()) {
            expression2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)list);
    }

    public void visitExpression(PsiExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createValue(expression2);
        this.addInstruction(new PushInstruction(dfaValue, expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression arrayExpression = expression2.getArrayExpression();
        arrayExpression.accept((PsiElementVisitor)this);
        PsiExpression indexExpression = expression2.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(indexExpression, (PsiType)PsiType.INT);
        } else {
            this.addInstruction(new PushInstruction(DfaUnknownValue.getInstance(), null));
        }
        DfaValue toPush = this.myFactory.createValue((PsiExpression)expression2);
        if (toPush == null) {
            toPush = this.myFactory.createTypeValue(expression2.getType(), Nullness.UNKNOWN);
        }
        this.addInstruction(new ArrayAccessInstruction(toPush, expression2));
        this.finishElement((PsiElement)expression2);
    }

    @Nullable
    private DfaVariableValue getTargetVariable(PsiExpression expression2) {
        DfaValue value2;
        PsiAssignmentExpression assignmentExpression;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (parent instanceof PsiVariable) {
            return this.getFactory().getVarFactory().createVariableValue((PsiVariable)parent, false);
        }
        if (parent instanceof PsiAssignmentExpression && (assignmentExpression = (PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.EQ) && PsiTreeUtil.isAncestor((PsiElement)assignmentExpression.getRExpression(), (PsiElement)expression2, (boolean)false) && (value2 = this.getFactory().createValue(assignmentExpression.getLExpression())) instanceof DfaVariableValue) {
            return (DfaVariableValue)value2;
        }
        return null;
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiType type2 = expression2.getType();
        PsiType componentType = type2 instanceof PsiArrayType ? ((PsiArrayType)type2).getComponentType() : null;
        DfaVariableValue var = this.getTargetVariable((PsiExpression)expression2);
        this.processArrayInitializers(expression2, componentType, DfaPsiUtil.getTypeNullability(componentType));
        if (var != null) {
            this.addInstruction(new PushInstruction(var, null, true));
            this.addInstruction(new PushInstruction(this.getFactory().createTypeValue(type2, Nullness.NOT_NULL), (PsiExpression)expression2));
            this.addInstruction(new AssignInstruction((PsiExpression)expression2, var));
            this.addInstruction(new PushInstruction(SpecialField.ARRAY_LENGTH.createValue(this.getFactory(), var), null, true));
            this.addInstruction(new PushInstruction(this.getFactory().getInt(expression2.getInitializers().length), null));
            this.addInstruction(new AssignInstruction(null, null));
            this.addInstruction(new PopInstruction());
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression2);
    }

    private void processArrayInitializers(@NotNull PsiArrayInitializerExpression expression2, @Nullable PsiType componentType, @NotNull Nullness componentNullability) {
        PsiExpression[] initializers;
        if (expression2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(4);
        }
        if (componentNullability == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(5);
        }
        for (PsiExpression initializer : initializers = expression2.getInitializers()) {
            initializer.accept((PsiElementVisitor)this);
            if (componentType != null) {
                this.generateBoxingUnboxingInstructionFor(initializer, componentType);
                if (componentNullability == Nullness.NOT_NULL) {
                    this.addInstruction(new CheckNotNullInstruction(NullabilityProblemKind.storingToNotNullArray.problem(initializer)));
                }
            }
            this.addInstruction(new PopInstruction());
        }
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createValue((PsiExpression)expression2);
        if (dfaValue != null) {
            this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
            this.finishElement((PsiElement)expression2);
            return;
        }
        IElementType op = expression2.getOperationTokenType();
        PsiExpression[] operands2 = expression2.getOperands();
        if (operands2.length <= 1) {
            this.pushUnknown();
            this.finishElement((PsiElement)expression2);
            return;
        }
        PsiType type2 = expression2.getType();
        if (op == JavaTokenType.ANDAND) {
            this.generateAndExpression(operands2, type2, true);
        } else if (op == JavaTokenType.OROR) {
            this.generateOrExpression(operands2, type2, true);
        } else if (op == JavaTokenType.XOR && PsiType.BOOLEAN.equals((Object)type2)) {
            this.generateXorExpression((PsiExpression)expression2, operands2, type2, false);
        } else if (op == JavaTokenType.AND && PsiType.BOOLEAN.equals((Object)type2)) {
            this.generateAndExpression(operands2, type2, false);
        } else if (op == JavaTokenType.OR && PsiType.BOOLEAN.equals((Object)type2)) {
            this.generateOrExpression(operands2, type2, false);
        } else if (ControlFlowAnalyzer.isBinaryDivision(op) && operands2.length == 2 && type2 != null && PsiType.LONG.isAssignableFrom(type2)) {
            this.generateDivMod(expression2, type2, operands2[0], operands2[1]);
        } else {
            this.generateOther(expression2, op, operands2, type2);
        }
        this.finishElement((PsiElement)expression2);
    }

    static boolean isBinaryDivision(IElementType binaryOp) {
        return binaryOp == JavaTokenType.DIV || binaryOp == JavaTokenType.PERC;
    }

    static boolean isAssignmentDivision(IElementType op) {
        return op == JavaTokenType.PERCEQ || op == JavaTokenType.DIVEQ;
    }

    private void generateDivMod(PsiPolyadicExpression expression2, PsiType type2, PsiExpression left, PsiExpression right) {
        left.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(left, type2);
        right.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(right, type2);
        this.checkZeroDivisor();
        this.addInstruction(new BinopInstruction(expression2.getOperationTokenType(), (PsiElement)(expression2.isPhysical() ? expression2 : null), this.myProject));
    }

    private void checkZeroDivisor() {
        this.addInstruction(new DupInstruction());
        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().createFromValue(0, (PsiType)PsiType.LONG, null), null));
        this.addInstruction(new BinopInstruction(JavaTokenType.NE, null, this.myProject));
        ConditionalGotoInstruction ifNonZero = new ConditionalGotoInstruction(null, false, null);
        this.addInstruction(ifNonZero);
        this.throwException((PsiType)JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(ArithmeticException.class.getName()), null);
        ifNonZero.setOffset(this.myCurrentFlow.getInstructionCount());
    }

    private void generateOther(PsiPolyadicExpression expression2, IElementType op, PsiExpression[] operands2, PsiType type2) {
        op = ControlFlowAnalyzer.substituteBinaryOperation(expression2, op);
        PsiExpression lExpr = operands2[0];
        lExpr.accept((PsiElementVisitor)this);
        PsiType lType = lExpr.getType();
        for (int i = 1; i < operands2.length; ++i) {
            PsiExpression rExpr = operands2[i];
            PsiType rType = rExpr.getType();
            this.acceptBinaryRightOperand(op, type2, lExpr, lType, rExpr, rType);
            this.addInstruction(new BinopInstruction(op, (PsiElement)(expression2.isPhysical() ? expression2 : null), this.myProject));
            lExpr = rExpr;
            lType = rType;
        }
    }

    @Nullable
    private static IElementType substituteBinaryOperation(PsiPolyadicExpression expression2, IElementType op) {
        if (JavaTokenType.PLUS == op) {
            if (TypeUtils.isJavaLangString(expression2.getType()) || ControlFlowAnalyzer.isAcceptableContextForMathOperation((PsiExpression)expression2)) {
                return op;
            }
            return null;
        }
        if (JavaTokenType.MINUS == op && !ControlFlowAnalyzer.isAcceptableContextForMathOperation((PsiExpression)expression2)) {
            return null;
        }
        return op;
    }

    private static boolean isAcceptableContextForMathOperation(PsiExpression expression2) {
        PsiType type2 = expression2.getType();
        for (PsiElement parent = expression2.getParent(); !(parent == null || parent instanceof PsiAssignmentExpression || parent instanceof PsiStatement || parent instanceof PsiLambdaExpression); parent = parent.getParent()) {
            if (parent instanceof PsiExpressionList) {
                return true;
            }
            if (!(parent instanceof PsiBinaryExpression) || DfaRelationValue.RelationType.fromElementType(((PsiBinaryExpression)parent).getOperationTokenType()) == null) continue;
            return true;
        }
        return false;
    }

    private void acceptBinaryRightOperand(@Nullable IElementType op, PsiType type2, PsiExpression lExpr, PsiType lType, PsiExpression rExpr, PsiType rType) {
        PsiType castType;
        boolean comparingPrimitiveNumeric;
        boolean comparing = op == JavaTokenType.EQEQ || op == JavaTokenType.NE;
        boolean comparingRef = comparing && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rType);
        boolean bl = comparingPrimitiveNumeric = comparing && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rType) && TypeConversionUtil.isNumericType((PsiType)lType) && TypeConversionUtil.isNumericType((PsiType)rType);
        Object object = comparingPrimitiveNumeric ? (TypeConversionUtil.isFloatOrDoubleType((PsiType)lType) ? PsiType.DOUBLE : PsiType.LONG) : (castType = type2);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(lExpr, castType);
        }
        rExpr.accept((PsiElementVisitor)this);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(rExpr, castType);
        }
    }

    void generateBoxingUnboxingInstructionFor(@NotNull PsiExpression expression2, PsiType expectedType) {
        if (expression2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(6);
        }
        this.generateBoxingUnboxingInstructionFor(expression2, expression2.getType(), expectedType);
    }

    void generateBoxingUnboxingInstructionFor(@NotNull PsiExpression context, PsiType actualType, PsiType expectedType) {
        if (context == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(7);
        }
        if (PsiType.VOID.equals((Object)expectedType)) {
            return;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isPrimitiveWrapper((PsiType)actualType)) {
            this.addInstruction(new MethodCallInstruction(context, MethodCallInstruction.MethodType.UNBOXING, expectedType));
        } else if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)actualType) && TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)expectedType)) {
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction(context, MethodCallInstruction.MethodType.BOXING, expectedType));
        } else if (actualType != expectedType && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)actualType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isNumericType((PsiType)actualType) && TypeConversionUtil.isNumericType((PsiType)expectedType)) {
            this.addInstruction(new MethodCallInstruction(context, MethodCallInstruction.MethodType.CAST, expectedType){

                @Override
                public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
                    return visitor.visitCast(this, runner, stateBefore);
                }
            });
        }
    }

    private void generateXorExpression(PsiExpression expression2, PsiExpression[] operands2, PsiType exprType, boolean forAssignment) {
        PsiExpression operand2 = operands2[0];
        operand2.accept((PsiElementVisitor)this);
        if (forAssignment) {
            this.addInstruction(new DupInstruction());
        }
        this.generateBoxingUnboxingInstructionFor(operand2, exprType);
        for (int i = 1; i < operands2.length; ++i) {
            operand2 = operands2[i];
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, exprType);
            PsiExpression psiAnchor = i == operands2.length - 1 && expression2.isPhysical() ? expression2 : null;
            this.addInstruction(new BinopInstruction(JavaTokenType.NE, (PsiElement)psiAnchor, this.myProject));
        }
    }

    private void generateOrExpression(PsiExpression[] operands2, PsiType exprType, boolean shortCircuit) {
        for (int i = 0; i < operands2.length; ++i) {
            PsiExpression nextOperand;
            PsiExpression operand2 = operands2[i];
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, exprType);
            if (!shortCircuit) {
                if (i <= 0) continue;
                this.combineStackBooleans(false, operand2);
                continue;
            }
            PsiExpression psiExpression = nextOperand = i == operands2.length - 1 ? null : operands2[i + 1];
            if (nextOperand == null) continue;
            this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset((PsiElement)nextOperand), true, (PsiElement)operand2));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
            this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)operands2[operands2.length - 1])));
        }
    }

    private void generateBooleanAssignmentExpression(boolean and, PsiExpression lExpression, PsiExpression rExpression, PsiType exprType) {
        lExpression.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(lExpression, exprType);
        this.addInstruction(new DupInstruction());
        rExpression.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpression, exprType);
        this.addInstruction(new SwapInstruction());
        this.combineStackBooleans(and, lExpression);
    }

    private void combineStackBooleans(boolean and, PsiExpression anchor) {
        ConditionalGotoInstruction toPopAndPushSuccess = new ConditionalGotoInstruction(null, and, (PsiElement)anchor);
        this.addInstruction(toPopAndPushSuccess);
        GotoInstruction overPushSuccess = new GotoInstruction(null);
        this.addInstruction(overPushSuccess);
        PopInstruction pop = new PopInstruction();
        this.addInstruction(pop);
        DfaConstValue constValue = this.myFactory.getBoolean(!and);
        PushInstruction pushSuccess = new PushInstruction(constValue, null);
        this.addInstruction(pushSuccess);
        toPopAndPushSuccess.setOffset(pop.getIndex());
        overPushSuccess.setOffset(pushSuccess.getIndex() + 1);
    }

    private void generateAndExpression(PsiExpression[] operands2, PsiType exprType, boolean shortCircuit) {
        ArrayList<ConditionalGotoInstruction> branchToFail = new ArrayList<ConditionalGotoInstruction>();
        for (int i = 0; i < operands2.length; ++i) {
            PsiExpression operand2 = operands2[i];
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, exprType);
            if (!shortCircuit) {
                if (i <= 0) continue;
                this.combineStackBooleans(true, operand2);
                continue;
            }
            ConditionalGotoInstruction onFail = new ConditionalGotoInstruction(null, true, (PsiElement)operand2);
            branchToFail.add(onFail);
            this.addInstruction(onFail);
        }
        if (!shortCircuit) {
            return;
        }
        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
        GotoInstruction toSuccess = new GotoInstruction(null);
        this.addInstruction(toSuccess);
        PushInstruction pushFalse = new PushInstruction(this.myFactory.getConstFactory().getFalse(), null);
        this.addInstruction(pushFalse);
        for (ConditionalGotoInstruction toFail : branchToFail) {
            toFail.setOffset(pushFalse.getIndex());
        }
        toSuccess.setOffset(pushFalse.getIndex() + 1);
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression2.getType(), Nullness.NOT_NULL), (PsiExpression)expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        ControlFlow.ControlFlowOffset elseOffset;
        this.startElement((PsiElement)expression2);
        PsiExpression condition2 = expression2.getCondition();
        PsiExpression thenExpression2 = expression2.getThenExpression();
        PsiExpression elseExpression2 = expression2.getElseExpression();
        ControlFlow.ControlFlowOffset controlFlowOffset = elseOffset = elseExpression2 == null ? ControlFlow.deltaOffset(this.getEndOffset((PsiElement)expression2), -1) : this.getStartOffset((PsiElement)elseExpression2);
        if (thenExpression2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
            PsiType type2 = expression2.getType();
            this.addInstruction(new ConditionalGotoInstruction(elseOffset, true, (PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2)));
            thenExpression2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(thenExpression2, type2);
            this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)expression2)));
            if (elseExpression2 != null) {
                elseExpression2.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(elseExpression2, type2);
            } else {
                this.pushUnknown();
            }
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression2);
    }

    void pushUnknown() {
        this.addInstruction(new PushInstruction(DfaUnknownValue.getInstance(), null));
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = expression2.getOperand();
        PsiTypeElement checkType = expression2.getCheckType();
        if (checkType != null) {
            operand2.accept((PsiElementVisitor)this);
            PsiType type2 = checkType.getType();
            if (type2 instanceof PsiClassType) {
                type2 = ((PsiClassType)type2).rawType();
            }
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(type2, Nullness.NOT_NULL), null));
            this.addInstruction(new InstanceofInstruction((PsiElement)expression2, this.myProject, operand2, type2));
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression2);
    }

    private void addMethodThrows(PsiMethod method, @Nullable PsiElement explicitCall) {
        if (method != null) {
            this.addThrows(explicitCall, method.getThrowsList().getReferencedTypes());
        }
    }

    private void addThrows(@Nullable PsiElement explicitCall, PsiClassType[] refs) {
        for (PsiClassType ref : refs) {
            this.pushUnknown();
            ConditionalGotoInstruction cond = new ConditionalGotoInstruction(null, false, null);
            this.addInstruction(cond);
            this.throwException((PsiType)ref, explicitCall);
            cond.setOffset(this.myCurrentFlow.getInstructionCount());
        }
    }

    private void throwException(@Nullable PsiType ref, @Nullable PsiElement anchor) {
        if (ref != null) {
            this.throwException(new ExceptionTransfer(this.myFactory.createDfaType(ref)), anchor);
        }
    }

    private void throwException(ExceptionTransfer kind2, @Nullable PsiElement anchor) {
        this.addInstruction(new EmptyStackInstruction());
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(kind2, this.myTrapStack), anchor));
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression2;
        this.startElement((PsiElement)expression2);
        if (this.myInlining) {
            for (CallInliner inliner : INLINERS) {
                if (!inliner.tryInlineCall(new CFGBuilder(this), expression2)) continue;
                this.finishElement((PsiElement)expression2);
                return;
            }
        }
        if ((qualifierExpression2 = (methodExpression = expression2.getMethodExpression()).getQualifierExpression()) != null) {
            qualifierExpression2.accept((PsiElementVisitor)this);
        } else if (this.myThisReadOnly) {
            this.addInstruction(new PushInstruction(this.myFactory.getFactValue(DfaFactType.MUTABILITY, Mutability.UNMODIFIABLE), null));
        } else {
            this.pushUnknown();
        }
        PsiExpression[] expressions2 = expression2.getArgumentList().getExpressions();
        JavaResolveResult result = methodExpression.advancedResolve(false);
        PsiElement method = result.getElement();
        PsiParameter[] parameters2 = method instanceof PsiMethod ? ((PsiMethod)method).getParameterList().getParameters() : null;
        for (int i = 0; i < expressions2.length; ++i) {
            PsiExpression paramExpr = expressions2[i];
            paramExpr.accept((PsiElementVisitor)this);
            if (parameters2 == null || i >= parameters2.length) continue;
            this.generateBoxingUnboxingInstructionFor(paramExpr, result.getSubstitutor().substitute(parameters2[i].getType()));
        }
        this.addBareCall(expression2, expression2.getMethodExpression());
        this.finishElement((PsiElement)expression2);
    }

    void addBareCall(@Nullable PsiMethodCallExpression expression2, @NotNull PsiReferenceExpression reference) {
        PsiReferenceExpression anchor;
        MethodCallInstruction instruction;
        List contracts2;
        if (reference == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(8);
        }
        this.addConditionalRuntimeThrow();
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)reference.resolve(), PsiMethod.class);
        List<Object> list = contracts2 = method == null ? Collections.emptyList() : ControlFlowAnalyzer.getMethodCallContracts(method, expression2);
        if (expression2 == null) {
            assert (reference instanceof PsiMethodReferenceExpression);
            instruction = new MethodCallInstruction((PsiMethodReferenceExpression)reference, contracts2);
            anchor = reference;
        } else {
            instruction = new MethodCallInstruction((PsiCall)expression2, this.myFactory.createValue((PsiExpression)expression2), contracts2);
            anchor = expression2;
        }
        this.addInstruction(instruction);
        if (contracts2.stream().anyMatch(c -> c.getReturnValue() == MethodContract.ValueConstraint.THROW_EXCEPTION)) {
            this.addInstruction(new DupInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getContractFail(), null));
            this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, this.myProject));
            ConditionalGotoInstruction ifNotFail = new ConditionalGotoInstruction(null, true, null);
            this.addInstruction(ifNotFail);
            this.addInstruction(new EmptyStackInstruction());
            this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(new ExceptionTransfer(null), this.myTrapStack), (PsiElement)anchor));
            ifNotFail.setOffset(this.myCurrentFlow.getInstructionCount());
        }
        if (!this.myTrapStack.isEmpty()) {
            this.addMethodThrows(method, (PsiElement)anchor);
        }
    }

    public static List<? extends MethodContract> getMethodCallContracts(@NotNull PsiMethod method, @Nullable PsiMethodCallExpression call) {
        List<MethodContract> contracts2;
        if (method == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(9);
        }
        return !(contracts2 = HardcodedContracts.getHardcodedContracts(method, call)).isEmpty() ? contracts2 : ControlFlowAnalyzer.getMethodContracts(method);
    }

    public static List<StandardMethodContract> getMethodContracts(@NotNull PsiMethod method) {
        if (method == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(10);
        }
        return (List)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            String text2;
            PsiAnnotation contractAnno;
            if (method == null) {
                ControlFlowAnalyzer.$$$reportNull$$$0(17);
            }
            if ((contractAnno = ControlFlowAnalyzer.findContractAnnotation(method)) != null && (text2 = AnnotationUtil.getStringAttributeValue((PsiAnnotation)contractAnno, null)) != null) {
                try {
                    int paramCount = method.getParameterList().getParametersCount();
                    List applicable = ContainerUtil.filter(StandardMethodContract.parseContract(text2), contract -> contract.arguments.length == paramCount);
                    return CachedValueProvider.Result.create((Object)applicable, (Object[])new Object[]{contractAnno, method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    @Nullable
    public static PsiAnnotation findContractAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(11);
        }
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton(ORG_JETBRAINS_ANNOTATIONS_CONTRACT));
    }

    public static boolean isPure(@NotNull PsiMethod method) {
        PsiAnnotation anno;
        if (method == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(12);
        }
        return (anno = ControlFlowAnalyzer.findContractAnnotation(method)) != null && Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)anno, (String)"pure"));
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (enumConstant.getArgumentList() == null) {
            return;
        }
        this.pushUnknown();
        this.pushConstructorArguments((PsiConstructorCall)enumConstant);
        this.addInstruction(new MethodCallInstruction((PsiCall)enumConstant, null, Collections.emptyList()));
        this.addInstruction(new PopInstruction());
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        PsiType type2;
        this.startElement((PsiElement)expression2);
        PsiExpression qualifier = expression2.getQualifier();
        if (qualifier != null) {
            qualifier.accept((PsiElementVisitor)this);
            this.addInstruction(new CheckNotNullInstruction(NullabilityProblemKind.innerClassNPE.problem(expression2)));
            this.addInstruction(new PopInstruction());
        }
        if ((type2 = expression2.getType()) instanceof PsiArrayType) {
            DfaVariableValue var = this.getTargetVariable((PsiExpression)expression2);
            if (var == null) {
                var = this.getFactory().getVarFactory().createVariableValue(this.createTempVariable(type2), false);
            }
            DfaValue length = SpecialField.ARRAY_LENGTH.createValue(this.getFactory(), var);
            this.addInstruction(new PushInstruction(length, null, true));
            PsiExpression[] dimensions = expression2.getArrayDimensions();
            boolean sizeOnStack = false;
            for (PsiExpression dimension : dimensions) {
                dimension.accept((PsiElementVisitor)this);
                if (sizeOnStack) {
                    this.addInstruction(new PopInstruction());
                }
                sizeOnStack = true;
            }
            PsiArrayInitializerExpression arrayInitializer = expression2.getArrayInitializer();
            if (arrayInitializer != null) {
                PsiType expectedType;
                Nullness nullability = DfaPsiUtil.getTypeNullability(((PsiArrayType)type2).getComponentType());
                if (nullability == Nullness.UNKNOWN && (expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, false)) instanceof PsiArrayType) {
                    nullability = DfaPsiUtil.getTypeNullability(((PsiArrayType)expectedType).getComponentType());
                }
                this.processArrayInitializers(arrayInitializer, ((PsiArrayType)type2).getComponentType(), nullability);
                if (!sizeOnStack) {
                    sizeOnStack = true;
                    this.addInstruction(new PushInstruction(this.getFactory().getInt(arrayInitializer.getInitializers().length), null));
                }
            }
            if (!sizeOnStack) {
                this.pushUnknown();
            }
            this.addInstruction(new PushInstruction(var, null, true));
            this.addInstruction(new PushInstruction(this.getFactory().createTypeValue(type2, Nullness.NOT_NULL), (PsiExpression)expression2));
            this.addInstruction(new AssignInstruction((PsiExpression)expression2, var));
            this.addInstruction(new SpliceInstruction(3, 0, 2, 1));
            this.addInstruction(new AssignInstruction(null, length));
            this.addInstruction(new PopInstruction());
        } else {
            this.pushUnknown();
            PsiMethod constructor = this.pushConstructorArguments((PsiConstructorCall)expression2);
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction((PsiCall)expression2, null, constructor == null ? Collections.emptyList() : ControlFlowAnalyzer.getMethodContracts(constructor)));
            if (!this.myTrapStack.isEmpty()) {
                this.addMethodThrows(constructor, (PsiElement)expression2);
            }
        }
        this.finishElement((PsiElement)expression2);
    }

    @Nullable
    private PsiMethod pushConstructorArguments(PsiConstructorCall call) {
        PsiExpressionList args = call.getArgumentList();
        PsiMethod ctr = call.resolveConstructor();
        if (args != null) {
            PsiExpression[] params = args.getExpressions();
            PsiParameter[] parameters2 = ctr == null ? null : ctr.getParameterList().getParameters();
            for (int i = 0; i < params.length; ++i) {
                PsiExpression param = params[i];
                param.accept((PsiElementVisitor)this);
                if (parameters2 == null || i >= parameters2.length) continue;
                this.generateBoxingUnboxingInstructionFor(param, parameters2[i].getType());
            }
        }
        return ctr;
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression inner = expression2.getExpression();
        if (inner != null) {
            inner.accept((PsiElementVisitor)this);
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitPostfixExpression(PsiPostfixExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
        if (operand2 != null) {
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, (PsiType)PsiType.INT);
        } else {
            this.pushUnknown();
        }
        this.addInstruction(new PopInstruction());
        this.pushUnknown();
        this.flushIncrementedValue(operand2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createValue((PsiExpression)expression2);
        if (dfaValue == null) {
            PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
            if (operand2 == null) {
                this.pushUnknown();
            } else {
                operand2.accept((PsiElementVisitor)this);
                PsiType type2 = expression2.getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type2);
                this.generateBoxingUnboxingInstructionFor(operand2, (PsiType)(unboxed == null ? type2 : unboxed));
                if (expression2.getOperationTokenType() == JavaTokenType.EXCL) {
                    this.addInstruction(new NotInstruction());
                } else if (expression2.getOperationTokenType() == JavaTokenType.MINUS && (PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2))) {
                    this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().createFromValue(PsiTypesUtil.getDefaultValue((PsiType)type2), type2, null), null));
                    this.addInstruction(new SwapInstruction());
                    this.addInstruction(new BinopInstruction(expression2.getOperationTokenType(), (PsiElement)expression2, this.myProject));
                } else {
                    this.addInstruction(new PopInstruction());
                    this.pushUnknown();
                    this.flushIncrementedValue(operand2);
                }
            }
        } else {
            this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
        }
        this.finishElement((PsiElement)expression2);
    }

    private void flushIncrementedValue(@Nullable PsiExpression operand2) {
        DfaValue dfaVariable;
        DfaValue dfaValue = dfaVariable = operand2 == null ? null : this.myFactory.createValue(operand2);
        if (dfaVariable instanceof DfaVariableValue && PsiUtil.isAccessedForWriting((PsiExpression)operand2)) {
            this.addInstruction(new FlushVariableInstruction((DfaVariableValue)dfaVariable));
            if (((DfaVariableValue)dfaVariable).getPsiVariable() instanceof PsiField) {
                this.addInstruction(new FlushVariableInstruction(null));
            }
        }
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
        if (qualifierExpression2 != null) {
            qualifierExpression2.accept((PsiElementVisitor)this);
            this.addInstruction(expression2.resolve() instanceof PsiField ? new DereferenceInstruction(qualifierExpression2) : new PopInstruction());
        }
        boolean writing = PsiUtil.isAccessedForWriting((PsiExpression)expression2) && !PsiUtil.isAccessedForReading((PsiExpression)expression2);
        this.addInstruction(new PushInstruction(this.myFactory.createValue((PsiExpression)expression2), (PsiExpression)expression2, writing));
        this.finishElement((PsiElement)expression2);
    }

    public void visitSuperExpression(PsiSuperExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression2.getType(), Nullness.NOT_NULL), (PsiExpression)expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitThisExpression(PsiThisExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue value2 = this.myFactory.createTypeValue(expression2.getType(), Nullness.NOT_NULL);
        if (this.myThisReadOnly) {
            value2 = this.myFactory.withFact(value2, DfaFactType.MUTABILITY, Mutability.UNMODIFIABLE);
        }
        this.addInstruction(new PushInstruction(value2, (PsiExpression)expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createLiteralValue(expression2);
        this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitTypeCastExpression(PsiTypeCastExpression castExpression) {
        this.startElement((PsiElement)castExpression);
        PsiExpression operand2 = castExpression.getOperand();
        if (operand2 != null) {
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, castExpression.getType());
        } else {
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(castExpression.getType(), Nullness.UNKNOWN), null));
        }
        PsiTypeElement typeElement = castExpression.getCastType();
        if (typeElement != null && operand2 != null && operand2.getType() != null) {
            if (typeElement.getType() instanceof PsiPrimitiveType && !UnnecessaryExplicitNumericCastInspection.isUnnecessaryPrimitiveNumericCast(castExpression)) {
                this.addInstruction(new PopInstruction());
                this.pushUnknown();
            } else {
                this.addInstruction(new TypeCastInstruction(castExpression, operand2, typeElement.getType()));
            }
        }
        this.finishElement((PsiElement)castExpression);
    }

    public void visitClass(PsiClass aClass) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inlineBlock(@NotNull PsiCodeBlock block, @NotNull Nullness resultNullness, @NotNull PsiVariable target) {
        if (block == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(13);
        }
        if (resultNullness == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(14);
        }
        if (target == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(15);
        }
        InlinedBlockContext oldBlock = this.myInlinedBlockContext;
        this.addInstruction(new PushInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, this.myTrapStack), null));
        this.myInlinedBlockContext = new InlinedBlockContext(block, resultNullness == Nullness.NOT_NULL, target);
        this.startElement((PsiElement)block);
        try {
            block.accept((PsiElementVisitor)this);
        }
        finally {
            this.finishElement((PsiElement)block);
            this.myInlinedBlockContext = oldBlock;
            this.addInstruction(new PopInstruction());
        }
    }

    @NotNull
    PsiVariable createTempVariable(@Nullable PsiType type2) {
        if (type2 == null) {
            type2 = PsiType.VOID;
        }
        TempVariable tempVariable = new TempVariable(this.getInstructionCount(), type2, this.getContext());
        if (tempVariable == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(16);
        }
        return tempVariable;
    }

    public static boolean isTempVariable(PsiModifierListOwner variable) {
        return variable instanceof TempVariable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentNullability";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultNullness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrapsInsideElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesInside";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "controlTransfer";
                break;
            }
            case 2: 
            case 3: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processArrayInitializers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateBoxingUnboxingInstructionFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addBareCall";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCallContracts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMethodContracts";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findContractAnnotation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPure";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inlineBlock";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMethodContracts$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InlinedBlockContext {
        final PsiCodeBlock myCodeBlock;
        final boolean myForceNonNullBlockResult;
        final PsiVariable myTarget;

        public InlinedBlockContext(PsiCodeBlock codeBlock, boolean forceNonNullBlockResult, PsiVariable target) {
            this.myCodeBlock = codeBlock;
            this.myForceNonNullBlockResult = forceNonNullBlockResult;
            this.myTarget = target;
        }
    }

    private static class TempVariable
    extends LightVariableBuilder<TempVariable> {
        TempVariable(int index, @NotNull PsiType type2, @NotNull PsiElement navigationElement) {
            if (type2 == null) {
                TempVariable.$$$reportNull$$$0(0);
            }
            if (navigationElement == null) {
                TempVariable.$$$reportNull$$$0(1);
            }
            super("tmp$" + index, type2, navigationElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "navigationElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer$TempVariable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CannotAnalyzeException
    extends RuntimeException {
        private CannotAnalyzeException() {
        }
    }
}

