/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfaFactType<T>
extends Key<T> {
    private static final List<DfaFactType<?>> ourFactTypes = new ArrayList();
    public static final DfaFactType<Boolean> CAN_BE_NULL = new DfaFactType<Boolean>("Can be null"){

        @Override
        String toString(@NotNull Boolean fact) {
            if (fact == null) {
                1.$$$reportNull$$$0(0);
            }
            return fact != false ? "Nullable" : "NotNull";
        }

        @Override
        @Nullable
        Boolean intersectFacts(@NotNull Boolean left, @NotNull Boolean right) {
            if (left == null) {
                1.$$$reportNull$$$0(1);
            }
            if (right == null) {
                1.$$$reportNull$$$0(2);
            }
            if (Boolean.FALSE.equals(left) || Boolean.FALSE.equals(right)) {
                return Boolean.FALSE;
            }
            return super.intersectFacts(left, right);
        }

        @Override
        @Nullable
        Boolean fromDfaValue(DfaValue value2) {
            DfaFactMapValue factValue;
            if (value2 instanceof DfaConstValue) {
                return ((DfaConstValue)value2).getValue() == null;
            }
            if (value2 instanceof DfaBoxedValue || value2 instanceof DfaUnboxedValue) {
                return false;
            }
            if (value2 instanceof DfaFactMapValue && ((factValue = (DfaFactMapValue)value2).get(OPTIONAL_PRESENCE) != null || factValue.get(RANGE) != null)) {
                return false;
            }
            return (Boolean)super.fromDfaValue(value2);
        }

        @Override
        @Nullable
        Boolean calcFromVariable(@NotNull DfaVariableValue value2) {
            if (value2 == null) {
                1.$$$reportNull$$$0(3);
            }
            return NullnessUtil.calcCanBeNull(value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toString";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "intersectFacts";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcFromVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final DfaFactType<Mutability> MUTABILITY = new DfaFactType<Mutability>("Mutable"){

        @Override
        boolean isUnknown(@NotNull Mutability fact) {
            if (fact == null) {
                2.$$$reportNull$$$0(0);
            }
            return fact == Mutability.UNKNOWN;
        }

        @Override
        @NotNull
        Mutability calcFromVariable(@NotNull DfaVariableValue value2) {
            if (value2 == null) {
                2.$$$reportNull$$$0(1);
            }
            PsiModifierListOwner variable = value2.getPsiVariable();
            Mutability mutability = Mutability.getMutability(variable);
            if (mutability == null) {
                2.$$$reportNull$$$0(2);
            }
            return mutability;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$2";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcFromVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnknown";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "calcFromVariable";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final DfaFactType<Boolean> OPTIONAL_PRESENCE = new DfaFactType<Boolean>("Optional presense"){

        @Override
        String toString(@NotNull Boolean fact) {
            if (fact == null) {
                3.$$$reportNull$$$0(0);
            }
            return fact != false ? "present Optional" : "absent Optional";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fact", "com/intellij/codeInspection/dataFlow/DfaFactType$3", "toString"));
        }
    };
    public static final DfaFactType<LongRangeSet> RANGE = new DfaFactType<LongRangeSet>("Range"){

        @Override
        boolean isSuper(@Nullable LongRangeSet superFact, @Nullable LongRangeSet subFact) {
            return superFact == null || subFact != null && superFact.contains(subFact);
        }

        @Override
        boolean isUnknown(@NotNull LongRangeSet fact) {
            if (fact == null) {
                4.$$$reportNull$$$0(0);
            }
            return LongRangeSet.all().equals(fact);
        }

        @Override
        @Nullable
        LongRangeSet fromDfaValue(DfaValue value2) {
            if (value2 instanceof DfaVariableValue) {
                return this.calcFromVariable((DfaVariableValue)value2);
            }
            return LongRangeSet.fromDfaValue(value2);
        }

        @Override
        @Nullable
        LongRangeSet calcFromVariable(@NotNull DfaVariableValue var) {
            if (var == null) {
                4.$$$reportNull$$$0(1);
            }
            if (var.getQualifier() != null) {
                for (SpecialField sf : SpecialField.values()) {
                    if (!sf.isMyAccessor(var.getPsiVariable())) continue;
                    return sf.getRange();
                }
            }
            PsiModifierListOwner psiVariable = var.getPsiVariable();
            LongRangeSet fromType = LongRangeSet.fromType(var.getVariableType());
            return fromType == null ? null : LongRangeSet.fromPsiElement(psiVariable).intersect(fromType);
        }

        @Override
        @Nullable
        LongRangeSet unionFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            if (left == null) {
                4.$$$reportNull$$$0(2);
            }
            if (right == null) {
                4.$$$reportNull$$$0(3);
            }
            return left.union(right);
        }

        @Override
        @Nullable
        LongRangeSet intersectFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            LongRangeSet intersection;
            if (left == null) {
                4.$$$reportNull$$$0(4);
            }
            if (right == null) {
                4.$$$reportNull$$$0(5);
            }
            return (intersection = left.intersect(right)).isEmpty() ? null : intersection;
        }

        @Override
        String toString(@NotNull LongRangeSet fact) {
            if (fact == null) {
                4.$$$reportNull$$$0(6);
            }
            return fact.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$4";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUnknown";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcFromVariable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unionFacts";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "intersectFacts";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toString";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final DfaFactType<TypeConstraint> TYPE_CONSTRAINT = new DfaFactType<TypeConstraint>("Type"){

        @Override
        boolean isSuper(@Nullable TypeConstraint superFact, @Nullable TypeConstraint subFact) {
            return superFact == null || subFact != null && superFact.isSuperStateOf(subFact);
        }

        @Override
        boolean isUnknown(@NotNull TypeConstraint fact) {
            if (fact == null) {
                5.$$$reportNull$$$0(0);
            }
            return fact.equals(TypeConstraint.EMPTY);
        }

        @Override
        @Nullable
        TypeConstraint intersectFacts(@NotNull TypeConstraint left, @NotNull TypeConstraint right) {
            if (left == null) {
                5.$$$reportNull$$$0(1);
            }
            if (right == null) {
                5.$$$reportNull$$$0(2);
            }
            for (DfaPsiType type2 : right.getInstanceofValues()) {
                if ((left = left.withInstanceofValue(type2)) != null) continue;
                return null;
            }
            for (DfaPsiType type2 : right.getNotInstanceofValues()) {
                if ((left = left.withNotInstanceofValue(type2)) != null) continue;
                return null;
            }
            return left;
        }

        @Override
        @Nullable
        TypeConstraint unionFacts(@NotNull TypeConstraint left, @NotNull TypeConstraint right) {
            if (left == null) {
                5.$$$reportNull$$$0(3);
            }
            if (right == null) {
                5.$$$reportNull$$$0(4);
            }
            return left.union(right);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$5";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUnknown";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "intersectFacts";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unionFacts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private DfaFactType(String name) {
        super("DfaFactType: " + name);
        ourFactTypes.add(this);
    }

    @Nullable
    T fromDfaValue(DfaValue value2) {
        return value2 instanceof DfaFactMapValue ? (T)((DfaFactMapValue)value2).get(this) : null;
    }

    @Nullable
    T calcFromVariable(@NotNull DfaVariableValue value2) {
        if (value2 == null) {
            DfaFactType.$$$reportNull$$$0(0);
        }
        return null;
    }

    boolean isSuper(@Nullable T superFact, @Nullable T subFact) {
        return Objects.equals(superFact, subFact);
    }

    boolean isUnknown(@NotNull T fact) {
        if (fact == null) {
            DfaFactType.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Nullable
    T intersectFacts(@NotNull T left, @NotNull T right) {
        if (left == null) {
            DfaFactType.$$$reportNull$$$0(2);
        }
        if (right == null) {
            DfaFactType.$$$reportNull$$$0(3);
        }
        return (T)(left.equals(right) ? left : null);
    }

    @Nullable
    T unionFacts(@NotNull T left, @NotNull T right) {
        if (left == null) {
            DfaFactType.$$$reportNull$$$0(4);
        }
        if (right == null) {
            DfaFactType.$$$reportNull$$$0(5);
        }
        return (T)(left.equals(right) ? left : null);
    }

    String toString(@NotNull T fact) {
        if (fact == null) {
            DfaFactType.$$$reportNull$$$0(6);
        }
        return fact.toString();
    }

    static List<DfaFactType<?>> getTypes() {
        return Collections.unmodifiableList(ourFactTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fact";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calcFromVariable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnknown";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "intersectFacts";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "unionFacts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "toString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

