/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DereferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardInstructionVisitor
extends InstructionVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.StandardInstructionVisitor");
    private final Set<BinopInstruction> myReachable = new THashSet();
    private final Set<BinopInstruction> myCanBeNullInInstanceof = new THashSet();
    private final Set<InstanceofInstruction> myUsefulInstanceofs = new THashSet();

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        NullabilityProblemKind<PsiExpression> kind2;
        DfaValue dfaSource = memState.pop();
        DfaValue dfaDest = memState.pop();
        if (!(dfaDest instanceof DfaVariableValue) && instruction.getAssignedValue() != null) {
            dfaDest = instruction.getAssignedValue();
        }
        PsiExpression lValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)instruction.getLExpression());
        PsiExpression rValue = instruction.getRExpression();
        if (lValue instanceof PsiArrayAccessExpression) {
            kind2 = NullabilityProblemKind.storingToNotNullArray;
            this.checkArrayElementAssignability(runner, memState, dfaSource, lValue, rValue);
        } else {
            kind2 = NullabilityProblemKind.assigningToNotNull;
        }
        if (dfaDest instanceof DfaVariableValue) {
            boolean forceDeclaredNullity;
            DfaVariableValue var = (DfaVariableValue)dfaDest;
            PsiModifierListOwner psi = var.getPsiVariable();
            boolean bl = forceDeclaredNullity = !(psi instanceof PsiParameter) || !(psi.getParent() instanceof PsiParameterList);
            if (forceDeclaredNullity && var.getInherentNullability() == Nullness.NOT_NULL) {
                this.checkNotNullable(memState, dfaSource, kind2.problem(rValue));
            }
            if (!(psi instanceof PsiField) || !psi.hasModifierProperty("volatile")) {
                memState.setVarValue(var, dfaSource);
            }
            if (var.getInherentNullability() == Nullness.NULLABLE && !memState.isNotNull(dfaSource) && instruction.isVariableInitializer()) {
                DfaMemoryStateImpl stateImpl = (DfaMemoryStateImpl)memState;
                stateImpl.setVariableState(var, stateImpl.getVariableState(var).withFact(DfaFactType.CAN_BE_NULL, true));
            }
        } else if (dfaDest instanceof DfaFactMapValue && Boolean.FALSE.equals(((DfaFactMapValue)dfaDest).get(DfaFactType.CAN_BE_NULL))) {
            this.checkNotNullable(memState, dfaSource, kind2.problem(rValue));
        }
        memState.push(dfaDest);
        this.flushArrayOnUnknownAssignment(instruction, runner.getFactory(), dfaDest, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private void checkArrayElementAssignability(DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaSource, PsiExpression lValue, PsiExpression rValue) {
        DfaValue arrayValue;
        if (rValue == null) {
            return;
        }
        PsiType rCodeType = rValue.getType();
        PsiType lCodeType = lValue.getType();
        if (rCodeType == null || lCodeType == null || !TypeConversionUtil.areTypesConvertible((PsiType)rCodeType, (PsiType)lCodeType)) {
            return;
        }
        PsiExpression array = ((PsiArrayAccessExpression)lValue).getArrayExpression();
        PsiType arrayType = StandardInstructionVisitor.getType(array, arrayValue = runner.getFactory().createValue(array), memState);
        if (!(arrayType instanceof PsiArrayType)) {
            return;
        }
        PsiType componentType = ((PsiArrayType)arrayType).getComponentType();
        PsiType sourceType = StandardInstructionVisitor.getType(rValue, dfaSource, memState);
        if (sourceType == null || TypeConversionUtil.areTypesConvertible((PsiType)sourceType, (PsiType)componentType)) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)rValue, PsiAssignmentExpression.class);
        this.processArrayStoreTypeMismatch(assignmentExpression, sourceType, componentType);
    }

    @Nullable
    private static PsiType getType(@Nullable PsiExpression expression2, @Nullable DfaValue value2, @NotNull DfaMemoryState memState) {
        PsiType type2;
        if (memState == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(0);
        }
        TypeConstraint fact = value2 == null ? null : memState.getValueFact(value2, DfaFactType.TYPE_CONSTRAINT);
        PsiType psiType = type2 = fact == null ? null : fact.getPsiType();
        if (type2 != null) {
            return type2;
        }
        return expression2 == null ? null : expression2.getType();
    }

    protected void processArrayStoreTypeMismatch(PsiAssignmentExpression assignmentExpression, PsiType fromType, PsiType toType) {
    }

    @Override
    public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue retValue = memState.pop();
        this.checkNotNullable(memState, retValue, NullabilityProblemKind.nullableReturn.problem(instruction.getReturn()));
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitArrayAccess(ArrayAccessInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        long longIdx;
        PsiArrayAccessExpression arrayExpression = instruction.getExpression();
        DfaValue index = memState.pop();
        DfaValue array = this.dereference(memState, memState.pop(), NullabilityProblemKind.arrayAccessNPE.problem(arrayExpression));
        boolean alwaysOutOfBounds = false;
        DfaValueFactory factory = runner.getFactory();
        if (index != DfaUnknownValue.getInstance()) {
            DfaValue indexLessThanLength;
            DfaValue dfaLength;
            DfaValue indexNonNegative = factory.createCondition(index, DfaRelationValue.RelationType.GE, factory.getInt(0));
            if (!memState.applyCondition(indexNonNegative)) {
                alwaysOutOfBounds = true;
            }
            if ((dfaLength = SpecialField.ARRAY_LENGTH.createValue(factory, array)) != null && !memState.applyCondition(indexLessThanLength = factory.createCondition(index, DfaRelationValue.RelationType.LT, dfaLength))) {
                alwaysOutOfBounds = true;
            }
        }
        this.processArrayAccess(arrayExpression, alwaysOutOfBounds);
        DfaValue result = instruction.getValue();
        LongRangeSet rangeSet = memState.getValueFact(index, DfaFactType.RANGE);
        if (rangeSet != null && !rangeSet.isEmpty() && rangeSet.min() == rangeSet.max() && (longIdx = rangeSet.min()) >= 0L && longIdx <= Integer.MAX_VALUE) {
            int intIdx = (int)longIdx;
            DfaValue arrayElementValue = runner.getFactory().getExpressionFactory().getArrayElementValue(array, intIdx);
            if (arrayElementValue != null) {
                result = arrayElementValue;
            }
        }
        memState.push(result);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void processArrayAccess(PsiArrayAccessExpression expression2, boolean alwaysOutOfBounds) {
    }

    @Override
    public DfaInstructionState[] visitFieldReference(DereferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiExpression expression2 = instruction.getExpression();
        DfaValue qualifier = this.dereference(memState, memState.pop(), NullabilityProblemKind.fieldAccessNPE.problem(expression2));
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiMethodReferenceExpression) {
            this.handleMethodReference(qualifier, (PsiMethodReferenceExpression)parent, runner, memState);
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private void handleMethodReference(DfaValue qualifier, PsiMethodReferenceExpression methodRef, DataFlowRunner runner, DfaMemoryState state) {
        PsiType functionalInterfaceType = methodRef.getFunctionalInterfaceType();
        if (functionalInterfaceType == null) {
            return;
        }
        PsiMethod sam2 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        if (sam2 == null || PsiType.VOID.equals((Object)sam2.getReturnType())) {
            return;
        }
        JavaResolveResult resolveResult = methodRef.advancedResolve(false);
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)resolveResult.getElement(), PsiMethod.class);
        if (method == null || !ControlFlowAnalyzer.isPure(method)) {
            return;
        }
        List<? extends MethodContract> contracts2 = ControlFlowAnalyzer.getMethodCallContracts(method, null);
        if (contracts2.isEmpty()) {
            return;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        DfaCallArguments callArguments = StandardInstructionVisitor.getMethodReferenceCallArguments(methodRef, qualifier, runner, sam2, method, substitutor);
        PsiType returnType = substitutor.substitute(method.getReturnType());
        DfaValue defaultResult = runner.getFactory().createTypeValue(returnType, DfaPsiUtil.getElementNullability(returnType, (PsiModifierListOwner)method));
        Stream<DfaValue> returnValues = StandardInstructionVisitor.possibleReturnValues(callArguments, state, contracts2, runner.getFactory(), defaultResult);
        returnValues.forEach(res -> this.processMethodReferenceResult(methodRef, contracts2, (DfaValue)res));
    }

    @NotNull
    private static DfaCallArguments getMethodReferenceCallArguments(PsiMethodReferenceExpression methodRef, DfaValue qualifier, DataFlowRunner runner, PsiMethod sam2, PsiMethod method, PsiSubstitutor substitutor) {
        PsiParameter[] samParameters = sam2.getParameterList().getParameters();
        boolean isStatic = method.hasModifierProperty("static");
        boolean instanceBound = !isStatic && !PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef);
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        Object[] arguments = new DfaValue[parameters2.length];
        Arrays.fill(arguments, DfaUnknownValue.getInstance());
        for (int i = 0; i < samParameters.length; ++i) {
            DfaValue value2 = runner.getFactory().createTypeValue(substitutor.substitute(samParameters[i].getType()), DfaPsiUtil.getFunctionalParameterNullability((PsiFunctionalExpression)methodRef, i));
            if (i == 0 && !isStatic && !instanceBound) {
                qualifier = value2;
                continue;
            }
            int idx = i - (isStatic || instanceBound ? 0 : 1);
            if (idx >= arguments.length) break;
            if (parameters2[idx].getType() instanceof PsiEllipsisType) continue;
            arguments[idx] = value2;
        }
        DfaCallArguments dfaCallArguments = new DfaCallArguments(qualifier, (DfaValue[])arguments);
        if (dfaCallArguments == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(1);
        }
        return dfaCallArguments;
    }

    private static Stream<DfaValue> possibleReturnValues(DfaCallArguments callArguments, DfaMemoryState state, List<? extends MethodContract> contracts2, DfaValueFactory factory, DfaValue defaultResult) {
        LinkedHashSet<DfaMemoryState> currentStates = ContainerUtil.newLinkedHashSet((Object[])new DfaMemoryState[]{state.createClosureState()});
        LinkedHashSet finalStates = ContainerUtil.newLinkedHashSet();
        for (MethodContract methodContract : contracts2) {
            DfaValue result = methodContract.getDfaReturnValue(factory, defaultResult);
            currentStates = StandardInstructionVisitor.addContractResults(callArguments, methodContract, currentStates, factory, finalStates, result);
        }
        return ((StreamEx)StreamEx.of((Collection)finalStates).map(DfaMemoryState::peek).append((Stream)(currentStates.isEmpty() ? StreamEx.empty() : StreamEx.of((Object)defaultResult)))).distinct();
    }

    protected void processMethodReferenceResult(PsiMethodReferenceExpression methodRef, List<? extends MethodContract> contracts2, DfaValue res) {
    }

    @Override
    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiType type2 = instruction.getCastTo();
        DfaValueFactory factory = runner.getFactory();
        PsiType fromType = instruction.getCasted().getType();
        if (fromType != null && type2.isConvertibleFrom(fromType) && !memState.castTopOfStack(factory.createDfaType(type2))) {
            this.onInstructionProducesCCE(instruction);
        }
        if (type2 instanceof PsiPrimitiveType) {
            memState.push(factory.getBoxedFactory().createUnboxed(memState.pop()));
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
    }

    @Override
    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        LinkedHashSet finalStates = ContainerUtil.newLinkedHashSet();
        finalStates.addAll(this.handleKnownMethods(instruction, runner, memState));
        if (finalStates.isEmpty()) {
            DfaCallArguments callArguments = this.popCall(instruction, runner, memState, true);
            LinkedHashSet currentStates = ContainerUtil.newLinkedHashSet((Object[])new DfaMemoryState[]{memState});
            DfaValue resultValue = StandardInstructionVisitor.getMethodResultValue(instruction, callArguments.myQualifier, memState, runner.getFactory());
            if (callArguments.myArguments != null) {
                for (MethodContract contract : instruction.getContracts()) {
                    DfaValue returnValue = contract.getDfaReturnValue(runner.getFactory(), resultValue);
                    if ((currentStates = StandardInstructionVisitor.addContractResults(callArguments, contract, currentStates, runner.getFactory(), finalStates, returnValue)).size() + finalStates.size() <= 300) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Too complex contract on " + instruction.getContext() + ", skipping contract processing");
                    }
                    finalStates.clear();
                    currentStates = ContainerUtil.newLinkedHashSet((Object[])new DfaMemoryState[]{memState});
                    break;
                }
            }
            for (DfaMemoryState state : currentStates) {
                state.push(resultValue);
                finalStates.add(state);
            }
        }
        PsiMethodReferenceExpression methodRef = instruction.getMethodType() == MethodCallInstruction.MethodType.METHOD_REFERENCE_CALL ? (PsiMethodReferenceExpression)instruction.getContext() : null;
        DfaInstructionState[] result = new DfaInstructionState[finalStates.size()];
        int i = 0;
        for (DfaMemoryState state : finalStates) {
            if (instruction.shouldFlushFields()) {
                state.flushFields();
            }
            if (methodRef != null) {
                this.processMethodReferenceResult(methodRef, instruction.getContracts(), state.peek());
            }
            result[i++] = new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), state);
        }
        return result;
    }

    @NotNull
    private List<DfaMemoryState> handleKnownMethods(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        CustomMethodHandlers.CustomMethodHandler handler = CustomMethodHandlers.find(instruction);
        if (handler == null) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(2);
            }
            return list;
        }
        memState = memState.createCopy();
        DfaCallArguments callArguments = this.popCall(instruction, runner, memState, false);
        List<DfaMemoryState> list = callArguments.myArguments == null ? Collections.emptyList() : handler.handle(callArguments, memState, runner.getFactory());
        if (list == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private DfaCallArguments popCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, boolean contractOnly) {
        PsiMethod method = instruction.getTargetMethod();
        MutationSignature sig = MutationSignature.fromMethod(method);
        DfaValue[] argValues = this.popCallArguments(instruction, runner, memState, contractOnly, sig);
        DfaValue qualifier = this.popQualifier(instruction, memState, sig);
        DfaCallArguments dfaCallArguments = new DfaCallArguments(qualifier, argValues);
        if (dfaCallArguments == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(4);
        }
        return dfaCallArguments;
    }

    @Nullable
    private DfaValue[] popCallArguments(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, boolean contractOnly, MutationSignature sig) {
        DfaValue[] argValues;
        int argCount = instruction.getArgCount();
        PsiMethod method = instruction.getTargetMethod();
        boolean varargCall = instruction.isVarArgCall();
        if (method == null || contractOnly && instruction.getContracts().isEmpty()) {
            argValues = null;
        } else {
            PsiParameterList paramList = method.getParameterList();
            int paramCount = paramList.getParametersCount();
            if (paramCount == argCount || method.isVarArgs() && argCount >= paramCount - 1) {
                argValues = new DfaValue[paramCount];
                if (varargCall) {
                    argValues[paramCount - 1] = runner.getFactory().createTypeValue(paramList.getParameters()[paramCount - 1].getType(), Nullness.NOT_NULL);
                }
            } else {
                argValues = null;
            }
        }
        for (int i = 0; i < argCount; ++i) {
            DfaValue arg = memState.pop();
            int paramIndex = argCount - i - 1;
            PsiElement anchor = instruction.getArgumentAnchor(paramIndex);
            Nullness requiredNullability = instruction.getArgRequiredNullability(paramIndex);
            if (requiredNullability == Nullness.NOT_NULL) {
                arg = this.dereference(memState, arg, NullabilityProblemKind.passingNullableToNotNullParameter.problem(anchor));
            } else if (requiredNullability == Nullness.UNKNOWN) {
                this.checkNotNullable(memState, arg, NullabilityProblemKind.passingNullableArgumentToNonAnnotatedParameter.problem(anchor));
            }
            if (sig.mutatesArg(paramIndex) && !memState.applyFact(arg, DfaFactType.MUTABILITY, Mutability.MUTABLE)) {
                this.reportMutabilityViolation(false, anchor);
                if (arg instanceof DfaVariableValue) {
                    memState.forceVariableFact((DfaVariableValue)arg, DfaFactType.MUTABILITY, Mutability.MUTABLE);
                }
            }
            if (argValues == null || paramIndex >= argValues.length - 1 && varargCall) continue;
            argValues[paramIndex] = arg;
        }
        return argValues;
    }

    protected void reportMutabilityViolation(boolean receiver2, @NotNull PsiElement anchor) {
        if (anchor == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(5);
        }
    }

    private DfaValue popQualifier(MethodCallInstruction instruction, DfaMemoryState memState, MutationSignature sig) {
        DfaValue value2 = this.dereference(memState, memState.pop(), instruction.getQualifierNullabilityProblem());
        if (sig.mutatesThis() && !memState.applyFact(value2, DfaFactType.MUTABILITY, Mutability.MUTABLE)) {
            this.reportMutabilityViolation(true, instruction.getContext());
            if (value2 instanceof DfaVariableValue) {
                memState.forceVariableFact((DfaVariableValue)value2, DfaFactType.MUTABILITY, Mutability.MUTABLE);
            }
        }
        return value2;
    }

    private static LinkedHashSet<DfaMemoryState> addContractResults(DfaCallArguments callArguments, MethodContract contract, LinkedHashSet<DfaMemoryState> states, DfaValueFactory factory, Set<DfaMemoryState> finalStates, DfaValue returnValue) {
        List conditions = ContainerUtil.map(contract.getConditions(), cv -> cv.makeDfaValue(factory, callArguments));
        if (StreamEx.of((Collection)conditions).allMatch(factory.getConstFactory().getTrue()::equals)) {
            for (DfaMemoryState state : states) {
                state.push(returnValue);
                finalStates.add(state);
            }
            return new LinkedHashSet<DfaMemoryState>();
        }
        if (StreamEx.of((Collection)conditions).has((Object)factory.getConstFactory().getFalse())) {
            return states;
        }
        LinkedHashSet falseStates = ContainerUtil.newLinkedHashSet();
        LinkedHashSet trueStates = ContainerUtil.newLinkedHashSet();
        for (DfaMemoryState state : states) {
            for (DfaValue condition2 : conditions) {
                DfaMemoryState falseState;
                if (condition2 == null) {
                    condition2 = DfaUnknownValue.getInstance();
                }
                if ((falseState = state.createCopy()).applyContractCondition(condition2.createNegated())) {
                    falseStates.add(falseState);
                }
                if (state.applyContractCondition(condition2)) continue;
                state = null;
                break;
            }
            if (state == null) continue;
            trueStates.add(state);
        }
        for (DfaMemoryState state : trueStates) {
            state.push(returnValue);
            finalStates.add(state);
        }
        return falseStates;
    }

    private <T extends PsiElement> DfaValue dereference(DfaMemoryState memState, DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<T> problem) {
        if (this.checkNotNullable(memState, value2, problem)) {
            return value2;
        }
        if (value2 instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)value2).withFact(DfaFactType.CAN_BE_NULL, false);
        }
        if (memState.isNull(value2) && NullabilityProblemKind.nullableFunctionReturn.isMyProblem(problem)) {
            return value2.getFactory().getFactValue(DfaFactType.CAN_BE_NULL, false);
        }
        if (value2 instanceof DfaVariableValue) {
            memState.forceVariableFact((DfaVariableValue)value2, DfaFactType.CAN_BE_NULL, false);
        }
        return value2;
    }

    @NotNull
    private static PsiMethod findSpecificMethod(@NotNull PsiMethod method, @NotNull DfaMemoryState state, @Nullable DfaValue qualifier) {
        if (method == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(6);
        }
        if (state == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(7);
        }
        if (qualifier == null || !PsiUtil.canBeOverridden((PsiMethod)method)) {
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(8);
            }
            return psiMethod;
        }
        TypeConstraint constraint = state.getValueFact(qualifier, DfaFactType.TYPE_CONSTRAINT);
        PsiType type2 = constraint == null ? null : constraint.getPsiType();
        PsiMethod psiMethod = MethodUtils.findSpecificMethod(method, type2);
        if (psiMethod == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(9);
        }
        return psiMethod;
    }

    @NotNull
    private static DfaValue getMethodResultValue(MethodCallInstruction instruction, @Nullable DfaValue qualifierValue, DfaMemoryState state, DfaValueFactory factory) {
        DfaValue precalculated = instruction.getPrecalculatedReturnValue();
        if (precalculated != null) {
            DfaValue dfaValue = precalculated;
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(10);
            }
            return dfaValue;
        }
        PsiType type2 = instruction.getResultType();
        MethodCallInstruction.MethodType methodType = instruction.getMethodType();
        if (methodType == MethodCallInstruction.MethodType.METHOD_REFERENCE_CALL && qualifierValue instanceof DfaVariableValue) {
            PsiMethod method = instruction.getTargetMethod();
            for (SpecialField sf : SpecialField.values()) {
                if (!sf.isMyAccessor((PsiModifierListOwner)method)) continue;
                DfaValue dfaValue = sf.createValue(factory, qualifierValue);
                if (dfaValue == null) {
                    StandardInstructionVisitor.$$$reportNull$$$0(11);
                }
                return dfaValue;
            }
            PsiModifierListOwner modifierListOwner = DfaExpressionFactory.getAccessedVariableOrGetter((PsiElement)method);
            if (modifierListOwner != null) {
                DfaVariableValue dfaVariableValue = factory.getVarFactory().createVariableValue(modifierListOwner, instruction.getResultType(), false, (DfaVariableValue)qualifierValue);
                if (dfaVariableValue == null) {
                    StandardInstructionVisitor.$$$reportNull$$$0(12);
                }
                return dfaVariableValue;
            }
        }
        if (methodType == MethodCallInstruction.MethodType.UNBOXING) {
            DfaValue dfaValue = factory.getBoxedFactory().createUnboxed(qualifierValue);
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(13);
            }
            return dfaValue;
        }
        if (methodType == MethodCallInstruction.MethodType.BOXING) {
            DfaValue boxed = factory.getBoxedFactory().createBoxed(qualifierValue);
            DfaValue dfaValue = boxed == null ? factory.createTypeValue(type2, Nullness.NOT_NULL) : boxed;
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(14);
            }
            return dfaValue;
        }
        if (methodType == MethodCallInstruction.MethodType.CAST) {
            assert (qualifierValue != null);
            if (qualifierValue instanceof DfaConstValue) {
                Object casted = TypeConversionUtil.computeCastTo((Object)((DfaConstValue)qualifierValue).getValue(), (PsiType)type2);
                DfaConstValue dfaConstValue = factory.getConstFactory().createFromValue(casted, type2, ((DfaConstValue)qualifierValue).getConstant());
                if (dfaConstValue == null) {
                    StandardInstructionVisitor.$$$reportNull$$$0(15);
                }
                return dfaConstValue;
            }
            DfaValue dfaValue = qualifierValue;
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(16);
            }
            return dfaValue;
        }
        if (type2 != null && !(type2 instanceof PsiPrimitiveType)) {
            Nullness nullability = instruction.getReturnNullability();
            PsiMethod targetMethod = instruction.getTargetMethod();
            Mutability mutable = Mutability.UNKNOWN;
            if (targetMethod != null) {
                mutable = Mutability.getMutability((PsiModifierListOwner)targetMethod);
                PsiMethod realMethod = StandardInstructionVisitor.findSpecificMethod(targetMethod, state, qualifierValue);
                if (realMethod != targetMethod) {
                    nullability = DfaPsiUtil.getElementNullability(type2, (PsiModifierListOwner)realMethod);
                    mutable = Mutability.getMutability((PsiModifierListOwner)realMethod);
                    PsiType returnType = realMethod.getReturnType();
                    if (returnType != null && TypeConversionUtil.erasure((PsiType)type2).isAssignableFrom(returnType)) {
                        type2 = returnType;
                    }
                }
                if (nullability == Nullness.UNKNOWN) {
                    nullability = factory.suggestNullabilityForNonAnnotatedMember((PsiModifierListOwner)targetMethod);
                }
            }
            DfaValue value2 = factory.createTypeValue(type2, nullability);
            DfaValue dfaValue = factory.withFact(value2, DfaFactType.MUTABILITY, mutable);
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(17);
            }
            return dfaValue;
        }
        LongRangeSet range = LongRangeSet.fromType(type2);
        if (range != null) {
            PsiCall call = instruction.getCallExpression();
            if (call instanceof PsiMethodCallExpression) {
                range = range.intersect(LongRangeSet.fromPsiElement((PsiModifierListOwner)call.resolveMethod()));
            }
            DfaValue dfaValue = factory.getFactValue(DfaFactType.RANGE, range);
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(18);
            }
            return dfaValue;
        }
        DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
        if (dfaUnknownValue == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(19);
        }
        return dfaUnknownValue;
    }

    protected boolean checkNotNullable(DfaMemoryState state, DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
        boolean notNullable = state.checkNotNullable(value2);
        if (notNullable && !NullabilityProblemKind.passingNullableArgumentToNonAnnotatedParameter.isMyProblem(problem)) {
            DfaValueFactory factory = ((DfaMemoryStateImpl)state).getFactory();
            state.applyCondition(factory.createCondition(value2, DfaRelationValue.RelationType.NE, factory.getConstFactory().getNull()));
        }
        return notNullable;
    }

    @Override
    public DfaInstructionState[] visitCheckNotNull(CheckNotNullInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue result = this.dereference(memState, memState.pop(), instruction.getProblem());
        memState.push(result);
        return super.visitCheckNotNull(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        this.myReachable.add(instruction);
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        IElementType opSign = instruction.getOperationSign();
        DfaRelationValue.RelationType relationType = DfaRelationValue.RelationType.fromElementType(opSign);
        if (relationType != null) {
            DfaInstructionState[] states = StandardInstructionVisitor.handleConstantComparison(instruction, runner, memState, dfaRight, dfaLeft, relationType);
            if (states == null) {
                states = this.handleRelationBinop(instruction, runner, memState, dfaRight, dfaLeft, relationType);
            }
            if (states != null) {
                return states;
            }
        }
        DfaValue result = null;
        if (JavaTokenType.AND == opSign) {
            LongRangeSet left = memState.getValueFact(dfaLeft, DfaFactType.RANGE);
            LongRangeSet right = memState.getValueFact(dfaRight, DfaFactType.RANGE);
            if (left != null && right != null) {
                result = runner.getFactory().getFactValue(DfaFactType.RANGE, left.bitwiseAnd(right));
            }
        } else if (JavaTokenType.PERC == opSign) {
            LongRangeSet left = memState.getValueFact(dfaLeft, DfaFactType.RANGE);
            LongRangeSet right = memState.getValueFact(dfaRight, DfaFactType.RANGE);
            if (left != null && right != null) {
                result = runner.getFactory().getFactValue(DfaFactType.RANGE, left.mod(right));
            }
        } else if (JavaTokenType.PLUS == opSign) {
            PsiType type2;
            PsiElement expr = instruction.getPsiAnchor();
            PsiType psiType = type2 = expr instanceof PsiExpression ? ((PsiExpression)expr).getType() : null;
            if (PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2)) {
                LongRangeSet left = memState.getValueFact(dfaLeft, DfaFactType.RANGE);
                LongRangeSet right = memState.getValueFact(dfaRight, DfaFactType.RANGE);
                if (left != null && right != null) {
                    result = runner.getFactory().getFactValue(DfaFactType.RANGE, left.plus(right, PsiType.LONG.equals((Object)type2)));
                }
            } else {
                result = instruction.getNonNullStringValue(runner.getFactory());
            }
        } else if (JavaTokenType.MINUS == opSign) {
            PsiType type3;
            PsiElement expr = instruction.getPsiAnchor();
            PsiType psiType = type3 = expr instanceof PsiExpression ? ((PsiExpression)expr).getType() : null;
            if (PsiType.INT.equals((Object)type3) || PsiType.LONG.equals((Object)type3)) {
                LongRangeSet left = memState.getValueFact(dfaLeft, DfaFactType.RANGE);
                LongRangeSet right = memState.getValueFact(dfaRight, DfaFactType.RANGE);
                if (left != null && right != null) {
                    result = runner.getFactory().getFactValue(DfaFactType.RANGE, left.minus(right, PsiType.LONG.equals((Object)type3)));
                }
            }
        } else if (instruction instanceof InstanceofInstruction) {
            this.handleInstanceof((InstanceofInstruction)instruction, dfaRight, dfaLeft);
        }
        memState.push(result == null ? DfaUnknownValue.getInstance() : result);
        instruction.setTrueReachable();
        instruction.setFalseReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Nullable
    private DfaInstructionState[] handleRelationBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft, DfaRelationValue.RelationType relationType) {
        DfaValueFactory factory = runner.getFactory();
        Instruction next = runner.getInstruction(instruction.getIndex() + 1);
        DfaRelationValue.RelationType[] relations = StandardInstructionVisitor.splitRelation(relationType);
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(relations.length);
        for (int i = 0; i < relations.length; ++i) {
            DfaMemoryState copy;
            DfaRelationValue.RelationType relation = relations[i];
            DfaValue condition2 = factory.createCondition(dfaLeft, relation, dfaRight);
            if (condition2 instanceof DfaUnknownValue) {
                return null;
            }
            if (condition2 instanceof DfaConstValue && Boolean.FALSE.equals(((DfaConstValue)condition2).getValue())) continue;
            DfaMemoryState dfaMemoryState = copy = i == relations.length - 1 ? memState : memState.createCopy();
            if (!copy.applyCondition(condition2)) continue;
            boolean isTrue = relationType.isSubRelation(relation);
            copy.push(factory.getBoolean(isTrue));
            if (isTrue) {
                instruction.setTrueReachable();
            } else {
                if (instruction instanceof InstanceofInstruction && !copy.isNull(dfaLeft)) {
                    this.myUsefulInstanceofs.add((InstanceofInstruction)instruction);
                }
                instruction.setFalseReachable();
            }
            states.add(new DfaInstructionState(next, copy));
        }
        this.myCanBeNullInInstanceof.add(instruction);
        return states.toArray(new DfaInstructionState[states.size()]);
    }

    @NotNull
    private static DfaRelationValue.RelationType[] splitRelation(DfaRelationValue.RelationType relationType) {
        switch (relationType) {
            case LT: 
            case LE: 
            case GT: 
            case GE: {
                DfaRelationValue.RelationType[] relationTypeArray = new DfaRelationValue.RelationType[]{DfaRelationValue.RelationType.LT, DfaRelationValue.RelationType.GT, DfaRelationValue.RelationType.EQ};
                if (relationTypeArray == null) {
                    StandardInstructionVisitor.$$$reportNull$$$0(20);
                }
                return relationTypeArray;
            }
        }
        DfaRelationValue.RelationType[] relationTypeArray = new DfaRelationValue.RelationType[]{relationType, relationType.getNegated()};
        if (relationTypeArray == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(21);
        }
        return relationTypeArray;
    }

    private void handleInstanceof(InstanceofInstruction instruction, DfaValue dfaRight, DfaValue dfaLeft) {
        if (dfaLeft instanceof DfaFactMapValue && dfaRight instanceof DfaFactMapValue) {
            DfaFactMapValue left = (DfaFactMapValue)dfaLeft;
            DfaFactMapValue right = (DfaFactMapValue)dfaRight;
            if (!Boolean.FALSE.equals(left.get(DfaFactType.CAN_BE_NULL))) {
                this.myCanBeNullInInstanceof.add(instruction);
            }
            if (right.getFacts().with(DfaFactType.CAN_BE_NULL, null).isSuperStateOf(left.getFacts())) {
                return;
            }
        }
        this.myUsefulInstanceofs.add(instruction);
    }

    @Nullable
    private static DfaInstructionState[] handleConstantComparison(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft, DfaRelationValue.RelationType relationType) {
        DfaInstructionState[] result;
        Object value2;
        if (dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaVariableValue) {
            Number leftValue = StandardInstructionVisitor.getKnownNumberValue(memState, (DfaVariableValue)dfaLeft);
            Number rightValue = StandardInstructionVisitor.getKnownNumberValue(memState, (DfaVariableValue)dfaRight);
            if (leftValue != null && rightValue != null) {
                return StandardInstructionVisitor.checkComparisonWithKnownValue(instruction, runner, memState, relationType, leftValue, rightValue);
            }
        }
        if (dfaRight instanceof DfaConstValue && dfaLeft instanceof DfaVariableValue && (value2 = ((DfaConstValue)dfaRight).getValue()) instanceof Number && (result = StandardInstructionVisitor.checkComparingWithConstant(instruction, runner, memState, (DfaVariableValue)dfaLeft, relationType, (Number)value2)) != null) {
            return result;
        }
        if (dfaRight instanceof DfaVariableValue && dfaLeft instanceof DfaConstValue) {
            return StandardInstructionVisitor.handleConstantComparison(instruction, runner, memState, dfaLeft, dfaRight, relationType.getFlipped());
        }
        if (relationType != DfaRelationValue.RelationType.EQ && relationType != DfaRelationValue.RelationType.NE) {
            return null;
        }
        if (dfaLeft instanceof DfaConstValue && dfaRight instanceof DfaConstValue || dfaLeft == runner.getFactory().getConstFactory().getContractFail() || dfaRight == runner.getFactory().getConstFactory().getContractFail()) {
            boolean negated;
            if (dfaLeft == dfaRight ^ (negated = relationType == DfaRelationValue.RelationType.NE ^ (DfaMemoryStateImpl.isNaN(dfaLeft) || DfaMemoryStateImpl.isNaN(dfaRight)))) {
                return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
            }
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        return null;
    }

    @Nullable
    private static DfaInstructionState[] checkComparingWithConstant(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaVariableValue var, DfaRelationValue.RelationType opSign, Number comparedWith) {
        Number knownValue = StandardInstructionVisitor.getKnownNumberValue(memState, var);
        if (knownValue != null) {
            return StandardInstructionVisitor.checkComparisonWithKnownValue(instruction, runner, memState, opSign, knownValue, comparedWith);
        }
        return null;
    }

    @Nullable
    private static Number getKnownNumberValue(DfaMemoryState memState, DfaVariableValue var) {
        DfaConstValue knownConstantValue = memState.getConstantValue(var);
        return knownConstantValue != null && knownConstantValue.getValue() instanceof Number ? (Number)((Number)knownConstantValue.getValue()) : (Number)null;
    }

    private static DfaInstructionState[] checkComparisonWithKnownValue(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaRelationValue.RelationType opSign, Number leftValue, Number rightValue) {
        boolean hasNaN;
        int cmp = StandardInstructionVisitor.compare(leftValue, rightValue);
        Boolean result = null;
        boolean bl = hasNaN = DfaUtil.isNaN(leftValue) || DfaUtil.isNaN(rightValue);
        if (cmp < 0 || cmp > 0) {
            if (opSign == DfaRelationValue.RelationType.EQ) {
                result = false;
            } else if (opSign == DfaRelationValue.RelationType.NE) {
                result = true;
            }
        }
        if (opSign == DfaRelationValue.RelationType.LT) {
            result = !hasNaN && cmp < 0;
        } else if (opSign == DfaRelationValue.RelationType.GT) {
            result = !hasNaN && cmp > 0;
        } else if (opSign == DfaRelationValue.RelationType.LE) {
            result = !hasNaN && cmp <= 0;
        } else if (opSign == DfaRelationValue.RelationType.GE) {
            result = !hasNaN && cmp >= 0;
        }
        if (result == null) {
            return null;
        }
        return result != false ? StandardInstructionVisitor.alwaysTrue(instruction, runner, memState) : StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
    }

    private static int compare(Number a, Number b) {
        long bLong;
        long aLong = a.longValue();
        if (aLong != (bLong = b.longValue())) {
            return aLong > bLong ? 1 : -1;
        }
        return Double.compare(a.doubleValue(), b.doubleValue());
    }

    private static DfaInstructionState[] alwaysFalse(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.push(runner.getFactory().getConstFactory().getFalse());
        instruction.setFalseReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private static DfaInstructionState[] alwaysTrue(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.push(runner.getFactory().getConstFactory().getTrue());
        instruction.setTrueReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public boolean isInstanceofRedundant(InstanceofInstruction instruction) {
        return !this.myUsefulInstanceofs.contains(instruction) && !instruction.isConditionConst() && this.myReachable.contains(instruction);
    }

    public boolean canBeNull(BinopInstruction instruction) {
        return this.myCanBeNullInInstanceof.contains(instruction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodReferenceCallArguments";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "handleKnownMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "popCall";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findSpecificMethod";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodResultValue";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "splitRelation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportMutabilityViolation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSpecificMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

