/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public final class StandardMethodContract
extends MethodContract {
    public final MethodContract.ValueConstraint[] arguments;
    public final MethodContract.ValueConstraint returnValue;

    public StandardMethodContract(@NotNull MethodContract.ValueConstraint[] arguments, @NotNull MethodContract.ValueConstraint returnValue) {
        if (arguments == null) {
            StandardMethodContract.$$$reportNull$$$0(0);
        }
        if (returnValue == null) {
            StandardMethodContract.$$$reportNull$$$0(1);
        }
        this.arguments = arguments;
        this.returnValue = returnValue;
    }

    @Override
    public MethodContract.ValueConstraint getReturnValue() {
        return this.returnValue;
    }

    @NotNull
    static MethodContract.ValueConstraint[] createConstraintArray(int paramCount) {
        MethodContract.ValueConstraint[] args = new MethodContract.ValueConstraint[paramCount];
        for (int i = 0; i < args.length; ++i) {
            args[i] = MethodContract.ValueConstraint.ANY_VALUE;
        }
        if (args == null) {
            StandardMethodContract.$$$reportNull$$$0(2);
        }
        return args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StandardMethodContract contract = (StandardMethodContract)o;
        if (!Arrays.equals((Object[])this.arguments, (Object[])contract.arguments)) {
            return false;
        }
        return this.returnValue == contract.returnValue;
    }

    public int hashCode() {
        int result = 0;
        for (MethodContract.ValueConstraint argument : this.arguments) {
            result = 31 * result + argument.ordinal();
        }
        result = 31 * result + this.returnValue.ordinal();
        return result;
    }

    @Override
    String getArgumentsPresentation() {
        return StringUtil.join((Object[])this.arguments, constraint -> constraint.toString(), (String)", ");
    }

    @Override
    public List<ContractValue> getConditions() {
        return IntStreamEx.ofIndices((Object[])this.arguments).mapToObj(idx -> this.arguments[idx].getCondition(idx)).without((Object)ContractValue.booleanValue(true)).toList();
    }

    public static List<StandardMethodContract> parseContract(String text2) throws ParseException {
        ArrayList result = ContainerUtil.newArrayList();
        for (String clause : StringUtil.replace((String)text2, (String)" ", (String)"").split(";")) {
            MethodContract.ValueConstraint[] args;
            String arrow = "->";
            int arrowIndex = clause.indexOf(arrow);
            if (arrowIndex < 0) {
                throw new ParseException("A contract clause must be in form arg1, ..., argN -> return-value");
            }
            String beforeArrow = clause.substring(0, arrowIndex);
            if (StringUtil.isNotEmpty((String)beforeArrow)) {
                String[] argStrings = beforeArrow.split(",");
                args = new MethodContract.ValueConstraint[argStrings.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = StandardMethodContract.parseConstraint(argStrings[i]);
                }
            } else {
                args = new MethodContract.ValueConstraint[]{};
            }
            result.add(new StandardMethodContract(args, StandardMethodContract.parseConstraint(clause.substring(arrowIndex + arrow.length()))));
        }
        return result;
    }

    private static MethodContract.ValueConstraint parseConstraint(String name) throws ParseException {
        if (StringUtil.isEmpty((String)name)) {
            throw new ParseException("Constraint should not be empty");
        }
        for (MethodContract.ValueConstraint constraint : MethodContract.ValueConstraint.values()) {
            if (!constraint.toString().equals(name)) continue;
            return constraint;
        }
        throw new ParseException("Constraint should be one of: null, !null, true, false, fail, _. Found: " + name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StandardMethodContract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StandardMethodContract";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstraintArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ParseException
    extends Exception {
        private ParseException(String message2) {
            super(message2);
        }
    }
}

