/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaExpressionFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory");
    private static final Condition<String> FALSE_GETTERS = DfaExpressionFactory.parseFalseGetters();
    private final DfaValueFactory myFactory;
    private final Map<Integer, PsiVariable> myMockIndices = ContainerUtil.newHashMap();

    private static Condition<String> parseFalseGetters() {
        try {
            String regex = Registry.stringValue((String)"ide.dfa.getters.with.side.effects").trim();
            if (!StringUtil.isEmpty((String)regex)) {
                Pattern pattern = Pattern.compile(regex);
                return s -> pattern.matcher((CharSequence)s).matches();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return Conditions.alwaysFalse();
    }

    DfaExpressionFactory(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    @Nullable
    public DfaValue getExpressionDfaValue(@Nullable PsiExpression expression2) {
        PsiType type2;
        DfaVariableValue qualifier;
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            return this.getExpressionDfaValue(((PsiParenthesizedExpression)expression2).getExpression());
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            DfaValue arrayElementValue;
            Object index;
            PsiExpression arrayExpression = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            qualifier = this.getQualifierVariable(arrayExpression);
            if (qualifier != null && (index = ExpressionUtils.computeConstantExpression(((PsiArrayAccessExpression)expression2).getIndexExpression())) instanceof Integer && (arrayElementValue = this.getArrayElementValue(qualifier, (Integer)index)) != null) {
                return arrayElementValue;
            }
            PsiType type3 = expression2.getType();
            if (type3 != null) {
                return this.myFactory.createTypeValue(type3, DfaPsiUtil.getElementNullability(type3, null));
            }
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return this.createReferenceValue(((PsiMethodCallExpression)expression2).getMethodExpression());
        }
        if (expression2 instanceof PsiReferenceExpression) {
            return this.createReferenceValue((PsiReferenceExpression)expression2);
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return this.myFactory.createLiteralValue((PsiLiteralExpression)expression2);
        }
        if (expression2 instanceof PsiNewExpression || expression2 instanceof PsiLambdaExpression) {
            return this.myFactory.createTypeValue(expression2.getType(), Nullness.NOT_NULL);
        }
        Object value2 = JavaConstantExpressionEvaluator.computeConstantExpression(expression2, false);
        if (value2 != null && (type2 = expression2.getType()) != null) {
            return this.myFactory.getConstFactory().createFromValue(value2, type2, null);
        }
        if (expression2 instanceof PsiThisExpression) {
            PsiElement target;
            qualifier = ((PsiThisExpression)expression2).getQualifier();
            PsiElement psiElement = target = qualifier == null ? null : qualifier.resolve();
            if (target instanceof PsiClass) {
                return this.myFactory.getVarFactory().createVariableValue((PsiModifierListOwner)target, null, false, null);
            }
        }
        return null;
    }

    private DfaValue createReferenceValue(@NotNull PsiReferenceExpression refExpr) {
        DfaValue specialValue;
        if (refExpr == null) {
            DfaExpressionFactory.$$$reportNull$$$0(0);
        }
        if ((specialValue = this.createFromSpecialField(refExpr)) != null) {
            return specialValue;
        }
        PsiModifierListOwner var = DfaExpressionFactory.getAccessedVariableOrGetter(refExpr.resolve());
        if (var == null) {
            return null;
        }
        if (!var.hasModifierProperty("volatile")) {
            DfaValue constValue;
            if (var instanceof PsiVariable && var.hasModifierProperty("final") && !PsiUtil.isAccessedForWriting((PsiExpression)refExpr) && (constValue = this.myFactory.getConstFactory().create((PsiVariable)var)) != null && !DfaExpressionFactory.maybeUninitializedConstant(constValue, refExpr, var)) {
                return constValue;
            }
            if (ExpressionUtil.isEffectivelyUnqualified(refExpr) || DfaExpressionFactory.isStaticFinalConstantWithoutInitializationHacks(var) || var instanceof PsiMethod && var.hasModifierProperty("static")) {
                return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType(), false, null);
            }
            DfaVariableValue qualifier = this.getQualifierVariable(refExpr.getQualifierExpression());
            if (qualifier != null) {
                return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType(), false, qualifier);
            }
        }
        PsiType type2 = refExpr.getType();
        return this.myFactory.createTypeValue(type2, DfaPsiUtil.getElementNullability(type2, var));
    }

    private DfaVariableValue getQualifierVariable(PsiExpression qualifierExpression2) {
        Object constValue;
        DfaValue qualifierValue = this.getExpressionDfaValue(qualifierExpression2);
        DfaVariableValue qualifier = null;
        if (qualifierValue instanceof DfaVariableValue) {
            qualifier = (DfaVariableValue)qualifierValue;
        } else if (qualifierValue instanceof DfaConstValue && (constValue = ((DfaConstValue)qualifierValue).getValue()) instanceof PsiVariable) {
            qualifier = this.myFactory.getVarFactory().createVariableValue((PsiVariable)constValue, false);
        }
        return qualifier;
    }

    private static boolean maybeUninitializedConstant(DfaValue constValue, @NotNull PsiReferenceExpression refExpr, PsiModifierListOwner var) {
        if (refExpr == null) {
            DfaExpressionFactory.$$$reportNull$$$0(1);
        }
        if (!(constValue instanceof DfaConstValue) || ((DfaConstValue)constValue).getValue() != var) {
            return false;
        }
        if (!(var instanceof PsiField) || var instanceof PsiEnumConstant) {
            return false;
        }
        return PsiTreeUtil.getTopmostParentOfType((PsiElement)refExpr, PsiClass.class) == PsiTreeUtil.getTopmostParentOfType((PsiElement)var, PsiClass.class);
    }

    private static boolean isStaticFinalConstantWithoutInitializationHacks(PsiModifierListOwner var) {
        return var instanceof PsiField && var.hasModifierProperty("final") && var.hasModifierProperty("static") && !DfaUtil.hasInitializationHacks((PsiField)var);
    }

    @Nullable
    private DfaValue createFromSpecialField(PsiReferenceExpression refExpr) {
        PsiElement target = refExpr.resolve();
        if (!(target instanceof PsiModifierListOwner)) {
            return null;
        }
        for (SpecialField sf : SpecialField.values()) {
            DfaVariableValue qualifier;
            if (!sf.isMyAccessor((PsiModifierListOwner)target) || (qualifier = this.getQualifierVariable(refExpr.getQualifierExpression())) == null) continue;
            return sf.createValue(this.myFactory, qualifier);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiModifierListOwner getAccessedVariableOrGetter(PsiElement target) {
        if (target instanceof PsiVariable) {
            return (PsiVariable)target;
        }
        if (target instanceof PsiMethod) {
            String qName;
            PsiMethod method = (PsiMethod)target;
            if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method) && ControlFlowAnalyzer.getMethodCallContracts(method, null).isEmpty() && ((qName = PsiUtil.getMemberQualifiedName((PsiMember)method)) == null || !FALSE_GETTERS.value((Object)qName))) {
                return method;
            }
            if (method.getParameterList().getParametersCount() == 0 && (ControlFlowAnalyzer.isPure(method) || AnnotationUtil.findAnnotation((PsiModifierListOwner)method.getContainingClass(), (String[])new String[]{"javax.annotation.concurrent.Immutable"}) != null) && ControlFlowAnalyzer.getMethodCallContracts(method, null).isEmpty()) {
                return method;
            }
        }
        return null;
    }

    public DfaValue getArrayElementValue(DfaValue array, int index) {
        PsiExpression constantArrayElement;
        if (!(array instanceof DfaVariableValue)) {
            return null;
        }
        DfaVariableValue arrayDfaVar = (DfaVariableValue)array;
        PsiType type2 = arrayDfaVar.getVariableType();
        if (!(type2 instanceof PsiArrayType)) {
            return null;
        }
        PsiType componentType = ((PsiArrayType)type2).getComponentType();
        PsiModifierListOwner arrayPsiVar = arrayDfaVar.getPsiVariable();
        if (arrayPsiVar instanceof PsiVariable && (constantArrayElement = ExpressionUtils.getConstantArrayElement((PsiVariable)arrayPsiVar, index)) != null) {
            return this.getExpressionDfaValue(constantArrayElement);
        }
        PsiVariable indexVariable = this.getArrayIndexVariable((PsiElement)arrayPsiVar, index);
        if (indexVariable == null) {
            return null;
        }
        return this.myFactory.getVarFactory().createVariableValue((PsiModifierListOwner)indexVariable, componentType, false, arrayDfaVar);
    }

    @Nullable
    private PsiVariable getArrayIndexVariable(@NotNull PsiElement anchor, int index) {
        if (anchor == null) {
            DfaExpressionFactory.$$$reportNull$$$0(2);
        }
        if (index >= 0) {
            return this.myMockIndices.computeIfAbsent(index, k -> {
                if (anchor == null) {
                    DfaExpressionFactory.$$$reportNull$$$0(3);
                }
                return new LightVariableBuilder("$array$index$" + k, (PsiType)PsiType.INT, anchor);
            });
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferenceValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "maybeUninitializedConstant";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayIndexVariable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getArrayIndexVariable$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

