/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.java18StreamApi.AddMethodsDialog;
import com.intellij.codeInspection.java18StreamApi.PseudoLambdaReplaceTemplate;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class StaticPseudoFunctionalStyleMethodOptions {
    private static final String PIPELINE_ELEMENT_NAME = "pipelineElement";
    private static final String FQN_ATTR = "classFqn";
    private static final String METHOD_ATTR = "method";
    private static final String STREAM_API_METHOD_ATTR = "streamApiMethod";
    private static final String LAMBDA_ROLE_ATTR = "lambdaRole";
    private static final String ACCEPTS_DEFAULT_ATTR = "acceptsDefault";
    private static final String DELETE_ATTR = "toDelete";
    private final List<PipelineElement> myElements = new ArrayList<PipelineElement>();

    public StaticPseudoFunctionalStyleMethodOptions() {
        StaticPseudoFunctionalStyleMethodOptions.restoreDefault(this.myElements);
    }

    private static void restoreDefault(List<PipelineElement> elements) {
        elements.clear();
        String guavaIterables = "com.google.common.collect.Iterables";
        elements.add(new PipelineElement(guavaIterables, "transform", PseudoLambdaReplaceTemplate.MAP));
        elements.add(new PipelineElement(guavaIterables, "filter", PseudoLambdaReplaceTemplate.FILTER));
        elements.add(new PipelineElement(guavaIterables, "find", PseudoLambdaReplaceTemplate.FIND));
        elements.add(new PipelineElement(guavaIterables, "all", PseudoLambdaReplaceTemplate.ALL_MATCH));
        elements.add(new PipelineElement(guavaIterables, "any", PseudoLambdaReplaceTemplate.ANY_MATCH));
        String guavaLists = "com.google.common.collect.Lists";
        elements.add(new PipelineElement(guavaLists, "transform", PseudoLambdaReplaceTemplate.MAP));
    }

    @NotNull
    public Collection<PipelineElement> findElementsByMethodName(@NotNull String methodName) {
        if (methodName == null) {
            StaticPseudoFunctionalStyleMethodOptions.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.filter(this.myElements, element -> {
            if (methodName == null) {
                StaticPseudoFunctionalStyleMethodOptions.$$$reportNull$$$0(4);
            }
            return methodName.equals(element.getMethodName());
        });
        if (list == null) {
            StaticPseudoFunctionalStyleMethodOptions.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void readExternal(@NotNull Element xmlElement) {
        if (xmlElement == null) {
            StaticPseudoFunctionalStyleMethodOptions.$$$reportNull$$$0(2);
        }
        StaticPseudoFunctionalStyleMethodOptions.restoreDefault(this.myElements);
        for (Element element : xmlElement.getChildren(PIPELINE_ELEMENT_NAME)) {
            String fqn = element.getAttributeValue(FQN_ATTR);
            String method = element.getAttributeValue(METHOD_ATTR);
            String streamApiMethod = element.getAttributeValue(STREAM_API_METHOD_ATTR);
            PseudoLambdaReplaceTemplate.LambdaRole lambdaRole = PseudoLambdaReplaceTemplate.LambdaRole.valueOf(element.getAttributeValue(LAMBDA_ROLE_ATTR));
            boolean acceptsDefault = Boolean.valueOf(element.getAttributeValue(ACCEPTS_DEFAULT_ATTR));
            boolean toDelete = element.getAttribute(DELETE_ATTR) != null;
            PipelineElement pipelineElement = new PipelineElement(fqn, method, new PseudoLambdaReplaceTemplate(streamApiMethod, lambdaRole, acceptsDefault));
            if (toDelete) {
                this.myElements.remove(pipelineElement);
                continue;
            }
            this.myElements.add(pipelineElement);
        }
    }

    public void writeExternal(@NotNull Element xmlElement) {
        if (xmlElement == null) {
            StaticPseudoFunctionalStyleMethodOptions.$$$reportNull$$$0(3);
        }
        ArrayList<PipelineElement> toRemoveElements = new ArrayList<PipelineElement>();
        StaticPseudoFunctionalStyleMethodOptions.restoreDefault(toRemoveElements);
        toRemoveElements.removeAll(this.myElements);
        for (PipelineElement element : toRemoveElements) {
            xmlElement.addContent(this.createXmlElement(element).setAttribute(DELETE_ATTR, ""));
        }
        ArrayList<PipelineElement> defaultElements = new ArrayList<PipelineElement>();
        StaticPseudoFunctionalStyleMethodOptions.restoreDefault(defaultElements);
        for (PipelineElement element : this.myElements) {
            if (defaultElements.contains(element)) continue;
            xmlElement.addContent(this.createXmlElement(element));
        }
    }

    public Element createXmlElement(PipelineElement element) {
        PseudoLambdaReplaceTemplate template = element.getTemplate();
        return new Element(PIPELINE_ELEMENT_NAME).setAttribute(FQN_ATTR, element.getHandlerClass()).setAttribute(METHOD_ATTR, element.getMethodName()).setAttribute(STREAM_API_METHOD_ATTR, template.getStreamApiMethodName()).setAttribute(LAMBDA_ROLE_ATTR, template.getLambdaRole().toString()).setAttribute(ACCEPTS_DEFAULT_ATTR, String.valueOf(template.isAcceptDefaultValue()));
    }

    public JComponent createPanel() {
        final JBList list = new JBList(this.myElements);
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<PipelineElement>(){

            protected void customizeCellRenderer(@NotNull JList list, PipelineElement element, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                String classFQName = element.getHandlerClass();
                String[] split = classFQName.split("\\.");
                int classShortNameIndex = classFQName.length() - split[split.length - 1].length();
                this.append(classFQName.substring(0, classShortNameIndex));
                this.append(classFQName.substring(classShortNameIndex), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES.derive(1, (Color)JBColor.BLUE, null, null));
                this.append("." + element.getMethodName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodOptions$1", "customizeCellRenderer"));
            }
        });
        return ToolbarDecorator.createDecorator((JList)list).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Project currentProject = (Project)CommonDataKeys.PROJECT.getData(button.getDataContext());
                if (currentProject == null) {
                    return;
                }
                if (DumbService.isDumb((Project)currentProject)) {
                    return;
                }
                AddMethodsDialog dlg = new AddMethodsDialog(currentProject, (Component)list, false);
                if (dlg.showAndGet()) {
                    PipelineElement newElement = dlg.getSelectedElement();
                    if (StaticPseudoFunctionalStyleMethodOptions.this.myElements.contains(newElement)) {
                        return;
                    }
                    StaticPseudoFunctionalStyleMethodOptions.this.myElements.add(newElement);
                    ((DefaultListModel)list.getModel()).addElement(newElement);
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int[] indices2 = list.getSelectedIndices();
                ArrayList toRemove = new ArrayList(indices2.length);
                for (int idx : indices2) {
                    toRemove.add(StaticPseudoFunctionalStyleMethodOptions.this.myElements.get(idx));
                }
                StaticPseudoFunctionalStyleMethodOptions.this.myElements.removeAll(toRemove);
                ListUtil.removeSelectedItems((JList)list);
            }
        }).createPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodOptions";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByMethodName";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findElementsByMethodName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PipelineElement {
        private final String myHandlerClass;
        private final String myMethodName;
        private final PseudoLambdaReplaceTemplate myTemplate;

        public PipelineElement(@NotNull String handlerClass, @NotNull String methodName, @NotNull PseudoLambdaReplaceTemplate template) {
            if (handlerClass == null) {
                PipelineElement.$$$reportNull$$$0(0);
            }
            if (methodName == null) {
                PipelineElement.$$$reportNull$$$0(1);
            }
            if (template == null) {
                PipelineElement.$$$reportNull$$$0(2);
            }
            this.myHandlerClass = handlerClass;
            this.myMethodName = methodName;
            this.myTemplate = template;
        }

        public String getHandlerClass() {
            return this.myHandlerClass;
        }

        public String getMethodName() {
            return this.myMethodName;
        }

        public PseudoLambdaReplaceTemplate getTemplate() {
            return this.myTemplate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipelineElement element = (PipelineElement)o;
            if (!this.myHandlerClass.equals(element.myHandlerClass)) {
                return false;
            }
            if (!this.myMethodName.equals(element.myMethodName)) {
                return false;
            }
            return this.myTemplate.equals(element.myTemplate);
        }

        public int hashCode() {
            int result = this.myHandlerClass.hashCode();
            result = 31 * result + this.myMethodName.hashCode();
            result = 31 * result + this.myTemplate.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handlerClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "template";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodOptions$PipelineElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

