/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawTypeCanBeGenericInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            RawTypeCanBeGenericInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitVariable(PsiVariable variable) {
                PsiType type2;
                super.visitVariable(variable);
                PsiTypeElement variableTypeElement = variable.getTypeElement();
                if (variableTypeElement != null && (type2 = RawTypeCanBeGenericInspection.getSuggestedType(variable)) != null) {
                    String typeText = type2.getPresentableText();
                    String message2 = InspectionsBundle.message((String)"inspection.raw.variable.type.can.be.generic.quickfix", (Object[])new Object[]{variable.getName(), typeText});
                    PsiElement beforeInitializer = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)variable.getInitializer());
                    ProblemDescriptor descriptor = holder.getManager().createProblemDescriptor((PsiElement)variableTypeElement, (PsiElement)(beforeInitializer != null ? beforeInitializer : variableTypeElement), message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{new MyLocalQuickFix(message2)});
                    holder.registerProblem(descriptor);
                }
            }
        };
        if (javaElementVisitor == null) {
            RawTypeCanBeGenericInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @Nullable
    private static PsiType getSuggestedType(@NotNull PsiVariable variable) {
        PsiExpression initializer;
        if (variable == null) {
            RawTypeCanBeGenericInspection.$$$reportNull$$$0(2);
        }
        if ((initializer = variable.getInitializer()) == null) {
            return null;
        }
        PsiType variableType = variable.getType();
        PsiType initializerType = initializer.getType();
        if (!(variableType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType variableClassType = (PsiClassType)variableType;
        if (!variableClassType.isRaw()) {
            return null;
        }
        if (!(initializerType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType initializerClassType = (PsiClassType)initializerType;
        if (initializerClassType.isRaw()) {
            return null;
        }
        PsiClassType.ClassResolveResult variableResolveResult = variableClassType.resolveGenerics();
        PsiClassType.ClassResolveResult initializerResolveResult = initializerClassType.resolveGenerics();
        if (initializerResolveResult.getElement() == null) {
            return null;
        }
        PsiClass variableResolved = variableResolveResult.getElement();
        if (variableResolved == null) {
            return null;
        }
        PsiSubstitutor targetSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)variableResolved, (PsiClass)initializerResolveResult.getElement(), (PsiSubstitutor)initializerResolveResult.getSubstitutor());
        if (targetSubstitutor == null) {
            return null;
        }
        PsiClassType type2 = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory().createType(variableResolved, targetSubstitutor);
        if (variableType.equals(type2)) {
            return null;
        }
        return type2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private String myName;

        public MyLocalQuickFix(@NotNull String name) {
            if (name == null) {
                MyLocalQuickFix.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.raw.variable.type.can.be.generic.family.quickfix", (Object[])new Object[0]);
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiVariable variable;
            PsiType type2;
            PsiElement element;
            if (project == null) {
                MyLocalQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyLocalQuickFix.$$$reportNull$$$0(4);
            }
            if ((element = descriptor.getStartElement().getParent()) instanceof PsiVariable && (type2 = RawTypeCanBeGenericInspection.getSuggestedType(variable = (PsiVariable)element)) != null) {
                TypeMigrationRules rules = new TypeMigrationRules(project);
                rules.setBoundScope(PsiSearchHelper.SERVICE.getInstance((Project)project).getUseScope((PsiElement)variable));
                TypeMigrationProcessor.runHighlightingTypeMigration(project, null, rules, (PsiElement)variable, type2, false, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection$MyLocalQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection$MyLocalQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

