/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.miscGenerics.SuspiciousMethodCallUtil;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousCollectionsMethodCallsInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean REPORT_CONVERTIBLE_METHOD_CALLS = true;

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message((String)"report.suspicious.but.possibly.correct.method.calls", (Object[])new Object[0]), (InspectionProfileEntry)this, "REPORT_CONVERTIBLE_METHOD_CALLS");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousCollectionsMethodCallsInspection.$$$reportNull$$$0(0);
        }
        final ArrayList patternMethods = new ArrayList();
        final IntArrayList indices2 = new IntArrayList();
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                String message2 = SuspiciousCollectionsMethodCallsInspection.getSuspiciousMethodCallMessage(methodCall, SuspiciousCollectionsMethodCallsInspection.this.REPORT_CONVERTIBLE_METHOD_CALLS, patternMethods, indices2);
                if (message2 != null) {
                    holder.registerProblem((PsiElement)methodCall.getArgumentList().getExpressions()[0], message2, new LocalQuickFix[0]);
                }
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiSubstitutor psiSubstitutor;
                MethodSignature signature;
                String message2;
                PsiType functionalInterfaceType = expression2.getFunctionalInterfaceType();
                PsiClassType.ClassResolveResult functionalInterfaceResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                if (interfaceMethod != null && interfaceMethod.getParameterList().getParametersCount() == 1 && (message2 = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage((PsiReferenceExpression)expression2, (signature = interfaceMethod.getSignature(psiSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)functionalInterfaceResolveResult))).getParameterTypes()[0], SuspiciousCollectionsMethodCallsInspection.this.REPORT_CONVERTIBLE_METHOD_CALLS, patternMethods, indices2)) != null) {
                    holder.registerProblem((PsiElement)ObjectUtils.notNull((Object)expression2.getReferenceNameElement(), (Object)expression2), message2, new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            SuspiciousCollectionsMethodCallsInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.suspicious.collections.method.calls.display.name", (Object[])new Object[0]);
        if (string == null) {
            SuspiciousCollectionsMethodCallsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            SuspiciousCollectionsMethodCallsInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("SuspiciousMethodCalls" == null) {
            SuspiciousCollectionsMethodCallsInspection.$$$reportNull$$$0(4);
        }
        return "SuspiciousMethodCalls";
    }

    @Nullable
    private static String getSuspiciousMethodCallMessage(PsiMethodCallExpression methodCall, boolean reportConvertibleMethodCalls, List<PsiMethod> patternMethods, IntArrayList indices2) {
        PsiType type2;
        TypeConstraint constraint;
        boolean exactType;
        PsiExpression[] args = methodCall.getArgumentList().getExpressions();
        if (args.length < 1) {
            return null;
        }
        PsiType argType = args[0].getType();
        String plainMessage = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage(methodCall, args[0], argType, (exactType = args[0] instanceof PsiNewExpression) || reportConvertibleMethodCalls, patternMethods, indices2);
        if (plainMessage != null && !exactType && (constraint = CommonDataflow.getExpressionFact(args[0], DfaFactType.TYPE_CONSTRAINT)) != null && (type2 = constraint.getPsiType()) != null && SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage(methodCall, args[0], type2, reportConvertibleMethodCalls, patternMethods, indices2) == null) {
            return null;
        }
        return plainMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

