/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.actions;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.actions.JvmPsiUtilKt$WhenMappings;
import com.intellij.lang.java.request.ExpectedJavaType;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.ExpectedType;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\u000b0\u0006j\u0002`\fH\u0000\u001a.\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0080\b\u00a2\u0006\u0002\u0010\u0014\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0003\u001a\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001cH\u0000\u001a\f\u0010\u001d\u001a\u00020\u000f*\u00020\u0002H\u0001\u001a\u0014\u0010\u001e\u001a\u00020\u001f*\u00020 2\u0006\u0010\b\u001a\u00020\tH\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006!"}, d2={"visibilityModifiers", "", "Lcom/intellij/lang/jvm/JvmModifier;", "getVisibilityModifiers", "()Ljava/util/Set;", "extractExpectedTypes", "", "Lcom/intellij/codeInsight/ExpectedTypeInfo;", "project", "Lcom/intellij/openapi/project/Project;", "expectedTypes", "Lcom/intellij/lang/jvm/actions/ExpectedType;", "Lcom/intellij/lang/jvm/actions/ExpectedTypes;", "extractNames", "", "", "suggestedNames", "Lcom/intellij/psi/codeStyle/SuggestedNameInfo;", "defaultName", "Lkotlin/Function0;", "(Lcom/intellij/psi/codeStyle/SuggestedNameInfo;Lkotlin/jvm/functions/Function0;)[Ljava/lang/String;", "toExpectedTypeInfo", "expectedType", "infoKind", "", "Lcom/intellij/lang/jvm/actions/ExpectedType$Kind;", "toJavaClassOrNull", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/lang/jvm/JvmClass;", "toPsiModifier", "toPsiSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "Lcom/intellij/lang/jvm/types/JvmSubstitutor;", "java-impl"})
public final class JvmPsiUtilKt {
    @NotNull
    private static final Set<JvmModifier> visibilityModifiers = SetsKt.setOf((Object[])new JvmModifier[]{JvmModifier.PUBLIC, JvmModifier.PROTECTED, JvmModifier.PACKAGE_LOCAL, JvmModifier.PRIVATE});

    @PsiModifier.ModifierConstant
    @NotNull
    public static final String toPsiModifier(@NotNull JvmModifier $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        switch (JvmPsiUtilKt$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                string = "public";
                break;
            }
            case 2: {
                string = "protected";
                break;
            }
            case 3: {
                string = "private";
                break;
            }
            case 4: {
                string = "packageLocal";
                break;
            }
            case 5: {
                string = "static";
                break;
            }
            case 6: {
                string = "abstract";
                break;
            }
            case 7: {
                string = "final";
                break;
            }
            case 8: {
                string = "native";
                break;
            }
            case 9: {
                string = "native";
                break;
            }
            case 10: {
                string = "strictfp";
                break;
            }
            case 11: {
                string = "transient";
                break;
            }
            case 12: {
                string = "volatile";
                break;
            }
            case 13: {
                string = "transitive";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Nullable
    public static final PsiClass toJavaClassOrNull(@NotNull JvmClass $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!($receiver instanceof PsiClass)) {
            return null;
        }
        if ($receiver instanceof PsiTypeParameter) {
            return null;
        }
        if ($receiver instanceof ClsClassImpl) {
            return null;
        }
        if (Intrinsics.areEqual((Object)((PsiClass)$receiver).getLanguage(), (Object)JavaLanguage.INSTANCE) ^ true) {
            return null;
        }
        return (PsiClass)$receiver;
    }

    @NotNull
    public static final Set<JvmModifier> getVisibilityModifiers() {
        return visibilityModifiers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ExpectedTypeInfo> extractExpectedTypes(@NotNull Project project, @NotNull List<? extends ExpectedType> expectedTypes) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(expectedTypes, (String)"expectedTypes");
        Iterable iterable = $receiver$iv = (Iterable)expectedTypes;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            ExpectedTypeInfo expectedTypeInfo;
            Object element$iv$iv = element$iv$iv$iv;
            ExpectedType it = (ExpectedType)element$iv$iv;
            if (JvmPsiUtilKt.toExpectedTypeInfo(project, it) == null) continue;
            ExpectedTypeInfo it$iv$iv = expectedTypeInfo;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final ExpectedTypeInfo toExpectedTypeInfo(Project project, ExpectedType expectedType) {
        if (expectedType instanceof ExpectedJavaType) {
            return ((ExpectedJavaType)expectedType).getInfo();
        }
        JvmPsiConversionHelper helper = JvmPsiConversionHelper.getInstance((Project)project);
        PsiType psiType = helper.convertType(expectedType.getTheType());
        if (psiType == null) {
            return null;
        }
        PsiType psiType2 = psiType;
        return ExpectedTypesProvider.createInfo(psiType2, JvmPsiUtilKt.infoKind(expectedType.getTheKind()), psiType2, TailType.NONE);
    }

    @ExpectedTypeInfo.Type
    private static final int infoKind(@NotNull ExpectedType.Kind $receiver) {
        int n;
        switch (JvmPsiUtilKt$WhenMappings.$EnumSwitchMapping$1[$receiver.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @NotNull
    public static final PsiSubstitutor toPsiSubstitutor(@NotNull JvmSubstitutor $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiSubstitutor psiSubstitutor = JvmPsiConversionHelper.getInstance((Project)project).convertSubstitutor($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"JvmPsiConversionHelper.g\u2026.convertSubstitutor(this)");
        return psiSubstitutor;
    }

    @NotNull
    public static final String[] extractNames(@Nullable SuggestedNameInfo suggestedNames, @NotNull Function0<String> defaultName) {
        String[] stringArray;
        Intrinsics.checkParameterIsNotNull(defaultName, (String)"defaultName");
        SuggestedNameInfo suggestedNameInfo = suggestedNames;
        if (suggestedNameInfo == null) {
            suggestedNameInfo = SuggestedNameInfo.NULL_INFO;
        }
        String[] names = suggestedNameInfo.names;
        Object[] objectArray = names;
        if (objectArray.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = (String)defaultName.invoke();
        } else {
            stringArray = names;
            Intrinsics.checkExpressionValueIsNotNull((Object)names, (String)"names");
        }
        return stringArray;
    }
}

