/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkTableImpl;
import com.intellij.util.SystemProperties;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class JavaAwareProjectJdkTableImpl
extends ProjectJdkTableImpl {
    private final JavaSdk myJavaSdk;
    private Sdk myInternalJdk;

    public static JavaAwareProjectJdkTableImpl getInstanceEx() {
        return (JavaAwareProjectJdkTableImpl)((Object)ServiceManager.getService(ProjectJdkTable.class));
    }

    public JavaAwareProjectJdkTableImpl(@NotNull JavaSdk javaSdk) {
        if (javaSdk == null) {
            JavaAwareProjectJdkTableImpl.$$$reportNull$$$0(0);
        }
        this.myJavaSdk = javaSdk;
    }

    @NotNull
    public Sdk getInternalJdk() {
        if (this.myInternalJdk == null) {
            String jdkHome = SystemProperties.getJavaHome();
            String versionName = ProjectBundle.message((String)"sdk.java.name.template", (Object[])new Object[]{SystemProperties.getJavaVersion()});
            this.myInternalJdk = this.myJavaSdk.createJdk(versionName, jdkHome);
        }
        Sdk sdk = this.myInternalJdk;
        if (sdk == null) {
            JavaAwareProjectJdkTableImpl.$$$reportNull$$$0(1);
        }
        return sdk;
    }

    public void removeJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            JavaAwareProjectJdkTableImpl.$$$reportNull$$$0(2);
        }
        super.removeJdk(jdk);
        if (jdk.equals(this.myInternalJdk)) {
            this.myInternalJdk = null;
        }
    }

    @NotNull
    public SdkTypeId getDefaultSdkType() {
        JavaSdk javaSdk = this.myJavaSdk;
        if (javaSdk == null) {
            JavaAwareProjectJdkTableImpl.$$$reportNull$$$0(3);
        }
        return javaSdk;
    }

    public void loadState(Element element) {
        this.myInternalJdk = null;
        try {
            super.loadState(element);
        }
        finally {
            this.getInternalJdk();
        }
    }

    protected String getSdkTypeName(String type2) {
        return type2 != null ? type2 : JavaSdk.getInstance().getName();
    }

    public static void removeInternalJdkInTests() {
        WriteAction.run(() -> {
            JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
            if (table.myInternalJdk != null) {
                table.removeJdk(table.myInternalJdk);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSdk";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/JavaAwareProjectJdkTableImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaAwareProjectJdkTableImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalJdk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSdkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeJdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

