/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.openapi.editor.DefaultLineWrapPositionStrategy;
import com.intellij.openapi.editor.Document;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JavaLineWrapPositionStrategy
extends DefaultLineWrapPositionStrategy {
    protected boolean canUseOffset(@NotNull Document document, int offset, boolean virtual) {
        CharSequence chars;
        char charAtOffset;
        if (document == null) {
            JavaLineWrapPositionStrategy.$$$reportNull$$$0(0);
        }
        if ((charAtOffset = (chars = document.getCharsSequence()).charAt(offset)) == '.') {
            char charAfter;
            char charBefore;
            if (offset > 0 && ((charBefore = chars.charAt(offset - 1)) == '.' || Character.isDigit(charBefore))) {
                return false;
            }
            if (offset + 1 < chars.length() && ((charAfter = chars.charAt(offset + 1)) == '.' || Character.isDigit(charAfter))) {
                return false;
            }
        }
        return !JavaLineWrapPositionStrategy.isInsideJDLinkTag(document, offset) && !JavaLineWrapPositionStrategy.isInsideHrefTag(document, offset);
    }

    private static boolean isInsideHrefTag(Document document, int offset) {
        return JavaLineWrapPositionStrategy.isInsideTag(document, offset, "<a", ">");
    }

    private static boolean isInsideJDLinkTag(Document document, int offset) {
        return JavaLineWrapPositionStrategy.isInsideTag(document, offset, "{@link", "}");
    }

    private static boolean isInsideTag(Document document, int offset, String tagStart, String tagEnd) {
        int offsetInChunk;
        CharSequence textChunkAroundOffset;
        int tagStartIndex;
        CharSequence sequence = document.getCharsSequence();
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        int searchStartOffset = lineStartOffset;
        int searchEndOffset = lineEndOffset;
        if (lineEndOffset - lineStartOffset > 200) {
            searchStartOffset = Math.max(offset - 100, lineStartOffset);
            searchEndOffset = Math.min(offset + 100, lineEndOffset);
        }
        if ((tagStartIndex = CharArrayUtil.lastIndexOf((CharSequence)(textChunkAroundOffset = sequence.subSequence(searchStartOffset, searchEndOffset)), (String)tagStart, (int)(offsetInChunk = offset - searchStartOffset))) > 0) {
            int nearestTagEndIndex = CharArrayUtil.indexOf((CharSequence)textChunkAroundOffset, (CharSequence)tagEnd, (int)tagStartIndex);
            return nearestTagEndIndex > offsetInChunk;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/formatter/java/JavaLineWrapPositionStrategy", "canUseOffset"));
    }
}

