/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeCorrector
extends PsiTypeMapper {
    private final Map<PsiClassType, PsiClassType> myResultMap = ContainerUtil.newIdentityHashMap();
    private final GlobalSearchScope myResolveScope;

    TypeCorrector(GlobalSearchScope resolveScope) {
        this.myResolveScope = resolveScope;
    }

    @Override
    public PsiType visitType(PsiType type2) {
        if (LambdaUtil.notInferredType((PsiType)type2)) {
            return type2;
        }
        return super.visitType(type2);
    }

    @Nullable
    public <T extends PsiType> T correctType(@NotNull T type2) {
        PsiClass mappedClass;
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass psiClass;
        PsiClassType classType;
        if (type2 == null) {
            TypeCorrector.$$$reportNull$$$0(0);
        }
        if (type2 instanceof PsiCorrectedClassType) {
            return (T)(this.myResolveScope.equals(type2.getResolveScope()) ? type2 : this.correctType(((PsiCorrectedClassType)type2).myDelegate));
        }
        if (type2 instanceof PsiClassType && (classType = (PsiClassType)type2).getParameterCount() == 0 && (psiClass = (classResolveResult = classType.resolveGenerics()).getElement()) != null && classResolveResult.getSubstitutor() == PsiSubstitutor.EMPTY && ((mappedClass = PsiSuperMethodUtil.correctClassByScope((PsiClass)psiClass, (GlobalSearchScope)this.myResolveScope)) == null || mappedClass == psiClass)) {
            return (T)classType;
        }
        return (T)((PsiType)type2.accept((PsiTypeVisitor)this));
    }

    @Override
    public PsiType visitClassType(PsiClassType classType) {
        PsiClassType alreadyComputed = this.myResultMap.get(classType);
        if (alreadyComputed != null) {
            return alreadyComputed;
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
        if (psiClass == null) {
            return classType;
        }
        PsiUtilCore.ensureValid((PsiElement)psiClass);
        PsiClass mappedClass = PsiSuperMethodUtil.correctClassByScope((PsiClass)psiClass, (GlobalSearchScope)this.myResolveScope);
        if (mappedClass == null) {
            return classType;
        }
        PsiCorrectedClassType mappedType = new PsiCorrectedClassType(classType.getLanguageLevel(), classType, new CorrectedResolveResult(psiClass, mappedClass, substitutor, classResolveResult));
        this.myResultMap.put(classType, (PsiClassType)mappedType);
        return mappedType;
    }

    @NotNull
    private PsiSubstitutor mapSubstitutor(PsiClass originalClass, PsiClass mappedClass, PsiSubstitutor substitutor) {
        PsiClass originalContaining;
        PsiTypeParameter[] originalTypeParameters;
        PsiTypeParameter[] typeParameters = mappedClass.getTypeParameters();
        if (typeParameters.length != (originalTypeParameters = originalClass.getTypeParameters()).length) {
            if (originalTypeParameters.length == 0) {
                PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory((Project)mappedClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)mappedClass);
                if (psiSubstitutor == null) {
                    TypeCorrector.$$$reportNull$$$0(1);
                }
                return psiSubstitutor;
            }
            PsiSubstitutor psiSubstitutor = substitutor;
            if (psiSubstitutor == null) {
                TypeCorrector.$$$reportNull$$$0(2);
            }
            return psiSubstitutor;
        }
        Map substitutionMap = substitutor.getSubstitutionMap();
        PsiSubstitutor mappedSubstitutor = PsiSubstitutor.EMPTY;
        for (int i = 0; i < originalTypeParameters.length; ++i) {
            if (!substitutionMap.containsKey(originalTypeParameters[i])) continue;
            PsiType originalSubstitute = substitutor.substitute(originalTypeParameters[i]);
            if (originalSubstitute != null) {
                PsiType substitute = this.mapType(originalSubstitute);
                if (substitute == null) {
                    PsiSubstitutor psiSubstitutor = substitutor;
                    if (psiSubstitutor == null) {
                        TypeCorrector.$$$reportNull$$$0(3);
                    }
                    return psiSubstitutor;
                }
                mappedSubstitutor = mappedSubstitutor.put(typeParameters[i], substitute);
                continue;
            }
            mappedSubstitutor = mappedSubstitutor.put(typeParameters[i], null);
        }
        if (mappedClass.hasModifierProperty("static")) {
            PsiSubstitutor psiSubstitutor = mappedSubstitutor;
            if (psiSubstitutor == null) {
                TypeCorrector.$$$reportNull$$$0(4);
            }
            return psiSubstitutor;
        }
        PsiClass mappedContaining = mappedClass.getContainingClass();
        if (mappedContaining != null != ((originalContaining = originalClass.getContainingClass()) != null)) {
            PsiSubstitutor psiSubstitutor = substitutor;
            if (psiSubstitutor == null) {
                TypeCorrector.$$$reportNull$$$0(5);
            }
            return psiSubstitutor;
        }
        if (mappedContaining != null) {
            PsiSubstitutor psiSubstitutor = mappedSubstitutor.putAll(this.mapSubstitutor(originalContaining, mappedContaining, substitutor));
            if (psiSubstitutor == null) {
                TypeCorrector.$$$reportNull$$$0(6);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = mappedSubstitutor;
        if (psiSubstitutor == null) {
            TypeCorrector.$$$reportNull$$$0(7);
        }
        return psiSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/TypeCorrector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/TypeCorrector";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mapSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "correctType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CorrectedResolveResult
    implements PsiClassType.ClassResolveResult {
        private final PsiClass myPsiClass;
        private final PsiClass myMappedClass;
        private final PsiSubstitutor mySubstitutor;
        private final PsiClassType.ClassResolveResult myClassResolveResult;
        private volatile PsiSubstitutor myLazySubstitutor;

        public CorrectedResolveResult(PsiClass psiClass, PsiClass mappedClass, PsiSubstitutor substitutor, PsiClassType.ClassResolveResult classResolveResult) {
            this.myPsiClass = psiClass;
            this.myMappedClass = mappedClass;
            this.mySubstitutor = substitutor;
            this.myClassResolveResult = classResolveResult;
        }

        @NotNull
        public PsiSubstitutor getSubstitutor() {
            PsiSubstitutor result = this.myLazySubstitutor;
            if (result == null) {
                this.myLazySubstitutor = result = TypeCorrector.this.mapSubstitutor(this.myPsiClass, this.myMappedClass, this.mySubstitutor);
            }
            PsiSubstitutor psiSubstitutor = result;
            if (psiSubstitutor == null) {
                CorrectedResolveResult.$$$reportNull$$$0(0);
            }
            return psiSubstitutor;
        }

        public PsiClass getElement() {
            return this.myMappedClass;
        }

        public boolean isPackagePrefixPackageReference() {
            return this.myClassResolveResult.isPackagePrefixPackageReference();
        }

        public boolean isAccessible() {
            return this.myClassResolveResult.isAccessible();
        }

        public boolean isStaticsScopeCorrect() {
            return this.myClassResolveResult.isStaticsScopeCorrect();
        }

        public PsiElement getCurrentFileResolveScope() {
            return this.myClassResolveResult.getCurrentFileResolveScope();
        }

        public boolean isValidResult() {
            return this.myClassResolveResult.isValidResult();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$CorrectedResolveResult", "getSubstitutor"));
        }
    }

    private class PsiCorrectedClassType
    extends PsiClassType.Stub {
        private final PsiClassType myDelegate;
        private final CorrectedResolveResult myResolveResult;

        private PsiCorrectedClassType(LanguageLevel languageLevel, PsiClassType delegate, CorrectedResolveResult resolveResult) {
            this(languageLevel, delegate, resolveResult, delegate.getAnnotationProvider());
        }

        private PsiCorrectedClassType(LanguageLevel languageLevel, PsiClassType delegate, CorrectedResolveResult resolveResult, TypeAnnotationProvider delegateAnnotationProvider) {
            super(languageLevel, delegateAnnotationProvider);
            this.myDelegate = delegate;
            this.myResolveResult = resolveResult;
        }

        @NotNull
        public PsiClass resolve() {
            PsiClass psiClass = this.myResolveResult.myMappedClass;
            if (psiClass == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(0);
            }
            return psiClass;
        }

        public String getClassName() {
            return this.myDelegate.getClassName();
        }

        @NotNull
        public PsiType[] getParameters() {
            PsiType[] psiTypeArray = (PsiType[])ContainerUtil.map2Array((Object[])this.myDelegate.getParameters(), PsiType.class, type2 -> {
                if (type2 == null) {
                    LOG.error(this.myDelegate + " of " + this.myDelegate.getClass() + "; substitutor=" + this.myDelegate.resolveGenerics().getSubstitutor());
                    return null;
                }
                return TypeCorrector.this.mapType(type2);
            });
            if (psiTypeArray == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(1);
            }
            return psiTypeArray;
        }

        public int getParameterCount() {
            return this.myDelegate.getParameters().length;
        }

        @NotNull
        public PsiClassType.ClassResolveResult resolveGenerics() {
            CorrectedResolveResult correctedResolveResult = this.myResolveResult;
            if (correctedResolveResult == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(2);
            }
            return correctedResolveResult;
        }

        @NotNull
        public PsiClassType rawType() {
            PsiClass psiClass = this.resolve();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
            PsiClassType psiClassType = factory.createType(psiClass, factory.createRawSubstitutor((PsiTypeParameterListOwner)psiClass));
            if (psiClassType == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(3);
            }
            return psiClassType;
        }

        @NotNull
        public GlobalSearchScope getResolveScope() {
            GlobalSearchScope globalSearchScope = TypeCorrector.this.myResolveScope;
            if (globalSearchScope == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(4);
            }
            return globalSearchScope;
        }

        @NotNull
        public LanguageLevel getLanguageLevel() {
            LanguageLevel languageLevel = this.myLanguageLevel;
            if (languageLevel == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(5);
            }
            return languageLevel;
        }

        @NotNull
        public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
            if (languageLevel == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(6);
            }
            PsiCorrectedClassType psiCorrectedClassType = new PsiCorrectedClassType(languageLevel, this.myDelegate, this.myResolveResult);
            if (psiCorrectedClassType == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(7);
            }
            return psiCorrectedClassType;
        }

        @NotNull
        public String getPresentableText(boolean annotated) {
            String string = this.myDelegate.getPresentableText(annotated);
            if (string == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public String getCanonicalText(boolean annotated) {
            String string = this.myDelegate.getCanonicalText(annotated);
            if (string == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        public String getInternalCanonicalText() {
            String string = this.myDelegate.getInternalCanonicalText();
            if (string == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(10);
            }
            return string;
        }

        public boolean isValid() {
            return this.myDelegate.isValid() && this.myResolveResult.myMappedClass.isValid() && this.myResolveResult.mySubstitutor.isValid();
        }

        public boolean equalsToText(@NotNull @NonNls String text2) {
            if (text2 == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(11);
            }
            return this.myDelegate.equalsToText(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 6: 
                case 11: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 6: 
                case 11: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveGenerics";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResolveScope";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguageLevel";
                    break;
                }
                case 6: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLanguageLevel";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInternalCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setLanguageLevel";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "equalsToText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 6: 
                case 11: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

