/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance(InferenceSession.class);
    private static final Key<PsiType> LOWER_BOUND = Key.create((String)"LowBound");
    private static final Key<PsiType> UPPER_BOUND = Key.create((String)"UpperBound");
    private static final Key<Boolean> ERASED = Key.create((String)"UNCHECKED_CONVERSION");
    private static final Function<Pair<PsiType, PsiType>, PsiType> UPPER_BOUND_FUNCTION = pair -> GenericsUtil.getGreatestLowerBound((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second));
    private static final String EQUALITY_CONSTRAINTS_PRESENTATION = "equality constraints";
    private static final String UPPER_BOUNDS_PRESENTATION = "upper bounds";
    private static final String LOWER_BOUNDS_PRESENTATION = "lower bounds";
    static final Key<PsiCapturedWildcardType> ORIGINAL_CAPTURE = Key.create((String)"ORIGINAL_CAPTURE");
    private final Set<InferenceVariable> myInferenceVariables = new LinkedHashSet<InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private final Set<ConstraintFormula> myConstraintsCopy = new HashSet<ConstraintFormula>();
    private InferenceSessionContainer myInferenceSessionContainer = new InferenceSessionContainer();
    private PsiSubstitutor mySiteSubstitutor;
    private final PsiManager myManager;
    private int myConstraintIdx;
    private List<String> myErrorMessages;
    private boolean myErased;
    public final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;
    private ParameterTypeInferencePolicy myPolicy;
    private PsiSubstitutor myInferenceSubstitution = PsiSubstitutor.EMPTY;
    private PsiSubstitutor myRestoreNameSubstitution = PsiSubstitutor.EMPTY;

    public InferenceSession(InitialInferenceState initialState) {
        this.myContext = initialState.getContext();
        this.myManager = this.myContext.getManager();
        this.myInferenceSubstitution = initialState.getInferenceSubstitutor();
        this.myInferenceVariables.addAll(initialState.getInferenceVariables());
        this.mySiteSubstitutor = initialState.getSiteSubstitutor();
        for (Pair<InferenceVariable[], PsiClassType> capture : initialState.getCaptures()) {
            this.myIncorporationPhase.addCapture((InferenceVariable[])capture.first, (PsiClassType)capture.second);
        }
        this.myInferenceSessionContainer = initialState.getInferenceSessionContainer();
        this.myErased = initialState.isErased();
        this.myPolicy = DefaultParameterTypeInferencePolicy.INSTANCE;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i = 0; i < leftTypes.length; ++i) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i]);
            PsiType t = this.substituteWithInferenceVariables(leftTypes[i]);
            PsiType s = this.substituteWithInferenceVariables(rightType);
            if (t == null || s == null) continue;
            this.addConstraint(new TypeCompatibilityConstraint(t, s));
        }
        this.myPolicy = DefaultParameterTypeInferencePolicy.INSTANCE;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this(typeParams, siteSubstitutor, manager, context, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context, ParameterTypeInferencePolicy policy) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.myPolicy = policy;
        this.initBounds(typeParams);
    }

    public static PsiType getUpperBound(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            InferenceSession.$$$reportNull$$$0(0);
        }
        return (PsiType)psiClass.getUserData(UPPER_BOUND);
    }

    public static PsiType getLowerBound(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            InferenceSession.$$$reportNull$$$0(1);
        }
        return (PsiType)psiClass.getUserData(LOWER_BOUND);
    }

    public static PsiType createTypeParameterTypeWithUpperBound(PsiType upperBound, PsiElement place) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        PsiTypeParameter parameter2 = elementFactory.createTypeParameterFromText("T", place);
        parameter2.putUserData(UPPER_BOUND, (Object)upperBound);
        return elementFactory.createType((PsiClass)parameter2);
    }

    public void initExpressionConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiElement parent) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        this.initExpressionConstraints(parameters2, args, parent, null, currentProperties != null && currentProperties.isVarargs());
    }

    public void initExpressionConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiElement parent, PsiMethod method, boolean varargs) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        if (method == null && currentProperties != null) {
            method = currentProperties.getMethod();
        }
        if (method != null) {
            this.initThrowsConstraints(method);
        }
        if (parameters2.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (!varargs && i >= parameters2.length || args[i] == null || !InferenceSession.isPertinentToApplicability(args[i], method)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters2, i, this.mySiteSubstitutor, varargs);
                this.addConstraint(new ExpressionCompatibilityConstraint(args[i], this.substituteWithInferenceVariables(parameterType)));
            }
        }
    }

    public void initThrowsConstraints(PsiMethod method) {
        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable = this.getInferenceVariable(this.substituteWithInferenceVariables((PsiType)thrownType));
            if (variable == null) continue;
            variable.setThrownBound();
        }
    }

    private static MethodCandidateInfo.CurrentCandidateProperties getCurrentProperties(PsiElement parent) {
        if (parent instanceof PsiCall) {
            return MethodCandidateInfo.getCurrentMethod((PsiElement)((PsiCall)parent).getArgumentList());
        }
        if (parent instanceof PsiAnonymousClass) {
            return InferenceSession.getCurrentProperties(parent.getParent());
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        return InferenceSession.isPertinentToApplicability(expr, method, null);
    }

    private static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method, PsiType expectedReturnType) {
        if ((expr instanceof PsiLambdaExpression && ((PsiLambdaExpression)expr).hasFormalParameterTypes() || expr instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expr).isExact()) && method != null) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expr.getParent());
            PsiType paramType = null;
            if (parent instanceof PsiExpressionList) {
                PsiElement gParent = parent.getParent();
                PsiTypeParameterListOwner owner = InferenceSession.getTypeParameterOwner(method, gParent);
                if (owner != null) {
                    PsiParameter[] parameters2;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)parent), (PsiElement)expr);
                    if (idx > (parameters2 = method.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters2[parameters2.length - 1].getType();
                        paramType = parameters2[parameters2.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters2[idx].getType();
                    }
                    if (InferenceSession.isTypeParameterType(owner, paramType)) {
                        return false;
                    }
                }
            } else if (expectedReturnType != null && (parent instanceof PsiLambdaExpression || parent instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMethod.class}) != null)) {
                if (InferenceSession.isTypeParameterType((PsiTypeParameterListOwner)method, expectedReturnType)) {
                    return false;
                }
                paramType = expectedReturnType;
            }
            if (expr instanceof PsiLambdaExpression) {
                for (PsiExpression expression2 : LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)expr))) {
                    if (InferenceSession.isPertinentToApplicability(expression2, method, LambdaUtil.getFunctionalInterfaceReturnType((PsiType)paramType))) continue;
                    return false;
                }
                return true;
            }
        }
        if (expr instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)expr).hasFormalParameterTypes();
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression2 = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression2, method)) {
                return false;
            }
            PsiExpression elseExpression2 = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression2, method)) {
                return false;
            }
        }
        return true;
    }

    private static PsiTypeParameterListOwner getTypeParameterOwner(@NotNull PsiMethod method, PsiElement gParent) {
        PsiClass containingClass;
        if (method == null) {
            InferenceSession.$$$reportNull$$$0(2);
        }
        PsiMethod owner = null;
        if (method.getTypeParameters().length > 0 && gParent instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
            owner = method;
        } else if (method.isConstructor() && gParent instanceof PsiNewExpression && (containingClass = method.getContainingClass()) != null && containingClass.hasTypeParameters() && PsiDiamondType.hasDiamond((PsiNewExpression)((PsiNewExpression)gParent))) {
            owner = containingClass;
        }
        return owner;
    }

    private static boolean isTypeParameterType(PsiTypeParameterListOwner method, PsiType paramType) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)paramType);
        return psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method;
    }

    private static PsiType getParameterType(PsiParameter[] parameters2, int i, @Nullable PsiSubstitutor substitutor, boolean varargs) {
        if (substitutor == null) {
            return null;
        }
        return substitutor.substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)i, (boolean)varargs));
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(3);
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor collectAdditionalAndInfer(@NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] args, @NotNull MethodCandidateInfo.CurrentCandidateProperties properties, @NotNull PsiSubstitutor psiSubstitutor) {
        if (parameters2 == null) {
            InferenceSession.$$$reportNull$$$0(4);
        }
        if (args == null) {
            InferenceSession.$$$reportNull$$$0(5);
        }
        if (properties == null) {
            InferenceSession.$$$reportNull$$$0(6);
        }
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(7);
        }
        return this.performGuardedInference(parameters2, args, this.myContext, properties, psiSubstitutor);
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent) {
        PsiSubstitutor psiSubstitutor = this.infer(parameters2, args, parent, InferenceSession.getCurrentProperties(parent));
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(8);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties) {
        PsiSubstitutor psiSubstitutor = this.performGuardedInference(parameters2, args, parent, properties, PsiSubstitutor.EMPTY);
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(9);
        }
        return psiSubstitutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PsiSubstitutor performGuardedInference(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties, @NotNull PsiSubstitutor initialSubstitutor) {
        if (initialSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(10);
        }
        this.doInfer(parameters2, args, parent, properties, initialSubstitutor);
        PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
        PsiSubstitutor psiSubstitutor2 = psiSubstitutor;
        if (psiSubstitutor2 == null) {
            InferenceSession.$$$reportNull$$$0(11);
        }
        return psiSubstitutor2;
        finally {
            for (ConstraintFormula formula : this.myConstraintsCopy) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                LambdaUtil.getFunctionalTypeMap().remove(((InputOutputConstraintFormula)formula).getExpression());
            }
            if (properties != null && this.myErrorMessages != null) {
                properties.getInfo().setApplicabilityError(StringUtil.join(this.myErrorMessages, (String)"\n"));
            }
        }
    }

    private void doInfer(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties, @NotNull PsiSubstitutor initialSubstitutor) {
        if (initialSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(12);
        }
        if (!this.repeatInferencePhases()) {
            return;
        }
        if (properties != null && !properties.isApplicabilityCheck()) {
            PsiType returnType;
            String expectedActualErrorMessage = null;
            PsiMethod method = properties.getMethod();
            if (parent instanceof PsiCallExpression && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)((PsiExpression)parent), (PsiMethod)method) && !PsiType.VOID.equals((Object)(returnType = method.getReturnType())) && returnType != null) {
                Ref errorMessage = new Ref();
                PsiType targetType = InferenceSession.getTargetTypeFromParent(parent, (Ref<String>)errorMessage, false);
                if (targetType == null && errorMessage.get() != null) {
                    return;
                }
                if (targetType != null && !PsiType.VOID.equals((Object)targetType)) {
                    PsiType actualType = PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method, (PsiSubstitutor)this.mySiteSubstitutor) ? returnType : this.mySiteSubstitutor.substitute(returnType);
                    this.registerReturnTypeConstraints(actualType, targetType, this.myContext);
                    expectedActualErrorMessage = "Incompatible types. Required " + targetType.getPresentableText() + " but '" + method.getName() + "' was inferred to " + actualType.getPresentableText() + ":";
                }
            }
            if (!this.repeatInferencePhases()) {
                if (expectedActualErrorMessage != null && this.myErrorMessages != null) {
                    this.myErrorMessages.add(0, expectedActualErrorMessage);
                }
            } else if (parameters2 != null && args != null && !this.isOverloadCheck()) {
                LinkedHashSet<ConstraintFormula> additionalConstraints = new LinkedHashSet<ConstraintFormula>();
                HashSet<ConstraintFormula> ignoredConstraints = new HashSet<ConstraintFormula>();
                if (parameters2.length > 0) {
                    this.collectAdditionalConstraints(parameters2, args, properties.getMethod(), this.mySiteSubstitutor, additionalConstraints, ignoredConstraints, properties.isVarargs(), initialSubstitutor);
                }
                this.proceedWithAdditionalConstraints(additionalConstraints, ignoredConstraints);
            }
        }
        this.resolveBounds(this.myInferenceVariables, initialSubstitutor);
    }

    private boolean isOverloadCheck() {
        if (this.myContext != null) {
            for (Object o : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
                if (!(o instanceof PsiExpressionList)) continue;
                PsiExpressionList element = (PsiExpressionList)o;
                for (PsiExpression expression2 : element.getExpressions()) {
                    if (expression2 != this.myContext) continue;
                    return true;
                }
            }
            return false;
        }
        return MethodCandidateInfo.isOverloadCheck();
    }

    private void collectAdditionalConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiMethod parentMethod, PsiSubstitutor siteSubstitutor, Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, boolean varargs, PsiSubstitutor initialSubstitutor) {
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[i]);
            if (arg == null) continue;
            PsiSubstitutor nestedSubstitutor = this.myInferenceSessionContainer.findNestedSubstitutor((PsiElement)arg, this.myInferenceSubstitution);
            PsiType parameterType = nestedSubstitutor.substitute(InferenceSession.getParameterType(parameters2, i, siteSubstitutor, varargs));
            if (!InferenceSession.isPertinentToApplicability(arg, parentMethod)) {
                if (arg instanceof PsiLambdaExpression && InferenceSession.ignoreConstraintTree(ignoredConstraints, arg, parameterType)) continue;
                additionalConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
            }
            additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(arg, parameterType));
            if (arg instanceof PsiCall) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCall)arg);
                if (calledMethod == null || !PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)arg, (PsiMethod)calledMethod)) continue;
                this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCall)arg, initialSubstitutor);
                continue;
            }
            if (!(arg instanceof PsiLambdaExpression) || !InferenceSession.isPertinentToApplicability(arg, parentMethod)) continue;
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)arg, ((PsiLambdaExpression)arg).getGroundTargetType(parameterType), !this.isProperType(initialSubstitutor.substitute(parameterType)), initialSubstitutor);
        }
    }

    private static boolean ignoreConstraintTree(Set<ConstraintFormula> ignoredConstraints, PsiExpression arg, PsiType parameterType) {
        for (Object expr : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
            if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expr), PsiLambdaExpression.class) != arg) continue;
            return true;
        }
        for (Object expr : LambdaUtil.ourParameterGuard.currentStack()) {
            if (!(expr instanceof PsiParameter) || ((PsiParameter)expr).getDeclarationScope() != arg) continue;
            ignoredConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
            return true;
        }
        return false;
    }

    public static PsiMethod getCalledMethod(PsiCall arg) {
        PsiExpressionList argumentList = arg.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList);
        if (properties != null) {
            return properties.getMethod();
        }
        JavaResolveResult resolveResult = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)arg);
        if (resolveResult instanceof MethodCandidateInfo) {
            return (PsiMethod)resolveResult.getElement();
        }
        return null;
    }

    private void collectLambdaReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiLambdaExpression lambdaExpression, PsiType parameterType, boolean addConstraint, PsiSubstitutor initialSubstitutor) {
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)parameterType);
        if (interfaceReturnType != null) {
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression);
            for (PsiExpression returnExpression2 : returnExpressions) {
                this.processReturnExpression(additionalConstraints, ignoredConstraints, returnExpression2, interfaceReturnType, addConstraint, initialSubstitutor);
            }
        }
    }

    private void processReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiExpression returnExpression2, PsiType functionalType, boolean addConstraint, PsiSubstitutor initialSubstitutor) {
        if (returnExpression2 instanceof PsiCallExpression) {
            if (addConstraint) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCall)((PsiCallExpression)returnExpression2));
                if (calledMethod != null && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)returnExpression2, (PsiMethod)calledMethod)) {
                    this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCall)((PsiCallExpression)returnExpression2), initialSubstitutor);
                }
            } else {
                this.getInferenceSessionContainer().registerNestedSession(this, functionalType, returnExpression2);
            }
        } else if (returnExpression2 instanceof PsiParenthesizedExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiParenthesizedExpression)returnExpression2).getExpression(), functionalType, addConstraint, initialSubstitutor);
        } else if (returnExpression2 instanceof PsiConditionalExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression2).getThenExpression(), functionalType, addConstraint, initialSubstitutor);
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression2).getElseExpression(), functionalType, addConstraint, initialSubstitutor);
        } else if (returnExpression2 instanceof PsiLambdaExpression) {
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)returnExpression2, functionalType, this.myErased, initialSubstitutor);
        }
    }

    private void collectAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiCall callExpression, PsiSubstitutor initialSubstitutor) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList != null) {
            PsiMethod method;
            JavaResolveResult result;
            MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList);
            JavaResolveResult javaResolveResult = result = properties != null ? null : PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)callExpression);
            Object object = properties != null ? properties.getMethod() : (method = result instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result).getElement() : null);
            if (method != null) {
                PsiExpression[] newArgs = argumentList.getExpressions();
                PsiParameter[] newParams = method.getParameterList().getParameters();
                if (newParams.length > 0) {
                    this.collectAdditionalConstraints(newParams, newArgs, method, InferenceSession.chooseSiteSubstitutor(properties, result, method), additionalConstraints, ignoredConstraints, InferenceSession.chooseVarargsMode(properties, result), initialSubstitutor);
                }
            }
        }
    }

    public static PsiSubstitutor chooseSiteSubstitutor(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult, PsiMethod method) {
        return resolveResult instanceof MethodCandidateInfo && method != null && !method.isConstructor() ? ((MethodCandidateInfo)resolveResult).getSiteSubstitutor() : (candidateProperties != null ? candidateProperties.getSubstitutor() : PsiSubstitutor.EMPTY);
    }

    public static boolean chooseVarargsMode(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult) {
        return resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isVarargs() || candidateProperties != null && candidateProperties.isVarargs();
    }

    public PsiSubstitutor getInstantiations(Collection<InferenceVariable> variables) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : variables) {
            PsiType equalsBound = this.getEqualsBound(variable, substitutor);
            if (equalsBound == null || PsiType.NULL.equals((Object)equalsBound)) continue;
            substitutor = substitutor.put(variable.getParameter(), equalsBound);
        }
        return substitutor;
    }

    PsiSubstitutor prepareSubstitution() {
        boolean foundErrorMessage = false;
        Iterator<List<InferenceVariable>> iterator = InferenceVariablesOrder.resolveOrderIterator(this.myInferenceVariables, this);
        while (iterator.hasNext()) {
            List<InferenceVariable> variables = iterator.next();
            for (InferenceVariable inferenceVariable : variables) {
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                PsiType instantiation = inferenceVariable.getInstantiation();
                if (instantiation != PsiType.NULL) continue;
                if (!foundErrorMessage) {
                    foundErrorMessage = this.checkBoundsConsistency(this.mySiteSubstitutor, inferenceVariable) == PsiType.NULL;
                }
                this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, (PsiType)JavaPsiFacade.getInstance((Project)typeParameter.getProject()).getElementFactory().createType((PsiClass)typeParameter));
            }
        }
        return this.mySiteSubstitutor;
    }

    public InitialInferenceState createInitialState(InferenceSessionContainer container, Collection<InferenceVariable> variables, PsiSubstitutor topInferenceSubstitutor) {
        return new InitialInferenceState(variables, topInferenceSubstitutor, this.myContext, this.myInferenceSubstitution, this.mySiteSubstitutor, this.myIncorporationPhase.getCaptures(), this.myErased, container);
    }

    public void initBounds(PsiTypeParameter ... typeParameters) {
        this.initBounds(this.myContext, typeParameters);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiTypeParameter ... typeParameters) {
        return this.initBounds(context, this.mySiteSubstitutor, typeParameters);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiSubstitutor siteSubstitutor, PsiTypeParameter ... typeParameters) {
        ArrayList<InferenceVariable> result = new ArrayList<InferenceVariable>(typeParameters.length);
        for (PsiTypeParameter parameter2 : typeParameters) {
            String name = parameter2.getName();
            if (this.myContext != null) {
                name = name + Math.abs(this.myContext.hashCode());
            }
            InferenceVariable variable = new InferenceVariable(context, parameter2, name);
            result.add(variable);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)parameter2.getProject());
            this.myInferenceSubstitution = this.myInferenceSubstitution.put(parameter2, (PsiType)elementFactory.createType((PsiClass)variable));
            this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.put((PsiTypeParameter)variable, (PsiType)elementFactory.createType((PsiClass)parameter2));
            this.myInferenceVariables.add(variable);
        }
        for (InferenceVariable variable : result) {
            PsiClassType[] extendsListTypes;
            PsiTypeParameter parameter3 = variable.getParameter();
            boolean added = false;
            for (PsiClassType classType : extendsListTypes = parameter3.getExtendsListTypes()) {
                if (this.isProperType((PsiType)(classType = this.substituteWithInferenceVariables(siteSubstitutor.substitute((PsiType)classType))))) {
                    added = true;
                }
                variable.addBound((PsiType)classType, InferenceBound.UPPER, null);
            }
            if (added) continue;
            variable.addBound((PsiType)PsiType.getJavaLangObject((PsiManager)parameter3.getManager(), (GlobalSearchScope)parameter3.getResolveScope()), InferenceBound.UPPER, null);
        }
        return result.toArray(new InferenceVariable[result.size()]);
    }

    public void registerReturnTypeConstraints(PsiType returnType, PsiType targetType, PsiElement context) {
        returnType = this.substituteWithInferenceVariables(returnType);
        if (this.myErased) {
            PsiSubstitutor substitutor;
            InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
            if (inferenceVariable != null && (returnType = (substitutor = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor)).substitute((PsiTypeParameter)inferenceVariable)) == null) {
                return;
            }
            this.addConstraint(new TypeCompatibilityConstraint(targetType, TypeConversionUtil.erasure((PsiType)returnType)));
        } else if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(returnType)) {
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)returnType);
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                LOG.assertTrue(returnType instanceof PsiClassType);
                PsiClassType substitutedCapture = (PsiClassType)PsiUtil.captureToplevelWildcards((PsiType)returnType, (PsiElement)context);
                PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
                PsiType[] parameters2 = substitutedCapture.getParameters();
                InferenceVariable[] copy = this.initFreshVariablesForCapturedBounds(typeParameters, parameters2);
                PsiType[] newParameters = new PsiType[parameters2.length];
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
                int idx = 0;
                for (int i = 0; i < parameters2.length; ++i) {
                    newParameters[i] = parameters2[i];
                    if (!(parameters2[i] instanceof PsiCapturedWildcardType)) continue;
                    newParameters[i] = elementFactory.createType((PsiClass)copy[idx++]);
                }
                substitutedCapture = elementFactory.createType(psiClass, newParameters);
                this.myIncorporationPhase.addCapture(copy, (PsiClassType)returnType);
                this.addConstraint(new TypeCompatibilityConstraint(targetType, (PsiType)substitutedCapture));
            }
        } else {
            InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType, targetType);
            if (inferenceVariable != null) {
                PsiSubstitutor substitutor = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor);
                PsiType substitutedReturnType = substitutor.substitute((PsiTypeParameter)inferenceVariable);
                if (substitutedReturnType != null) {
                    this.addConstraint(new TypeCompatibilityConstraint(targetType, PsiUtil.captureToplevelWildcards((PsiType)substitutedReturnType, (PsiElement)context)));
                }
            } else {
                this.addConstraint(new TypeCompatibilityConstraint(targetType, returnType));
            }
        }
    }

    private InferenceVariable[] initFreshVariablesForCapturedBounds(PsiTypeParameter[] typeParameters, PsiType[] parameters2) {
        if (Registry.is((String)"javac.fresh.variables.for.captured.wildcards.only")) {
            ArrayList<PsiTypeParameter> capturedParams = new ArrayList<PsiTypeParameter>();
            PsiSubstitutor restParamSubstitution = PsiSubstitutor.EMPTY;
            for (int i = 0; i < parameters2.length; ++i) {
                PsiType parameter2 = parameters2[i];
                if (parameter2 instanceof PsiCapturedWildcardType) {
                    capturedParams.add(typeParameters[i]);
                    continue;
                }
                restParamSubstitution = restParamSubstitution.put(typeParameters[i], parameter2);
            }
            InferenceVariable[] variables = this.initBounds(null, restParamSubstitution, capturedParams.toArray(PsiTypeParameter.EMPTY_ARRAY));
            int idx = 0;
            for (PsiType parameter3 : parameters2) {
                if (!(parameter3 instanceof PsiCapturedWildcardType) || !this.isProperType((PsiType)((PsiCapturedWildcardType)parameter3).getWildcard())) continue;
                variables[idx++].putUserData(ORIGINAL_CAPTURE, (PsiCapturedWildcardType)parameter3);
            }
            return variables;
        }
        return this.initBounds((PsiElement)null, typeParameters);
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType) || InferenceSession.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER, InferenceBound.EQ}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType((PsiType)bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion((PsiType)targetType, bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized((PsiType)targetType)) {
            Processor differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (InferenceSession.findParameterizationOfTheSameGenericClass(bounds, (Processor<Pair<PsiType, PsiType>>)(differentParameterizationProcessor = pair -> pair.first == null || pair.second == null || !TypesDistinctProver.provablyDistinct((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second)))) != null) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            ArrayList<PsiType> boundsToCheck = new ArrayList<PsiType>(bounds);
            boundsToCheck.addAll(eqBounds);
            for (PsiType lowBound : boundsToCheck) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiType getTargetType(PsiElement context) {
        return InferenceSession.getTargetTypeFromParent(context, (Ref<String>)new Ref(), true);
    }

    private static PsiType getTargetTypeFromParent(PsiElement context, Ref<String> errorMessage, boolean inferParent) {
        PsiType targetType = PsiTypesUtil.getExpectedTypeByParent((PsiElement)context);
        if (targetType != null) {
            return targetType;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)context.getParent());
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList argumentList;
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiCall && (argumentList = ((PsiCall)gParent).getArgumentList()) != null) {
                MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList);
                if (properties != null && properties.isApplicabilityCheck()) {
                    return InferenceSession.getTypeByMethod(context, argumentList, (PsiElement)properties.getMethod(), properties.isVarargs(), properties.getSubstitutor(), inferParent);
                }
                JavaResolveResult result = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((PsiCall)gParent));
                PsiElement element = result.getElement();
                if (element == null) {
                    errorMessage.set((Object)"Overload resolution failed");
                    return null;
                }
                if (element instanceof PsiMethod && (inferParent || !((PsiMethod)element).hasTypeParameters())) {
                    boolean varargs = result instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).isVarargs();
                    return InferenceSession.getTypeByMethod(context, argumentList, result.getElement(), varargs, result.getSubstitutor(), inferParent);
                }
            }
        } else {
            if (parent instanceof PsiConditionalExpression) {
                return InferenceSession.getTargetTypeFromParent(parent, errorMessage, inferParent);
            }
            if (parent instanceof PsiLambdaExpression) {
                return InferenceSession.getTargetTypeFromParentLambda((PsiLambdaExpression)parent, errorMessage, inferParent);
            }
            if (parent instanceof PsiReturnStatement) {
                return InferenceSession.getTargetTypeFromParentLambda((PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMethod.class}), errorMessage, inferParent);
            }
        }
        return null;
    }

    private static PsiType getTargetTypeFromParentLambda(PsiLambdaExpression lambdaExpression, Ref<String> errorMessage, boolean inferParent) {
        if (lambdaExpression != null) {
            PsiType typeTypeByParentCall = InferenceSession.getTargetTypeFromParent((PsiElement)lambdaExpression, errorMessage, inferParent);
            if (typeTypeByParentCall != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)lambdaExpression.getGroundTargetType(typeTypeByParentCall));
            }
            PsiType cachedLambdaType = (PsiType)LambdaUtil.getFunctionalTypeMap().get(lambdaExpression);
            if (cachedLambdaType != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)lambdaExpression.getGroundTargetType(cachedLambdaType));
            }
            return inferParent || !(PsiUtil.skipParenthesizedExprUp((PsiElement)lambdaExpression.getParent()) instanceof PsiExpressionList) ? LambdaUtil.getFunctionalInterfaceReturnType((PsiType)lambdaExpression.getFunctionalInterfaceType()) : null;
        }
        return null;
    }

    private static PsiType getTypeByMethod(PsiElement context, PsiExpressionList argumentList, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor, boolean inferParent) {
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters2 = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters2.length == 0) {
                return null;
            }
            Object[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters2.length != args.length && !inferParent) {
                return null;
            }
            PsiElement arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find((Object[])args, (Object)arg);
            if (i < 0) {
                return null;
            }
            PsiType parameterType = InferenceSession.getParameterType(parameters2, i, substitutor, varargs);
            boolean isRaw = substitutor != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)((PsiMethod)parentMethod), (PsiSubstitutor)substitutor);
            return isRaw ? TypeConversionUtil.erasure((PsiType)parameterType) : parameterType;
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType);
        return psiClass instanceof InferenceVariable ? this.getInferenceVariable((PsiTypeParameter)psiClass) : null;
    }

    public boolean isProperType(@Nullable PsiType type2) {
        return this.collectDependencies(type2, null);
    }

    public boolean collectDependencies(@Nullable PsiType type2, @Nullable Set<InferenceVariable> dependencies) {
        return InferenceSession.collectDependencies(type2, dependencies, (Function<PsiClassType, InferenceVariable>)((Function)classType -> this.getInferenceVariable((PsiType)classType)));
    }

    public static boolean collectDependencies(@Nullable PsiType type2, final @Nullable Set<InferenceVariable> dependencies, final Function<PsiClassType, InferenceVariable> fun) {
        if (type2 == null) {
            return true;
        }
        Boolean isProper = (Boolean)type2.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

            public Boolean visitType(PsiType type2) {
                return true;
            }

            public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return true;
            }

            public Boolean visitArrayType(PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return (Boolean)bound.accept((PsiTypeVisitor)this);
            }

            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = (InferenceVariable)((Object)fun.fun((Object)classType));
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                PsiClassType.ClassResolveResult result = classType.resolveGenerics();
                PsiClass aClass = result.getElement();
                if (aClass != null) {
                    PsiSubstitutor substitutor = result.getSubstitutor();
                    for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                        PsiType psiType = substitutor.substitute(typeParameter);
                        if (psiType == null || ((Boolean)psiType.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    public boolean repeatInferencePhases() {
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (!this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i = this.myConstraintIdx; i < this.myConstraints.size(); ++i) {
            ConstraintFormula constraint = this.myConstraints.get(i);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    private boolean isThrowable(List<PsiType> upperBounds) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds) {
            if (upperBound.equalsToText("java.lang.Object") || !this.isProperType(upperBound)) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor) {
        LinkedHashSet<InferenceVariable> dependencies = new LinkedHashSet<InferenceVariable>();
        if (!this.collectDependencies(bound, dependencies)) {
            return bound;
        }
        for (InferenceVariable dependency : dependencies) {
            PsiType instantiation = dependency.getInstantiation();
            if (instantiation == PsiType.NULL) continue;
            substitutor = substitutor.put((PsiTypeParameter)dependency, instantiation);
        }
        return substitutor.substitute(bound);
    }

    private boolean hasBoundProblems(List<InferenceVariable> typeParams, PsiSubstitutor substitutor) {
        for (InferenceVariable typeParameter : typeParams) {
            List<PsiType> extendsTypes;
            PsiType[] bounds;
            PsiClass aClass;
            PsiType type2;
            if (typeParameter.getInstantiation() != PsiType.NULL || (type2 = substitutor.substitute((PsiTypeParameter)typeParameter)) instanceof PsiClassType && (aClass = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)((PsiTypeParameter)aClass)) || GenericsUtil.findTypeParameterBoundError((PsiTypeParameter)typeParameter, (PsiType[])(bounds = (extendsTypes = typeParameter.getBounds(InferenceBound.UPPER)).toArray(new PsiType[extendsTypes.size()])), (PsiSubstitutor)substitutor, (PsiElement)this.myContext, (boolean)true) == null) continue;
            return true;
        }
        return false;
    }

    private void resolveBounds(Collection<InferenceVariable> inferenceVariables, @NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            InferenceSession.$$$reportNull$$$0(13);
        }
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(inferenceVariables);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(allVars, this);
            List<InferenceVariable> unresolved = new ArrayList<InferenceVariable>();
            for (InferenceVariable var : vars) {
                PsiType eqBound = this.getEqualsBound(var, substitutor);
                if (eqBound != PsiType.NULL) continue;
                unresolved.add(var);
            }
            if (!unresolved.isEmpty() && vars.size() > unresolved.size()) {
                vars.removeAll(unresolved);
                vars.addAll(unresolved);
            }
            if (!this.myIncorporationPhase.hasCaptureConstraints(unresolved)) {
                PsiSubstitutor firstSubstitutor = this.resolveSubset(vars, substitutor);
                if (this.myErrorMessages == null && this.hasBoundProblems(vars, firstSubstitutor)) {
                    firstSubstitutor = null;
                    unresolved = vars;
                }
                if (firstSubstitutor != null) {
                    substitutor = firstSubstitutor;
                    allVars.removeAll(vars);
                    continue;
                }
            }
            if (!this.initFreshVariables(substitutor, unresolved)) {
                return;
            }
            this.myIncorporationPhase.forgetCaptures(vars);
            if (this.repeatInferencePhases()) continue;
            return;
        }
        this.setUncheckedInContext();
        Map map = substitutor.getSubstitutionMap();
        for (PsiTypeParameter parameter2 : map.keySet()) {
            PsiTypeParameter param;
            PsiType mapping = (PsiType)map.get(parameter2);
            if (parameter2 instanceof InferenceVariable) {
                ((InferenceVariable)parameter2).setInstantiation(mapping);
                if (((InferenceVariable)parameter2).getCallContext() != this.myContext) continue;
                param = ((InferenceVariable)parameter2).getParameter();
            } else {
                param = parameter2;
            }
            this.mySiteSubstitutor = this.mySiteSubstitutor.put(param, mapping);
        }
    }

    public void setUncheckedInContext() {
        if (this.myContext != null && !MethodCandidateInfo.isOverloadCheck()) {
            this.myContext.putUserData(ERASED, (Object)this.myErased);
        }
    }

    private boolean initFreshVariables(PsiSubstitutor substitutor, List<InferenceVariable> vars) {
        int i;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getManager().getProject());
        PsiSubstitutor ySubstitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] yVars = new PsiTypeParameter[vars.size()];
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        for (i = 0; i < vars.size(); ++i) {
            InferenceVariable var = vars.get(i);
            PsiTypeParameter parameter2 = var.getParameter();
            yVars[i] = elementFactory.createTypeParameterFromText(nameGenerator.generateUniqueName(parameter2.getName()), (PsiElement)parameter2);
            ySubstitutor = ySubstitutor.put((PsiTypeParameter)var, (PsiType)elementFactory.createType((PsiClass)yVars[i]));
        }
        for (i = 0; i < yVars.length; ++i) {
            PsiTypeParameter parameter3 = yVars[i];
            InferenceVariable var = vars.get(i);
            PsiType lub = this.getLowerBound(var, substitutor);
            if (lub != PsiType.NULL) {
                for (PsiClassType upperBoundType : parameter3.getExtendsListTypes()) {
                    if (TypeConversionUtil.isAssignable((PsiType)upperBoundType, (PsiType)lub)) continue;
                    return false;
                }
                parameter3.putUserData(LOWER_BOUND, (Object)lub);
            }
            parameter3.putUserData(UPPER_BOUND, (Object)this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, ySubstitutor.putAll(substitutor), true));
            TypeConversionUtil.markAsFreshVariable((PsiTypeParameter)parameter3, (PsiElement)this.myContext);
            if (var.addBound((PsiType)elementFactory.createType((PsiClass)parameter3), InferenceBound.EQ, this.myIncorporationPhase)) continue;
            return false;
        }
        return true;
    }

    private PsiSubstitutor resolveSubsetOrdered(Set<InferenceVariable> varsToResolve, PsiSubstitutor siteSubstitutor) {
        PsiSubstitutor substitutor = siteSubstitutor;
        Iterator<List<InferenceVariable>> varsIterator = InferenceVariablesOrder.resolveOrderIterator(varsToResolve, this);
        while (varsIterator.hasNext()) {
            List<InferenceVariable> vars = varsIterator.next();
            PsiSubstitutor resolveSubset = this.resolveSubset(vars, substitutor);
            substitutor = substitutor.putAll(resolveSubset);
        }
        return substitutor;
    }

    @NotNull
    private PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor) {
        if (this.myErased) {
            for (InferenceVariable var : vars) {
                substitutor = substitutor.put((PsiTypeParameter)var, null);
            }
        }
        for (InferenceVariable var : vars) {
            PsiType instantiation = var.getInstantiation();
            PsiType type2 = instantiation == PsiType.NULL ? this.checkBoundsConsistency(substitutor, var) : instantiation;
            if (type2 == PsiType.NULL) continue;
            substitutor = substitutor.put((PsiTypeParameter)var, type2);
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(14);
        }
        return psiSubstitutor;
    }

    private PsiType checkBoundsConsistency(PsiSubstitutor substitutor, InferenceVariable var) {
        PsiType type2;
        PsiType eqBound = this.getEqualsBound(var, substitutor);
        if (eqBound != PsiType.NULL && eqBound instanceof PsiPrimitiveType) {
            return PsiType.NULL;
        }
        PsiType lowerBound = this.getLowerBound(var, substitutor);
        PsiType upperBound = this.getUpperBound(var, substitutor);
        if (eqBound != PsiType.NULL && (this.myErased || eqBound != null)) {
            PsiCapturedWildcardType capturedWildcard;
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)eqBound);
            if (aClass instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)((PsiTypeParameter)aClass)) && (capturedWildcard = (PsiCapturedWildcardType)var.getUserData(ORIGINAL_CAPTURE)) != null && capturedWildcard.getUpperBound().equals(InferenceSession.getUpperBound(aClass))) {
                eqBound = capturedWildcard;
            }
            if (lowerBound != PsiType.NULL && !TypeConversionUtil.isAssignable((PsiType)eqBound, (PsiType)lowerBound)) {
                String incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION);
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
                return PsiType.NULL;
            }
            type2 = eqBound;
            if (!TypeConversionUtil.isAssignable((PsiType)eqBound, (PsiType)lowerBound, (boolean)false)) {
                this.setErased();
            }
        } else {
            type2 = InferenceVariable.modifyAnnotations(lowerBound, (lb, modifier) -> modifier.modifyLowerBoundAnnotations(lb, upperBound));
        }
        if (type2 == PsiType.NULL) {
            if (var.isThrownBound() && this.myPolicy.inferRuntimeExceptionForThrownBoundWithNoConstraints() && this.isThrowable(var.getBounds(InferenceBound.UPPER))) {
                type2 = PsiType.getJavaLangRuntimeException((PsiManager)this.myManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myManager.getProject()));
            } else {
                PsiType psiType = type2 = var.getBounds(InferenceBound.UPPER).size() == 1 ? (PsiType)this.myPolicy.getInferredTypeWithNoConstraint((PsiManager)this.myManager, (PsiType)upperBound).first : upperBound;
            }
            if (this.myErrorMessages == null && type2 instanceof PsiIntersectionType) {
                String conflictingConjunctsMessage = ((PsiIntersectionType)type2).getConflictingConjunctsMessage();
                if (conflictingConjunctsMessage == null) {
                    conflictingConjunctsMessage = InferenceSession.findParameterizationOfTheSameGenericClass(var.getBounds(InferenceBound.UPPER), (Processor<Pair<PsiType, PsiType>>)((Processor)pair -> pair.first == null || pair.second == null || Comparing.equal((Object)this.substituteNonProperBound((PsiType)pair.first, substitutor), (Object)this.substituteNonProperBound((PsiType)pair.second, substitutor)))) != null ? type2.getPresentableText(false) : InferenceSession.getConjunctsConflict((PsiIntersectionType)type2);
                }
                if (conflictingConjunctsMessage != null) {
                    this.registerIncompatibleErrorMessage("Type parameter " + var.getParameter().getName() + " has incompatible upper bounds: " + conflictingConjunctsMessage);
                    return PsiType.NULL;
                }
            }
        } else {
            for (PsiType upperType : var.getBounds(InferenceBound.UPPER)) {
                if (this.myErrorMessages != null || !this.isProperType(upperType)) continue;
                String incompatibleBoundsMessage = null;
                if (type2 != lowerBound && !TypeConversionUtil.isAssignable((PsiType)upperType, (PsiType)type2)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION);
                } else if (type2 == lowerBound && !TypeConversionUtil.isAssignable((PsiType)upperType, (PsiType)lowerBound)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION);
                }
                if (incompatibleBoundsMessage == null) continue;
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
                return PsiType.NULL;
            }
        }
        if (type2 == PsiType.NULL) {
            this.registerIncompatibleErrorMessage("Incompatible upper bounds: " + StringUtil.join(var.getBounds(InferenceBound.UPPER), bound -> {
                PsiType substituted = this.substituteNonProperBound((PsiType)bound, substitutor);
                return this.getPresentableText(substituted != null ? substituted : bound);
            }, (String)", "));
        }
        return type2;
    }

    private static String getConjunctsConflict(PsiIntersectionType type2) {
        PsiType[] conjuncts = type2.getConjuncts();
        for (int i = 0; i < conjuncts.length; ++i) {
            PsiClass conjunct = PsiUtil.resolveClassInClassTypeOnly((PsiType)conjuncts[i]);
            for (int i1 = 0; i1 < conjuncts.length; ++i1) {
                if (i == i1) continue;
                PsiClass oppositeConjunct = PsiUtil.resolveClassInClassTypeOnly((PsiType)conjuncts[i1]);
                if (conjunct != null && oppositeConjunct != null || (!(conjuncts[i] instanceof PsiArrayType) || !TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)((PsiArrayType)conjuncts[i]), (PsiType)conjuncts[i1])) && (!(conjuncts[i] instanceof PsiCapturedWildcardType) || oppositeConjunct == null || oppositeConjunct.isInterface() || oppositeConjunct instanceof PsiTypeParameter)) continue;
                return conjuncts[i].getPresentableText() + " and " + conjuncts[i1].getPresentableText();
            }
        }
        return null;
    }

    public String getPresentableText(PsiType psiType) {
        PsiType substituted = this.myRestoreNameSubstitution.substitute(psiType);
        return substituted != null ? substituted.getPresentableText() : null;
    }

    public void registerIncompatibleErrorMessage(Collection<InferenceVariable> variables, String incompatibleTypesMessage) {
        variables = new ArrayList<InferenceVariable>(variables);
        ((ArrayList)variables).sort((v1, v2) -> Comparing.compare((Comparable)((Object)v1.getName()), (Comparable)((Object)v2.getName())));
        String variablesEnumeration = StringUtil.join(variables, variable -> variable.getParameter().getName(), (String)", ");
        this.registerIncompatibleErrorMessage("no instance(s) of type variable(s) " + variablesEnumeration + " exist so that " + incompatibleTypesMessage);
    }

    public void registerIncompatibleErrorMessage(@NotNull String incompatibleBoundsMessage) {
        if (incompatibleBoundsMessage == null) {
            InferenceSession.$$$reportNull$$$0(15);
        }
        if (this.myErrorMessages == null) {
            this.myErrorMessages = new ArrayList<String>();
        }
        if (!this.myErrorMessages.contains(incompatibleBoundsMessage)) {
            this.myErrorMessages.add(incompatibleBoundsMessage);
        }
    }

    private String incompatibleBoundsMessage(InferenceVariable var, PsiSubstitutor substitutor, InferenceBound lowBound, String lowBoundName, InferenceBound upperBound, String upperBoundName) {
        Function typePresentation = type2 -> {
            PsiType substituted = this.substituteNonProperBound((PsiType)type2, substitutor);
            return this.getPresentableText(substituted != null ? substituted : type2);
        };
        return "inference variable " + var.getParameter().getName() + " has incompatible bounds:\n " + lowBoundName + ": " + StringUtil.join(var.getBounds(lowBound), (Function)typePresentation, (String)", ") + "\n" + upperBoundName + ": " + StringUtil.join(var.getBounds(upperBound), (Function)typePresentation, (String)", ");
    }

    private PsiType getLowerBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.LOWER, (Function<Pair<PsiType, PsiType>, PsiType>)((Function)pair -> GenericsUtil.getLeastUpperBound((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second), (PsiManager)this.myManager)), substitutor);
    }

    private PsiType getUpperBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, substitutor);
    }

    public PsiType getEqualsBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.EQ, (Function<Pair<PsiType, PsiType>, PsiType>)((Function)pair -> !Comparing.equal((Object)pair.first, (Object)pair.second) ? null : (PsiType)pair.first), substitutor);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor) {
        return this.composeBound(variable, boundType, fun, substitutor, false);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor, boolean includeNonProperBounds) {
        List<PsiType> lowerBounds = variable.getBounds(boundType);
        PsiPrimitiveType lub = PsiType.NULL;
        for (PsiType lowerBound : lowerBounds) {
            lowerBound = this.substituteNonProperBound(lowerBound, substitutor);
            if (!includeNonProperBounds && !this.isProperType(lowerBound)) continue;
            if (lub == PsiType.NULL) {
                lub = lowerBound;
                continue;
            }
            Pair pair = Pair.create((Object)lub, (Object)lowerBound);
            if ((lub = (PsiType)fun.fun((Object)pair)) != null) continue;
            return PsiType.NULL;
        }
        return lub;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        if (this.myContext != null) {
            return this.myContext.getResolveScope();
        }
        return GlobalSearchScope.allScope((Project)this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (this.myConstraintsCopy.add(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        PsiSubstitutor siteSubstitutor = PsiSubstitutor.EMPTY;
        while (!additionalConstraints.isEmpty()) {
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints, ignoredConstraints);
            LinkedHashSet<InferenceVariable> varsToResolve = new LinkedHashSet<InferenceVariable>();
            for (ConstraintFormula formula : subset) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
            }
            PsiSubstitutor substitutor = this.resolveSubsetOrdered(varsToResolve, siteSubstitutor);
            for (ConstraintFormula formula : subset) {
                if (this.processOneConstraint(formula, additionalConstraints, substitutor, ignoredConstraints)) continue;
                return false;
            }
        }
        return true;
    }

    private void collectVarsToResolve(Set<InferenceVariable> varsToResolve, InputOutputConstraintFormula formula) {
        Set<InferenceVariable> inputVariables = formula.getInputVariables(this);
        if (inputVariables != null) {
            for (InferenceVariable inputVariable : inputVariables) {
                varsToResolve.addAll(inputVariable.getDependencies(this));
            }
            varsToResolve.addAll(inputVariables);
        }
    }

    private boolean processOneConstraint(ConstraintFormula formula, Set<ConstraintFormula> additionalConstraints, PsiSubstitutor substitutor, Set<ConstraintFormula> ignoredConstraints) {
        PsiExpression expression2;
        if (this.myContext instanceof PsiCall) {
            PsiExpressionList argumentList = ((PsiCall)this.myContext).getArgumentList();
            LOG.assertTrue(argumentList != null);
            MethodCandidateInfo.updateSubstitutor((PsiElement)argumentList, (PsiSubstitutor)substitutor);
        }
        formula.apply(substitutor, true);
        this.addConstraint(formula);
        if (!this.repeatInferencePhases()) {
            return false;
        }
        if (formula instanceof ExpressionCompatibilityConstraint && (expression2 = ((ExpressionCompatibilityConstraint)formula).getExpression()) instanceof PsiLambdaExpression) {
            PsiType parameterType = ((PsiLambdaExpression)expression2).getGroundTargetType(((ExpressionCompatibilityConstraint)formula).getT());
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)expression2, parameterType, !this.isProperType(parameterType), substitutor);
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        Set<InferenceVariable> outputVariables = this.getOutputVariables(additionalConstraints);
        Set<InferenceVariable> ignoredOutputVariables = this.getOutputVariables(ignoredConstraints);
        LinkedHashSet<ConstraintFormula> subset = new LinkedHashSet<ConstraintFormula>();
        LinkedHashSet<ConstraintFormula> noInputVariables = new LinkedHashSet<ConstraintFormula>();
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                Set<InferenceVariable> inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        if (dependsOnOutput) break;
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        if (!this.hasCapture(inputVariable)) {
                            if (this.dependsOnOutput(ignoredOutputVariables, dependencies)) {
                                dependsOnOutput = true;
                                ignoredConstraints.add(constraint);
                                break;
                            }
                            dependsOnOutput = this.dependsOnOutput(outputVariables, dependencies);
                        }
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    if (!inputVariables.isEmpty()) continue;
                    noInputVariables.add(constraint);
                    continue;
                }
                subset.add(constraint);
                noInputVariables.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            additionalConstraints.removeAll(ignoredConstraints);
            if (!additionalConstraints.isEmpty()) {
                subset.add(additionalConstraints.iterator().next());
            }
        }
        if (!noInputVariables.isEmpty()) {
            subset = noInputVariables;
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    private boolean dependsOnOutput(Set<InferenceVariable> outputVariables, Set<InferenceVariable> dependencies) {
        for (InferenceVariable outputVariable : outputVariables) {
            if (!ContainerUtil.intersects(outputVariable.getDependencies(this), dependencies)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Set<InferenceVariable> getOutputVariables(Set<ConstraintFormula> constraintFormulas) {
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : constraintFormulas) {
            Set<InferenceVariable> inputVariables;
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        HashSet<InferenceVariable> hashSet = outputVariables;
        if (hashSet == null) {
            InferenceSession.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    public PsiSubstitutor collectApplicabilityConstraints(PsiMethodReferenceExpression reference, MethodCandidateInfo candidateInfo, PsiType functionalInterfaceType) {
        block12: {
            PsiSubstitutor psiSubstitutor;
            boolean isStatic;
            PsiParameter[] parameters2;
            PsiParameter[] functionalMethodParameters;
            PsiClass containingClass;
            PsiClass methodContainingClass;
            PsiMethod method;
            boolean varargs;
            MethodSignature signature;
            block11: {
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
                LOG.assertTrue(interfaceMethod != null, (Object)this.myContext);
                PsiSubstitutor functionalInterfaceSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult);
                signature = interfaceMethod.getSignature(functionalInterfaceSubstitutor);
                varargs = candidateInfo.isVarargs();
                method = candidateInfo.getElement();
                methodContainingClass = method.getContainingClass();
                PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)reference);
                containingClass = qualifierResolveResult.getContainingClass();
                if (containingClass == null) {
                    return this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
                }
                functionalMethodParameters = interfaceMethod.getParameterList().getParameters();
                parameters2 = method.getParameterList().getParameters();
                isStatic = method.hasModifierProperty("static");
                psiSubstitutor = qualifierResolveResult.getSubstitutor();
                if ((parameters2.length != functionalMethodParameters.length || varargs) && (!isStatic || !varargs)) break block11;
                if (method.isConstructor() && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)psiSubstitutor)) {
                    this.initBounds(containingClass.getTypeParameters());
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
                if (methodContainingClass != null) {
                    psiSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), psiSubstitutor);
                    LOG.assertTrue(psiSubstitutor != null, (Object)("derived: " + containingClass + "; super: " + methodContainingClass + "; reference: " + reference.getText() + "; containingFile: " + reference.getContainingFile().getName()));
                }
                for (int i = 0; i < functionalMethodParameters.length; ++i) {
                    PsiType pType = signature.getParameterTypes()[i];
                    this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards((PsiType)pType, (PsiElement)functionalMethodParameters[i])));
                }
                break block12;
            }
            if (!PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)reference, (MethodSignature)signature, (boolean)varargs, (boolean)isStatic, (int)parameters2.length)) break block12;
            PsiType pType = signature.getParameterTypes()[0];
            if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)psiSubstitutor)) {
                PsiSubstitutor receiverSubstitutor;
                PsiClassType subclassType = StrictSubtypingConstraint.getSubclassType(containingClass, pType, true);
                PsiSubstitutor psiSubstitutor2 = receiverSubstitutor = subclassType != null ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClassType)((PsiClassType)PsiUtil.captureToplevelWildcards((PsiType)subclassType, (PsiElement)this.myContext))) : null;
                if (receiverSubstitutor != null) {
                    if (!method.hasTypeParameters() && (signature.getParameterTypes().length == 1 || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)receiverSubstitutor))) {
                        return methodContainingClass != null ? JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), receiverSubstitutor) : receiverSubstitutor;
                    }
                    this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(receiverSubstitutor);
                    if (methodContainingClass != null) {
                        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), receiverSubstitutor);
                        LOG.assertTrue(superSubstitutor != null, (Object)("mContainingClass: " + methodContainingClass.getName() + "; containingClass: " + containingClass.getName()));
                        this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(superSubstitutor);
                    }
                    psiSubstitutor = receiverSubstitutor;
                }
            }
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)containingClass, (PsiElement)JavaPsiFacade.getElementFactory((Project)reference.getProject()).getArrayClass(PsiUtil.getLanguageLevel((PsiElement)reference)))) {
                return null;
            }
            PsiClassType qType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(containingClass, psiSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables((PsiType)qType), pType));
            if (methodContainingClass != null) {
                psiSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), psiSubstitutor);
                LOG.assertTrue(psiSubstitutor != null, (Object)("derived: " + containingClass + "; super: " + methodContainingClass + "; reference: " + reference.getText() + "; containingFile: " + reference.getContainingFile().getName()));
            }
            for (int i = 0; i < signature.getParameterTypes().length - 1; ++i) {
                PsiType interfaceParamType = signature.getParameterTypes()[i + 1];
                this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards((PsiType)interfaceParamType, (PsiElement)functionalMethodParameters[i])));
            }
        }
        return null;
    }

    public void setErased() {
        this.myErased = true;
    }

    public InferenceVariable getInferenceVariable(PsiTypeParameter parameter2) {
        return parameter2 instanceof InferenceVariable && this.myInferenceVariables.contains(parameter2) ? (InferenceVariable)parameter2 : null;
    }

    public static boolean isMoreSpecific(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context, boolean varargs) {
        return (Boolean)LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])m1.getTypeParameters(), (PsiSubstitutor)siteSubstitutor1, () -> InferenceSession.isMoreSpecificInternal(m1, m2, siteSubstitutor1, args, context, varargs));
    }

    private static boolean isMoreSpecificInternal(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context, boolean varargs) {
        ArrayList<PsiTypeParameter> params = new ArrayList<PsiTypeParameter>();
        for (PsiTypeParameter param : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)m2)) {
            params.add(param);
        }
        siteSubstitutor1 = InferenceSession.getSiteSubstitutor(siteSubstitutor1, params);
        InferenceSession session = new InferenceSession(params.toArray(new PsiTypeParameter[params.size()]), siteSubstitutor1, m2.getManager(), context);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        PsiParameter[] parameters2 = m2.getParameterList().getParameters();
        if (!varargs) {
            LOG.assertTrue(parameters1.length == parameters2.length);
        }
        int paramsLength = !varargs ? parameters1.length : Math.max(parameters1.length, parameters2.length) - 1;
        for (int i = 0; i < paramsLength; ++i) {
            PsiType sType = InferenceSession.getParameterType(parameters1, i, siteSubstitutor1, false);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, siteSubstitutor1, varargs));
            if (sType instanceof PsiClassType && tType instanceof PsiClassType && LambdaUtil.isFunctionalType((PsiType)sType) && LambdaUtil.isFunctionalType((PsiType)tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args[i])) continue;
                return false;
            }
            if (session.isProperType(tType) && !TypeConversionUtil.isAssignable((PsiType)tType, (PsiType)sType)) {
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = InferenceSession.getParameterType(parameters1, paramsLength, siteSubstitutor1, true);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, paramsLength, siteSubstitutor1, true));
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases();
    }

    private static PsiSubstitutor getSiteSubstitutor(PsiSubstitutor siteSubstitutor1, List<PsiTypeParameter> params) {
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter param : params) {
            subst = subst.put(param, siteSubstitutor1.substitute(param));
        }
        return subst;
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiType capturedSType = sType;
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType((PsiType)capturedSType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)sInterfaceMethod, (PsiClassType.ClassResolveResult)sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType((PsiType)tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)tInterfaceMethod, (PsiClassType.ClassResolveResult)tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    protected static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals((Object)tReturnType)) {
                return true;
            }
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)arg));
            if (sReturnType instanceof PsiClassType && tReturnType instanceof PsiClassType && LambdaUtil.isFunctionalType((PsiType)sReturnType) && LambdaUtil.isFunctionalType((PsiType)tReturnType) && !TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)sReturnType), (PsiType)TypeConversionUtil.erasure((PsiType)tReturnType)) && !TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)tReturnType), (PsiType)TypeConversionUtil.erasure((PsiType)sReturnType))) {
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(new PsiExpression[returnExpressions.size()]))) {
                    return false;
                }
            } else {
                boolean tPrimitive;
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)sReturnType);
                boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)tReturnType);
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression2 : returnExpressions) {
                        if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)returnExpression2)) {
                            PsiType returnExpressionType = returnExpression2.getType();
                            if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                            return false;
                        }
                        if (!sPrimitive) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable((PsiType)tReturnType, (PsiType)sReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            boolean tPrimitive;
            PsiParameter[] tParameters;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            LOG.assertTrue(sParameters.length == (tParameters = tInterfaceMethod.getParameterList().getParameters()).length, (Object)("s: " + sInterfaceMethod.getParameterList().getText() + "; t: " + tInterfaceMethod.getParameterList().getText()));
            for (int i = 0; i < tParameters.length; ++i) {
                PsiType tSubstituted = tSubstitutor.substitute(tParameters[i].getType());
                PsiType sSubstituted = sSubstitutor.substitute(sParameters[i].getType());
                if (session != null) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                    continue;
                }
                if (Comparing.equal((Object)tSubstituted, (Object)sSubstituted)) continue;
                return false;
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals((Object)tReturnType)) {
                return true;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)sReturnType);
            boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)tReturnType);
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null, (Object)arg);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)methodReturnType) || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable((PsiType)tReturnType, (PsiType)sReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression2 = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression2 = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression2, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression2, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure((PsiType)tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure((PsiType)sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable((PsiType)sConjunctErasure, (PsiType)erasedType);
                subRelation |= TypeConversionUtil.isAssignable((PsiType)erasedType, (PsiType)sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure((PsiType)sType)) != null) {
            return TypeConversionUtil.isAssignable((PsiType)sTypeErasure, (PsiType)erasedType) || TypeConversionUtil.isAssignable((PsiType)erasedType, (PsiType)sTypeErasure);
        }
        return false;
    }

    public void collectCaptureDependencies(InferenceVariable inferenceVariable, Set<InferenceVariable> dependencies) {
        this.myIncorporationPhase.collectCaptureDependencies(inferenceVariable, dependencies);
    }

    public boolean hasCapture(InferenceVariable inferenceVariable) {
        return this.myIncorporationPhase.hasCaptureConstraints(Collections.singletonList(inferenceVariable));
    }

    public static boolean wasUncheckedConversionPerformed(PsiElement call) {
        PsiExpressionList args;
        Boolean erased = (Boolean)call.getUserData(ERASED);
        if (erased != null && erased.booleanValue()) {
            return true;
        }
        if (call instanceof PsiCallExpression && (args = ((PsiCallExpression)call).getArgumentList()) != null) {
            for (PsiExpression expression2 : args.getExpressions()) {
                if (expression2 instanceof PsiNewExpression && !PsiDiamondType.hasDiamond((PsiNewExpression)((PsiNewExpression)expression2)) || !InferenceSession.wasUncheckedConversionPerformed((PsiElement)expression2)) continue;
                return true;
            }
        }
        return false;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public void propagateVariables(Collection<InferenceVariable> variables, PsiSubstitutor restoreNamesSubstitution) {
        this.myInferenceVariables.addAll(variables);
        this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.putAll(restoreNamesSubstitution);
    }

    public PsiType substituteWithInferenceVariables(@Nullable PsiType type2) {
        return this.myInferenceSubstitution.substitute(type2);
    }

    public PsiSubstitutor getInferenceSubstitution() {
        return this.myInferenceSubstitution;
    }

    public PsiSubstitutor getRestoreNameSubstitution() {
        return this.myRestoreNameSubstitution;
    }

    public InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    public PsiType startWithFreshVars(PsiType type2) {
        PsiSubstitutor s = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : this.myInferenceVariables) {
            s = s.put((PsiTypeParameter)variable, (PsiType)JavaPsiFacade.getElementFactory((Project)variable.getProject()).createType((PsiClass)variable.getParameter()));
        }
        return s.substitute(type2);
    }

    public static PsiClass findParameterizationOfTheSameGenericClass(List<PsiType> upperBounds, Processor<Pair<PsiType, PsiType>> processor) {
        for (int i = 0; i < upperBounds.size(); ++i) {
            PsiType sBound = upperBounds.get(i);
            PsiClass sClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)sBound);
            if (sClass == null) continue;
            LinkedHashSet superClasses = InheritanceUtil.getSuperClasses((PsiClass)sClass);
            superClasses.add(sClass);
            for (int j = i + 1; j < upperBounds.size(); ++j) {
                PsiType tBound = upperBounds.get(j);
                PsiClass tClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)tBound);
                if (tClass == null) continue;
                LinkedHashSet tSupers = InheritanceUtil.getSuperClasses((PsiClass)tClass);
                tSupers.add(tClass);
                tSupers.retainAll(superClasses);
                for (PsiClass gClass : tSupers) {
                    PsiSubstitutor sSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)gClass, (PsiClassType)((PsiClassType)sBound));
                    PsiSubstitutor tSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)gClass, (PsiClassType)((PsiClassType)tBound));
                    for (PsiTypeParameter typeParameter : gClass.getTypeParameters()) {
                        PsiType tType;
                        PsiType sType = sSubstitutor.substituteWithBoundsPromotion(typeParameter);
                        Pair typePair = Pair.create((Object)sType, (Object)(tType = tSubstitutor.substituteWithBoundsPromotion(typeParameter)));
                        if (processor.process((Object)typePair)) continue;
                        return gClass;
                    }
                }
            }
        }
        return null;
    }

    public List<String> getIncompatibleErrorMessages() {
        return this.myErrorMessages;
    }

    public boolean isErased() {
        return this.myErased;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiSubstitutor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSubstitutor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatibleBoundsMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "infer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "performGuardedInference";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSubset";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUpperBound";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLowerBound";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterOwner";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalAndInfer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performGuardedInference";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doInfer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveBounds";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerIncompatibleErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

