/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodCandidatesProcessor
extends MethodsProcessor {
    protected boolean myHasAccessibleStaticCorrectCandidate;

    public MethodCandidatesProcessor(@NotNull PsiElement place, PsiFile placeFile, @NotNull PsiConflictResolver[] resolvers, @NotNull List<CandidateInfo> container) {
        if (place == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(0);
        }
        if (resolvers == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(1);
        }
        if (container == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(2);
        }
        super(resolvers, container, place, placeFile);
    }

    public MethodCandidatesProcessor(@NotNull PsiElement place, PsiFile placeFile) {
        if (place == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(3);
        }
        super(new PsiConflictResolver[]{DuplicateConflictResolver.INSTANCE}, (List<CandidateInfo>)new SmartList(), place, placeFile);
    }

    @Override
    public void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor) {
        if (element == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(4);
        }
        if (substitutor == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            this.addMethod(method, substitutor, this.isInStaticScope() && !method.hasModifierProperty("static"));
        }
    }

    public void addMethod(@NotNull PsiMethod method, PsiSubstitutor substitutor, boolean staticProblem) {
        boolean isAccessible;
        if (method == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(6);
        }
        boolean bl = isAccessible = JavaResolveUtil.isAccessible((PsiMember)method, this.getContainingClass(method), method.getModifierList(), this.myPlace, this.myAccessClass, this.myCurrentFileContext, this.myPlaceFile) && !this.isShadowed(method);
        if (!(!this.isAccepted(method) || this.isInterfaceStaticMethodAccessibleThroughInheritance(method) && ImportsUtil.hasStaticImportOn((PsiElement)this.myPlace, (PsiMember)method, (boolean)true))) {
            PsiClass containingClass;
            if (!staticProblem && this.myAccessClass != null && method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && containingClass.isInterface() && !(this.myAccessClass instanceof PsiTypeParameter) && !containingClass.equals(this.myAccessClass)) {
                staticProblem = true;
            }
            this.add((CandidateInfo)this.createCandidateInfo(method, substitutor, staticProblem, isAccessible, false));
            if (this.acceptVarargs() && method.isVarArgs() && PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myPlace)) {
                this.add((CandidateInfo)this.createCandidateInfo(method, substitutor, staticProblem, isAccessible, true));
            }
            this.myHasAccessibleStaticCorrectCandidate |= isAccessible;
        }
    }

    private boolean isInterfaceStaticMethodAccessibleThroughInheritance(PsiMethod method) {
        if (method.hasModifierProperty("static") && !(this.myCurrentFileContext instanceof PsiImportStaticStatement) && this.myPlace instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)this.myPlace).getMethodExpression().getQualifierExpression() == null) {
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && containingClass.isInterface();
        }
        return false;
    }

    protected PsiClass getContainingClass(PsiMethod method) {
        return method.getContainingClass();
    }

    protected boolean acceptVarargs() {
        return false;
    }

    protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean staticProblem, boolean accessible, final boolean varargs) {
        if (method == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(7);
        }
        if (substitutor == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(8);
        }
        final PsiExpressionList argumentList = this.getArgumentList();
        return new MethodCandidateInfo((PsiElement)method, substitutor, !accessible, staticProblem, (PsiElement)argumentList, this.myCurrentFileContext, null, this.getTypeArguments(), this.getLanguageLevel()){
            private PsiType[] myExpressionTypes;

            public PsiType[] getArgumentTypes() {
                if (this.myExpressionTypes == null && argumentList != null) {
                    PsiType[] expressionTypes = MethodCandidatesProcessor.getExpressionTypes(argumentList);
                    if (MethodCandidateInfo.isOverloadCheck() || LambdaUtil.isLambdaParameterCheck()) {
                        return expressionTypes;
                    }
                    this.myExpressionTypes = expressionTypes;
                }
                return this.myExpressionTypes;
            }

            public boolean isVarargs() {
                return varargs;
            }
        };
    }

    protected static PsiType[] getExpressionTypes(PsiExpressionList argumentList) {
        return argumentList != null ? argumentList.getExpressionTypes() : null;
    }

    protected boolean isAccepted(PsiMethod candidate) {
        if (!this.isConstructor()) {
            return !candidate.isConstructor() && candidate.getName().equals(this.getName(ResolveState.initial()));
        }
        if (!candidate.isConstructor()) {
            return false;
        }
        if (this.myAccessClass == null) {
            return true;
        }
        if (this.myAccessClass instanceof PsiAnonymousClass) {
            PsiClass containingClass = this.getContainingClass(candidate);
            return containingClass != null && containingClass.equals(this.myAccessClass.getSuperClass());
        }
        return this.myAccessClass.isEquivalentTo((PsiElement)this.getContainingClass(candidate));
    }

    protected boolean isShadowed(PsiMethod candidate) {
        if (this.myCurrentFileContext instanceof PsiImportStaticStatement) {
            for (JavaResolveResult result : this.getResults()) {
                if (result.getElement() == candidate || !result.isAccessible() || result.getCurrentFileResolveScope() instanceof PsiImportStaticStatement) continue;
                return true;
            }
        }
        return false;
    }

    public CandidateInfo[] getCandidates() {
        JavaResolveResult[] resolveResult = this.getResult();
        if (resolveResult.length == 0) {
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] infos = new CandidateInfo[resolveResult.length];
        System.arraycopy(resolveResult, 0, infos, 0, resolveResult.length);
        return infos;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/scope/processor/MethodCandidatesProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createCandidateInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

