/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;

public class ChangeSignatureUtil {
    private ChangeSignatureUtil() {
    }

    public static <Parent extends PsiElement, Child extends PsiElement> void synchronizeList(Parent list, List<Child> newElements, ChildrenGenerator<Parent, Child> generator, boolean[] shouldRemoveChild) throws IncorrectOperationException {
        List<Child> elements;
        ArrayList<Child> elementsToRemove = null;
        int index = 0;
        while (true) {
            elements = generator.getChildren(list);
            if (index == newElements.size()) break;
            if (elementsToRemove == null) {
                elementsToRemove = new ArrayList<Child>();
                for (int i = 0; i < shouldRemoveChild.length; ++i) {
                    if (!shouldRemoveChild[i] || i >= elements.size()) continue;
                    elementsToRemove.add(elements.get(i));
                }
            }
            PsiElement oldElement = index < elements.size() ? (PsiElement)elements.get(index) : null;
            PsiElement newElement = (PsiElement)newElements.get(index);
            if (newElement != null) {
                if (!newElement.equals(oldElement)) {
                    if (oldElement != null && elementsToRemove.contains(oldElement)) {
                        oldElement.delete();
                        --index;
                    } else {
                        assert (list.isWritable()) : PsiUtilCore.getVirtualFile(list);
                        list.addBefore(newElement, oldElement);
                        if (list.equals(newElement.getParent())) {
                            newElement.delete();
                        }
                    }
                }
            } else if (!(newElements.size() <= 1 || elements.isEmpty() && index >= newElements.size() - 1)) {
                PsiElement anchor = index == 0 ? list.getFirstChild() : (index - 1 < elements.size() ? (PsiElement)elements.get(index - 1) : null);
                CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)list.getNode());
                PsiElement psi = Factory.createSingleLeafElement((IElementType)JavaTokenType.COMMA, (CharSequence)",", (int)0, (int)1, (CharTable)charTable, (PsiManager)list.getManager()).getPsi();
                if (anchor != null) {
                    list.addAfter(psi, anchor);
                } else {
                    list.add(psi);
                }
            }
            ++index;
        }
        for (int i = newElements.size(); i < elements.size(); ++i) {
            PsiElement element = (PsiElement)elements.get(i);
            element.delete();
        }
    }

    public static void invokeChangeSignatureOn(PsiMethod method, Project project) {
        ChangeSignatureHandler handler = ((RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(method.getLanguage())).getChangeSignatureHandler();
        if (handler != null) {
            handler.invoke(project, new PsiElement[]{method}, null);
        }
    }

    public static boolean deepTypeEqual(PsiType type1, PsiType type2) {
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || !type1.equals(type2)) {
            return false;
        }
        return Comparing.equal((String)type1.getCanonicalText(true), (String)type2.getCanonicalText(true));
    }

    public static interface ChildrenGenerator<Parent extends PsiElement, Child extends PsiElement> {
        public List<Child> getChildren(Parent var1);
    }
}

