/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.DetectedJavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaChangeSignatureDetector
implements LanguageChangeSignatureDetector<DetectedJavaChangeInfo> {
    private static final Logger LOG = Logger.getInstance(JavaChangeSignatureDetector.class);

    @NotNull
    public DetectedJavaChangeInfo createInitialChangeInfo(@NotNull PsiElement element) {
        if (element == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(0);
        }
        DetectedJavaChangeInfo detectedJavaChangeInfo = DetectedJavaChangeInfo.createFromMethod((PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class), false);
        if (detectedJavaChangeInfo == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(1);
        }
        return detectedJavaChangeInfo;
    }

    public void performChange(DetectedJavaChangeInfo changeInfo, Editor editor, @NotNull String oldText) {
        if (oldText == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(2);
        }
        changeInfo.perform(oldText, editor, true);
    }

    public boolean isChangeSignatureAvailableOnElement(@NotNull PsiElement element, DetectedJavaChangeInfo currentInfo) {
        if (element == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(3);
        }
        PsiMethod method = currentInfo.getMethod();
        TextRange range = method.getTextRange();
        PsiCodeBlock body2 = method.getBody();
        if (body2 != null) {
            range = new TextRange(range.getStartOffset(), body2.getTextOffset());
        }
        return element.getContainingFile() == method.getContainingFile() && range.contains(element.getTextRange());
    }

    public boolean ignoreChanges(PsiElement element) {
        if (element instanceof PsiMethod) {
            return true;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportList.class) != null;
    }

    public TextRange getHighlightingRange(@NotNull DetectedJavaChangeInfo changeInfo) {
        PsiMethod method;
        if (changeInfo == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(4);
        }
        return (method = changeInfo.getMethod()) != null ? JavaChangeSignatureDetector.getSignatureRange(method) : null;
    }

    public String getMethodSignaturePreview(DetectedJavaChangeInfo initialChangeInfo, List<TextRange> deleteRanges, List<TextRange> newRanges) {
        CanonicalTypes.Type returnType;
        StringBuilder buf = new StringBuilder();
        String visibility = VisibilityUtil.getVisibilityString((String)initialChangeInfo.getNewVisibility());
        buf.append(visibility);
        if (!StringUtil.isEmptyOrSpaces((String)visibility)) {
            buf.append(" ");
        }
        if ((returnType = initialChangeInfo.getNewReturnType()) != null) {
            buf.append(returnType.getTypeText()).append(" ");
        }
        buf.append(initialChangeInfo.getNewName()).append("(");
        JavaParameterInfo[] newParameters = initialChangeInfo.getNewParameters();
        boolean first = true;
        boolean[] toRemove = initialChangeInfo.toRemoveParm();
        block0: for (int i = 0; i < toRemove.length; ++i) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            String oldParamName = initialChangeInfo.getOldParameterNames()[i];
            String oldParamType = initialChangeInfo.getOldParameterTypes()[i];
            if (toRemove[i]) {
                String deletedParam = oldParamType + " " + oldParamName;
                deleteRanges.add(new TextRange(buf.length(), buf.length() + deletedParam.length()));
                buf.append(deletedParam);
                continue;
            }
            for (JavaParameterInfo parameter2 : newParameters) {
                if (parameter2.getOldIndex() != i) continue;
                buf.append(parameter2.getTypeText());
                buf.append(" ");
                if (!oldParamName.equals(parameter2.getName())) {
                    deleteRanges.add(new TextRange(buf.length(), buf.length() + oldParamName.length()));
                    buf.append(oldParamName);
                }
                buf.append(parameter2.getName());
                continue block0;
            }
        }
        for (JavaParameterInfo param : newParameters) {
            if (param.getOldIndex() != -1) continue;
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            String paramPresentation = param.getTypeText() + " " + (String)ObjectUtils.notNull((Object)param.getName(), (Object)"");
            newRanges.add(new TextRange(buf.length(), buf.length() + paramPresentation.length()));
            buf.append(paramPresentation);
        }
        buf.append(")");
        return buf.toString();
    }

    public FileType getFileType() {
        return JavaFileType.INSTANCE;
    }

    public DetectedJavaChangeInfo createNextChangeInfo(String signature, @NotNull DetectedJavaChangeInfo currentInfo, boolean delegate) {
        PsiMethod currentInfoMethod;
        if (currentInfo == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(5);
        }
        if ((currentInfoMethod = currentInfo.getMethod()) == null) {
            return null;
        }
        Project project = currentInfoMethod.getProject();
        PsiMethod oldMethod = currentInfo.getMethod();
        String visibility = "";
        PsiClass containingClass = oldMethod.getContainingClass();
        if (containingClass != null && containingClass.isInterface()) {
            visibility = "public ";
        }
        PsiMethod method = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText((visibility + signature).trim(), (PsiElement)oldMethod);
        return currentInfo.createNextInfo(method, delegate);
    }

    public static TextRange getSignatureRange(PsiMethod method) {
        int endOffset = method.getThrowsList().getTextRange().getEndOffset();
        int startOffset = method.getTextRange().getStartOffset();
        return new TextRange(startOffset, endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialChangeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInitialChangeInfo";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isChangeSignatureAvailableOnElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightingRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNextChangeInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

