/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ExceptionsTableModel;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.JavaParameterTableModel;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.inCallers.JavaCallerChooser;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.JavaCodeFragmentTableCellEditor;
import com.intellij.refactoring.ui.JavaComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TableColumnAnimator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChangeSignatureDialog
extends ChangeSignatureDialogBase<ParameterInfoImpl, PsiMethod, String, JavaMethodDescriptor, ParameterTableModelItemBase<ParameterInfoImpl>, JavaParameterTableModel> {
    private ExceptionsTableModel myExceptionsModel;
    protected Set<PsiMethod> myMethodsToPropagateExceptions;
    private AnActionButton myPropExceptionsButton;
    private Tree myExceptionPropagationTree;

    public JavaChangeSignatureDialog(Project project, PsiMethod method, boolean allowDelegation, PsiElement context) {
        this(project, new JavaMethodDescriptor(method), allowDelegation, context);
    }

    protected JavaChangeSignatureDialog(Project project, JavaMethodDescriptor descriptor, boolean allowDelegation, PsiElement context) {
        super(project, (MethodDescriptor)descriptor, allowDelegation, context);
    }

    public static JavaChangeSignatureDialog createAndPreselectNew(Project project, PsiMethod method, List<ParameterInfoImpl> parameterInfos, boolean allowDelegation, PsiReferenceExpression refExpr) {
        return JavaChangeSignatureDialog.createAndPreselectNew(project, method, parameterInfos, allowDelegation, refExpr, null);
    }

    public static JavaChangeSignatureDialog createAndPreselectNew(Project project, PsiMethod method, final List<ParameterInfoImpl> parameterInfos, boolean allowDelegation, PsiReferenceExpression refExpr, final Consumer<List<ParameterInfoImpl>> callback) {
        return new JavaChangeSignatureDialog(project, method, allowDelegation, (PsiElement)refExpr){

            protected int getSelectedIdx() {
                for (int i = 0; i < parameterInfos.size(); ++i) {
                    ParameterInfoImpl info = (ParameterInfoImpl)parameterInfos.get(i);
                    if (info.oldParameterIndex >= 0) continue;
                    return i;
                }
                return super.getSelectedIdx();
            }

            @Override
            protected BaseRefactoringProcessor createRefactoringProcessor() {
                List parameters2 = this.getParameters();
                return new ChangeSignatureProcessor(this.myProject, ((JavaMethodDescriptor)this.myMethod).getMethod(), this.isGenerateDelegate(), (String)this.getVisibility(), this.getMethodName(), this.getReturnType(), parameters2.toArray(new ParameterInfoImpl[parameters2.size()]), this.getExceptions(), this.myMethodsToPropagateParameters, this.myMethodsToPropagateExceptions){

                    protected void performRefactoring(@NotNull UsageInfo[] usages) {
                        if (usages == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.performRefactoring(usages);
                        if (callback != null) {
                            callback.consume((Object)this.getParameters());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDialog$1$1", "performRefactoring"));
                    }
                };
            }
        };
    }

    protected VisibilityPanelBase<String> createVisibilityControl() {
        return new JavaComboBoxVisibilityPanel();
    }

    protected JComponent createCenterPanel() {
        JComponent centerPanel = super.createCenterPanel();
        this.myPropagateParamChangesButton.setVisible(true);
        return centerPanel;
    }

    protected void updatePropagateButtons() {
        super.updatePropagateButtons();
        this.myPropExceptionsButton.setEnabled(!this.isGenerateDelegate() && this.mayPropagateExceptions());
    }

    protected boolean mayPropagateExceptions() {
        PsiClassType[] types;
        ThrownExceptionInfo[] exceptions = this.myExceptionsModel.getThrownExceptions();
        if (exceptions.length <= (types = ((JavaMethodDescriptor)this.myMethod).getMethod().getThrowsList().getReferencedTypes()).length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (exceptions[i].getOldIndex() == i) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected List<Pair<String, JPanel>> createAdditionalPanels() {
        this.myExceptionsModel = new ExceptionsTableModel((PsiElement)((JavaMethodDescriptor)this.myMethod).getMethod().getThrowsList());
        this.myExceptionsModel.setTypeInfos(((JavaMethodDescriptor)this.myMethod).getMethod());
        final JBTable table = new JBTable((TableModel)this.myExceptionsModel);
        table.setStriped(true);
        table.setRowHeight(20);
        table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new CodeFragmentTableCellRenderer(this.myProject));
        final JavaCodeFragmentTableCellEditor cellEditor = new JavaCodeFragmentTableCellEditor(this.myProject);
        cellEditor.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                int row = table.getSelectedRow();
                int col = table.getSelectedColumn();
                JavaChangeSignatureDialog.this.myExceptionsModel.setValueAt(cellEditor.getCellEditorValue(), row, col);
                JavaChangeSignatureDialog.this.updateSignature();
            }
        });
        table.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)((Object)cellEditor));
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().setSelectionInterval(0, 0);
        table.setSurrendersFocusOnKeystroke(true);
        this.myPropExceptionsButton = new AnActionButton(RefactoringBundle.message((String)"changeSignature.propagate.exceptions.title"), null, AllIcons.Hierarchy.Caller){

            public void actionPerformed(AnActionEvent e) {
                Ref chooser = new Ref();
                Consumer callback = psiMethods -> {
                    JavaChangeSignatureDialog.this.myMethodsToPropagateExceptions = psiMethods;
                    JavaChangeSignatureDialog.this.myExceptionPropagationTree = ((JavaCallerChooser)((Object)((Object)chooser.get()))).getTree();
                };
                chooser.set((Object)new JavaCallerChooser(((JavaMethodDescriptor)JavaChangeSignatureDialog.this.myMethod).getMethod(), JavaChangeSignatureDialog.this.myProject, RefactoringBundle.message((String)"changeSignature.exception.caller.chooser"), JavaChangeSignatureDialog.this.myExceptionPropagationTree, (Consumer<Set<PsiMethod>>)callback));
                ((JavaCallerChooser)((Object)chooser.get())).show();
            }
        };
        this.myPropExceptionsButton.setShortcut((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"alt X"}));
        JPanel panel = ToolbarDecorator.createDecorator((JTable)table).addExtraAction(this.myPropExceptionsButton).createPanel();
        panel.setBorder((Border)JBUI.Borders.empty());
        this.myExceptionsModel.addTableModelListener((TableModelListener)this.mySignatureUpdater);
        ArrayList<Pair<String, JPanel>> result = new ArrayList<Pair<String, JPanel>>();
        String message2 = RefactoringBundle.message((String)"changeSignature.exceptions.panel.border.title");
        result.add(Pair.create((Object)message2, (Object)panel));
        ArrayList<Pair<String, JPanel>> arrayList = result;
        if (arrayList == null) {
            JavaChangeSignatureDialog.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    protected LanguageFileType getFileType() {
        return StdFileTypes.JAVA;
    }

    protected JavaParameterTableModel createParametersInfoModel(JavaMethodDescriptor descriptor) {
        PsiParameterList parameterList = descriptor.getMethod().getParameterList();
        return new JavaParameterTableModel((PsiElement)parameterList, this.myDefaultValueContext, (RefactoringDialog)this);
    }

    protected boolean isListTableViewSupported() {
        return true;
    }

    protected ChangeSignatureDialogBase.ParametersListTable createParametersListTable() {
        return new ChangeSignatureDialogBase.ParametersListTable(){
            private final EditorTextFieldJBTableRowRenderer myRowRenderer;
            {
                this.myRowRenderer = new EditorTextFieldJBTableRowRenderer(JavaChangeSignatureDialog.this.getProject(), (FileType)JavaChangeSignatureDialog.this.getFileType(), JavaChangeSignatureDialog.this.myDisposable){

                    protected String getText(JTable table, int row) {
                        ParameterTableModelItemBase item = this.getRowItem(row);
                        String typeText = item.typeCodeFragment.getText();
                        String separator = StringUtil.repeatSymbol((char)' ', (int)(JavaChangeSignatureDialog.this.getTypesMaxLength() - typeText.length() + 1));
                        String text2 = typeText + separator + ((ParameterInfoImpl)item.parameter).getName();
                        String defaultValue = item.defaultValueCodeFragment.getText();
                        String tail = "";
                        if (StringUtil.isNotEmpty((String)defaultValue)) {
                            tail = tail + " default value = " + defaultValue;
                        }
                        if (((ParameterInfoImpl)item.parameter).isUseAnySingleVariable()) {
                            if (StringUtil.isNotEmpty((String)defaultValue)) {
                                tail = tail + ";";
                            }
                            tail = tail + " Use any var.";
                        }
                        if (!StringUtil.isEmpty((String)tail)) {
                            text2 = text2 + " //" + tail;
                        }
                        return " " + text2;
                    }
                };
            }

            protected JBTableRowRenderer getRowRenderer(int row) {
                return this.myRowRenderer;
            }

            @NotNull
            protected JBTableRowEditor getRowEditor(final ParameterTableModelItemBase<ParameterInfoImpl> item) {
                JBTableRowEditor jBTableRowEditor = new JBTableRowEditor(){
                    private EditorTextField myTypeEditor;
                    private EditorTextField myNameEditor;
                    private EditorTextField myDefaultValueEditor;
                    private JCheckBox myAnyVar;

                    public void prepareEditor(JTable table, int row) {
                        this.setLayout(new BorderLayout());
                        Document document = PsiDocumentManager.getInstance((Project)JavaChangeSignatureDialog.this.getProject()).getDocument((PsiFile)item.typeCodeFragment);
                        this.myTypeEditor = new EditorTextField(document, JavaChangeSignatureDialog.this.getProject(), (FileType)JavaChangeSignatureDialog.this.getFileType());
                        this.myTypeEditor.addDocumentListener((DocumentListener)JavaChangeSignatureDialog.this.mySignatureUpdater);
                        this.myTypeEditor.setPreferredWidth(this.getTable().getWidth() / 2);
                        this.myTypeEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 0));
                        this.add(2.createLabeledPanel((String)"Type:", (JComponent)this.myTypeEditor), "West");
                        this.myNameEditor = new EditorTextField(((ParameterInfoImpl)item.parameter).getName(), JavaChangeSignatureDialog.this.getProject(), (FileType)JavaChangeSignatureDialog.this.getFileType());
                        this.myNameEditor.addDocumentListener((DocumentListener)JavaChangeSignatureDialog.this.mySignatureUpdater);
                        this.myNameEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 1));
                        this.add(2.createLabeledPanel((String)"Name:", (JComponent)this.myNameEditor), "Center");
                        new TextFieldCompletionProvider(){

                            protected void addCompletionVariants(@NotNull String text2, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                                PsiCodeFragment fragment;
                                if (text2 == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (prefix == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (result == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                if ((fragment = item.typeCodeFragment) instanceof PsiTypeCodeFragment) {
                                    PsiType type2;
                                    try {
                                        type2 = ((PsiTypeCodeFragment)fragment).getType();
                                    }
                                    catch (Exception e) {
                                        return;
                                    }
                                    SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)JavaChangeSignatureDialog.this.myProject).suggestVariableName(VariableKind.PARAMETER, null, null, type2);
                                    for (String completionVariant : info.names) {
                                        LookupElementBuilder element = LookupElementBuilder.create((String)completionVariant);
                                        result.addElement((LookupElement)element.withLookupString(completionVariant.toLowerCase(Locale.ENGLISH)));
                                    }
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "text";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "prefix";
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "result";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureDialog$4$2$1";
                                objectArray[2] = "addCompletionVariants";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        }.apply(this.myNameEditor, ((ParameterInfoImpl)item.parameter).getName());
                        if (!item.isEllipsisType() && ((ParameterInfoImpl)item.parameter).getOldIndex() == -1) {
                            JPanel additionalPanel = new JPanel(new BorderLayout());
                            Document doc = PsiDocumentManager.getInstance((Project)JavaChangeSignatureDialog.this.getProject()).getDocument((PsiFile)item.defaultValueCodeFragment);
                            this.myDefaultValueEditor = new EditorTextField(doc, JavaChangeSignatureDialog.this.getProject(), (FileType)JavaChangeSignatureDialog.this.getFileType());
                            ((PsiExpressionCodeFragment)item.defaultValueCodeFragment).setExpectedType(JavaChangeSignatureDialog.getRowType((ParameterTableModelItemBase<ParameterInfoImpl>)item));
                            this.myDefaultValueEditor.setPreferredWidth(this.getTable().getWidth() / 2);
                            this.myDefaultValueEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 2));
                            additionalPanel.add((Component)2.createLabeledPanel((String)"Default value:", (JComponent)this.myDefaultValueEditor), "West");
                            if (!JavaChangeSignatureDialog.this.isGenerateDelegate()) {
                                this.myAnyVar = new JCheckBox("&Use Any Var");
                                UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myAnyVar);
                                DialogUtil.registerMnemonic((AbstractButton)this.myAnyVar, (char)'&');
                                this.myAnyVar.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        ((ParameterInfoImpl)item.parameter).setUseAnySingleVariable(myAnyVar.isSelected());
                                    }
                                });
                                JPanel anyVarPanel = new JPanel(new BorderLayout());
                                anyVarPanel.add((Component)this.myAnyVar, "South");
                                UIUtil.addInsets((JComponent)anyVarPanel, (Insets)JBUI.insetsBottom((int)8));
                                additionalPanel.add((Component)anyVarPanel, "Center");
                            }
                            this.add(additionalPanel, "South");
                        }
                    }

                    public JBTableRow getValue() {
                        return new JBTableRow(){

                            public Object getValueAt(int column) {
                                switch (column) {
                                    case 0: {
                                        return item.typeCodeFragment;
                                    }
                                    case 1: {
                                        return myNameEditor.getText().trim();
                                    }
                                    case 2: {
                                        return item.defaultValueCodeFragment;
                                    }
                                    case 3: {
                                        return myAnyVar != null && myAnyVar.isSelected();
                                    }
                                }
                                return null;
                            }
                        };
                    }

                    public JComponent getPreferredFocusedComponent() {
                        MouseEvent me = this.getMouseEvent();
                        if (me == null) {
                            return this.myTypeEditor.getFocusTarget();
                        }
                        double x = me.getPoint().getX();
                        return x <= (double)JavaChangeSignatureDialog.this.getTypesColumnWidth() ? this.myTypeEditor.getFocusTarget() : (this.myDefaultValueEditor == null || x <= (double)JavaChangeSignatureDialog.this.getNamesColumnWidth() ? this.myNameEditor.getFocusTarget() : this.myDefaultValueEditor.getFocusTarget());
                    }

                    public JComponent[] getFocusableComponents() {
                        ArrayList<JComponent> focusable = new ArrayList<JComponent>();
                        focusable.add(this.myTypeEditor.getFocusTarget());
                        focusable.add(this.myNameEditor.getFocusTarget());
                        if (this.myDefaultValueEditor != null) {
                            focusable.add(this.myDefaultValueEditor.getFocusTarget());
                        }
                        if (this.myAnyVar != null) {
                            focusable.add(this.myAnyVar);
                        }
                        return focusable.toArray(new JComponent[focusable.size()]);
                    }
                };
                if (jBTableRowEditor == null) {
                    4.$$$reportNull$$$0(0);
                }
                return jBTableRowEditor;
            }

            protected boolean isRowEmpty(int row) {
                ParameterInfoImpl parameter2 = (ParameterInfoImpl)this.getRowItem((int)row).parameter;
                return StringUtil.isEmpty((String)parameter2.getName()) && StringUtil.isEmpty((String)parameter2.getTypeText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDialog$4", "getRowEditor"));
            }
        };
    }

    private int getTypesMaxLength() {
        int len = 0;
        for (ParameterTableModelItemBase item : ((JavaParameterTableModel)this.myParametersTableModel).getItems()) {
            String text2 = item.typeCodeFragment == null ? null : item.typeCodeFragment.getText();
            len = Math.max(len, text2 == null ? 0 : text2.length());
        }
        return len;
    }

    private int getNamesMaxLength() {
        int len = 0;
        for (ParameterTableModelItemBase item : ((JavaParameterTableModel)this.myParametersTableModel).getItems()) {
            String text2 = ((ParameterInfoImpl)item.parameter).getName();
            len = Math.max(len, text2 == null ? 0 : text2.length());
        }
        return len;
    }

    private int getColumnWidth(int index) {
        int letters = this.getTypesMaxLength() + (index == 0 ? 1 : this.getNamesMaxLength() + 2);
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        font = new Font(font.getFontName(), font.getStyle(), 12);
        return letters * Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("W");
    }

    private int getTypesColumnWidth() {
        return this.getColumnWidth(0);
    }

    private int getNamesColumnWidth() {
        return this.getColumnWidth(1);
    }

    @Nullable
    private static PsiType getRowType(ParameterTableModelItemBase<ParameterInfoImpl> item) {
        try {
            return ((PsiTypeCodeFragment)item.typeCodeFragment).getType();
        }
        catch (PsiTypeCodeFragment.NoTypeException | PsiTypeCodeFragment.TypeSyntaxException e) {
            return null;
        }
    }

    protected void customizeParametersTable(TableView<ParameterTableModelItemBase<ParameterInfoImpl>> table) {
        final JTable t = table.getComponent();
        final TableColumn defaultValue = t.getColumnModel().getColumn(2);
        final TableColumn varArg = t.getColumnModel().getColumn(3);
        t.removeColumn(defaultValue);
        t.removeColumn(varArg);
        t.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 1) {
                    t.getModel().removeTableModelListener(this);
                    TableColumnAnimator animator = new TableColumnAnimator(t);
                    animator.setStep(48);
                    animator.addColumn(defaultValue, (t.getWidth() - 48) / 3);
                    animator.addColumn(varArg, 48);
                    animator.startAndDoWhenDone(() -> t.editCellAt(t.getRowCount() - 1, 0));
                    animator.start();
                }
            }
        });
    }

    protected void invokeRefactoring(BaseRefactoringProcessor processor) {
        if (this.myMethodsToPropagateExceptions != null && !this.mayPropagateExceptions()) {
            Messages.showWarningDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.exceptions.wont.propagate"), (String)ChangeSignatureHandler.REFACTORING_NAME);
            this.myMethodsToPropagateExceptions = null;
        }
        super.invokeRefactoring(processor);
    }

    protected BaseRefactoringProcessor createRefactoringProcessor() {
        List parameters2 = this.getParameters();
        return new ChangeSignatureProcessor(this.myProject, ((JavaMethodDescriptor)this.myMethod).getMethod(), this.isGenerateDelegate(), (String)this.getVisibility(), this.getMethodName(), this.getReturnType(), parameters2.toArray(new ParameterInfoImpl[parameters2.size()]), this.getExceptions(), this.myMethodsToPropagateParameters, this.myMethodsToPropagateExceptions);
    }

    @Nullable
    protected CanonicalTypes.Type getReturnType() {
        if (this.myReturnTypeField != null) {
            try {
                PsiType type2 = ((PsiTypeCodeFragment)this.myReturnTypeCodeFragment).getType();
                return CanonicalTypes.createTypeWrapper(type2);
            }
            catch (PsiTypeCodeFragment.NoTypeException | PsiTypeCodeFragment.TypeSyntaxException e) {
                return null;
            }
        }
        return null;
    }

    protected ThrownExceptionInfo[] getExceptions() {
        return this.myExceptionsModel.getThrownExceptions();
    }

    protected PsiCodeFragment createReturnTypeCodeFragment() {
        String returnTypeText = StringUtil.notNullize((String)((JavaMethodDescriptor)this.myMethod).getReturnTypeText());
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)this.myProject);
        return factory.createTypeCodeFragment(returnTypeText, (PsiElement)((JavaMethodDescriptor)this.myMethod).getMethod(), true, 1);
    }

    protected CallerChooserBase<PsiMethod> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<PsiMethod>> callback) {
        return new JavaCallerChooser(((JavaMethodDescriptor)this.myMethod).getMethod(), this.myProject, title, treeToReuse, callback);
    }

    protected String validateAndCommitData() {
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String name = this.getMethodName();
        if (!PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(name)) {
            return RefactoringMessageUtil.getIncorrectIdentifierMessage(name);
        }
        if (((JavaMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite) {
            try {
                ((PsiTypeCodeFragment)this.myReturnTypeCodeFragment).getType();
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myReturnTypeField, true));
                return RefactoringBundle.message((String)"changeSignature.wrong.return.type", (Object[])new Object[]{this.myReturnTypeCodeFragment.getText()});
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myReturnTypeField, true));
                return RefactoringBundle.message((String)"changeSignature.no.return.type");
            }
        }
        List parameterInfos = ((JavaParameterTableModel)this.myParametersTableModel).getItems();
        int newParametersNumber = parameterInfos.size();
        for (int i = 0; i < newParametersNumber; ++i) {
            String def;
            PsiType type2;
            ParameterTableModelItemBase item = (ParameterTableModelItemBase)parameterInfos.get(i);
            if (!PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(((ParameterInfoImpl)item.parameter).getName())) {
                return RefactoringMessageUtil.getIncorrectIdentifierMessage(((ParameterInfoImpl)item.parameter).getName());
            }
            try {
                type2 = ((PsiTypeCodeFragment)((ParameterTableModelItemBase)parameterInfos.get((int)i)).typeCodeFragment).getType();
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                return RefactoringBundle.message((String)"changeSignature.wrong.type.for.parameter", (Object[])new Object[]{item.typeCodeFragment.getText(), ((ParameterInfoImpl)item.parameter).getName()});
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                return RefactoringBundle.message((String)"changeSignature.no.type.for.parameter", (Object[])new Object[]{"return", ((ParameterInfoImpl)item.parameter).getName()});
            }
            ((ParameterInfoImpl)item.parameter).setType(type2);
            if (type2 instanceof PsiEllipsisType && i != newParametersNumber - 1) {
                return RefactoringBundle.message((String)"changeSignature.vararg.not.last");
            }
            if (((ParameterInfoImpl)item.parameter).oldParameterIndex >= 0) continue;
            ((ParameterInfoImpl)item.parameter).defaultValue = def = (String)WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> JavaCodeStyleManager.getInstance((Project)this.myProject).qualifyClassReferences((PsiElement)item.defaultValueCodeFragment).getText().trim());
            if (type2 instanceof PsiEllipsisType) continue;
            try {
                if (StringUtil.isEmpty((String)def)) continue;
                factory.createExpressionFromText(def, null);
                continue;
            }
            catch (IncorrectOperationException e) {
                return e.getMessage();
            }
        }
        ThrownExceptionInfo[] exceptionInfos = this.myExceptionsModel.getThrownExceptions();
        PsiTypeCodeFragment[] typeCodeFragments = this.myExceptionsModel.getTypeCodeFragments();
        for (int i = 0; i < exceptionInfos.length; ++i) {
            ThrownExceptionInfo exceptionInfo = exceptionInfos[i];
            PsiTypeCodeFragment typeCodeFragment = typeCodeFragments[i];
            try {
                PsiType type3 = typeCodeFragment.getType();
                if (!(type3 instanceof PsiClassType)) {
                    return RefactoringBundle.message((String)"changeSignature.wrong.type.for.exception", (Object[])new Object[]{typeCodeFragment.getText()});
                }
                PsiClassType throwable = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createTypeByFQClassName("java.lang.Throwable", type3.getResolveScope());
                if (!throwable.isAssignableFrom(type3)) {
                    return RefactoringBundle.message((String)"changeSignature.not.throwable.type", (Object[])new Object[]{typeCodeFragment.getText()});
                }
                exceptionInfo.setType((PsiClassType)type3);
                continue;
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                return RefactoringBundle.message((String)"changeSignature.wrong.type.for.exception", (Object[])new Object[]{typeCodeFragment.getText()});
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                return RefactoringBundle.message((String)"changeSignature.no.type.for.exception");
            }
        }
        try {
            if (((JavaMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite && PsiTypesUtil.hasUnresolvedComponents((PsiType)((PsiTypeCodeFragment)this.myReturnTypeCodeFragment).getType()) && Messages.showOkCancelDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.cannot.resolve.return.type", (Object[])new Object[]{this.myReturnTypeCodeFragment.getText()}), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getWarningIcon()) != 0) {
                return "";
            }
            for (ParameterTableModelItemBase item : parameterInfos) {
                if (!PsiTypesUtil.hasUnresolvedComponents((PsiType)((PsiTypeCodeFragment)item.typeCodeFragment).getType()) || Messages.showOkCancelDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.cannot.resolve.parameter.type", (Object[])new Object[]{item.typeCodeFragment.getText(), ((ParameterInfoImpl)item.parameter).getName()}), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getWarningIcon()) == 0) continue;
                return "";
            }
        }
        catch (PsiTypeCodeFragment.IncorrectTypeException incorrectTypeException) {
            // empty catch block
        }
        return null;
    }

    protected ValidationInfo doValidate() {
        if (!this.getTableComponent().isEditing()) {
            for (ParameterTableModelItemBase item : ((JavaParameterTableModel)this.myParametersTableModel).getItems()) {
                if (((ParameterInfoImpl)item.parameter).oldParameterIndex >= 0 || !StringUtil.isEmpty((String)item.defaultValueCodeFragment.getText())) continue;
                return new ValidationInfo("Default value is missing. Method calls will contain blanks instead of the new parameter value.");
            }
        }
        return super.doValidate();
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected String calculateSignature() {
        return this.doCalculateSignature(((JavaMethodDescriptor)this.myMethod).getMethod());
    }

    protected String doCalculateSignature(PsiMethod method) {
        String text2;
        StringBuilder buffer = new StringBuilder();
        PsiModifierList modifierList = method.getModifierList();
        String modifiers = modifierList.getText();
        String oldModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList);
        String newModifier = (String)ObjectUtils.notNull((Object)this.getVisibility(), (Object)"packageLocal");
        String newModifierStr = VisibilityUtil.getVisibilityString((String)newModifier);
        if (!Comparing.equal((String)newModifier, (String)oldModifier)) {
            int index = modifiers.indexOf(oldModifier);
            if (index >= 0) {
                StringBuilder buf = new StringBuilder(modifiers);
                buf.replace(index, index + oldModifier.length() + (StringUtil.isEmpty((String)newModifierStr) ? 1 : 0), newModifierStr);
                modifiers = buf.toString();
            } else {
                if (!StringUtil.isEmpty((String)newModifierStr)) {
                    newModifierStr = newModifierStr + " ";
                }
                modifiers = newModifierStr + modifiers;
            }
        }
        buffer.append(modifiers);
        if (!(modifiers.length() <= 0 || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\n') || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\r') || StringUtil.endsWithChar((CharSequence)modifiers, (char)' '))) {
            buffer.append(" ");
        }
        if (!method.isConstructor()) {
            CanonicalTypes.Type type2 = this.getReturnType();
            if (type2 != null) {
                buffer.append(type2.getTypeText());
            }
            buffer.append(" ");
        }
        buffer.append(this.getMethodName());
        buffer.append("(");
        int lineBreakIdx = buffer.lastIndexOf("\n");
        String indent = StringUtil.repeatSymbol((char)' ', (int)(lineBreakIdx >= 0 ? buffer.length() - lineBreakIdx - 1 : buffer.length()));
        List items = ((JavaParameterTableModel)this.myParametersTableModel).getItems();
        int curIndent = indent.length();
        for (int i = 0; i < items.size(); ++i) {
            ParameterTableModelItemBase item = (ParameterTableModelItemBase)items.get(i);
            if (i > 0) {
                buffer.append(",");
                buffer.append("\n");
                buffer.append(indent);
            }
            text2 = item.typeCodeFragment.getText();
            buffer.append(text2).append(" ");
            String name = ((ParameterInfoImpl)item.parameter).getName();
            buffer.append(name);
            curIndent = indent.length() + text2.length() + 1 + name.length();
        }
        buffer.append(")");
        PsiTypeCodeFragment[] thrownExceptionsFragments = this.myExceptionsModel.getTypeCodeFragments();
        if (thrownExceptionsFragments.length > 0) {
            buffer.append(" throws ");
            indent = StringUtil.repeatSymbol((char)' ', (int)(curIndent += 9));
            for (int i = 0; i < thrownExceptionsFragments.length; ++i) {
                text2 = thrownExceptionsFragments[i].getText();
                if (i != 0) {
                    buffer.append(indent);
                }
                buffer.append(text2);
                if (i < thrownExceptionsFragments.length - 1) {
                    buffer.append(",");
                }
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDialog", "createAdditionalPanels"));
    }
}

