/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.FunctionalInterfaceSuggester;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.IntroduceFunctionalVariableAction;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceFunctionalVariableHandler
extends IntroduceVariableHandler {
    @Override
    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        if (project == null) {
            IntroduceFunctionalVariableHandler.$$$reportNull$$$0(0);
        }
        ExtractMethodHandler.selectAndPass(project, editor, file, new Pass<PsiElement[]>(){

            public void pass(final PsiElement[] elements) {
                if (elements.length == 0) {
                    String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
                    IntroduceFunctionalVariableHandler.this.showErrorMessage(project, editor, message2);
                    return;
                }
                PsiElement anchorStatement = elements[0] instanceof PsiComment ? elements[0] : RefactoringUtil.getParentStatement(elements[0], false);
                PsiElement tempContainer = IntroduceFunctionalVariableHandler.this.checkAnchorStatement(project, editor, anchorStatement);
                if (tempContainer == null) {
                    return;
                }
                PsiElement[] elementsInCopy = IntroduceParameterHandler.getElementsInCopy(project, file, elements);
                final MyExtractMethodProcessor processor = new MyExtractMethodProcessor(project, editor, elementsInCopy, null, IntroduceFunctionalVariableAction.REFACTORING_NAME, null, "refactoring.introduceVariable");
                processor.setShowErrorDialogs(false);
                try {
                    if (!processor.prepare()) {
                        IntroduceFunctionalVariableHandler.this.showErrorMessage(project, editor);
                        return;
                    }
                }
                catch (PrepareFailedException e) {
                    IntroduceFunctionalVariableHandler.this.showErrorMessage(project, editor, e.getMessage());
                    return;
                }
                if (!processor.showDialog()) {
                    return;
                }
                PsiMethod emptyMethod = processor.generateEmptyMethod("name", elements[0]);
                Collection<? extends PsiType> types = FunctionalInterfaceSuggester.suggestFunctionalInterfaces(emptyMethod);
                if (types.isEmpty()) {
                    types = FunctionalInterfaceSuggester.suggestFunctionalInterfaces(emptyMethod, true);
                }
                if (types.isEmpty()) {
                    IntroduceFunctionalVariableHandler.this.showErrorMessage(project, editor, "No applicable functional interfaces found");
                    return;
                }
                if (types.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                    IntroduceFunctionalVariableHandler.this.functionalInterfaceSelected((PsiType)ContainerUtil.getFirstItem(types), project, editor, processor, elements);
                } else {
                    final LinkedHashMap<PsiClass, PsiType> classes2 = new LinkedHashMap<PsiClass, PsiType>();
                    for (PsiType psiType : types) {
                        classes2.put(PsiUtil.resolveClassInType((PsiType)psiType), psiType);
                    }
                    PsiClass[] psiClasses = classes2.keySet().toArray(new PsiClass[classes2.size()]);
                    String string = PsiFormatUtil.formatMethod((PsiMethod)emptyMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)256, (int)2);
                    PsiType returnType = emptyMethod.getReturnType();
                    assert (returnType != null);
                    String title = "Choose Applicable Functional Interface: " + string + " -> " + returnType.getPresentableText();
                    NavigationUtil.getPsiElementPopup((PsiElement[])psiClasses, (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)title, (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                        public boolean execute(@NotNull PsiClass psiClass) {
                            if (psiClass == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            IntroduceFunctionalVariableHandler.this.functionalInterfaceSelected((PsiType)classes2.get(psiClass), project, editor, processor, elements);
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/refactoring/introduceVariable/IntroduceFunctionalVariableHandler$1$1", "execute"));
                        }
                    }).showInBestPositionFor(editor);
                }
            }
        });
    }

    private void functionalInterfaceSelected(PsiType type2, Project project, Editor editor, MyExtractMethodProcessor processor, PsiElement[] elements) {
        if (!elements[0].isValid()) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)elements[0])) {
            return;
        }
        MyExtractMethodProcessor physicalProcessor = new MyExtractMethodProcessor(project, editor, elements, null, IntroduceFunctionalVariableAction.REFACTORING_NAME, null, "refactoring.introduceVariable");
        try {
            physicalProcessor.prepare();
        }
        catch (PrepareFailedException e) {
            this.showErrorMessage(project, editor);
        }
        physicalProcessor.copyParameters(processor);
        physicalProcessor.setMethodVisibility("public");
        CommandProcessor.getInstance().executeCommand(project, () -> {
            PsiMethodCallExpression expression2 = (PsiMethodCallExpression)WriteAction.compute(() -> IntroduceFunctionalVariableHandler.createReplacement(project, type2, physicalProcessor));
            this.invokeImpl(project, expression2.getMethodExpression().getQualifierExpression(), editor);
        }, IntroduceFunctionalVariableAction.REFACTORING_NAME, null);
    }

    private static PsiMethodCallExpression createReplacement(Project project, PsiType selectedType, ExtractMethodProcessor processor) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)selectedType);
        PsiClass wrapperClass = resolveResult.getElement();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)wrapperClass);
        assert (method != null) : "not functional class";
        String interfaceMethodName = method.getName();
        processor.setMethodName(interfaceMethodName);
        processor.doExtract();
        PsiMethod extractedMethod = processor.getExtractedMethod();
        PsiParameter[] parameters2 = extractedMethod.getParameterList().getParameters();
        PsiParameter[] interfaceParameters = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        for (int i = 0; i < interfaceParameters.length; ++i) {
            PsiTypeElement typeAfterInterface = factory.createTypeElement(substitutor.substitute(interfaceParameters[i].getType()));
            PsiTypeElement typeElement = parameters2[i].getTypeElement();
            if (typeElement == null) continue;
            typeElement.replace((PsiElement)typeAfterInterface);
        }
        PsiMethodCallExpression methodCall = processor.getMethodCall();
        PsiMethodCallExpression psiExpression = (PsiMethodCallExpression)factory.createExpressionFromText("new " + selectedType.getCanonicalText() + "() {}." + methodCall.getText(), (PsiElement)methodCall);
        PsiExpression qualifierExpression2 = psiExpression.getMethodExpression().getQualifierExpression();
        assert (qualifierExpression2 != null);
        PsiAnonymousClass anonymousClass = ((PsiNewExpression)qualifierExpression2).getAnonymousClass();
        assert (anonymousClass != null);
        ChangeContextUtil.encodeContextInfo((PsiElement)extractedMethod, true);
        PsiClass aClass = extractedMethod.getContainingClass();
        ChangeContextUtil.decodeContextInfo(anonymousClass.add((PsiElement)extractedMethod), aClass, (PsiExpression)RefactoringChangeUtil.createThisExpression(anonymousClass.getManager(), aClass));
        if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(anonymousClass, false, Collections.emptySet())) {
            PsiExpression castExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("((" + selectedType.getCanonicalText() + ")" + AnonymousCanBeLambdaInspection.replaceAnonymousWithLambda((PsiElement)qualifierExpression2, selectedType).getText() + ")", (PsiElement)qualifierExpression2);
            qualifierExpression2.replace((PsiElement)castExpression);
        }
        extractedMethod.delete();
        return (PsiMethodCallExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(methodCall.replace((PsiElement)psiExpression));
    }

    @Override
    protected void showErrorMessage(Project project, Editor editor, String message2) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)IntroduceFunctionalVariableAction.REFACTORING_NAME, (String)"refactoring.introduceVariable");
    }

    private void showErrorMessage(@NotNull Project project, Editor editor) {
        if (project == null) {
            IntroduceFunctionalVariableHandler.$$$reportNull$$$0(1);
        }
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{IntroduceFunctionalVariableAction.REFACTORING_NAME}));
        this.showErrorMessage(project, editor, message2);
    }

    protected void setupProcessorWithoutDialog(ExtractMethodProcessor processor, InputVariables inputVariables) {
        processor.setDataFromInputVariables();
        processor.setMethodVisibility("public");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/refactoring/introduceVariable/IntroduceFunctionalVariableHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyExtractMethodProcessor
    extends ExtractMethodProcessor {
        public MyExtractMethodProcessor(Project project, Editor editor, PsiElement[] elements, PsiType forcedReturnType, String refactoringName, String initialMethodName, String helpId) {
            super(project, editor, elements, forcedReturnType, refactoringName, initialMethodName, helpId);
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        protected boolean isFoldingApplicable() {
            return false;
        }

        @Override
        protected void showMultipleOutputMessage(PsiType expressionType) throws PrepareFailedException {
            throw new PrepareFailedException(this.buildMultipleOutputMessageError(expressionType), this.myElements[0]);
        }

        @Override
        protected AbstractExtractDialog createExtractMethodDialog(boolean direct) {
            this.setDataFromInputVariables();
            return new ExtractMethodDialog(this.myProject, this.myTargetClass, this.myInputVariables, null, this.getTypeParameterList(), (PsiType[])this.getThrownExceptions(), this.isStatic(), this.isCanBeStatic(), false, IntroduceFunctionalVariableAction.REFACTORING_NAME, "refactoring.introduceVariable", null, this.myElements){

                @Override
                protected JComponent createNorthPanel() {
                    if (!MyExtractMethodProcessor.this.myInputVariables.hasInstanceFields()) {
                        return null;
                    }
                    JPanel optionsPanel = new JPanel(new FlowLayout(0, 0, 5));
                    this.createStaticOptions(optionsPanel, RefactoringBundle.message((String)"introduce.functional.variable.pass.fields.checkbox"));
                    return optionsPanel;
                }

                @Override
                public JComponent getPreferredFocusedComponent() {
                    return this.myParamTable;
                }

                @Override
                protected String getSignature() {
                    String parametersList = Arrays.stream(this.getChosenParameters()).filter(data -> data.passAsParameter).map(data -> data.type.getPresentableText()).reduce((result, item) -> result + ", " + item).orElse("");
                    String returnTypeString = MyExtractMethodProcessor.this.myReturnType == null || PsiType.VOID.equals((Object)MyExtractMethodProcessor.this.myReturnType) ? "{}" : MyExtractMethodProcessor.this.myReturnType.getPresentableText();
                    return "(" + parametersList + ") -> " + returnTypeString;
                }

                @Override
                protected void checkMethodConflicts(MultiMap<PsiElement, String> conflicts) {
                    this.checkParametersConflicts(conflicts);
                    for (VariableData data : this.getChosenParameters()) {
                        if (data.passAsParameter) continue;
                        PsiElement scope = PsiUtil.getVariableCodeBlock((PsiVariable)data.variable, null);
                        if (!(PsiUtil.isLanguageLevel8OrHigher((PsiElement)data.variable) ? scope != null && !HighlightControlFlowUtil.isEffectivelyFinal(data.variable, scope, null) : data.variable.hasModifierProperty("final"))) continue;
                        conflicts.putValue(null, (Object)("Variable " + data.name + " is not effectively final and won't be accessible inside functional expression"));
                    }
                }

                @Override
                @NotNull
                public String getVisibility() {
                    if ("public" == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return "public";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceVariable/IntroduceFunctionalVariableHandler$MyExtractMethodProcessor$1", "getVisibility"));
                }
            };
        }

        @Override
        public boolean prepare(@Nullable Pass<ExtractMethodProcessor> pass) throws PrepareFailedException {
            boolean prepare = super.prepare(pass);
            if (prepare && (this.myNotNullConditionalCheck || this.myNullConditionalCheck)) {
                return false;
            }
            return prepare;
        }

        @Override
        public boolean showDialog() {
            if (!this.myInputVariables.hasInstanceFields() && this.myInputVariables.getInputVariables().isEmpty() || ApplicationManager.getApplication().isUnitTestMode()) {
                IntroduceFunctionalVariableHandler.this.setupProcessorWithoutDialog(this, this.myInputVariables);
                return true;
            }
            return super.showDialog();
        }

        @Override
        protected boolean defineVariablesForUnselectedParameters() {
            return false;
        }

        public void copyParameters(MyExtractMethodProcessor processor) {
            this.myInputVariables.setPassFields(processor.myInputVariables.isPassFields());
            VariableData[] variables = processor.myVariableDatum;
            this.myVariableDatum = new VariableData[variables.length];
            for (int i = 0; i < variables.length; ++i) {
                VariableData data = variables[i];
                String variableName = data.variable.getName();
                assert (variableName != null);
                VariableData dataByVName = this.myInputVariables.getInputVariables().stream().filter(vData -> variableName.equals(vData.variable.getName())).findFirst().orElse(null);
                if (dataByVName == null) continue;
                dataByVName.passAsParameter = data.passAsParameter;
                dataByVName.name = data.name;
                this.myVariableDatum[i] = dataByVName;
            }
        }
    }
}

