/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.impl.source.jsp.jspJava.JspCodeBlock;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.java.ReplaceExpressionUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.ChainCallInplaceIntroducer;
import com.intellij.refactoring.introduceVariable.InputValidator;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.introduceVariable.JavaVariableInplaceIntroducer;
import com.intellij.refactoring.introduceVariable.ReassignVariableUtil;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.refactoring.util.occurrences.NotInSuperCallOccurrenceFilter;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceVariableBase
extends IntroduceHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceVariable.IntroduceVariableBase");
    @NonNls
    private static final String PREFER_STATEMENTS_OPTION = "introduce.variable.prefer.statements";
    @NonNls
    private static final String REFACTORING_ID = "refactoring.extractVariable";
    protected static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.variable.title");
    public static final Key<Boolean> NEED_PARENTHESIS = Key.create((String)"NEED_PARENTHESIS");
    private JavaVariableInplaceIntroducer myInplaceIntroducer;

    public static SuggestedNameInfo getSuggestedName(@Nullable PsiType type2, @NotNull PsiExpression expression2) {
        if (expression2 == null) {
            IntroduceVariableBase.$$$reportNull$$$0(0);
        }
        return IntroduceVariableBase.getSuggestedName(type2, expression2, (PsiElement)expression2);
    }

    public static SuggestedNameInfo getSuggestedName(@Nullable PsiType type2, @NotNull PsiExpression expression2, PsiElement anchor) {
        if (expression2 == null) {
            IntroduceVariableBase.$$$reportNull$$$0(1);
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression2.getProject());
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, expression2, type2);
        String[] strings = JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, type2, VariableKind.LOCAL_VARIABLE, nameInfo);
        SuggestedNameInfo.Delegate delegate = new SuggestedNameInfo.Delegate(strings, nameInfo);
        return codeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)delegate, anchor, true);
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        SelectionModel selectionModel;
        if (project == null) {
            IntroduceVariableBase.$$$reportNull$$$0(2);
        }
        if (!(selectionModel = editor.getSelectionModel()).hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement[] statementsInRange = IntroduceVariableBase.findStatementsAtOffset(editor, file, offset);
            if (statementsInRange.length == 1 && IntroduceVariableBase.selectLineAtCaret(offset, statementsInRange)) {
                selectionModel.selectLineAtCaret();
                PsiExpression expressionInRange = IntroduceVariableBase.findExpressionInRange(project, file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
                if (expressionInRange == null || IntroduceVariableBase.getErrorMessage(expressionInRange) != null) {
                    selectionModel.removeSelection();
                }
            }
            if (!selectionModel.hasSelection()) {
                List<PsiExpression> expressions2 = IntroduceVariableBase.collectExpressions(file, editor, offset);
                if (expressions2.isEmpty()) {
                    selectionModel.selectLineAtCaret();
                } else if (!IntroduceVariableBase.isChooserNeeded(expressions2)) {
                    TextRange textRange = expressions2.get(0).getTextRange();
                    selectionModel.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                } else {
                    IntroduceTargetChooser.showChooser((Editor)editor, expressions2, (Pass)new Pass<PsiExpression>(){

                        public void pass(PsiExpression selectedValue) {
                            IntroduceVariableBase.this.invoke(project, editor, file, selectedValue.getTextRange().getStartOffset(), selectedValue.getTextRange().getEndOffset());
                        }
                    }, (Function)new PsiExpressionTrimRenderer.RenderFunction(), (String)"Expressions", (int)IntroduceVariableBase.preferredSelection(statementsInRange, expressions2), (NotNullFunction)ScopeHighlighter.NATURAL_RANGER);
                    return;
                }
            }
        }
        if (this.invoke(project, editor, file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) && LookupManager.getActiveLookup((Editor)editor) == null) {
            selectionModel.removeSelection();
        }
    }

    public static boolean isChooserNeeded(List<PsiExpression> exprs) {
        if (exprs.size() == 1) {
            PsiExpression expression2 = exprs.get(0);
            return expression2 instanceof PsiNewExpression && ((PsiNewExpression)expression2).getAnonymousClass() != null;
        }
        return true;
    }

    public static boolean selectLineAtCaret(int offset, PsiElement[] statementsInRange) {
        TextRange range = statementsInRange[0].getTextRange();
        if (statementsInRange[0] instanceof PsiExpressionStatement) {
            range = ((PsiExpressionStatement)statementsInRange[0]).getExpression().getTextRange();
        }
        return range.getStartOffset() > offset || range.getEndOffset() <= offset || IntroduceVariableBase.isPreferStatements();
    }

    public static int preferredSelection(PsiElement[] statementsInRange, List<PsiExpression> expressions2) {
        PsiExpression expression2;
        int selection = statementsInRange.length == 1 && statementsInRange[0] instanceof PsiExpressionStatement && PsiUtilCore.hasErrorElementChild((PsiElement)statementsInRange[0]) ? expressions2.indexOf(((PsiExpressionStatement)statementsInRange[0]).getExpression()) : ((expression2 = expressions2.get(0)) instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression2).resolve() instanceof PsiLocalVariable ? 1 : -1);
        return selection;
    }

    public static boolean isPreferStatements() {
        return Boolean.valueOf(PropertiesComponent.getInstance().getBoolean(PREFER_STATEMENTS_OPTION)) != false || Registry.is((String)PREFER_STATEMENTS_OPTION, (boolean)false);
    }

    public static List<PsiExpression> collectExpressions(PsiFile file, Editor editor, int offset) {
        return IntroduceVariableBase.collectExpressions(file, editor, offset, false);
    }

    public static List<PsiExpression> collectExpressions(PsiFile file, Editor editor, int offset, boolean acceptVoid) {
        return IntroduceVariableBase.collectExpressions(file, editor.getDocument(), offset, acceptVoid);
    }

    public static List<PsiExpression> collectExpressions(PsiFile file, Document document, int offset, boolean acceptVoid) {
        CharSequence text2 = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!Character.isJavaIdentifierPart(text2.charAt(offset))) {
            --correctedOffset;
        }
        if (correctedOffset < 0) {
            correctedOffset = offset;
        } else if (!Character.isJavaIdentifierPart(text2.charAt(correctedOffset))) {
            if (text2.charAt(correctedOffset) == ';') {
                --correctedOffset;
            }
            if (correctedOffset < 0 || text2.charAt(correctedOffset) != ')') {
                correctedOffset = offset;
            }
        }
        PsiElement elementAtCaret = file.findElementAt(correctedOffset);
        ArrayList<PsiExpression> expressions2 = new ArrayList<PsiExpression>();
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PsiExpression.class);
        while (expression2 != null) {
            if (!(expressions2.contains(expression2) || expression2 instanceof PsiParenthesizedExpression || expression2 instanceof PsiSuperExpression || !acceptVoid && PsiType.VOID.equals((Object)expression2.getType()))) {
                if (expression2 instanceof PsiMethodReferenceExpression) {
                    expressions2.add(expression2);
                } else if (!(expression2 instanceof PsiAssignmentExpression)) {
                    PsiElement resolve;
                    if (!(expression2 instanceof PsiReferenceExpression)) {
                        expressions2.add(expression2);
                    } else if (!(expression2.getParent() instanceof PsiMethodCallExpression || (resolve = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiClass || resolve instanceof PsiPackage)) {
                        expressions2.add(expression2);
                    }
                }
            }
            expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpression.class);
        }
        return expressions2;
    }

    public static PsiElement[] findStatementsAtOffset(Editor editor, PsiFile file, int offset) {
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(offset);
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        return CodeInsightUtil.findStatementsInRange(file, lineStart, lineEnd);
    }

    private boolean invoke(Project project, Editor editor, PsiFile file, int startOffset, int endOffset) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.introduceVariable");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        return this.invokeImpl(project, IntroduceVariableBase.findExpressionInRange(project, file, startOffset, endOffset), editor);
    }

    private static PsiExpression findExpressionInRange(Project project, PsiFile file, int startOffset, int endOffset) {
        PsiElement[] statements;
        PsiExpression tempExpr = CodeInsightUtil.findExpressionInRange(file, startOffset, endOffset);
        if (tempExpr == null && (statements = CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset)).length == 1) {
            if (statements[0] instanceof PsiExpressionStatement) {
                tempExpr = ((PsiExpressionStatement)statements[0]).getExpression();
            } else if (statements[0] instanceof PsiReturnStatement) {
                tempExpr = ((PsiReturnStatement)statements[0]).getReturnValue();
            }
        }
        if (tempExpr == null) {
            tempExpr = IntroduceVariableBase.getSelectedExpression(project, file, startOffset, endOffset);
        }
        return tempExpr;
    }

    public static PsiExpression getSelectedExpression(Project project, PsiFile file, int startOffset, int endOffset) {
        PsiExpression tempExpr;
        PsiElement elementAtEnd;
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        PsiElement elementAtStart = file.findElementAt(startOffset);
        if (elementAtStart == null || elementAtStart instanceof PsiWhiteSpace || elementAtStart instanceof PsiComment) {
            PsiElement element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)elementAtStart);
            if (element != null) {
                startOffset = element.getTextOffset();
                elementAtStart = file.findElementAt(startOffset);
            }
            if (elementAtStart == null) {
                if (injectedLanguageManager.isInjectedFragment(file)) {
                    return IntroduceVariableBase.getSelectionFromInjectedHost(project, file, injectedLanguageManager, startOffset, endOffset);
                }
                return null;
            }
            startOffset = elementAtStart.getTextOffset();
        }
        if ((elementAtEnd = file.findElementAt(endOffset - 1)) == null || elementAtEnd instanceof PsiWhiteSpace || elementAtEnd instanceof PsiComment) {
            if ((elementAtEnd = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)elementAtEnd)) == null) {
                return null;
            }
            endOffset = elementAtEnd.getTextRange().getEndOffset();
        }
        if (endOffset <= startOffset) {
            return null;
        }
        PsiElement elementAt = PsiTreeUtil.findCommonParent((PsiElement)elementAtStart, (PsiElement)elementAtEnd);
        if (elementAt instanceof PsiExpressionStatement) {
            return ((PsiExpressionStatement)elementAt).getExpression();
        }
        PsiExpression containingExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiExpression.class, (boolean)false);
        if (containingExpression != null && containingExpression == elementAtEnd && startOffset == containingExpression.getTextOffset()) {
            return containingExpression;
        }
        if (containingExpression == null || containingExpression instanceof PsiLambdaExpression) {
            if (injectedLanguageManager.isInjectedFragment(file)) {
                return IntroduceVariableBase.getSelectionFromInjectedHost(project, file, injectedLanguageManager, startOffset, endOffset);
            }
            elementAt = null;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiLiteralExpression.class);
        PsiLiteralExpression startLiteralExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, PsiLiteralExpression.class);
        PsiLiteralExpression endLiteralExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(endOffset), PsiLiteralExpression.class);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String text2 = null;
        try {
            PsiType type2;
            text2 = file.getText().subSequence(startOffset, endOffset).toString();
            String prefix = null;
            if (startLiteralExpression != null) {
                int startExpressionOffset = startLiteralExpression.getTextOffset();
                if (startOffset == startExpressionOffset + 1) {
                    text2 = "\"" + text2;
                } else if (startOffset > startExpressionOffset + 1) {
                    prefix = "\" + ";
                    text2 = "\"" + text2;
                }
            }
            String suffix = null;
            if (endLiteralExpression != null) {
                int endExpressionOffset = endLiteralExpression.getTextOffset() + endLiteralExpression.getTextLength();
                if (endOffset == endExpressionOffset - 1) {
                    text2 = text2 + "\"";
                } else if (endOffset < endExpressionOffset - 1) {
                    suffix = " + \"";
                    text2 = text2 + "\"";
                }
            }
            if (literalExpression != null && text2.equals(literalExpression.getText())) {
                return literalExpression;
            }
            PsiLiteralExpression parent = literalExpression != null ? literalExpression : elementAt;
            tempExpr = elementFactory.createExpressionFromText(text2, (PsiElement)parent);
            final boolean[] hasErrors = new boolean[1];
            JavaRecursiveElementWalkingVisitor errorsVisitor = new JavaRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (hasErrors[0]) {
                        return;
                    }
                    super.visitElement(element);
                }

                public void visitErrorElement(PsiErrorElement element) {
                    hasErrors[0] = true;
                }
            };
            tempExpr.accept((PsiElementVisitor)errorsVisitor);
            if (hasErrors[0]) {
                return null;
            }
            tempExpr.putUserData(ElementToWorkOn.PREFIX, (Object)prefix);
            tempExpr.putUserData(ElementToWorkOn.SUFFIX, (Object)suffix);
            RangeMarker rangeMarker = FileDocumentManager.getInstance().getDocument(file.getVirtualFile()).createRangeMarker(startOffset, endOffset);
            tempExpr.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)rangeMarker);
            if (parent != null) {
                tempExpr.putUserData(ElementToWorkOn.PARENT, (Object)parent);
            } else {
                PsiErrorElement errorElement;
                PsiErrorElement psiErrorElement = errorElement = elementAtStart instanceof PsiErrorElement ? (PsiErrorElement)elementAtStart : (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)elementAtStart, PsiErrorElement.class);
                if (errorElement == null) {
                    errorElement = (PsiErrorElement)PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, PsiErrorElement.class);
                }
                if (errorElement == null) {
                    return null;
                }
                if (!(errorElement.getParent() instanceof PsiClass)) {
                    return null;
                }
                tempExpr.putUserData(ElementToWorkOn.PARENT, (Object)errorElement);
                tempExpr.putUserData(ElementToWorkOn.OUT_OF_CODE_BLOCK, (Object)Boolean.TRUE);
            }
            String fakeInitializer = "intellijidearulezzz";
            int[] refIdx = new int[1];
            PsiElement toBeExpression = IntroduceVariableBase.createReplacement("intellijidearulezzz", project, prefix, suffix, (PsiElement)parent, rangeMarker, refIdx);
            toBeExpression.accept((PsiElementVisitor)errorsVisitor);
            if (hasErrors[0]) {
                return null;
            }
            if (literalExpression != null && toBeExpression instanceof PsiExpression ? (type2 = ((PsiExpression)toBeExpression).getType()) != null && !type2.equals(literalExpression.getType()) : containingExpression != null && !Comparing.equal((Object)containingExpression.getType(), (Object)tempExpr.getType())) {
                return null;
            }
            PsiReferenceExpression refExpr = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)toBeExpression.findElementAt(refIdx[0]), PsiReferenceExpression.class);
            if (refExpr == null) {
                return null;
            }
            if (toBeExpression == refExpr && refIdx[0] > 0) {
                return null;
            }
            if (ReplaceExpressionUtil.isNeedParenthesis(refExpr.getNode(), tempExpr.getNode())) {
                tempExpr.putCopyableUserData(NEED_PARENTHESIS, (Object)Boolean.TRUE);
                return tempExpr;
            }
        }
        catch (IncorrectOperationException e) {
            if (elementAt instanceof PsiExpressionList) {
                PsiElement parent = elementAt.getParent();
                return parent instanceof PsiCallExpression ? IntroduceVariableBase.createArrayCreationExpression(text2, startOffset, endOffset, (PsiCallExpression)parent) : null;
            }
            return null;
        }
        return tempExpr;
    }

    private static PsiExpression getSelectionFromInjectedHost(Project project, PsiFile file, InjectedLanguageManager injectedLanguageManager, int startOffset, int endOffset) {
        PsiLanguageInjectionHost injectionHost = injectedLanguageManager.getInjectionHost((PsiElement)file);
        return IntroduceVariableBase.getSelectedExpression(project, injectionHost.getContainingFile(), injectedLanguageManager.injectedToHost((PsiElement)file, startOffset), injectedLanguageManager.injectedToHost((PsiElement)file, endOffset));
    }

    @Nullable
    public static String getErrorMessage(PsiExpression expr) {
        Boolean needParenthesis = (Boolean)expr.getCopyableUserData(NEED_PARENTHESIS);
        if (needParenthesis != null && needParenthesis.booleanValue()) {
            return "Extracting selected expression would change the semantic of the whole expression.";
        }
        return null;
    }

    private static PsiExpression createArrayCreationExpression(String text2, int startOffset, int endOffset, PsiCallExpression parent) {
        if (text2 == null || parent == null) {
            return null;
        }
        String[] varargsExpressions = text2.split("s*,s*");
        if (varargsExpressions.length > 1) {
            PsiElement endElement;
            PsiElement startElement;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)parent.getProject());
            JavaResolveResult resolveResult = parent.resolveMethodGenerics();
            PsiMethod psiMethod = (PsiMethod)resolveResult.getElement();
            if (psiMethod == null || !psiMethod.isVarArgs()) {
                return null;
            }
            PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
            PsiParameter varargParameter = parameters2[parameters2.length - 1];
            PsiType type2 = varargParameter.getType();
            LOG.assertTrue(type2 instanceof PsiEllipsisType);
            PsiArrayType psiType = (PsiArrayType)((PsiEllipsisType)type2).toArrayType();
            PsiExpression[] args = parent.getArgumentList().getExpressions();
            PsiSubstitutor psiSubstitutor = resolveResult.getSubstitutor();
            if (args.length < parameters2.length || startOffset < args[parameters2.length - 1].getTextRange().getStartOffset()) {
                return null;
            }
            PsiFile containingFile = parent.getContainingFile();
            for (startElement = containingFile.findElementAt(startOffset); startElement != null && startElement.getParent() != parent.getArgumentList(); startElement = startElement.getParent()) {
            }
            if (startElement == null || startOffset > startElement.getTextOffset()) {
                return null;
            }
            for (endElement = containingFile.findElementAt(endOffset - 1); endElement != null && endElement.getParent() != parent.getArgumentList(); endElement = endElement.getParent()) {
            }
            if (endElement == null || endOffset < endElement.getTextRange().getEndOffset()) {
                return null;
            }
            PsiType componentType = TypeConversionUtil.erasure((PsiType)psiSubstitutor.substitute(psiType.getComponentType()));
            try {
                PsiExpression expressionFromText = elementFactory.createExpressionFromText("new " + componentType.getCanonicalText() + "[]{" + text2 + "}", (PsiElement)parent);
                RangeMarker rangeMarker = FileDocumentManager.getInstance().getDocument(containingFile.getVirtualFile()).createRangeMarker(startOffset, endOffset);
                expressionFromText.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)rangeMarker);
                expressionFromText.putUserData(ElementToWorkOn.PARENT, (Object)parent);
                return expressionFromText;
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected boolean invokeImpl(final Project project, final PsiExpression expr, final Editor editor) {
        boolean isInplaceAvailableOnDataContext;
        PsiType originalType;
        String errorMessage;
        if (expr != null && (errorMessage = IntroduceVariableBase.getErrorMessage(expr)) != null) {
            this.showErrorMessage(project, editor, RefactoringBundle.getCannotRefactorMessage((String)errorMessage));
            return false;
        }
        if (expr != null && expr.getParent() instanceof PsiExpressionStatement) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.introduceVariable.incompleteStatement");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + expr);
        }
        if (expr == null || !expr.isPhysical()) {
            if (ReassignVariableUtil.reassign(editor)) {
                return false;
            }
            if (expr == null) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.an.expression"));
                this.showErrorMessage(project, editor, message2);
                return false;
            }
        }
        if ((originalType = RefactoringUtil.getTypeByExpressionWithExpectedType(expr)) == null || LambdaUtil.notInferredType((PsiType)originalType)) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"unknown.expression.type"));
            this.showErrorMessage(project, editor, message3);
            return false;
        }
        if (PsiType.VOID.equals((Object)originalType)) {
            String message4 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.has.void.type"));
            this.showErrorMessage(project, editor, message4);
            return false;
        }
        PsiElement physicalElement = (PsiElement)expr.getUserData(ElementToWorkOn.PARENT);
        final PsiElement anchorStatement = RefactoringUtil.getParentStatement((PsiElement)(physicalElement != null ? physicalElement : expr), false);
        PsiElement tempContainer = this.checkAnchorStatement(project, editor, anchorStatement);
        if (tempContainer == null) {
            return false;
        }
        PsiFile file = anchorStatement.getContainingFile();
        LOG.assertTrue(file != null, (Object)"expr.getContainingFile() == null");
        PsiElement nameSuggestionContext = editor == null ? null : file.findElementAt(editor.getCaretModel().getOffset());
        RefactoringSupportProvider supportProvider = (RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(expr.getLanguage());
        boolean bl = isInplaceAvailableOnDataContext = supportProvider != null && editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider.isInplaceIntroduceAvailable((PsiElement)expr, nameSuggestionContext) && (!ApplicationManager.getApplication().isUnitTestMode() || this.isInplaceAvailableInTestMode()) && !IntroduceVariableBase.isInJspHolderMethod(expr);
        if (isInplaceAvailableOnDataContext) {
            MultiMap conflicts = new MultiMap();
            IntroduceVariableBase.checkInLoopCondition(expr, (MultiMap<PsiElement, String>)conflicts);
            if (!conflicts.isEmpty()) {
                this.showErrorMessage(project, editor, StringUtil.join((Iterable)conflicts.values(), (String)"<br>"));
                return false;
            }
        }
        ExpressionOccurrenceManager occurrenceManager = IntroduceVariableBase.createOccurrenceManager(expr, tempContainer);
        final PsiExpression[] occurrences = occurrenceManager.getOccurrences();
        final PsiElement anchorStatementIfAll = occurrenceManager.getAnchorStatementForAll();
        final OccurrencesInfo occurrencesInfo = new OccurrencesInfo(occurrences);
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return false;
        }
        LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> occurrencesMap = occurrencesInfo.buildOccurrencesMap(expr);
        final boolean inFinalContext = occurrenceManager.isInFinalContext();
        final InputValidator validator = new InputValidator(this, project, anchorStatementIfAll, anchorStatement, occurrenceManager);
        final TypeSelectorManagerImpl typeSelectorManager = new TypeSelectorManagerImpl(project, originalType, expr, occurrences);
        final boolean[] wasSucceed = new boolean[]{true};
        Pass<JavaReplaceChoice> callback = new Pass<JavaReplaceChoice>(){

            public void pass(JavaReplaceChoice choice) {
                boolean hasWriteAccess = occurrencesInfo.myHasWriteAccess;
                List<PsiExpression> nonWrite = occurrencesInfo.myNonWrite;
                if (choice != null) {
                    boolean noWriteChoice = choice == JavaReplaceChoice.NO_WRITE;
                    boolean allChoice = choice.isAll();
                    boolean replaceAll = allChoice || noWriteChoice;
                    typeSelectorManager.setAllOccurrences(replaceAll);
                    PsiElement chosenAnchor = IntroduceVariableBase.chooseAnchor(replaceAll, noWriteChoice, nonWrite, anchorStatementIfAll, anchorStatement);
                    IntroduceVariableSettings settings = IntroduceVariableBase.this.getSettings(project, editor, expr, occurrences, typeSelectorManager, inFinalContext, hasWriteAccess, validator, chosenAnchor, choice);
                    boolean cantChangeFinalModifier = (hasWriteAccess || inFinalContext) && allChoice;
                    PsiExpression[] allOccurrences = (PsiExpression[])Arrays.stream(occurrences).filter(occurrence -> !expr.equals(occurrence) || !(expr.getParent() instanceof PsiExpressionStatement)).filter(occurrence -> allChoice || noWriteChoice && !PsiUtil.isAccessedForWriting((PsiExpression)occurrence) || expr.equals(occurrence)).toArray(PsiExpression[]::new);
                    if (choice.isChain()) {
                        IntroduceVariableBase.this.myInplaceIntroducer = new ChainCallInplaceIntroducer(project, settings, chosenAnchor, editor, expr, allOccurrences, typeSelectorManager, REFACTORING_NAME);
                    } else {
                        IntroduceVariableBase.this.myInplaceIntroducer = new JavaVariableInplaceIntroducer(project, settings, chosenAnchor, editor, expr, cantChangeFinalModifier, allOccurrences, typeSelectorManager, REFACTORING_NAME);
                    }
                    if (IntroduceVariableBase.this.myInplaceIntroducer.startInplaceIntroduceTemplate()) {
                        return;
                    }
                }
                CommandProcessor.getInstance().executeCommand(project, () -> {
                    IntroduceVariableSettings settings;
                    PsiVariable variable;
                    Editor topLevelEditor;
                    block4: {
                        if (!anchorStatement.isValid()) {
                            return;
                        }
                        topLevelEditor = !InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(anchorStatement.getContainingFile()) ? InjectedLanguageUtil.getTopLevelEditor((Editor)editor) : editor;
                        variable = null;
                        try {
                            settings = IntroduceVariableBase.this.getSettings(project, topLevelEditor, expr, occurrences, typeSelectorManager, inFinalContext, hasWriteAccess, validator, anchorStatement, choice);
                            if (settings.isOK()) break block4;
                            wasSucceed2[0] = false;
                        }
                        catch (Throwable throwable) {
                            RefactoringEventData afterData = new RefactoringEventData();
                            afterData.addElement(variable);
                            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                            throw throwable;
                        }
                        RefactoringEventData afterData = new RefactoringEventData();
                        afterData.addElement(variable);
                        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                        return;
                    }
                    RefactoringEventData beforeData = new RefactoringEventData();
                    beforeData.addElement((PsiElement)expr);
                    ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(IntroduceVariableBase.REFACTORING_ID, beforeData);
                    PsiElement chosenAnchor = IntroduceVariableBase.chooseAnchor(settings.isReplaceAllOccurrences(), hasWriteAccess, nonWrite, anchorStatementIfAll, anchorStatement);
                    variable = IntroduceVariableBase.introduce(project, expr, topLevelEditor, chosenAnchor, occurrences, settings);
                    RefactoringEventData afterData = new RefactoringEventData();
                    afterData.addElement((PsiElement)variable);
                    ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                }, REFACTORING_NAME, null);
            }
        };
        if (!isInplaceAvailableOnDataContext) {
            callback.pass(null);
        } else {
            JavaReplaceChoice choice = this.getOccurrencesChoice();
            if (choice != null) {
                callback.pass((Object)choice);
            } else {
                String title = occurrencesInfo.myChainMethodName != null && occurrences.length == 1 ? "Lambda chain detected" : "Multiple occurrences found";
                OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Pass)callback, occurrencesMap, title);
            }
        }
        return wasSucceed[0];
    }

    protected PsiElement checkAnchorStatement(Project project, Editor editor, PsiElement anchorStatement) {
        if (anchorStatement == null) {
            String message2 = RefactoringBundle.message((String)"refactoring.is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME});
            this.showErrorMessage(project, editor, message2);
            return null;
        }
        if (IntroduceVariableBase.checkAnchorBeforeThisOrSuper(project, editor, anchorStatement, REFACTORING_NAME, "refactoring.introduceVariable")) {
            return null;
        }
        PsiElement tempContainer = anchorStatement.getParent();
        if (!(tempContainer instanceof PsiCodeBlock) && !RefactoringUtil.isLoopOrIf(tempContainer) && !(tempContainer instanceof PsiLambdaExpression) && tempContainer.getParent() instanceof PsiLambdaExpression) {
            String message3 = RefactoringBundle.message((String)"refactoring.is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME});
            this.showErrorMessage(project, editor, message3);
            return null;
        }
        return tempContainer;
    }

    protected JavaReplaceChoice getOccurrencesChoice() {
        return null;
    }

    protected static PsiElement chooseAnchor(boolean allOccurrences, boolean hasWriteAccess, List<PsiExpression> nonWrite, PsiElement anchorStatementIfAll, PsiElement anchorStatement) {
        if (allOccurrences) {
            if (hasWriteAccess) {
                return RefactoringUtil.getAnchorElementForMultipleExpressions(nonWrite.toArray(new PsiExpression[nonWrite.size()]), null);
            }
            return anchorStatementIfAll;
        }
        return anchorStatement;
    }

    protected boolean isInplaceAvailableInTestMode() {
        return false;
    }

    private static ExpressionOccurrenceManager createOccurrenceManager(PsiExpression expr, PsiElement tempContainer) {
        PsiParameter[] parameters2;
        PsiClass containingClass;
        HashSet vars = new HashSet();
        ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)expr)).filter(element -> element instanceof PsiReferenceExpression)).forEach(element -> {
            PsiElement resolve = ((PsiReferenceExpression)element).resolve();
            if (resolve instanceof PsiVariable) {
                vars.add((PsiVariable)resolve);
            }
        });
        PsiElement containerParent = tempContainer;
        PsiElement lastScope = tempContainer;
        while (!(containerParent instanceof PsiFile || containerParent instanceof PsiMethod && ((containingClass = ((PsiMethod)containerParent).getContainingClass()) == null || !PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass) || vars.stream().anyMatch(variable -> PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)variable, (boolean)true))) || containerParent instanceof PsiLambdaExpression && Arrays.stream(parameters2 = ((PsiLambdaExpression)containerParent).getParameterList().getParameters()).anyMatch(parameter2 -> vars.contains(parameter2)))) {
            if (containerParent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)containerParent;
                if (vars.stream().anyMatch(variable -> PsiTreeUtil.isAncestor((PsiElement)forStatement.getInitialization(), (PsiElement)variable, (boolean)true))) break;
            }
            if (!((containerParent = containerParent.getParent()) instanceof PsiCodeBlock)) continue;
            lastScope = containerParent;
        }
        return new ExpressionOccurrenceManager(expr, lastScope, NotInSuperCallOccurrenceFilter.INSTANCE);
    }

    private static boolean isInJspHolderMethod(PsiExpression expr) {
        PsiElement parent1 = expr.getParent();
        if (parent1 == null) {
            return false;
        }
        PsiElement parent2 = parent1.getParent();
        if (!(parent2 instanceof JspCodeBlock)) {
            return false;
        }
        PsiElement parent3 = parent2.getParent();
        return parent3 instanceof JspHolderMethod;
    }

    public static PsiVariable introduce(final Project project, final PsiExpression expr, final Editor editor, final PsiElement anchorStatement, final PsiExpression[] occurrences, final IntroduceVariableSettings settings) {
        int line;
        final PsiElement container = anchorStatement.getParent();
        PsiElement child = anchorStatement;
        final boolean isInsideLoop = RefactoringUtil.isLoopOrIf(container);
        if (!isInsideLoop) {
            child = IntroduceVariableBase.locateAnchor(child);
            if (IntroduceVariableBase.isFinalVariableOnLHS(expr)) {
                child = child.getNextSibling();
            }
        }
        final PsiElement anchor = child == null ? anchorStatement : child;
        boolean tempDeleteSelf = false;
        final boolean replaceSelf = settings.isReplaceLValues() || !RefactoringUtil.isAssignmentLHS((PsiElement)expr);
        final PsiElement exprParent = expr.getParent();
        if (!isInsideLoop) {
            PsiElement parent;
            if (exprParent instanceof PsiExpressionStatement && anchor.equals(anchorStatement) && ((parent = exprParent.getParent()) instanceof PsiCodeBlock || parent instanceof PsiCodeFragment)) {
                tempDeleteSelf = true;
            }
            tempDeleteSelf &= replaceSelf;
        }
        final boolean deleteSelf = tempDeleteSelf;
        final boolean replaceLoop = isInsideLoop ? exprParent instanceof PsiExpressionStatement : container instanceof PsiLambdaExpression && exprParent == container;
        final int col = editor != null ? editor.getCaretModel().getLogicalPosition().column : 0;
        int n = line = editor != null ? editor.getCaretModel().getLogicalPosition().line : 0;
        if (deleteSelf && editor != null) {
            LogicalPosition pos = new LogicalPosition(line, col);
            editor.getCaretModel().moveToLogicalPosition(pos);
        }
        PsiCodeBlock newDeclarationScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)container, PsiCodeBlock.class, (boolean)false);
        final FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(settings.getEnteredName(), newDeclarationScope);
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<SmartPsiElementPointer<PsiVariable>>(){

            public SmartPsiElementPointer<PsiVariable> compute() {
                try {
                    PsiField declaration2;
                    PsiStatement statement = null;
                    if (!isInsideLoop && deleteSelf) {
                        statement = (PsiStatement)exprParent;
                    }
                    PsiExpression expr1 = fieldConflictsResolver.fixInitializer(expr);
                    PsiExpression initializer = RefactoringUtil.unparenthesizeExpression(expr1);
                    SmartTypePointer selectedType = SmartTypePointerManager.getInstance((Project)project).createSmartTypePointer(settings.getSelectedType());
                    initializer = IntroduceVariableBase.simplifyVariableInitializer(initializer, selectedType.getType());
                    PsiType type2 = IntroduceVariableBase.stripNullabilityAnnotationsFromTargetType(selectedType, project);
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                    if (container instanceof PsiClass) {
                        declaration2 = elementFactory.createField(settings.getEnteredName(), type2);
                        declaration2.setInitializer(initializer);
                    } else {
                        declaration2 = elementFactory.createVariableDeclarationStatement(settings.getEnteredName(), type2, initializer, container);
                    }
                    if (!isInsideLoop) {
                        declaration2 = this.addDeclaration((PsiElement)declaration2, initializer);
                        LOG.assertTrue(expr1.isValid());
                        if (deleteSelf) {
                            PsiElement lastChild = statement.getLastChild();
                            if (lastChild instanceof PsiComment) {
                                declaration2.addBefore(lastChild, null);
                            }
                            statement.delete();
                            if (editor != null) {
                                LogicalPosition pos = new LogicalPosition(line, col);
                                editor.getCaretModel().moveToLogicalPosition(pos);
                                editor.getCaretModel().moveToOffset(declaration2.getTextRange().getEndOffset());
                                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                                editor.getSelectionModel().removeSelection();
                            }
                        }
                    }
                    PsiExpression ref = elementFactory.createExpressionFromText(settings.getEnteredName(), null);
                    if (settings.isReplaceAllOccurrences()) {
                        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
                        for (PsiExpression occurrence : occurrences) {
                            if (deleteSelf && occurrence.equals(expr)) continue;
                            if (occurrence.equals(expr)) {
                                occurrence = expr1;
                            }
                            if (occurrence != null) {
                                occurrence = RefactoringUtil.outermostParenthesizedExpression(occurrence);
                            }
                            if (!settings.isReplaceLValues() && RefactoringUtil.isAssignmentLHS((PsiElement)occurrence)) continue;
                            array.add(IntroduceVariableBase.replace(occurrence, ref, project));
                        }
                        if (!deleteSelf && replaceSelf && expr1 instanceof PsiPolyadicExpression && expr1.isValid() && !expr1.isPhysical()) {
                            array.add(IntroduceVariableBase.replace(expr1, ref, project));
                        }
                        if (editor != null) {
                            PsiElement[] replacedOccurrences = PsiUtilCore.toPsiElementArray(array);
                            IntroduceVariableBase.highlightReplacedOccurrences(project, editor, replacedOccurrences);
                        }
                    } else if (!deleteSelf && replaceSelf) {
                        IntroduceVariableBase.replace(expr1, ref, project);
                    }
                    if (declaration2 instanceof PsiDeclarationStatement) {
                        declaration2 = RefactoringUtil.putStatementInLoopBody((PsiStatement)declaration2, container, anchorStatement, replaceSelf && replaceLoop);
                    }
                    PsiVariable var = (PsiVariable)((declaration2 = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)declaration2)) instanceof PsiDeclarationStatement ? ((PsiDeclarationStatement)declaration2).getDeclaredElements()[0] : declaration2);
                    PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)settings.isDeclareFinal());
                    fieldConflictsResolver.fix();
                    return SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)var);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }

            private PsiElement addDeclaration(PsiElement declaration2, PsiExpression initializer) {
                PsiElement[] declaredElements;
                if (anchor instanceof PsiDeclarationStatement && (declaredElements = ((PsiDeclarationStatement)anchor).getDeclaredElements()).length > 1) {
                    final int[] usedFirstVar = new int[]{-1};
                    initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitReferenceExpression(PsiReferenceExpression expression2) {
                            int i = ArrayUtilRt.find((Object[])declaredElements, (Object)expression2.resolve());
                            if (i > -1) {
                                usedFirstVar[0] = Math.max(i, usedFirstVar[0]);
                            }
                            super.visitReferenceExpression(expression2);
                        }
                    });
                    if (usedFirstVar[0] > -1) {
                        PsiVariable psiVariable = (PsiVariable)declaredElements[usedFirstVar[0]];
                        psiVariable.normalizeDeclaration();
                        PsiDeclarationStatement parDeclarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, PsiDeclarationStatement.class);
                        return container.addAfter(declaration2, (PsiElement)parDeclarationStatement);
                    }
                }
                return container.addBefore(declaration2, anchor);
            }
        });
        return pointer != null ? (PsiVariable)pointer.getElement() : null;
    }

    private static PsiType stripNullabilityAnnotationsFromTargetType(SmartTypePointer selectedType, final Project project) {
        PsiType type2 = selectedType.getType();
        if (type2 == null) {
            return null;
        }
        final PsiAnnotation[] annotations2 = type2.getAnnotations();
        type2 = type2.annotate(new TypeAnnotationProvider(){

            @NotNull
            public PsiAnnotation[] getAnnotations() {
                NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
                HashSet nullables = new HashSet();
                nullables.addAll(manager.getNotNulls());
                nullables.addAll(manager.getNullables());
                PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])Arrays.stream(annotations2).filter(annotation -> !nullables.contains(annotation.getQualifiedName())).toArray(PsiAnnotation[]::new);
                if (psiAnnotationArray == null) {
                    5.$$$reportNull$$$0(0);
                }
                return psiAnnotationArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceVariable/IntroduceVariableBase$5", "getAnnotations"));
            }
        });
        return type2;
    }

    private static boolean isFinalVariableOnLHS(PsiExpression expr) {
        PsiElement resolve;
        return expr instanceof PsiReferenceExpression && RefactoringUtil.isAssignmentLHS((PsiElement)expr) && (resolve = ((PsiReferenceExpression)expr).resolve()) instanceof PsiVariable && ((PsiVariable)resolve).hasModifierProperty("final");
    }

    public static PsiExpression simplifyVariableInitializer(PsiExpression initializer, PsiType expectedType) {
        if (initializer instanceof PsiTypeCastExpression) {
            PsiType operandType;
            PsiExpression operand2 = ((PsiTypeCastExpression)initializer).getOperand();
            if (operand2 != null && (operandType = operand2.getType()) != null && TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)operandType)) {
                return operand2;
            }
        } else if (initializer instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)initializer;
            if (newExpression.getArrayInitializer() != null) {
                return newExpression.getArrayInitializer();
            }
            PsiExpression tryToDetectDiamondNewExpr = ((PsiVariable)JavaPsiFacade.getElementFactory((Project)initializer.getProject()).createVariableDeclarationStatement("x", expectedType, initializer, (PsiElement)initializer).getDeclaredElements()[0]).getInitializer();
            if (tryToDetectDiamondNewExpr instanceof PsiNewExpression && PsiDiamondTypeUtil.canCollapseToDiamond((PsiNewExpression)tryToDetectDiamondNewExpr, (PsiNewExpression)tryToDetectDiamondNewExpr, expectedType)) {
                PsiElement paramList = PsiDiamondTypeUtil.replaceExplicitWithDiamond((PsiElement)newExpression.getClassOrAnonymousClassReference().getParameterList());
                return (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)paramList, PsiNewExpression.class);
            }
        }
        return initializer;
    }

    public static PsiElement replace(PsiExpression expr1, PsiExpression ref, Project project) throws IncorrectOperationException {
        Object expr2 = expr1 instanceof PsiArrayInitializerExpression && expr1.getParent() instanceof PsiNewExpression ? (PsiNewExpression)expr1.getParent() : RefactoringUtil.outermostParenthesizedExpression(expr1);
        if (expr2.isPhysical() || expr1.getUserData(ElementToWorkOn.REPLACE_NON_PHYSICAL) != null) {
            return expr2.replace((PsiElement)ref);
        }
        String prefix = (String)expr1.getUserData(ElementToWorkOn.PREFIX);
        String suffix = (String)expr1.getUserData(ElementToWorkOn.SUFFIX);
        PsiElement parent = (PsiElement)expr1.getUserData(ElementToWorkOn.PARENT);
        RangeMarker rangeMarker = (RangeMarker)expr1.getUserData(ElementToWorkOn.TEXT_RANGE);
        LOG.assertTrue(parent != null, (Object)expr1);
        return parent.replace(IntroduceVariableBase.createReplacement(ref.getText(), project, prefix, suffix, parent, rangeMarker, new int[1]));
    }

    private static PsiElement createReplacement(String refText, Project project, String prefix, String suffix, PsiElement parent, RangeMarker rangeMarker, int[] refIdx) {
        String text2 = refText;
        if (parent != null) {
            String allText = parent.getContainingFile().getText();
            TextRange parentRange = parent.getTextRange();
            LOG.assertTrue(parentRange.getStartOffset() <= rangeMarker.getStartOffset(), (Object)(parent + "; prefix:" + prefix + "; suffix:" + suffix));
            String beg = allText.substring(parentRange.getStartOffset(), rangeMarker.getStartOffset());
            if (StringUtil.stripQuotesAroundValue((String)beg).trim().length() == 0 && prefix == null) {
                beg = "";
            }
            LOG.assertTrue(rangeMarker.getEndOffset() <= parentRange.getEndOffset(), (Object)(parent + "; prefix:" + prefix + "; suffix:" + suffix));
            String end = allText.substring(rangeMarker.getEndOffset(), parentRange.getEndOffset());
            if (StringUtil.stripQuotesAroundValue((String)end).trim().length() == 0 && suffix == null) {
                end = "";
            }
            String start = beg + (prefix != null ? prefix : "");
            refIdx[0] = start.length();
            text2 = start + refText + (suffix != null ? suffix : "") + end;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        return parent instanceof PsiStatement ? factory.createStatementFromText(text2, parent) : (parent instanceof PsiCodeBlock ? factory.createCodeBlockFromText(text2, parent) : factory.createExpressionFromText(text2, parent));
    }

    @Override
    protected boolean invokeImpl(Project project, PsiLocalVariable localVariable, Editor editor) {
        throw new UnsupportedOperationException();
    }

    private static PsiElement locateAnchor(PsiElement child) {
        PsiElement prev;
        while (child != null && !((prev = child.getPrevSibling()) instanceof PsiStatement) && !PsiUtil.isJavaToken((PsiElement)prev, (IElementType)JavaTokenType.LBRACE)) {
            child = prev;
        }
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = child.getNextSibling();
        }
        return child;
    }

    protected static void highlightReplacedOccurrences(Project project, Editor editor, PsiElement[] replacedOccurrences) {
        if (editor == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        highlightManager.addOccurrenceHighlights(editor, replacedOccurrences, attributes, true, null);
        WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    protected abstract void showErrorMessage(Project var1, Editor var2, String var3);

    protected boolean reportConflicts(MultiMap<PsiElement, String> conflicts, Project project, IntroduceVariableSettings settings) {
        return false;
    }

    public IntroduceVariableSettings getSettings(Project project, Editor editor, PsiExpression expr, PsiExpression[] occurrences, final TypeSelectorManagerImpl typeSelectorManager, boolean declareFinalIfAll, boolean anyAssignmentLHS, InputValidator validator, PsiElement anchor, JavaReplaceChoice replaceChoice) {
        final boolean replaceAll = replaceChoice.isMultiple();
        SuggestedNameInfo suggestedName = IntroduceVariableBase.getSuggestedName(typeSelectorManager.getDefaultType(), expr, anchor);
        final String variableName = suggestedName.names.length > 0 ? suggestedName.names[0] : "";
        final boolean declareFinal = replaceAll && declareFinalIfAll || !anyAssignmentLHS && IntroduceVariableBase.createFinals(project);
        final boolean replaceWrite = anyAssignmentLHS && replaceChoice.isAll();
        return new IntroduceVariableSettings(){

            @Override
            public String getEnteredName() {
                return variableName;
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return replaceAll;
            }

            @Override
            public boolean isDeclareFinal() {
                return declareFinal;
            }

            @Override
            public boolean isReplaceLValues() {
                return replaceWrite;
            }

            @Override
            public PsiType getSelectedType() {
                PsiType selectedType = typeSelectorManager.getTypeSelector().getSelectedType();
                return selectedType != null ? selectedType : typeSelectorManager.getDefaultType();
            }

            @Override
            public boolean isOK() {
                return true;
            }
        };
    }

    public static boolean createFinals(Project project) {
        Boolean createFinals = JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS;
        return createFinals == null ? ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_LOCALS : createFinals;
    }

    public static boolean checkAnchorBeforeThisOrSuper(Project project, Editor editor, PsiElement tempAnchorElement, String refactoringName, String helpID) {
        PsiMethod method;
        PsiExpression enclosingExpr;
        if (tempAnchorElement instanceof PsiExpressionStatement && (enclosingExpr = ((PsiExpressionStatement)tempAnchorElement).getExpression()) instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)enclosingExpr).resolveMethod()) != null && method.isConstructor()) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"invalid.expression.context"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)refactoringName, (String)helpID);
            return true;
        }
        return false;
    }

    public static void checkInLoopCondition(PsiExpression occurence, MultiMap<PsiElement, String> conflicts) {
        PsiElement loopForLoopCondition = RefactoringUtil.getLoopForLoopCondition(occurence);
        if (loopForLoopCondition == null) {
            return;
        }
        List<PsiVariable> referencedVariables = RefactoringUtil.collectReferencedVariables((PsiElement)occurence);
        ArrayList<PsiVariable> modifiedInBody = new ArrayList<PsiVariable>();
        for (PsiVariable psiVariable : referencedVariables) {
            if (!RefactoringUtil.isModifiedInScope(psiVariable, loopForLoopCondition)) continue;
            modifiedInBody.add(psiVariable);
        }
        if (!modifiedInBody.isEmpty()) {
            for (PsiVariable variable : modifiedInBody) {
                String message2 = RefactoringBundle.message((String)"is.modified.in.loop.body", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)variable, (boolean)false)});
                conflicts.putValue((Object)variable, (Object)CommonRefactoringUtil.capitalize((String)message2));
            }
            conflicts.putValue((Object)occurence, (Object)RefactoringBundle.message((String)"introducing.variable.may.break.code.logic"));
        }
    }

    @Override
    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroducer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceVariable/IntroduceVariableBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuggestedName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class OccurrencesInfo {
        List<PsiExpression> myOccurrences;
        List<PsiExpression> myNonWrite;
        boolean myCantReplaceAll;
        boolean myCantReplaceAllButWrite;
        boolean myHasWriteAccess;
        final String myChainMethodName;

        public OccurrencesInfo(PsiExpression[] occurrences) {
            this.myOccurrences = Arrays.asList(occurrences);
            this.myNonWrite = new ArrayList<PsiExpression>();
            this.myCantReplaceAll = false;
            this.myCantReplaceAllButWrite = false;
            for (PsiExpression occurrence : this.myOccurrences) {
                if (!RefactoringUtil.isAssignmentLHS((PsiElement)occurrence)) {
                    this.myNonWrite.add(occurrence);
                    continue;
                }
                if (IntroduceVariableBase.isFinalVariableOnLHS(occurrence)) {
                    this.myCantReplaceAll = true;
                    continue;
                }
                if (this.myNonWrite.isEmpty()) continue;
                this.myCantReplaceAllButWrite = true;
                this.myCantReplaceAll = true;
            }
            this.myHasWriteAccess = this.myOccurrences.size() > this.myNonWrite.size() && this.myOccurrences.size() > 1;
            this.myChainMethodName = this.getChainCallExtractor();
        }

        private String getChainCallExtractor() {
            if (this.myHasWriteAccess || this.myOccurrences.isEmpty()) {
                return null;
            }
            PsiExpression expression2 = this.myOccurrences.get(0);
            if (this.myOccurrences.size() == 1 && expression2.getParent() instanceof PsiLambdaExpression) {
                return null;
            }
            PsiElement parent = PsiTreeUtil.findCommonParent(this.myOccurrences);
            if (parent == null) {
                return null;
            }
            PsiType type2 = expression2.getType();
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            ChainCallExtractor extractor = ChainCallExtractor.findExtractor(lambda2, expression2, type2);
            if (extractor == null) {
                return null;
            }
            PsiParameter parameter2 = lambda2.getParameterList().getParameters()[0];
            if (!ReferencesSearch.search((PsiElement)parameter2).forEach(ref -> this.myOccurrences.stream().anyMatch(expr -> PsiTreeUtil.isAncestor((PsiElement)expr, (PsiElement)ref.getElement(), (boolean)false)))) {
                return null;
            }
            return extractor.getMethodName((PsiVariable)parameter2, expression2, type2);
        }

        @NotNull
        LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> buildOccurrencesMap(PsiExpression expr) {
            LinkedHashMap occurrencesMap = ContainerUtil.newLinkedHashMap();
            if (this.myChainMethodName != null) {
                if (this.myOccurrences.size() > 1 && !this.myCantReplaceAll) {
                    occurrencesMap.put(JavaReplaceChoice.NO, Collections.singletonList(expr));
                    occurrencesMap.put(JavaReplaceChoice.ALL, this.myOccurrences);
                    occurrencesMap.put(new JavaReplaceChoice("Replace all {0} occurrences and extract as ''" + this.myChainMethodName + "'' operation", true, true, true), this.myOccurrences);
                } else {
                    occurrencesMap.put(JavaReplaceChoice.NO_CHAIN, Collections.singletonList(expr));
                    occurrencesMap.put(new JavaReplaceChoice("Extract as ''" + this.myChainMethodName + "'' operation", false, false, true), Collections.singletonList(expr));
                }
            } else {
                occurrencesMap.put(JavaReplaceChoice.NO, Collections.singletonList(expr));
                if (this.myHasWriteAccess && !this.myCantReplaceAllButWrite) {
                    occurrencesMap.put(JavaReplaceChoice.NO_WRITE, this.myNonWrite);
                }
                if (this.myOccurrences.size() > 1 && !this.myCantReplaceAll) {
                    JavaReplaceChoice choice = occurrencesMap.containsKey(JavaReplaceChoice.NO_WRITE) ? new JavaReplaceChoice("Replace read and write occurrences (will change semantics!)", true, true, false) : JavaReplaceChoice.ALL;
                    occurrencesMap.put(choice, this.myOccurrences);
                }
            }
            LinkedHashMap linkedHashMap = occurrencesMap;
            if (linkedHashMap == null) {
                OccurrencesInfo.$$$reportNull$$$0(0);
            }
            return linkedHashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceVariable/IntroduceVariableBase$OccurrencesInfo", "buildOccurrencesMap"));
        }
    }

    public static interface Validator {
        public boolean isOK(IntroduceVariableSettings var1);
    }

    public static class JavaReplaceChoice
    implements OccurrencesChooser.BaseReplaceChoice {
        public static final JavaReplaceChoice NO = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.NO);
        public static final JavaReplaceChoice NO_WRITE = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.NO_WRITE);
        public static final JavaReplaceChoice ALL = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.ALL);
        public static final JavaReplaceChoice NO_CHAIN = new JavaReplaceChoice("Create variable inside current lambda", false, false, false);
        public static final JavaReplaceChoice CHAIN = new JavaReplaceChoice("Extract as a separate operation", false, false, true);
        public static final JavaReplaceChoice CHAIN_ALL = new JavaReplaceChoice("Replace all occurrences and extract as a separate operation", true, true, true);
        private final String myDescription;
        private final boolean myAll;
        private final boolean myMultiple;
        private final boolean myChain;

        JavaReplaceChoice(OccurrencesChooser.ReplaceChoice choice) {
            this(choice.getDescription(), choice.isAll(), choice.isMultiple(), false);
        }

        JavaReplaceChoice(String description, boolean all, boolean multiple, boolean chain) {
            this.myDescription = description;
            this.myAll = all;
            this.myMultiple = multiple;
            this.myChain = chain;
        }

        public String getDescription() {
            return this.myDescription;
        }

        public boolean isMultiple() {
            return this.myMultiple;
        }

        public boolean isAll() {
            return this.myAll;
        }

        public boolean isChain() {
            return this.myChain;
        }

        public String formatDescription(int occurrencesCount) {
            return MessageFormat.format(this.getDescription(), occurrencesCount);
        }
    }
}

