/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.analysis.AnalysisScope;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.listeners.JavaRefactoringListenerManager;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.impl.JavaRefactoringListenerManagerImpl;
import com.intellij.refactoring.memberPullUp.PullUpData;
import com.intellij.refactoring.memberPullUp.PullUpHelper;
import com.intellij.refactoring.memberPullUp.PullUpHelperFactory;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PullUpProcessor
extends BaseRefactoringProcessor
implements PullUpData {
    private static final Logger LOG = Logger.getInstance(PullUpProcessor.class);
    private final PsiClass mySourceClass;
    private final PsiClass myTargetSuperClass;
    private final MemberInfo[] myMembersToMove;
    private final DocCommentPolicy myJavaDocPolicy;
    private Set<PsiMember> myMembersAfterMove;
    private Set<PsiMember> myMovedMembers;
    private final Map<Language, PullUpHelper<MemberInfo>> myProcessors = ContainerUtil.newHashMap();

    public PullUpProcessor(PsiClass sourceClass, PsiClass targetSuperClass, MemberInfo[] membersToMove, DocCommentPolicy javaDocPolicy) {
        super(sourceClass.getProject());
        this.mySourceClass = sourceClass;
        this.myTargetSuperClass = targetSuperClass;
        this.myMembersToMove = membersToMove;
        this.myJavaDocPolicy = javaDocPolicy;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PullUpProcessor.$$$reportNull$$$0(0);
        }
        PullUpUsageViewDescriptor pullUpUsageViewDescriptor = new PullUpUsageViewDescriptor();
        if (pullUpUsageViewDescriptor == null) {
            PullUpProcessor.$$$reportNull$$$0(1);
        }
        return pullUpUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (MemberInfo memberInfo : this.myMembersToMove) {
            PsiMember member = (PsiMember)memberInfo.getMember();
            if (!member.hasModifierProperty("static")) continue;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)member)) {
                result.add(new UsageInfo(reference));
            }
        }
        UsageInfo[] usageInfoArray = result.isEmpty() ? UsageInfo.EMPTY_ARRAY : result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            PullUpProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.pull.up";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.mySourceClass);
        data.addMembers((Object[])this.myMembersToMove, info -> (PsiMember)info.getMember());
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PullUpProcessor.$$$reportNull$$$0(3);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myTargetSuperClass);
        return data;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PullUpProcessor.$$$reportNull$$$0(4);
        }
        this.moveMembersToBase();
        this.moveFieldInitializations();
        for (UsageInfo usage : usages) {
            PullUpHelper<MemberInfo> processor;
            PsiElement element = usage.getElement();
            if (element == null || (processor = this.getProcessor(element)) == null) continue;
            processor.updateUsage(element);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.processMethodsDuplicates(), ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    private void processMethodsDuplicates() {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            if (!this.myTargetSuperClass.isValid()) {
                return;
            }
            Query search = ClassInheritorsSearch.search((PsiClass)this.myTargetSuperClass);
            HashSet<VirtualFile> hierarchyFiles = new HashSet<VirtualFile>();
            for (PsiClass aClass : search) {
                VirtualFile virtualFile;
                PsiFile containingFile = aClass.getContainingFile();
                if (containingFile == null || (virtualFile = containingFile.getVirtualFile()) == null) continue;
                hierarchyFiles.add(virtualFile);
            }
            HashSet<PsiMember> methodsToSearchDuplicates = new HashSet<PsiMember>();
            for (PsiMember psiMember : this.myMembersAfterMove) {
                if (!(psiMember instanceof PsiMethod) || !psiMember.isValid() || ((PsiMethod)psiMember).getBody() == null) continue;
                methodsToSearchDuplicates.add(psiMember);
            }
            MethodDuplicatesHandler.invokeOnScope(this.myProject, methodsToSearchDuplicates, new AnalysisScope(this.myProject, hierarchyFiles), true);
        }), MethodDuplicatesHandler.REFACTORING_NAME, true, this.myProject);
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"pullUp.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.mySourceClass)});
        if (string == null) {
            PullUpProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void moveMembersToBase() throws IncorrectOperationException {
        this.myMovedMembers = ContainerUtil.newHashSet();
        this.myMembersAfterMove = ContainerUtil.newHashSet();
        for (MemberInfo info : this.myMembersToMove) {
            this.myMovedMembers.add((PsiMember)info.getMember());
        }
        PsiSubstitutor substitutor = this.upDownSuperClassSubstitutor();
        for (MemberInfo info : this.myMembersToMove) {
            PullUpHelper<MemberInfo> processor = this.getProcessor(info);
            LOG.assertTrue(processor != null, (Object)info.getMember());
            if (!(info.getMember() instanceof PsiClass) || info.getOverrides() == null) {
                processor.setCorrectVisibility((MemberInfoBase)info);
                processor.encodeContextInfo((MemberInfoBase)info);
            }
            processor.move((MemberInfoBase)info, substitutor);
        }
        for (PsiMember member : this.myMembersAfterMove) {
            PullUpHelper<MemberInfo> processor = this.getProcessor((PsiElement)member);
            LOG.assertTrue(processor != null, (Object)member);
            processor.postProcessMember(member);
            JavaRefactoringListenerManager listenerManager = JavaRefactoringListenerManager.getInstance((Project)this.myProject);
            ((JavaRefactoringListenerManagerImpl)listenerManager).fireMemberMoved(this.mySourceClass, member);
        }
    }

    @Nullable
    private PullUpHelper<MemberInfo> getProcessor(@NotNull PsiElement element) {
        if (element == null) {
            PullUpProcessor.$$$reportNull$$$0(6);
        }
        Language language = element.getLanguage();
        return this.getProcessor(language);
    }

    @Nullable
    private PullUpHelper<MemberInfo> getProcessor(Language language) {
        PullUpHelper helper = this.myProcessors.get(language);
        if (helper == null) {
            PullUpHelperFactory helperFactory = (PullUpHelperFactory)PullUpHelper.INSTANCE.forLanguage(language);
            if (helperFactory == null) {
                return null;
            }
            helper = helperFactory.createPullUpHelper((PullUpData)this);
            this.myProcessors.put(language, (PullUpHelper<MemberInfo>)helper);
        }
        return helper;
    }

    @Nullable
    private PullUpHelper<MemberInfo> getProcessor(@NotNull MemberInfo info) {
        PsiReferenceList refList;
        if (info == null) {
            PullUpProcessor.$$$reportNull$$$0(7);
        }
        if ((refList = info.getSourceReferenceList()) != null) {
            return this.getProcessor(refList.getLanguage());
        }
        return this.getProcessor(info.getMember());
    }

    private PsiSubstitutor upDownSuperClassSubstitutor() {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass)) {
            substitutor = substitutor.put(parameter2, null);
        }
        Map substitutionMap = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.myTargetSuperClass, (PsiClass)this.mySourceClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).getSubstitutionMap();
        for (PsiTypeParameter parameter3 : substitutionMap.keySet()) {
            PsiType type2 = (PsiType)substitutionMap.get(parameter3);
            PsiClass resolvedClass = PsiUtil.resolveClassInType((PsiType)type2);
            if (!(resolvedClass instanceof PsiTypeParameter)) continue;
            substitutor = substitutor.put((PsiTypeParameter)resolvedClass, (PsiType)JavaPsiFacade.getElementFactory((Project)this.myProject).createType((PsiClass)parameter3));
        }
        return substitutor;
    }

    public void moveFieldInitializations() throws IncorrectOperationException {
        LOG.assertTrue(this.myMembersAfterMove != null);
        LinkedHashSet<PsiField> movedFields = new LinkedHashSet<PsiField>();
        for (PsiMember member : this.myMembersAfterMove) {
            if (!(member instanceof PsiField)) continue;
            movedFields.add((PsiField)member);
        }
        if (movedFields.isEmpty()) {
            return;
        }
        PullUpHelper<MemberInfo> processor = this.getProcessor((PsiElement)this.myTargetSuperClass);
        LOG.assertTrue(processor != null, (Object)this.myTargetSuperClass);
        processor.moveFieldInitializations(movedFields);
    }

    public static boolean checkedInterfacesContain(Collection<? extends MemberInfoBase<? extends PsiMember>> memberInfos, PsiMethod psiMethod) {
        for (MemberInfoBase<? extends PsiMember> memberInfoBase : memberInfos) {
            if (!memberInfoBase.isChecked() || !(memberInfoBase.getMember() instanceof PsiClass) || !Boolean.FALSE.equals(memberInfoBase.getOverrides()) || ((PsiClass)memberInfoBase.getMember()).findMethodBySignature(psiMethod, true) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            PullUpProcessor.$$$reportNull$$$0(8);
        }
        List<PsiClass> list = Collections.singletonList(this.mySourceClass);
        if (list == null) {
            PullUpProcessor.$$$reportNull$$$0(9);
        }
        return list;
    }

    public PsiClass getSourceClass() {
        return this.mySourceClass;
    }

    public PsiClass getTargetClass() {
        return this.myTargetSuperClass;
    }

    public DocCommentPolicy getDocCommentPolicy() {
        return this.myJavaDocPolicy;
    }

    public Set<PsiMember> getMembersToMove() {
        return this.myMovedMembers;
    }

    public Set<PsiMember> getMovedMembers() {
        return this.myMembersAfterMove;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/memberPullUp/PullUpProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/memberPullUp/PullUpProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PullUpUsageViewDescriptor
    implements UsageViewDescriptor {
        private PullUpUsageViewDescriptor() {
        }

        public String getProcessedElementsHeader() {
            return "Pull up members from class " + DescriptiveNameUtil.getDescriptiveName((PsiElement)PullUpProcessor.this.mySourceClass);
        }

        @NotNull
        public PsiElement[] getElements() {
            PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map((Object[])PullUpProcessor.this.myMembersToMove, info -> (PsiMember)info.getMember(), (Object[])PsiElement.EMPTY_ARRAY);
            if (psiElementArray == null) {
                PullUpUsageViewDescriptor.$$$reportNull$$$0(0);
            }
            return psiElementArray;
        }

        public String getCodeReferencesText(int usagesCount, int filesCount) {
            return "Class to pull up members to \"" + RefactoringUIUtil.getDescription((PsiElement)PullUpProcessor.this.myTargetSuperClass, (boolean)true) + "\"";
        }

        public String getCommentReferencesText(int usagesCount, int filesCount) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/memberPullUp/PullUpProcessor$PullUpUsageViewDescriptor", "getElements"));
        }
    }
}

