/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.ui.TypeMigrationDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTypeSignatureHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance(ChangeTypeSignatureHandler.class);
    public static final String REFACTORING_NAME = "Type Migration";

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(0);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = TargetElementUtil.adjustOffset((PsiFile)file, (Document)editor.getDocument(), (int)editor.getCaretModel().getOffset());
        PsiElement element = file.findElementAt(offset);
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeElement.class);
        while (typeElement != null) {
            PsiElement parent = typeElement.getParent();
            PsiElement[] toMigrate = null;
            if (parent instanceof PsiVariable) {
                toMigrate = ChangeTypeSignatureHandler.extractReferencedVariables(typeElement);
            } else if (parent instanceof PsiMember && !(parent instanceof PsiClass) || ChangeTypeSignatureHandler.isClassArgument(parent)) {
                toMigrate = new PsiElement[]{parent};
            }
            if (toMigrate != null && toMigrate.length > 0) {
                ChangeTypeSignatureHandler.invoke(project, toMigrate, editor);
                return;
            }
            typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiTypeElement.class, (boolean)false);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"The caret should be positioned on type of field, variable, method or method parameter to be refactored", (String)REFACTORING_NAME, (String)"refactoring.migrateType");
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(elements.length == 1);
        PsiElement element = elements[0];
        ChangeTypeSignatureHandler.invokeOnElement(project, element);
    }

    private static void invokeOnElement(Project project, PsiElement element) {
        if (element instanceof PsiVariable || element instanceof PsiMember && !(element instanceof PsiClass) || element instanceof PsiFile || ChangeTypeSignatureHandler.isClassArgument(element)) {
            ChangeTypeSignatureHandler.invoke(project, new PsiElement[]{element}, null);
        }
    }

    private static boolean isClassArgument(PsiElement element) {
        if (element instanceof PsiReferenceParameterList) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
            if (member instanceof PsiAnonymousClass) {
                return ((PsiAnonymousClass)member).getBaseClassReference().getParameterList() == element;
            }
            if (member instanceof PsiClass) {
                PsiReferenceList implementsList = ((PsiClass)member).getImplementsList();
                PsiReferenceList extendsList = ((PsiClass)member).getExtendsList();
                return PsiTreeUtil.isAncestor((PsiElement)implementsList, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)extendsList, (PsiElement)element, (boolean)false);
            }
        }
        return false;
    }

    private static void invoke(@NotNull Project project, @NotNull PsiElement[] roots, @Nullable Editor editor) {
        if (project == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(3);
        }
        if (roots == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(4);
        }
        if (Util.canBeMigrated(roots)) {
            TypeMigrationDialog.SingleElement dialog = new TypeMigrationDialog.SingleElement(project, roots);
            dialog.show();
            return;
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"only.fields.variables.of.methods.of.valid.type.can.be.considered"), (String)RefactoringBundle.message((String)"unable.to.start.type.migration"), null);
    }

    @NotNull
    private static PsiElement[] extractReferencedVariables(@NotNull PsiTypeElement typeElement) {
        PsiElement parent;
        if (typeElement == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(5);
        }
        if ((parent = typeElement.getParent()) instanceof PsiVariable) {
            PsiDeclarationStatement declaration2;
            if (parent instanceof PsiField) {
                PsiField aField = (PsiField)parent;
                ArrayList<PsiField> fields = new ArrayList<PsiField>();
                do {
                    fields.add(aField);
                } while ((aField = (PsiField)PsiTreeUtil.getNextSiblingOfType((PsiElement)aField, PsiField.class)) != null && aField.getTypeElement() == typeElement);
                PsiElement[] psiElementArray = fields.toArray(new PsiElement[fields.size()]);
                if (psiElementArray == null) {
                    ChangeTypeSignatureHandler.$$$reportNull$$$0(6);
                }
                return psiElementArray;
            }
            if (parent instanceof PsiLocalVariable && (declaration2 = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiDeclarationStatement.class)) != null) {
                PsiElement[] psiElementArray = (PsiElement[])Arrays.stream(declaration2.getDeclaredElements()).filter(PsiVariable.class::isInstance).toArray(PsiVariable[]::new);
                if (psiElementArray == null) {
                    ChangeTypeSignatureHandler.$$$reportNull$$$0(7);
                }
                return psiElementArray;
            }
            PsiElement[] psiElementArray = new PsiElement[]{parent};
            if (psiElementArray == null) {
                ChangeTypeSignatureHandler.$$$reportNull$$$0(8);
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(9);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "extractReferencedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractReferencedVariables";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

