/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;

public class ConditionalReturnStatementValue
implements ReturnValue {
    PsiExpression myReturnValue;

    public ConditionalReturnStatementValue(PsiExpression returnValue) {
        this.myReturnValue = returnValue;
    }

    @Override
    public boolean isEquivalent(ReturnValue other) {
        if (!(other instanceof ConditionalReturnStatementValue)) {
            return false;
        }
        PsiExpression otherReturnValue = ((ConditionalReturnStatementValue)other).myReturnValue;
        if (otherReturnValue == null || this.myReturnValue == null) {
            return this.myReturnValue == null && otherReturnValue == null;
        }
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myReturnValue, (PsiElement)otherReturnValue);
    }

    @Override
    public PsiStatement createReplacement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        PsiIfStatement statement;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)methodCallExpression.getProject()).getElementFactory();
        if (this.myReturnValue == null) {
            statement = (PsiIfStatement)elementFactory.createStatementFromText("if(a) return;", null);
        } else {
            statement = (PsiIfStatement)elementFactory.createStatementFromText("if(a) return b;", null);
            PsiReturnStatement thenBranch = (PsiReturnStatement)statement.getThenBranch();
            assert (thenBranch != null);
            PsiExpression returnValue = thenBranch.getReturnValue();
            assert (returnValue != null);
            returnValue.replace((PsiElement)this.myReturnValue);
        }
        PsiExpression condition2 = statement.getCondition();
        assert (condition2 != null);
        condition2.replace((PsiElement)methodCallExpression);
        return (PsiStatement)CodeStyleManager.getInstance((Project)statement.getManager().getProject()).reformat((PsiElement)statement);
    }

    public boolean isEmptyOrConstantExpression() {
        return this.myReturnValue == null || ExpressionUtils.isNullLiteral(this.myReturnValue) || PsiUtil.isConstantExpression((PsiExpression)this.myReturnValue);
    }
}

