/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReplacementUtil {
    private static final Logger LOG = Logger.getInstance(PsiReplacementUtil.class);

    public static void replaceExpression(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText) {
        if (expression2 == null) {
            PsiReplacementUtil.$$$reportNull$$$0(0);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(1);
        }
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression2);
        PsiElement replacementExpression = expression2.replace((PsiElement)newExpression);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        styleManager.reformat(replacementExpression);
    }

    public static void replaceExpression(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText, CommentTracker tracker) {
        if (expression2 == null) {
            PsiReplacementUtil.$$$reportNull$$$0(2);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(3);
        }
        Project project = expression2.getProject();
        PsiElement replacementExpression = tracker.replaceAndRestoreComments((PsiElement)expression2, newExpressionText);
        CodeStyleManager.getInstance((Project)project).reformat(replacementExpression);
    }

    public static PsiElement replaceExpressionAndShorten(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText) {
        if (expression2 == null) {
            PsiReplacementUtil.$$$reportNull$$$0(4);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(5);
        }
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression2);
        PsiElement replacementExp = expression2.replace((PsiElement)newExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceExpressionAndShorten(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText, CommentTracker tracker) {
        if (expression2 == null) {
            PsiReplacementUtil.$$$reportNull$$$0(6);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(7);
        }
        Project project = expression2.getProject();
        PsiElement replacementExp = tracker.replaceAndRestoreComments((PsiElement)expression2, newExpressionText);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceStatement(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) {
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(8);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(9);
        }
        Project project = statement.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)statement);
        PsiElement replacementExp = statement.replace((PsiElement)newStatement);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceStatement(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText, CommentTracker commentTracker) {
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(10);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(11);
        }
        Project project = statement.getProject();
        PsiElement replacementExp = commentTracker.replaceAndRestoreComments((PsiElement)statement, newStatementText);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static void replaceStatementAndShortenClassNames(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) {
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(12);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(13);
        }
        PsiReplacementUtil.replaceStatementAndShortenClassNames(statement, newStatementText, null);
    }

    public static PsiElement replaceStatementAndShortenClassNames(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText, @Nullable CommentTracker tracker) {
        PsiStatement newStatement;
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(14);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(15);
        }
        Project project = statement.getProject();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        if (tracker != null) {
            newStatement = (PsiStatement)tracker.replaceAndRestoreComments((PsiElement)statement, newStatementText);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            newStatement = (PsiStatement)statement.replace((PsiElement)factory.createStatementFromText(newStatementText, (PsiElement)statement));
        }
        return styleManager.reformat(javaStyleManager.shortenClassReferences((PsiElement)newStatement));
    }

    public static void replaceExpressionWithReferenceTo(@NotNull PsiExpression expression2, @NotNull PsiMember target) {
        if (expression2 == null) {
            PsiReplacementUtil.$$$reportNull$$$0(16);
        }
        if (target == null) {
            PsiReplacementUtil.$$$reportNull$$$0(17);
        }
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiReferenceExpression newExpression = (PsiReferenceExpression)factory.createExpressionFromText("xxx", (PsiElement)expression2);
        PsiReferenceExpression replacementExpression = (PsiReferenceExpression)expression2.replace((PsiElement)newExpression);
        PsiElement element = replacementExpression.bindToElement((PsiElement)target);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        styleManager.shortenClassReferences(element);
    }

    @NotNull
    public static String getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement) {
        if (element == null) {
            PsiReplacementUtil.$$$reportNull$$$0(18);
        }
        StringBuilder out = new StringBuilder();
        PsiReplacementUtil.getElementText(element, elementToReplace, replacement, out);
        String string = out.toString();
        if (string == null) {
            PsiReplacementUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static void getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement, @NotNull StringBuilder out) {
        if (element == null) {
            PsiReplacementUtil.$$$reportNull$$$0(20);
        }
        if (out == null) {
            PsiReplacementUtil.$$$reportNull$$$0(21);
        }
        if (element.equals(elementToReplace)) {
            out.append(replacement);
            return;
        }
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            out.append(element.getText());
            return;
        }
        for (PsiElement child : children) {
            PsiReplacementUtil.getElementText(child, elementToReplace, replacement, out);
        }
    }

    public static void replaceOperatorAssignmentWithAssignmentExpression(@NotNull PsiAssignmentExpression assignmentExpression) {
        if (assignmentExpression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(22);
        }
        CommentTracker tracker = new CommentTracker();
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        String operator2 = sign.getText();
        String newOperator = operator2.substring(0, operator2.length() - 1);
        String lhsText = tracker.markUnchanged(lhs).getText();
        String rhsText = rhs == null ? "" : tracker.markUnchanged(rhs).getText();
        boolean parentheses = ParenthesesUtils.areParenthesesNeeded(sign, rhs);
        String cast = PsiReplacementUtil.getCastString(lhs, rhs);
        StringBuilder newExpression = new StringBuilder(lhsText);
        newExpression.append('=').append(cast);
        if (!cast.isEmpty()) {
            newExpression.append('(');
        }
        newExpression.append(lhsText).append(newOperator);
        if (parentheses) {
            newExpression.append('(').append(rhsText).append(')');
        } else {
            newExpression.append(rhsText);
        }
        if (!cast.isEmpty()) {
            newExpression.append(')');
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)assignmentExpression, newExpression.toString(), tracker);
    }

    private static String getCastString(PsiExpression lhs, PsiExpression rhs) {
        if (lhs == null || rhs == null) {
            return "";
        }
        PsiType lType = lhs.getType();
        PsiType rType = rhs.getType();
        if (TypeConversionUtil.isNumericType((PsiType)rType)) {
            rType = TypeConversionUtil.binaryNumericPromotion((PsiType)lType, (PsiType)rType);
        }
        if (lType == null || rType == null || TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType) || !TypeConversionUtil.areTypesConvertible((PsiType)lType, (PsiType)rType)) {
            return "";
        }
        return '(' + lType.getCanonicalText() + ')';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpressionText";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatementText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/PsiReplacementUtil";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/PsiReplacementUtil";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionAndShorten";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatement";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatementAndShortenClassNames";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionWithReferenceTo";
                break;
            }
            case 18: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getElementText";
                break;
            }
            case 19: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replaceOperatorAssignmentWithAssignmentExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

