/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessBooleanExpressionInspection
extends BaseInspection {
    static final Set<IElementType> booleanTokens = new HashSet<IElementType>();
    public boolean m_ignoreExpressionsContainingConstants = true;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            PointlessBooleanExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacement = (String)infos[1];
        PsiExpression expression2 = (PsiExpression)infos[0];
        if (replacement.isEmpty() && expression2 instanceof PsiAssignmentExpression) {
            String string = InspectionGadgetsBundle.message("boolean.expression.does.not.modify.problem.descriptor", expression2.getText());
            if (string == null) {
                PointlessBooleanExpressionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("boolean.expression.can.be.simplified.problem.descriptor", replacement);
        if (string == null) {
            PointlessBooleanExpressionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    StringBuilder buildSimplifiedExpression(@Nullable PsiExpression expression2, StringBuilder out, CommentTracker tracker) {
        if (expression2 instanceof PsiAssignmentExpression) {
            this.buildSimplifiedAssignmentExpression((PsiAssignmentExpression)expression2, out, tracker);
        } else if (expression2 instanceof PsiPolyadicExpression) {
            this.buildSimplifiedPolyadicExpression((PsiPolyadicExpression)expression2, out, tracker);
        } else if (expression2 instanceof PsiPrefixExpression) {
            this.buildSimplifiedPrefixExpression((PsiPrefixExpression)expression2, out, tracker);
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression expression1 = parenthesizedExpression.getExpression();
            out.append('(');
            this.buildSimplifiedExpression(expression1, out, tracker);
            out.append(')');
        } else if (expression2 != null) {
            out.append(tracker.markUnchanged(expression2).getText());
        }
        return out;
    }

    private void buildSimplifiedPolyadicExpression(PsiPolyadicExpression expression2, StringBuilder out, CommentTracker tracker) {
        IElementType tokenType = expression2.getOperationTokenType();
        PsiExpression[] operands2 = expression2.getOperands();
        ArrayList<PsiExpression> expressions2 = new ArrayList<PsiExpression>();
        if (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.AND)) {
            for (PsiExpression operand2 : operands2) {
                if (this.evaluate(operand2) == Boolean.TRUE) continue;
                if (this.evaluate(operand2) == Boolean.FALSE) {
                    out.append("false");
                    return;
                }
                expressions2.add(operand2);
            }
            if (expressions2.isEmpty()) {
                out.append("true");
                return;
            }
            this.buildSimplifiedExpression(expressions2, tokenType.equals(JavaTokenType.ANDAND) ? "&&" : "&", false, out, tracker);
        } else if (tokenType.equals(JavaTokenType.OROR) || tokenType.equals(JavaTokenType.OR)) {
            for (PsiExpression operand3 : operands2) {
                if (this.evaluate(operand3) == Boolean.FALSE) continue;
                if (this.evaluate(operand3) == Boolean.TRUE) {
                    out.append("true");
                    return;
                }
                expressions2.add(operand3);
            }
            if (expressions2.isEmpty()) {
                out.append("false");
                return;
            }
            this.buildSimplifiedExpression(expressions2, tokenType.equals(JavaTokenType.OROR) ? "||" : "|", false, out, tracker);
        } else if (tokenType.equals(JavaTokenType.XOR) || tokenType.equals(JavaTokenType.NE)) {
            boolean negate = false;
            for (PsiExpression operand4 : operands2) {
                if (this.evaluate(operand4) == Boolean.FALSE) continue;
                if (this.evaluate(operand4) == Boolean.TRUE) {
                    negate = !negate;
                    continue;
                }
                expressions2.add(operand4);
            }
            if (expressions2.isEmpty()) {
                if (negate) {
                    out.append("true");
                } else {
                    out.append("false");
                }
                return;
            }
            this.buildSimplifiedExpression(expressions2, tokenType.equals(JavaTokenType.XOR) ? "^" : "!=", negate, out, tracker);
        } else if (tokenType.equals(JavaTokenType.EQEQ)) {
            boolean negate = false;
            for (PsiExpression operand5 : operands2) {
                if (this.evaluate(operand5) == Boolean.TRUE) continue;
                if (this.evaluate(operand5) == Boolean.FALSE) {
                    negate = !negate;
                    continue;
                }
                expressions2.add(operand5);
            }
            if (expressions2.isEmpty()) {
                if (negate) {
                    out.append("false");
                } else {
                    out.append("true");
                }
                return;
            }
            this.buildSimplifiedExpression(expressions2, "==", negate, out, tracker);
        } else {
            out.append(tracker.markUnchanged(expression2).getText());
        }
    }

    private void buildSimplifiedExpression(List<PsiExpression> expressions2, String token, boolean negate, StringBuilder out, CommentTracker tracker) {
        if (expressions2.size() == 1) {
            PsiExpression expression2 = expressions2.get(0);
            if (!negate) {
                out.append(tracker.markUnchanged(expression2).getText());
                return;
            }
            if (ComparisonUtils.isComparison(expression2)) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
                String negatedComparison = ComparisonUtils.getNegatedComparison(binaryExpression.getOperationTokenType());
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                assert (rhs != null);
                out.append(tracker.markUnchanged(lhs).getText()).append(negatedComparison).append(tracker.markUnchanged(rhs).getText());
            } else if (ParenthesesUtils.getPrecedence(expression2) > 3) {
                out.append("!(").append(tracker.markUnchanged(expression2).getText()).append(')');
            } else {
                out.append('!').append(tracker.markUnchanged(expression2).getText());
            }
        } else {
            if (negate) {
                out.append("!(");
            }
            boolean useToken = false;
            for (PsiExpression expression3 : expressions2) {
                if (useToken) {
                    out.append(token);
                    PsiElement previousSibling = expression3.getPrevSibling();
                    if (previousSibling instanceof PsiWhiteSpace) {
                        out.append(previousSibling.getText());
                    }
                } else {
                    useToken = true;
                }
                this.buildSimplifiedExpression(expression3, out, tracker);
                PsiElement nextSibling = expression3.getNextSibling();
                if (!(nextSibling instanceof PsiWhiteSpace)) continue;
                out.append(nextSibling.getText());
            }
            if (negate) {
                out.append(')');
            }
        }
    }

    private void buildSimplifiedPrefixExpression(PsiPrefixExpression expression2, StringBuilder out, CommentTracker tracker) {
        PsiJavaToken sign = expression2.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        PsiExpression operand2 = expression2.getOperand();
        if (JavaTokenType.EXCL.equals(tokenType)) {
            Boolean value2 = this.evaluate(operand2);
            if (value2 == Boolean.TRUE) {
                out.append("false");
                return;
            }
            if (value2 == Boolean.FALSE) {
                out.append("true");
                return;
            }
        }
        this.buildSimplifiedExpression(operand2, out.append(sign.getText()), tracker);
    }

    private void buildSimplifiedAssignmentExpression(PsiAssignmentExpression expression2, StringBuilder out, CommentTracker tracker) {
        IElementType tokenType = expression2.getOperationTokenType();
        PsiExpression lhs = expression2.getLExpression();
        if (tokenType == JavaTokenType.ANDEQ) {
            if (this.evaluate(expression2.getRExpression()) == Boolean.TRUE) {
                if (expression2.getParent() instanceof PsiExpressionStatement) {
                    return;
                }
                out.append(lhs.getText());
            } else {
                out.append(lhs.getText()).append("=false");
            }
            tracker.markUnchanged(lhs);
            return;
        }
        if (tokenType == JavaTokenType.OREQ) {
            if (this.evaluate(expression2.getRExpression()) == Boolean.FALSE) {
                if (expression2.getParent() instanceof PsiExpressionStatement) {
                    return;
                }
                out.append(lhs.getText());
            } else {
                out.append(lhs.getText()).append("=true");
            }
            tracker.markUnchanged(lhs);
            return;
        }
        tracker.markUnchanged(lhs);
        out.append(lhs.getText()).append(expression2.getOperationSign().getText());
        this.buildSimplifiedExpression(expression2.getRExpression(), out, tracker);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        String replacement = (String)infos[1];
        if (replacement.isEmpty() && infos[0] instanceof PsiAssignmentExpression) {
            return new RemovePointlessBooleanExpressionFix();
        }
        boolean hasSideEffect = (Boolean)infos[2];
        return new PointlessBooleanExpressionFix(hasSideEffect);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBooleanExpressionVisitor();
    }

    @Nullable
    Boolean evaluate(@Nullable PsiExpression expression2) {
        if (expression2 == null || this.m_ignoreExpressionsContainingConstants && PointlessBooleanExpressionInspection.containsReference(expression2)) {
            return null;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            return this.evaluate(parenthesizedExpression.getExpression());
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.OROR)) {
                PsiExpression[] operands2;
                for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                    if (SideEffectChecker.mayHaveSideEffects(operand2)) {
                        return null;
                    }
                    if (this.evaluate(operand2) != Boolean.TRUE) continue;
                    return Boolean.TRUE;
                }
            } else if (tokenType.equals(JavaTokenType.ANDAND)) {
                PsiExpression[] operands3;
                for (PsiExpression operand3 : operands3 = polyadicExpression.getOperands()) {
                    if (SideEffectChecker.mayHaveSideEffects(operand3)) {
                        return null;
                    }
                    if (this.evaluate(operand3) != Boolean.FALSE) continue;
                    return Boolean.FALSE;
                }
            }
        } else if (expression2 instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (JavaTokenType.EXCL.equals(tokenType)) {
                PsiExpression operand4 = prefixExpression.getOperand();
                Boolean b = this.evaluate(operand4);
                if (b == Boolean.FALSE) {
                    return Boolean.TRUE;
                }
                if (b == Boolean.TRUE) {
                    return Boolean.FALSE;
                }
            }
        } else if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (JavaTokenType.ANDEQ.equals(tokenType) || JavaTokenType.OREQ.equals(tokenType)) {
                return this.evaluate(rhs);
            }
        }
        return (Boolean)ConstantExpressionUtil.computeCastTo((PsiExpression)expression2, (PsiType)PsiType.BOOLEAN);
    }

    private static boolean containsReference(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        ReferenceVisitor visitor = new ReferenceVisitor();
        expression2.accept((PsiElementVisitor)visitor);
        return visitor.containsReference();
    }

    static {
        booleanTokens.add(JavaTokenType.ANDAND);
        booleanTokens.add(JavaTokenType.AND);
        booleanTokens.add(JavaTokenType.OROR);
        booleanTokens.add(JavaTokenType.OR);
        booleanTokens.add(JavaTokenType.XOR);
        booleanTokens.add(JavaTokenType.EQEQ);
        booleanTokens.add(JavaTokenType.NE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReferenceVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean referenceFound;

        private ReferenceVisitor() {
        }

        public void visitElement(PsiElement element) {
            if (this.referenceFound) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiElement target = expression2.resolve();
            if (target instanceof PsiField && ExpressionUtils.isConstant((PsiField)target)) {
                this.referenceFound = true;
            } else {
                super.visitReferenceExpression(expression2);
            }
        }

        boolean containsReference() {
            return this.referenceFound;
        }
    }

    private class PointlessBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private PointlessBooleanExpressionVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        private void checkExpression(PsiExpression expression2) {
            BooleanExpressionKind kind2 = this.getExpressionKind(expression2);
            if (kind2 == BooleanExpressionKind.UNKNOWN) {
                return;
            }
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
            if (parent instanceof PsiExpression && this.getExpressionKind((PsiExpression)parent) != BooleanExpressionKind.UNKNOWN) {
                return;
            }
            String replacement = PointlessBooleanExpressionInspection.this.buildSimplifiedExpression(expression2, new StringBuilder(), new CommentTracker()).toString();
            Supplier<PsiElement> newBodySupplier = () -> JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(replacement, (PsiElement)expression2);
            if (parent instanceof PsiLambdaExpression && !LambdaUtil.isSafeLambdaBodyReplacement((PsiLambdaExpression)((PsiLambdaExpression)parent), newBodySupplier)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, replacement, kind2 == BooleanExpressionKind.USELESS_WITH_SIDE_EFFECTS);
        }

        @NotNull
        private BooleanExpressionKind getExpressionKind(PsiExpression expression2) {
            if (expression2 instanceof PsiPrefixExpression || expression2 instanceof PsiAssignmentExpression) {
                BooleanExpressionKind booleanExpressionKind = PointlessBooleanExpressionInspection.this.evaluate(expression2) != null ? BooleanExpressionKind.USELESS : BooleanExpressionKind.UNKNOWN;
                if (booleanExpressionKind == null) {
                    PointlessBooleanExpressionVisitor.$$$reportNull$$$0(0);
                }
                return booleanExpressionKind;
            }
            if (expression2 instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                IElementType sign = polyadicExpression.getOperationTokenType();
                if (!booleanTokens.contains(sign)) {
                    BooleanExpressionKind booleanExpressionKind = BooleanExpressionKind.UNKNOWN;
                    if (booleanExpressionKind == null) {
                        PointlessBooleanExpressionVisitor.$$$reportNull$$$0(1);
                    }
                    return booleanExpressionKind;
                }
                PsiExpression[] operands2 = polyadicExpression.getOperands();
                boolean containsConstant = false;
                boolean stopCheckingSideEffects = false;
                boolean sideEffectMayBeRemoved = false;
                boolean reducedToConstant = false;
                for (PsiExpression operand2 : operands2) {
                    Boolean value2;
                    if (operand2 == null) {
                        BooleanExpressionKind booleanExpressionKind = BooleanExpressionKind.UNKNOWN;
                        if (booleanExpressionKind == null) {
                            PointlessBooleanExpressionVisitor.$$$reportNull$$$0(2);
                        }
                        return booleanExpressionKind;
                    }
                    PsiType type2 = operand2.getType();
                    if (type2 == null || !type2.equals(PsiType.BOOLEAN) && !type2.equalsToText("java.lang.Boolean")) {
                        BooleanExpressionKind booleanExpressionKind = BooleanExpressionKind.UNKNOWN;
                        if (booleanExpressionKind == null) {
                            PointlessBooleanExpressionVisitor.$$$reportNull$$$0(3);
                        }
                        return booleanExpressionKind;
                    }
                    if (!stopCheckingSideEffects && SideEffectChecker.mayHaveSideEffects(operand2)) {
                        sideEffectMayBeRemoved = true;
                    }
                    if ((value2 = PointlessBooleanExpressionInspection.this.evaluate(operand2)) == null) continue;
                    containsConstant = true;
                    if (JavaTokenType.ANDAND.equals(sign) && !value2.booleanValue() || JavaTokenType.OROR.equals(sign) && value2.booleanValue()) {
                        stopCheckingSideEffects = true;
                        reducedToConstant = true;
                    }
                    if ((!JavaTokenType.AND.equals(sign) || value2.booleanValue()) && (!JavaTokenType.OR.equals(sign) || !value2.booleanValue())) continue;
                    reducedToConstant = true;
                }
                if (containsConstant) {
                    if (sideEffectMayBeRemoved && reducedToConstant) {
                        BooleanExpressionKind booleanExpressionKind = ControlFlowUtils.canExtractStatement(expression2) ? BooleanExpressionKind.USELESS_WITH_SIDE_EFFECTS : BooleanExpressionKind.UNKNOWN;
                        if (booleanExpressionKind == null) {
                            PointlessBooleanExpressionVisitor.$$$reportNull$$$0(4);
                        }
                        return booleanExpressionKind;
                    }
                    BooleanExpressionKind booleanExpressionKind = BooleanExpressionKind.USELESS;
                    if (booleanExpressionKind == null) {
                        PointlessBooleanExpressionVisitor.$$$reportNull$$$0(5);
                    }
                    return booleanExpressionKind;
                }
            }
            BooleanExpressionKind booleanExpressionKind = BooleanExpressionKind.UNKNOWN;
            if (booleanExpressionKind == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(6);
            }
            return booleanExpressionKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection$PointlessBooleanExpressionVisitor", "getExpressionKind"));
        }
    }

    private class PointlessBooleanExpressionFix
    extends InspectionGadgetsFix {
        private final boolean myHasSideEffect;

        public PointlessBooleanExpressionFix(boolean hasSideEffect) {
            this.myHasSideEffect = hasSideEffect;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myHasSideEffect ? InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix.sideEffect", new Object[0]) : InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                PointlessBooleanExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                PointlessBooleanExpressionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            boolean isConstant;
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression2 = (PsiExpression)element;
            CommentTracker tracker = new CommentTracker();
            String simplifiedExpression = PointlessBooleanExpressionInspection.this.buildSimplifiedExpression(expression2, new StringBuilder(), tracker).toString();
            boolean bl = isConstant = simplifiedExpression.equals("true") || simplifiedExpression.equals("false");
            if (isConstant) {
                if ((expression2 = RefactoringUtil.ensureCodeBlock(expression2)) == null) {
                    return;
                }
                PsiStatement anchor = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class);
                if (anchor == null) {
                    return;
                }
                List<PsiExpression> sideEffects = this.extractSideEffects(expression2);
                for (PsiExpression sideEffect : sideEffects) {
                    tracker.markUnchanged(sideEffect);
                }
                PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, expression2);
                if (statements.length > 0) {
                    BlockUtils.addBefore(anchor, statements);
                }
            }
            PsiReplacementUtil.replaceExpression(expression2, simplifiedExpression, tracker);
        }

        private List<PsiExpression> extractSideEffects(PsiExpression expression2) {
            if (!(expression2 instanceof PsiPolyadicExpression)) {
                return Collections.emptyList();
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            IElementType sign = polyadicExpression.getOperationTokenType();
            Boolean stopper = sign == JavaTokenType.ANDAND ? Boolean.FALSE : (sign == JavaTokenType.OROR ? Boolean.TRUE : null);
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            ArrayList<PsiExpression> sideEffects = new ArrayList<PsiExpression>();
            for (PsiExpression operand2 : operands2) {
                if (stopper != null && stopper.equals(PointlessBooleanExpressionInspection.this.evaluate(operand2))) break;
                sideEffects.addAll(SideEffectChecker.extractSideEffectExpressions(operand2));
            }
            return sideEffects;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection$PointlessBooleanExpressionFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class RemovePointlessBooleanExpressionFix
    extends InspectionGadgetsFix {
        private RemovePointlessBooleanExpressionFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("boolean.expression.remove.compound.assignment.quickfix", new Object[0]);
            if (string == null) {
                RemovePointlessBooleanExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
            List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(assignmentExpression.getLExpression());
            assert (sideEffects.size() < 2);
            if (!sideEffects.isEmpty()) {
                CommentTracker.replaceWithSubexpressionAndRestoreComments((PsiExpression)assignmentExpression, sideEffects.get(0));
            } else {
                new CommentTracker().deleteAndRestoreComments(element.getParent());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection$RemovePointlessBooleanExpressionFix", "getFamilyName"));
        }
    }

    private static enum BooleanExpressionKind {
        USELESS,
        USELESS_WITH_SIDE_EFFECTS,
        UNKNOWN;

    }
}

