/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryReturnInspection
extends BaseInspection {
    public boolean ignoreInThenBranch = false;

    @NotNull
    public String getID() {
        if ("UnnecessaryReturnStatement" == null) {
            UnnecessaryReturnInspection.$$$reportNull$$$0(0);
        }
        return "UnnecessaryReturnStatement";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.return.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryReturnInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        if (((Boolean)infos[0]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("unnecessary.return.constructor.problem.descriptor", new Object[0]);
            if (string == null) {
                UnnecessaryReturnInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.return.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryReturnInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.return.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInThenBranch");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteUnnecessaryStatementFix("return");
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryReturnVisitor();
    }

    public static boolean isReturnRedundant(@NotNull PsiReturnStatement statement, boolean ignoreInThenBranch, @Nullable Ref<Boolean> isInConstructorRef) {
        if (statement == null) {
            UnnecessaryReturnInspection.$$$reportNull$$$0(4);
        }
        if (statement.getReturnValue() != null) {
            return false;
        }
        PsiElement methodParent = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        PsiCodeBlock codeBlock = null;
        if (methodParent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)methodParent;
            codeBlock = method.getBody();
            if (isInConstructorRef != null) {
                isInConstructorRef.set((Object)method.isConstructor());
            }
        } else if (methodParent instanceof PsiLambdaExpression) {
            isInConstructorRef.set((Object)false);
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)methodParent;
            PsiElement lambdaBody = lambdaExpression.getBody();
            if (lambdaBody instanceof PsiCodeBlock) {
                codeBlock = (PsiCodeBlock)lambdaBody;
            }
        } else {
            return false;
        }
        if (codeBlock == null) {
            return false;
        }
        if (!ControlFlowUtils.blockCompletesWithStatement(codeBlock, (PsiStatement)statement)) {
            return false;
        }
        return !ignoreInThenBranch || !UnnecessaryReturnInspection.isInThenBranch((PsiStatement)statement);
    }

    private static boolean isInThenBranch(PsiStatement statement) {
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (ifStatement == null) {
            return false;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return elseBranch != null && !PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)statement, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/UnnecessaryReturnInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/UnnecessaryReturnInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReturnRedundant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UnnecessaryReturnVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryReturnVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                UnnecessaryReturnVisitor.$$$reportNull$$$0(0);
            }
            super.visitReturnStatement(statement);
            Ref constructorRef = Ref.create();
            if (UnnecessaryReturnInspection.isReturnRedundant(statement, UnnecessaryReturnInspection.this.ignoreInThenBranch, (Ref<Boolean>)constructorRef)) {
                this.registerStatementError((PsiStatement)statement, constructorRef.get());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/UnnecessaryReturnInspection$UnnecessaryReturnVisitor", "visitReturnStatement"));
        }
    }
}

