/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.fixes.EqualityToSafeEqualsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualityToEqualsFix
extends InspectionGadgetsFix {
    private final boolean myNegated;

    public EqualityToEqualsFix() {
        this(true);
    }

    private EqualityToEqualsFix(boolean negated) {
        this.myNegated = negated;
    }

    @Nullable
    public static EqualityToEqualsFix buildFix(PsiBinaryExpression expression2) {
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        PsiExpression lhs = ParenthesesUtils.stripParentheses(expression2.getLOperand());
        if (lhs instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)lhs).resolve()) instanceof PsiModifierListOwner) {
            NullableNotNullManager.getInstance((Project)expression2.getProject());
            if (NullableNotNullManager.isNullable((PsiModifierListOwner)((PsiModifierListOwner)target))) {
                return null;
            }
        }
        return new EqualityToEqualsFix(JavaTokenType.NE.equals(expression2.getOperationTokenType()));
    }

    @NotNull
    public static InspectionGadgetsFix[] buildEqualityFixes(PsiBinaryExpression expression2) {
        ArrayList result = new ArrayList(2);
        ContainerUtil.addIfNotNull(result, (Object)EqualityToEqualsFix.buildFix(expression2));
        ContainerUtil.addIfNotNull(result, (Object)EqualityToSafeEqualsFix.buildFix(expression2));
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            EqualityToEqualsFix.$$$reportNull$$$0(0);
        }
        return inspectionGadgetsFixArray;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myNegated ? InspectionGadgetsBundle.message("inequality.to.not.equals.quickfix", new Object[0]) : InspectionGadgetsBundle.message("equality.to.equals.quickfix", new Object[0]);
        if (string == null) {
            EqualityToEqualsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("equality.to.equals.quickfix", new Object[0]);
        if (string == null) {
            EqualityToEqualsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement comparisonToken = descriptor.getPsiElement();
        PsiElement parent = comparisonToken.getParent();
        if (!(parent instanceof PsiBinaryExpression)) {
            return;
        }
        PsiBinaryExpression expression2 = (PsiBinaryExpression)parent;
        PsiExpression lhs = ParenthesesUtils.stripParentheses(expression2.getLOperand());
        PsiExpression rhs = ParenthesesUtils.stripParentheses(expression2.getROperand());
        if (lhs == null || rhs == null) {
            return;
        }
        CommentTracker commentTracker = new CommentTracker();
        StringBuilder newExpression = new StringBuilder();
        if (JavaTokenType.NE.equals(expression2.getOperationTokenType())) {
            newExpression.append('!');
        }
        if (ParenthesesUtils.getPrecedence(lhs) > 1) {
            newExpression.append('(').append(commentTracker.markUnchanged(lhs).getText()).append(')');
        } else {
            newExpression.append(commentTracker.markUnchanged(lhs).getText());
        }
        newExpression.append(".equals(").append(commentTracker.markUnchanged(rhs).getText()).append(')');
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression2, newExpression.toString(), commentTracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/EqualityToEqualsFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEqualityFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

